/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vfs;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.MetaModel;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchPath {
    public final List<ObjectPath> elements;

    private SearchPath(@NotNull List<ObjectPath> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/vfs/SearchPath", "<init>"));
        }
        this.elements = elements;
    }

    @NotNull
    public ObjectPath getCurrent() {
        ObjectPath objectPath = this.elements.get(0);
        if (objectPath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/SearchPath", "getCurrent"));
        }
        return objectPath;
    }

    @Contract(value="!null->!null")
    public static SearchPath of(@Nullable ObjectPath p) {
        return p == null ? null : new SearchPath(Collections.singletonList(p));
    }

    @Nullable
    public static SearchPath of(@NotNull List<ObjectPath> p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/database/vfs/SearchPath", "of"));
        }
        return p.isEmpty() ? null : new SearchPath(p);
    }

    @Nullable
    public static SearchPath of(@NotNull Iterable<? extends DasObject> o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/vfs/SearchPath", "of"));
        }
        return SearchPath.of(JBIterable.from(o).transform(ObjectPath::of).toList());
    }

    @Contract(value="!null->!null")
    public static ObjectPath getCurrent(@Nullable SearchPath p) {
        return p == null ? null : p.getCurrent();
    }

    @NotNull
    public static List<ObjectPath> getElements(@Nullable SearchPath p) {
        List<Object> list = p == null ? Collections.emptyList() : p.elements;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/SearchPath", "getElements"));
        }
        return list;
    }

    @Nullable
    public static SearchPath deserializeList(@Nullable String o, @NotNull MetaModel<?> metaModel) {
        if (metaModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaModel", "com/intellij/database/vfs/SearchPath", "deserializeList"));
        }
        if (o == null) {
            return null;
        }
        return SearchPath.of(JBIterable.of((Object[])o.split(",")).transform(x -> {
            if (metaModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaModel", "com/intellij/database/vfs/SearchPath", "lambda$deserializeList$0"));
            }
            return ObjectPath.deserialize(x, metaModel);
        }).toList());
    }

    @Contract(value="!null->!null")
    public static String serialize(@Nullable SearchPath o) {
        if (o == null) {
            return null;
        }
        return StringUtil.join(o.elements, ObjectPath::serialize, (String)",");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchPath multi = (SearchPath)o;
        return this.elements.equals(multi.elements);
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    public String toString() {
        return StringUtil.join(this.elements, (Function)Functions.TO_STRING(), (String)",");
    }
}

