/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.DatabaseOpenFileDescriptor;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbCustomType;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbElementImpl;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbPackage;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.dbm.common.DbmSourceAware;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.ComparableObject;
import com.intellij.util.ui.update.ComparableObjectCheck;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbNodeDescriptor
extends PresentableNodeDescriptor
implements DataProvider,
ComparableObject {
    public static final DbNodeDescriptor[] EMPTY_ARRAY = new DbNodeDescriptor[0];
    private final DbElement myElement;

    public DbNodeDescriptor(DbElement element, NodeDescriptor parent) {
        super(element.getProject(), parent);
        this.myElement = element;
    }

    public DbElement getElement() {
        return this.myElement;
    }

    protected void update(PresentationData presentation) {
        DasSynonym synonym;
        Iterable path;
        String pathString;
        SimpleTextAttributes style;
        DbElement element = this.getElement();
        if (!element.isValid()) {
            return;
        }
        presentation.setChanged(true);
        final Icon icon = element.getIcon();
        presentation.setIcon(icon == null ? null : new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                icon.paintIcon(c, g, x, y);
            }

            @Override
            public int getIconWidth() {
                return icon.getIconWidth() + 3;
            }

            @Override
            public int getIconHeight() {
                return icon.getIconHeight();
            }
        });
        Object delegate = element.getDelegate();
        boolean hasErrors = !this.isValid() ? true : (element instanceof DbDataSource && delegate instanceof LocalDataSource ? !DbImplUtil.canConnectTo(element) : (delegate instanceof DbmSourceAware ? ((DbmSourceAware)delegate).isInvalid() : false));
        String nodeText = DbPresentation.getPresentableName((DasObject)element);
        presentation.setPresentableText(nodeText);
        SimpleTextAttributes simpleTextAttributes = style = hasErrors ? new SimpleTextAttributes(8, this.getColor(), (Color)JBColor.RED) : SimpleTextAttributes.REGULAR_ATTRIBUTES;
        if (DbImplUtil.isConnected(element)) {
            style = SimpleTextAttributes.merge((SimpleTextAttributes)style, (SimpleTextAttributes)SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            presentation.setTooltip("Connected");
        }
        presentation.addText(new PresentableNodeDescriptor.ColoredFragment(nodeText, null, style));
        if (element instanceof DbDataSource || element instanceof DbNamespaceImpl) {
            String textExt;
            DbElement root = DatabaseStructure.getTopSingleRoot(element);
            if (root != element && StringUtil.isNotEmpty((String)(textExt = QNameUtil.getQualifiedName(root)))) {
                presentation.addText(" (" + textExt + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        } else if (element instanceof DbCustomType) {
            String description = DbImplUtil.getCustomTypeShortDescription(element.getDelegate());
            if (description != null) {
                presentation.addText(' ' + description, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        } else if (element instanceof DbColumn) {
            String type = new DdlBuilder().configureFor(element).type((DasTypedObject)((DbColumn)element)).getStatement();
            presentation.addText(" " + type, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            if (DasUtil.isAutoVal((DasColumn)((DbColumn)element))) {
                presentation.addText(" (auto increment)", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        } else if (element instanceof DbTable) {
            ObjectKind type = element.getKind();
            if (type != ObjectKind.TABLE && type != ObjectKind.VIEW) {
                presentation.addText(" " + element.getTypeName(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        } else if (element instanceof DbRoutine) {
            DbRoutine procedure = (DbRoutine)element;
            StringBuilder sb = new StringBuilder();
            DdlBuilder builder = new DdlBuilder(sb).configureFor(element);
            DbImplUtil.getDatabaseDialect((DbElement)procedure).sqlDefinePrototype(builder, (DasRoutine)procedure, false, true);
            presentation.addText(sb.toString(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else if (element instanceof DasTableKey) {
            presentation.addText(" " + DbNodeDescriptor.multiRef((MultiRef<? extends DasTypedObject>)((DasTableKey)element).getColumnsRef()), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else if (element instanceof DasForeignKey) {
            DasForeignKey foreignKey = (DasForeignKey)element;
            String referencingColumns = DbNodeDescriptor.multiRef((MultiRef<? extends DasTypedObject>)foreignKey.getColumnsRef());
            String arrowToReferenced = DbNodeDescriptor.arrowToColumns(foreignKey.getRefTableName(), (MultiRef<? extends DasTypedObject>)foreignKey.getRefColumns());
            presentation.addText(" " + referencingColumns + " " + arrowToReferenced, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else if (element instanceof DasIndex) {
            DasIndex index = (DasIndex)element;
            String unique = index.isUnique() ? " UNIQUE" : "";
            String columns = DbNodeDescriptor.multiRef((MultiRef<? extends DasTypedObject>)index.getColumnsRef());
            presentation.addText(" " + columns + unique, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else if (element instanceof DasSynonym && (pathString = StringUtil.join((Iterable)(path = (synonym = (DasSynonym)element).getTargetPath()), (String)".")).length() > 0) {
            String text = " " + DbNodeDescriptor.arrow() + " " + pathString;
            presentation.addText(text, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    public PresentableNodeDescriptor getChildToHighlightAt(int index) {
        return null;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        return DbNodeDescriptor.getData(dataId, this.getElement());
    }

    static Object getData(@NonNls String dataId, DbElement element) {
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            final Project project = element.getProject();
            final Object delegate = ContainerUtil.getFirstItem(((DbElementImpl)element).getDelegates());
            if (delegate instanceof Navigatable) {
                return delegate;
            }
            if (delegate instanceof DatabaseSystem) {
                VirtualFile virtualFile = delegate instanceof SqlDataSource ? (VirtualFile)ContainerUtil.getFirstItem((List)((SqlDataSource)delegate).getFiles()) : DatabaseEditorHelper.findExistingConsoleVirtualFile((DatabaseSystem)delegate);
                if (virtualFile == null && DbImplUtil.canConnectTo(element)) {
                    return new NavigatableAdapter(){

                        public void navigate(boolean requestFocus) {
                            VirtualFile file = DatabaseEditorHelper.getConsoleVirtualFile((DatabaseSystem)delegate);
                            if (file == null) {
                                return;
                            }
                            new OpenFileDescriptor(project, file).navigate(requestFocus);
                        }
                    };
                }
                return virtualFile == null ? element : new OpenFileDescriptor(project, virtualFile);
            }
            if (delegate instanceof DasNamespace && element.getKind() == ObjectKind.SCHEMA) {
                if (DbImplUtil.canConnectTo(element)) {
                    final DatabaseSystem dataSourceInfo = (DatabaseSystem)ObjectUtils.assertNotNull((Object)element.getDataSource().getDelegate());
                    return new NavigatableAdapter(){

                        public void navigate(boolean requestFocus) {
                            DatabaseEditorHelper.openConsoleFile(project, dataSourceInfo, (DasNamespace)delegate, false);
                        }
                    };
                }
                return element;
            }
            return DbNodeDescriptor.getNavigatableImpl(project, element);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return element;
        }
        return null;
    }

    @NotNull
    public static Object getNavigatableImpl(Project project, DbElement element) {
        DbElement parent = element.getDbParent();
        DbElement adjusted = parent instanceof DbTable ? parent : (parent instanceof DbPackage ? (DbElement)ObjectUtils.notNull((Object)parent.getDbChildren(DbElement.class, ObjectKind.BODY).first(), (Object)parent) : element);
        DatabaseElementVirtualFileImpl virtualFile = DatabaseElementVirtualFileImpl.findFile(adjusted);
        if (virtualFile != null && (DatabaseEditorHelper.isTableDataAvailable(adjusted) || DatabaseEditorHelper.isDefinitionAvailable(adjusted))) {
            int offset = adjusted == element ? -1 : DatabaseOpenFileDescriptor.calcTargetOffset(project, (VirtualFile)virtualFile, (DasObject)element);
            DatabaseOpenFileDescriptor databaseOpenFileDescriptor = new DatabaseOpenFileDescriptor(virtualFile.getProject(), virtualFile, offset);
            if (databaseOpenFileDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DbNodeDescriptor", "getNavigatableImpl"));
            }
            return databaseOpenFileDescriptor;
        }
        DbElement dbElement = adjusted;
        if (dbElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DbNodeDescriptor", "getNavigatableImpl"));
        }
        return dbElement;
    }

    public boolean expandOnDoubleClick() {
        return !(this.getElement() instanceof DbTable);
    }

    public boolean isValid() {
        return this.getElement().isValid();
    }

    public int getWeight() {
        DbElement element = this.getElement();
        if (element == null || !element.isValid()) {
            return super.getWeight();
        }
        return element.getWeight();
    }

    public String toString() {
        return super.toString();
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.myElement};
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DbNodeDescriptor", "getEqualityObjects"));
        }
        return objectArray;
    }

    public final boolean equals(Object o) {
        return ComparableObjectCheck.equals((ComparableObject)this, (Object)o);
    }

    public final int hashCode() {
        return ComparableObjectCheck.hashCode((ComparableObject)this, (int)super.hashCode());
    }

    @NotNull
    public static String arrowToColumns(@Nullable String tableName, @NotNull MultiRef<? extends DasTypedObject> columnsRef) {
        if (columnsRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnsRef", "com/intellij/database/view/DbNodeDescriptor", "arrowToColumns"));
        }
        String string = StringUtil.isEmpty((String)tableName) ? "" : DbNodeDescriptor.arrow() + " " + tableName + " " + DbNodeDescriptor.multiRef(columnsRef);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DbNodeDescriptor", "arrowToColumns"));
        }
        return string;
    }

    @NotNull
    public static String multiRef(@NotNull MultiRef<? extends DasTypedObject> ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/database/view/DbNodeDescriptor", "multiRef"));
        }
        String string = ref.size() == 0 ? "" : "(" + StringUtil.join((Iterable)ref.names(), (String)", ") + ")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DbNodeDescriptor", "multiRef"));
        }
        return string;
    }

    @NotNull
    public static String arrow() {
        String string = ApplicationManager.getApplication().isUnitTestMode() ? "->" : UIUtil.rightArrow();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DbNodeDescriptor", "arrow"));
        }
        return string;
    }
}

