/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.ObjectKind;
import java.lang.reflect.Array;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseEditorCapabilities {

    public static class DbEditorCaps {
        private final TableEditorCaps myNewTableEditorCaps;
        private final TableEditorCaps myExistingTableEditorCaps;

        public DbEditorCaps(@NotNull TableEditorCaps newTableEditorCaps, @NotNull TableEditorCaps existingTableEditorCaps) {
            if (newTableEditorCaps == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTableEditorCaps", "com/intellij/database/view/editors/DatabaseEditorCapabilities$DbEditorCaps", "<init>"));
            }
            if (existingTableEditorCaps == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingTableEditorCaps", "com/intellij/database/view/editors/DatabaseEditorCapabilities$DbEditorCaps", "<init>"));
            }
            this.myNewTableEditorCaps = newTableEditorCaps;
            this.myExistingTableEditorCaps = existingTableEditorCaps;
        }

        @NotNull
        public TableEditorCaps getTableEditorCaps(boolean existing) {
            TableEditorCaps tableEditorCaps = existing ? this.myExistingTableEditorCaps : this.myNewTableEditorCaps;
            if (tableEditorCaps == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorCapabilities$DbEditorCaps", "getTableEditorCaps"));
            }
            return tableEditorCaps;
        }

        @Nullable
        public ObjectEditorCaps getModifyCaps(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/view/editors/DatabaseEditorCapabilities$DbEditorCaps", "getModifyCaps"));
            }
            TableEditorCaps tcaps = this.getTableEditorCaps(true);
            if (kind == ObjectKind.TABLE) {
                return tcaps;
            }
            if (kind == ObjectKind.COLUMN) {
                return tcaps.getColumnCaps(true);
            }
            if (kind == ObjectKind.INDEX) {
                return tcaps.getIndexCaps(true);
            }
            if (kind == ObjectKind.KEY) {
                return tcaps.getKeyCaps(true);
            }
            if (kind == ObjectKind.FOREIGN_KEY) {
                return tcaps.getForeignKeyCaps(true);
            }
            return null;
        }
    }

    public static class ForeignKeyEditorCaps
    extends ObjectEditorCaps {
        private final ValuesCapability<DasForeignKey.Deferrability> myDeferrability;
        private final ValuesCapability<DasForeignKey.RuleAction> myUpdateRule;
        private final ValuesCapability<DasForeignKey.RuleAction> myDeleteRule;

        public ForeignKeyEditorCaps(@NotNull Capability rename, @NotNull Capability comment, @NotNull ValuesCapability<DasForeignKey.Deferrability> deferrability, @NotNull ValuesCapability<DasForeignKey.RuleAction> updateRule, @NotNull ValuesCapability<DasForeignKey.RuleAction> deleteRule) {
            if (rename == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rename", "com/intellij/database/view/editors/DatabaseEditorCapabilities$ForeignKeyEditorCaps", "<init>"));
            }
            if (comment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/database/view/editors/DatabaseEditorCapabilities$ForeignKeyEditorCaps", "<init>"));
            }
            if (deferrability == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deferrability", "com/intellij/database/view/editors/DatabaseEditorCapabilities$ForeignKeyEditorCaps", "<init>"));
            }
            if (updateRule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateRule", "com/intellij/database/view/editors/DatabaseEditorCapabilities$ForeignKeyEditorCaps", "<init>"));
            }
            if (deleteRule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deleteRule", "com/intellij/database/view/editors/DatabaseEditorCapabilities$ForeignKeyEditorCaps", "<init>"));
            }
            super(rename, comment);
            this.myDeferrability = deferrability;
            this.myUpdateRule = updateRule;
            this.myDeleteRule = deleteRule;
        }

        @NotNull
        public ValuesCapability<DasForeignKey.RuleAction> getUpdateRule() {
            ValuesCapability<DasForeignKey.RuleAction> valuesCapability = this.myUpdateRule;
            if (valuesCapability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorCapabilities$ForeignKeyEditorCaps", "getUpdateRule"));
            }
            return valuesCapability;
        }

        @NotNull
        public ValuesCapability<DasForeignKey.RuleAction> getDeleteRule() {
            ValuesCapability<DasForeignKey.RuleAction> valuesCapability = this.myDeleteRule;
            if (valuesCapability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorCapabilities$ForeignKeyEditorCaps", "getDeleteRule"));
            }
            return valuesCapability;
        }

        @NotNull
        public ValuesCapability<DasForeignKey.Deferrability> getDeferrability() {
            ValuesCapability<DasForeignKey.Deferrability> valuesCapability = this.myDeferrability;
            if (valuesCapability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorCapabilities$ForeignKeyEditorCaps", "getDeferrability"));
            }
            return valuesCapability;
        }

        @Override
        public boolean canDoAnything() {
            return super.canDoAnything() || this.getUpdateRule().isAvailable() || this.getDeleteRule().isAvailable() || this.getDeferrability().isAvailable();
        }
    }

    public static class TableKeyColumnEditorCaps {
    }

    public static class IndexColumnEditorCaps {
        private final Capability mySorting;

        public IndexColumnEditorCaps(@NotNull Capability sorting) {
            if (sorting == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sorting", "com/intellij/database/view/editors/DatabaseEditorCapabilities$IndexColumnEditorCaps", "<init>"));
            }
            this.mySorting = sorting;
        }

        @NotNull
        public Capability getSorting() {
            Capability capability = this.mySorting;
            if (capability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorCapabilities$IndexColumnEditorCaps", "getSorting"));
            }
            return capability;
        }
    }

    public static class TableKeyEditorCaps
    extends KeyEditorCaps {
        private final TableEditorCaps myTableCaps;
        private final boolean myTableHasPk;
        private final boolean myIsPk;

        public TableKeyEditorCaps(@NotNull TableEditorCaps tableCaps, @NotNull KeyEditorCaps caps, boolean tableHasPk, boolean isPk) {
            if (tableCaps == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableCaps", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableKeyEditorCaps", "<init>"));
            }
            if (caps == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableKeyEditorCaps", "<init>"));
            }
            super(caps.getRename(), caps.getComment(), caps.getColumnEditorCaps());
            this.myTableCaps = tableCaps;
            this.myTableHasPk = tableHasPk;
            this.myIsPk = isPk;
        }

        @NotNull
        public Capability getPrimaryKey() {
            Capability capability = Capability.from(this.myTableCaps.getPrimaryKey().isSupported(), this.myTableCaps.getPrimaryKey().canSupersede(this.myIsPk, this.myTableHasPk));
            if (capability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableKeyEditorCaps", "getPrimaryKey"));
            }
            return capability;
        }

        @Override
        public boolean canDoAnything() {
            return super.canDoAnything() || this.getPrimaryKey().isAvailable();
        }
    }

    public static class KeyEditorCaps
    extends ObjectEditorCaps {
        private final TableKeyColumnEditorCaps myColumnEditorCaps;

        public KeyEditorCaps(@NotNull Capability rename, @NotNull Capability comment, @NotNull TableKeyColumnEditorCaps caps) {
            if (rename == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rename", "com/intellij/database/view/editors/DatabaseEditorCapabilities$KeyEditorCaps", "<init>"));
            }
            if (comment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/database/view/editors/DatabaseEditorCapabilities$KeyEditorCaps", "<init>"));
            }
            if (caps == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/view/editors/DatabaseEditorCapabilities$KeyEditorCaps", "<init>"));
            }
            super(rename, comment);
            this.myColumnEditorCaps = caps;
        }

        @NotNull
        public TableKeyColumnEditorCaps getColumnEditorCaps() {
            TableKeyColumnEditorCaps tableKeyColumnEditorCaps = this.myColumnEditorCaps;
            if (tableKeyColumnEditorCaps == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorCapabilities$KeyEditorCaps", "getColumnEditorCaps"));
            }
            return tableKeyColumnEditorCaps;
        }
    }

    public static class IndexEditorCaps
    extends ObjectEditorCaps {
        private final Capability myUnique;
        private final IndexColumnEditorCaps myColumnEditorCaps;

        public IndexEditorCaps(@NotNull Capability rename, @NotNull Capability comment, @NotNull Capability unique, @NotNull IndexColumnEditorCaps caps) {
            if (rename == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rename", "com/intellij/database/view/editors/DatabaseEditorCapabilities$IndexEditorCaps", "<init>"));
            }
            if (comment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/database/view/editors/DatabaseEditorCapabilities$IndexEditorCaps", "<init>"));
            }
            if (unique == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unique", "com/intellij/database/view/editors/DatabaseEditorCapabilities$IndexEditorCaps", "<init>"));
            }
            if (caps == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/view/editors/DatabaseEditorCapabilities$IndexEditorCaps", "<init>"));
            }
            super(rename, comment);
            this.myUnique = unique;
            this.myColumnEditorCaps = caps;
        }

        @NotNull
        public Capability getUnique() {
            Capability capability = this.myUnique;
            if (capability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorCapabilities$IndexEditorCaps", "getUnique"));
            }
            return capability;
        }

        @NotNull
        public IndexColumnEditorCaps getColumnEditorCaps() {
            IndexColumnEditorCaps indexColumnEditorCaps = this.myColumnEditorCaps;
            if (indexColumnEditorCaps == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorCapabilities$IndexEditorCaps", "getColumnEditorCaps"));
            }
            return indexColumnEditorCaps;
        }

        @Override
        public boolean canDoAnything() {
            return super.canDoAnything() || this.getUnique().isAvailable();
        }
    }

    public static class TableColumnEditorCaps
    extends ColumnEditorCaps {
        private final TableEditorCaps myTableCaps;
        private final boolean myTableHasPk;
        private final boolean myIsPk;
        private final boolean myIsUnique;

        public TableColumnEditorCaps(@NotNull TableEditorCaps tableCaps, @NotNull ColumnEditorCaps columnCaps, boolean tableHasPk, boolean isPk, boolean isUnique) {
            if (tableCaps == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableCaps", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableColumnEditorCaps", "<init>"));
            }
            if (columnCaps == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnCaps", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableColumnEditorCaps", "<init>"));
            }
            super(columnCaps.getRename(), columnCaps.getComment(), columnCaps.getDataType(), columnCaps.getAutoInc(), columnCaps.getDefault(), columnCaps.getNotNull());
            this.myTableCaps = tableCaps;
            this.myTableHasPk = tableHasPk;
            this.myIsPk = isPk;
            this.myIsUnique = isUnique;
        }

        @NotNull
        public Capability getPrimaryKey() {
            Capability capability = Capability.from(this.myTableCaps.getPrimaryKey().isSupported(), this.myTableCaps.getPrimaryKey().canSupersede(this.myIsPk, this.myTableHasPk));
            if (capability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableColumnEditorCaps", "getPrimaryKey"));
            }
            return capability;
        }

        @NotNull
        public Capability getUnique() {
            Capability capability = Capability.from(this.myTableCaps.getIndices().isSupported(), this.myTableCaps.getIndices().canChange(this.myIsUnique));
            if (capability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableColumnEditorCaps", "getUnique"));
            }
            return capability;
        }

        @Override
        public boolean canDoAnything() {
            return super.canDoAnything() || this.getPrimaryKey().isAvailable() || this.getUnique().isAvailable();
        }
    }

    public static class TableEditorCaps
    extends ObjectEditorCaps {
        private final ListCapability myColumns;
        private final ListCapability myIndices;
        private final ListCapability myForeignKeys;
        private final ListCapability myPrimaryKey;
        private final ListCapability myAltKeys;
        private final ListCapability myConstraints;
        private final ColumnEditorCaps myNewColumnCaps;
        private final ColumnEditorCaps myExistingColumnCaps;
        private final KeyEditorCaps myNewKeyCaps;
        private final KeyEditorCaps myExistingKeyCaps;
        private final IndexEditorCaps myNewIndexCaps;
        private final IndexEditorCaps myExistingIndexCaps;
        private final ForeignKeyEditorCaps myNewForeignKeyCaps;
        private final ForeignKeyEditorCaps myExistingForeignKeyCaps;

        public TableEditorCaps(@NotNull Capability rename, @NotNull Capability comment, @NotNull ListCapability columns, @NotNull ListCapability indices, @NotNull ListCapability foreignKeys, @NotNull ListCapability primaryKey, @NotNull ListCapability altKeys, @NotNull ListCapability constraints, @NotNull ColumnEditorCaps newColumnCaps, @NotNull ColumnEditorCaps existingColumnCaps, @NotNull KeyEditorCaps newKeyCaps, @NotNull KeyEditorCaps existingKeyCaps, @NotNull IndexEditorCaps newIndexCaps, @NotNull IndexEditorCaps existingIndexCaps, @NotNull ForeignKeyEditorCaps newForeignKeyCaps, @NotNull ForeignKeyEditorCaps existingForeignKeyCaps) {
            if (rename == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rename", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableEditorCaps", "<init>"));
            }
            if (comment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableEditorCaps", "<init>"));
            }
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableEditorCaps", "<init>"));
            }
            if (indices == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indices", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableEditorCaps", "<init>"));
            }
            if (foreignKeys == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foreignKeys", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableEditorCaps", "<init>"));
            }
            if (primaryKey == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryKey", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableEditorCaps", "<init>"));
            }
            if (altKeys == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "altKeys", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableEditorCaps", "<init>"));
            }
            if (constraints == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraints", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableEditorCaps", "<init>"));
            }
            if (newColumnCaps == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newColumnCaps", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableEditorCaps", "<init>"));
            }
            if (existingColumnCaps == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingColumnCaps", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableEditorCaps", "<init>"));
            }
            if (newKeyCaps == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newKeyCaps", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableEditorCaps", "<init>"));
            }
            if (existingKeyCaps == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingKeyCaps", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableEditorCaps", "<init>"));
            }
            if (newIndexCaps == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newIndexCaps", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableEditorCaps", "<init>"));
            }
            if (existingIndexCaps == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingIndexCaps", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableEditorCaps", "<init>"));
            }
            if (newForeignKeyCaps == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newForeignKeyCaps", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableEditorCaps", "<init>"));
            }
            if (existingForeignKeyCaps == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingForeignKeyCaps", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableEditorCaps", "<init>"));
            }
            super(rename, comment);
            this.myPrimaryKey = primaryKey;
            this.myColumns = columns;
            this.myIndices = indices;
            this.myForeignKeys = foreignKeys;
            this.myAltKeys = altKeys;
            this.myConstraints = constraints;
            this.myNewColumnCaps = newColumnCaps;
            this.myExistingColumnCaps = existingColumnCaps;
            this.myNewKeyCaps = newKeyCaps;
            this.myExistingKeyCaps = existingKeyCaps;
            this.myNewIndexCaps = newIndexCaps;
            this.myExistingIndexCaps = existingIndexCaps;
            this.myNewForeignKeyCaps = newForeignKeyCaps;
            this.myExistingForeignKeyCaps = existingForeignKeyCaps;
        }

        @NotNull
        public ListCapability getPrimaryKey() {
            ListCapability listCapability = this.myPrimaryKey;
            if (listCapability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableEditorCaps", "getPrimaryKey"));
            }
            return listCapability;
        }

        @NotNull
        public ListCapability getColumns() {
            ListCapability listCapability = this.myColumns;
            if (listCapability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableEditorCaps", "getColumns"));
            }
            return listCapability;
        }

        @NotNull
        public ListCapability getAltKeys() {
            ListCapability listCapability = this.myAltKeys;
            if (listCapability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableEditorCaps", "getAltKeys"));
            }
            return listCapability;
        }

        @NotNull
        public ListCapability getIndices() {
            ListCapability listCapability = this.myIndices;
            if (listCapability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableEditorCaps", "getIndices"));
            }
            return listCapability;
        }

        @NotNull
        public ListCapability getForeignKeys() {
            ListCapability listCapability = this.myForeignKeys;
            if (listCapability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableEditorCaps", "getForeignKeys"));
            }
            return listCapability;
        }

        @NotNull
        public ListCapability getConstraints() {
            ListCapability listCapability = this.myConstraints;
            if (listCapability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableEditorCaps", "getConstraints"));
            }
            return listCapability;
        }

        @NotNull
        public ColumnEditorCaps getColumnCaps(boolean existing) {
            ColumnEditorCaps columnEditorCaps = existing ? this.myExistingColumnCaps : this.myNewColumnCaps;
            if (columnEditorCaps == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableEditorCaps", "getColumnCaps"));
            }
            return columnEditorCaps;
        }

        @NotNull
        public IndexEditorCaps getIndexCaps(boolean existing) {
            IndexEditorCaps indexEditorCaps = existing ? this.myExistingIndexCaps : this.myNewIndexCaps;
            if (indexEditorCaps == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableEditorCaps", "getIndexCaps"));
            }
            return indexEditorCaps;
        }

        @NotNull
        public ForeignKeyEditorCaps getForeignKeyCaps(boolean existing) {
            ForeignKeyEditorCaps foreignKeyEditorCaps = existing ? this.myExistingForeignKeyCaps : this.myNewForeignKeyCaps;
            if (foreignKeyEditorCaps == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableEditorCaps", "getForeignKeyCaps"));
            }
            return foreignKeyEditorCaps;
        }

        @NotNull
        public KeyEditorCaps getKeyCaps(boolean existing) {
            KeyEditorCaps keyEditorCaps = existing ? this.myExistingKeyCaps : this.myNewKeyCaps;
            if (keyEditorCaps == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableEditorCaps", "getKeyCaps"));
            }
            return keyEditorCaps;
        }

        @Override
        public boolean canDoAnything() {
            return super.canDoAnything() || this.getPrimaryKey().canDoAnything() || this.getColumns().canDoAnything() || this.getIndices().canDoAnything() || this.getForeignKeys().canDoAnything() || this.getConstraints().canDoAnything() || this.getColumnCaps(true).canDoAnything() || this.getColumnCaps(false).canDoAnything() || this.getIndexCaps(true).canDoAnything() || this.getIndexCaps(false).canDoAnything() || this.getForeignKeyCaps(true).canDoAnything() || this.getForeignKeyCaps(false).canDoAnything();
        }
    }

    public static class ColumnEditorCaps
    extends ObjectEditorCaps {
        private final Capability myDataType;
        private final Capability myAutoInc;
        private final Capability myDefault;
        private final Capability myNotNull;

        public ColumnEditorCaps(@NotNull Capability rename, @NotNull Capability comment, @NotNull Capability dataType, @NotNull Capability autoInc, @NotNull Capability aDefault, @NotNull Capability notNull) {
            if (rename == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rename", "com/intellij/database/view/editors/DatabaseEditorCapabilities$ColumnEditorCaps", "<init>"));
            }
            if (comment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/database/view/editors/DatabaseEditorCapabilities$ColumnEditorCaps", "<init>"));
            }
            if (dataType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/view/editors/DatabaseEditorCapabilities$ColumnEditorCaps", "<init>"));
            }
            if (autoInc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "autoInc", "com/intellij/database/view/editors/DatabaseEditorCapabilities$ColumnEditorCaps", "<init>"));
            }
            if (aDefault == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aDefault", "com/intellij/database/view/editors/DatabaseEditorCapabilities$ColumnEditorCaps", "<init>"));
            }
            if (notNull == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notNull", "com/intellij/database/view/editors/DatabaseEditorCapabilities$ColumnEditorCaps", "<init>"));
            }
            super(rename, comment);
            this.myDataType = dataType;
            this.myAutoInc = autoInc;
            this.myDefault = aDefault;
            this.myNotNull = notNull;
        }

        @NotNull
        public Capability getAutoInc() {
            Capability capability = this.myAutoInc;
            if (capability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorCapabilities$ColumnEditorCaps", "getAutoInc"));
            }
            return capability;
        }

        @NotNull
        public Capability getDefault() {
            Capability capability = this.myDefault;
            if (capability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorCapabilities$ColumnEditorCaps", "getDefault"));
            }
            return capability;
        }

        @NotNull
        public Capability getNotNull() {
            Capability capability = this.myNotNull;
            if (capability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorCapabilities$ColumnEditorCaps", "getNotNull"));
            }
            return capability;
        }

        @NotNull
        public Capability getDataType() {
            Capability capability = this.myDataType;
            if (capability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorCapabilities$ColumnEditorCaps", "getDataType"));
            }
            return capability;
        }

        @Override
        public boolean canDoAnything() {
            return super.canDoAnything() || this.getAutoInc().isAvailable() || this.getDefault().isAvailable() || this.getNotNull().isAvailable() || this.getDataType().isAvailable();
        }
    }

    public static abstract class ObjectEditorCaps {
        private final Capability myRename;
        private final Capability myComment;

        protected ObjectEditorCaps(@NotNull Capability rename, @NotNull Capability comment) {
            if (rename == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rename", "com/intellij/database/view/editors/DatabaseEditorCapabilities$ObjectEditorCaps", "<init>"));
            }
            if (comment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/database/view/editors/DatabaseEditorCapabilities$ObjectEditorCaps", "<init>"));
            }
            this.myRename = rename;
            this.myComment = comment;
        }

        @NotNull
        public Capability getRename() {
            Capability capability = this.myRename;
            if (capability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorCapabilities$ObjectEditorCaps", "getRename"));
            }
            return capability;
        }

        @NotNull
        public Capability getComment() {
            Capability capability = this.myComment;
            if (capability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorCapabilities$ObjectEditorCaps", "getComment"));
            }
            return capability;
        }

        public boolean canDoAnything() {
            return this.getRename().isAvailable() || this.getComment().isAvailable();
        }
    }

    public static class ValuesCapability<T> {
        private final Capability myCapability;
        private final T[] myValues;

        public static <T> ValuesCapability<T> unsupported(@NotNull Class<T> clazz) {
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/view/editors/DatabaseEditorCapabilities$ValuesCapability", "unsupported"));
            }
            return new ValuesCapability<Object>(Capability.UNSUPPORTED, (Object[])Array.newInstance(clazz, 0));
        }

        public static <T> ValuesCapability<T> supported(boolean avail, T ... values) {
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/database/view/editors/DatabaseEditorCapabilities$ValuesCapability", "supported"));
            }
            return new ValuesCapability<T>(Capability.available(avail), values);
        }

        private ValuesCapability(Capability capability, T[] values) {
            this.myCapability = capability;
            this.myValues = values;
        }

        public boolean isAvailable() {
            return this.myCapability.isAvailable();
        }

        public boolean isSupported() {
            return this.myCapability.isSupported();
        }

        public T[] values() {
            return this.myValues;
        }
    }

    public static class ListCapability {
        private static final int REORDERABLE = 1;
        private static final int ADDABLE = 2;
        private static final int REMOVABLE = 4;
        private static final int UNSUPPORTED = 8;
        private static final ListCapability[] INSTANCES = new ListCapability[9];
        private final int myFlags;

        public static ListCapability unsupported() {
            return INSTANCES[8];
        }

        public static ListCapability supported(boolean reorder, boolean add, boolean remove) {
            return INSTANCES[(reorder ? 1 : 0) + (add ? 2 : 0) + (remove ? 4 : 0)];
        }

        public static ListCapability get(boolean supported, boolean reorder, boolean add, boolean remove) {
            return supported ? ListCapability.supported(reorder, add, remove) : ListCapability.unsupported();
        }

        public boolean canDoAnything() {
            return this.canAdd() || this.canRemove() || this.canReorder();
        }

        public boolean isSupported() {
            return this.myFlags != 8;
        }

        public boolean canSupersede(boolean addedMy, boolean addedAny) {
            return addedAny && !addedMy ? this.canReadd() : this.canChange(addedMy);
        }

        public boolean canReadd() {
            return this.canRemove() && this.canAdd();
        }

        public boolean canChange(boolean added) {
            return added ? this.canRemove() : this.canAdd();
        }

        public boolean canAdd() {
            return (this.myFlags & 2) != 0;
        }

        public boolean canRemove() {
            return (this.myFlags & 4) != 0;
        }

        public boolean canReorder() {
            return (this.myFlags & 1) != 0;
        }

        private ListCapability(int flags) {
            this.myFlags = flags;
        }

        static {
            for (int i = 0; i < INSTANCES.length; ++i) {
                ListCapability.INSTANCES[i] = new ListCapability(i);
            }
        }
    }

    public static enum Capability {
        UNSUPPORTED,
        UNAVAILABLE,
        AVAILABLE;


        public boolean isAvailable() {
            return this == AVAILABLE;
        }

        public boolean isSupported() {
            return this != UNSUPPORTED;
        }

        public <T> T convert(T unsup, T unavail, T avail) {
            return this == UNSUPPORTED ? unsup : (this == UNAVAILABLE ? unavail : avail);
        }

        @NotNull
        public static Capability from(boolean supported, boolean avail) {
            Capability capability = !supported ? UNSUPPORTED : (avail ? AVAILABLE : UNAVAILABLE);
            if (capability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorCapabilities$Capability", "from"));
            }
            return capability;
        }

        @NotNull
        public static Capability available(boolean avail) {
            Capability capability = avail ? AVAILABLE : UNAVAILABLE;
            if (capability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorCapabilities$Capability", "available"));
            }
            return capability;
        }

        @NotNull
        public static Capability supported(boolean sup) {
            Capability capability = sup ? AVAILABLE : UNSUPPORTED;
            if (capability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorCapabilities$Capability", "supported"));
            }
            return capability;
        }
    }
}

