/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.CommonBundle;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.actions.AddDataSourceFromUrl;
import com.intellij.database.actions.DdlActions;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.AbstractDataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceTemplate;
import com.intellij.database.dataSource.DataSourceTemplateAdapter;
import com.intellij.database.dataSource.DatabaseArtifactManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DataSourceProblemsCollector;
import com.intellij.database.dataSource.validation.DataSourceProblemsProvider;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.dataSource.validation.NamedProgressive;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.psi.DbPsiManager;
import com.intellij.database.psi.DbPsiManagerSpi;
import com.intellij.database.psi.DefaultDbPsiManager;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.ui.DataSourceErrorsConfigurable;
import com.intellij.database.view.ui.DataSourceSettings;
import com.intellij.database.view.ui.DataSourceSidePanel;
import com.intellij.database.view.ui.DatabaseConfigController;
import com.intellij.database.view.ui.DatabaseDriverConfigurable;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.database.view.ui.SidePanelItem;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.SidePanelCountLabel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.navigation.BackAction;
import com.intellij.ui.navigation.ForwardAction;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntArrayList;
import icons.DatabaseIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DatabaseConfigEditor
extends SettingsEditor<DataSourceSettings>
implements DatabaseConfigController,
Place.Navigator {
    private static final Logger LOG = Logger.getInstance(DatabaseConfigEditor.class);
    private final DatabaseCredentials myDatabaseCredentials = DatabaseCredentials.newUIInstance();
    private final DataSourceSettings mySettings;
    private final JPanel myRootPanel;
    private final JPanel myRightPanel;
    private final Map<Object, SidePanelItem> mySidePanelItems = ContainerUtil.newIdentityHashMap();
    private final JPanel myInfoPanel;
    private SidePanelItem mySelectedItem;
    private DataSourceErrorsConfigurable myErrorsConfigurable;
    private ValidationComponent myValidationComponent;
    private ValidationComponent myErrorInfoComponent;
    private final DataSourceProblemsCollector<SidePanelItem> myErrorsCollector;
    private final List<Object> myRemovedObjects = ContainerUtil.newArrayList();
    private final UserDataHolderBase myUserDataHolder = new UserDataHolderBase();
    private boolean myFilling = false;
    final DatabaseConfigValidator.Control myControl = new DatabaseConfigValidator.Control(){

        @Override
        @NotNull
        public <T> T actualize(@NotNull T driver, boolean forEdit) {
            if (driver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/view/ui/DatabaseConfigEditor$1", "actualize"));
            }
            Object object = ObjectUtils.chooseNotNull((Object)DatabaseConfigEditor.this.actualizeObject(driver, forEdit), driver);
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditor$1", "actualize"));
            }
            return (T)object;
        }

        @Override
        public void changed(@NotNull Object object) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/ui/DatabaseConfigEditor$1", "changed"));
            }
            if (object instanceof DatabaseDriver) {
                SidePanelItem.DriverItem item = DatabaseConfigEditor.this.findItem((DatabaseDriver)object);
                if (item != null && item.getConfigurable() != null) {
                    ((DatabaseDriverConfigurable)((Object)item.getConfigurable())).reset(((DatabaseDriverConfigurable)((Object)item.getConfigurable())).getTempDriverRef());
                }
                DatabaseConfigEditor.this.updateDriverDependants((DatabaseDriver)object);
            }
        }
    };
    private History myHistory = new History((Place.Navigator)this);
    private DataSourceSidePanel mySidePanel;
    private AddAction myAddAction;
    private final Function.Mono<DataSourceTemplate> ACTUALIZE_WRAPPER = new Function.Mono<DataSourceTemplate>(){

        public DataSourceTemplate fun(DataSourceTemplate template) {
            return new DataSourceTemplateAdapter(template){

                private DataSourceTemplate actual() {
                    if (this.myDelegate instanceof DatabaseDriver) {
                        return DatabaseConfigEditor.this.actualize((DatabaseDriver)this.myDelegate, false);
                    }
                    return this.myDelegate;
                }

                @NotNull
                public String getName() {
                    String string = this.actual().getName();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditor$10$1", "getName"));
                    }
                    return string;
                }

                @NotNull
                public String getFullName() {
                    String string = this.actual().getFullName();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditor$10$1", "getFullName"));
                    }
                    return string;
                }

                @NotNull
                public List<DataSourceTemplate> getSubConfigurations() {
                    List list = this.actual().getSubConfigurations();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditor$10$1", "getSubConfigurations"));
                    }
                    return list;
                }

                public Icon getIcon(@Iconable.IconFlags int flags) {
                    return this.actual().getIcon(flags);
                }
            };
        }
    };

    DatabaseConfigEditor(DataSourceSettings settings) {
        int newDsAmount = settings.getNewDataSources().size();
        int newDrAmount = settings.getNewDrivers().size();
        if (newDsAmount > 10 || newDrAmount > 10) {
            LOG.info("Data Sources: " + newDsAmount + ", Drivers: " + newDrAmount);
        }
        this.mySettings = settings;
        this.myRootPanel = new MyRootPanel(new BorderLayout());
        this.myRightPanel = new NonOpaquePanel((LayoutManager)new BorderLayout(0, 5));
        this.myValidationComponent = new ValidationComponent(false);
        this.myErrorInfoComponent = new ValidationComponent(true);
        this.myInfoPanel = new JPanel(new BorderLayout());
        this.myInfoPanel.add((Component)this.myErrorInfoComponent, "North");
        this.myInfoPanel.add((Component)this.myValidationComponent, "South");
        this.myErrorsConfigurable = new DataSourceErrorsConfigurable(this, () -> {
            Place place = this.getPlace(this.myErrorsConfigurable);
            this.mySidePanel.getList().invalidate();
            this.mySidePanel.getList().repaint();
            this.mySidePanel.setMinimumWidth(this.mySidePanel.getItemWidth(place));
        });
        this.myErrorsCollector = new DataSourceProblemsCollector(this.myErrorsConfigurable);
        OnePixelSplitter mySplitter = new OnePixelSplitter(false, 0.3f);
        mySplitter.setFirstComponent(this.createLeftPanel());
        mySplitter.setSecondComponent((JComponent)this.myRightPanel);
        this.myRootPanel.add((Component)mySplitter, "Center");
        Dimension d = this.myRootPanel.getPreferredSize();
        d.width = Math.max(d.width, 800);
        d.height = Math.max(d.height, 600);
        this.myRootPanel.setPreferredSize(d);
        this.setSelectedEditor(null);
        this.resetTreeModel(settings);
        DatabaseArtifactManager.getInstance().addListener((artifactName, artifactVersion) -> ContainerUtil.process(this.mySidePanelItems.values(), (Processor)new SidePanelItem.ItemsVisitor(){

            @Override
            boolean visit(SidePanelItem.DriverItem driverItem) {
                DatabaseDriverImpl driver;
                DatabaseDriverConfigurable conf = (DatabaseDriverConfigurable)((Object)driverItem.getConfigurable());
                DatabaseDriverImpl databaseDriverImpl = driver = conf == null ? null : conf.getTempDriver();
                if (driver != null && (artifactName == null || Comparing.equal((String)driver.getArtifactName(), (String)artifactName) && Comparing.equal((String)driver.getArtifactVersion(), (String)artifactVersion)) && driverItem.getConfigurable() != null) {
                    ((DatabaseDriverConfigurable)((Object)driverItem.getConfigurable())).reset(driver);
                    DatabaseConfigEditor.this.updateDriverDependants(driver);
                }
                return true;
            }
        }), (Disposable)this);
        this.addSettingsEditorListener(e -> {
            this.stateChangedAsyncInner();
            this.updateSidePanelImpl();
        });
        DbUIUtil.invokeLater(() -> DatabaseArtifactManager.getInstance().updateLists());
    }

    void updateDriverDependants(DatabaseDriver driver) {
        final DatabaseDriver actualDriver = this.actualize(driver, false);
        ContainerUtil.process(this.mySidePanelItems.values(), (Processor)new SidePanelItem.ItemsVisitor(){

            @Override
            boolean visit(SidePanelItem.DataSourceItem dataSourceItem) {
                LocalDataSource dataSource = dataSourceItem.extractActualLocalDataSource();
                if (dataSource != null && actualDriver == DatabaseConfigEditor.this.actualize(dataSource.getDatabaseDriver(), false)) {
                    AbstractDataSourceConfigurable configurable = (AbstractDataSourceConfigurable)((Object)dataSourceItem.getConfigurable());
                    if (configurable != null) {
                        configurable.onUserActivity();
                    } else {
                        DatabaseConfigEditor.createEditorIfNeeded(dataSourceItem);
                    }
                    DatabaseConfigEditor.this.myErrorsCollector.update(dataSourceItem);
                }
                return true;
            }
        });
    }

    @Nullable
    private SidePanelItem.DriverItem findItem(final @NotNull DatabaseDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/view/ui/DatabaseConfigEditor", "findItem"));
        }
        SidePanelItem.DriverItem item = (SidePanelItem.DriverItem)ObjectUtils.tryCast((Object)this.mySidePanelItems.get(driver), SidePanelItem.DriverItem.class);
        if (item != null) {
            return item;
        }
        final Ref result = Ref.create();
        ContainerUtil.process(this.mySidePanelItems.values(), (Processor)new SidePanelItem.ItemsVisitor(){

            @Override
            boolean visit(SidePanelItem.DriverItem driverItem) {
                DatabaseDriverConfigurable configurable = (DatabaseDriverConfigurable)((Object)driverItem.getConfigurable());
                if (driverItem.getObject() == driver || configurable != null && configurable.getTempDriverRef() == driver) {
                    result.set((Object)driverItem);
                    return false;
                }
                return true;
            }
        });
        return (SidePanelItem.DriverItem)result.get();
    }

    private void updateSidePanelImpl() {
        final SidePanelItem item = this.mySelectedItem;
        if (item == null) {
            return;
        }
        this.myErrorsCollector.update(item);
        this.updateValidationProblem(this.mySelectedItem);
        this.mySidePanel.getList().invalidate();
        this.mySidePanel.getList().repaint();
        if (item.getObject() instanceof DatabaseDriver) {
            ContainerUtil.process(this.mySidePanelItems.values(), (Processor)new SidePanelItem.ItemsVisitor(){

                @Override
                boolean visit(SidePanelItem.DataSourceItem dsItem) {
                    LocalDataSource source = dsItem.extractActualLocalDataSource();
                    if (source == null || source.getDatabaseDriver() != item.getObject()) {
                        return true;
                    }
                    DataSourceConfigurable conf = (DataSourceConfigurable)((Object)ObjectUtils.tryCast((Object)DatabaseConfigEditor.createEditorIfNeeded(dsItem), DataSourceConfigurable.class));
                    if (conf != null) {
                        conf.actualizeDriver();
                    }
                    return true;
                }
            });
        }
    }

    private void stateChangedAsyncInner() {
        DatabaseDriverConfigurable driverConfigurable;
        AbstractDataSourceConfigurable dsConfigurable;
        if (this.myFilling) {
            return;
        }
        this.clearModifiedCache();
        AbstractDataSourceConfigurable abstractDataSourceConfigurable = dsConfigurable = this.mySelectedItem == null ? null : (AbstractDataSourceConfigurable)((Object)ObjectUtils.tryCast(this.mySelectedItem.getConfigurable(), AbstractDataSourceConfigurable.class));
        if (dsConfigurable != null) {
            dsConfigurable.onUserActivity();
        }
        DatabaseDriverConfigurable databaseDriverConfigurable = driverConfigurable = this.mySelectedItem == null ? null : (DatabaseDriverConfigurable)((Object)ObjectUtils.tryCast(this.mySelectedItem.getConfigurable(), DatabaseDriverConfigurable.class));
        if (driverConfigurable != null) {
            this.updateDriverDependants(driverConfigurable.getTempDriver());
        }
    }

    @Nullable
    private Place getPlace(@Nullable Object object) {
        SidePanelItem item = this.mySidePanelItems.get(object);
        return item == null ? null : item.getPlace();
    }

    @Nullable
    private SidePanelItem getItem(@Nullable Place place) {
        SidePanelItem item = SidePanelItem.getItem(place);
        if (item != null) {
            item = this.mySidePanelItems.get(item.getObject());
        }
        return item;
    }

    private void clearModifiedCache() {
        for (SidePanelItem item : this.mySidePanelItems.values()) {
            item.resetModifiedCache();
        }
    }

    private void removeSidePanelItem(@NotNull SidePanelItem item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/view/ui/DatabaseConfigEditor", "removeSidePanelItem"));
        }
        SidePanelItem old = this.mySidePanelItems.remove(item.getObject());
        item.removeConfigurable();
        this.myErrorsCollector.remove(item);
        assert (old == item);
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/view/ui/DatabaseConfigEditor", "getUserData"));
        }
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/view/ui/DatabaseConfigEditor", "putUserData"));
        }
        this.myUserDataHolder.putUserData(key, value);
    }

    public void setHistory(History history) {
        this.myHistory = history;
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        SidePanelItem item = this.getItem(place);
        if (item != this.mySelectedItem) {
            this.setSelectedEditor(item);
            if (this.mySelectedItem != null) {
                this.myHistory.pushQueryPlace();
                if (requestFocus) {
                    UIUtil.requestFocus((JComponent)((JComponent)ObjectUtils.assertNotNull((Object)this.mySelectedItem.getComponent())));
                }
            }
            this.mySidePanel.select(place);
            this.updateSidePanelImpl();
        }
        return ActionCallback.DONE;
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/database/view/ui/DatabaseConfigEditor", "queryPlace"));
        }
        SidePanelItem.setItem(place, this.mySelectedItem);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySidePanel.getList();
    }

    protected void disposeEditor() {
        super.disposeEditor();
        for (SidePanelItem item : ContainerUtil.newArrayList(this.mySidePanelItems.values())) {
            this.removeSidePanelItem(item);
        }
        this.myErrorsConfigurable.disposeUIResources();
        for (DbDataSource o : ContainerUtil.newArrayList(this.mySettings.getNewDataSources())) {
            if (o.isValid()) continue;
            this.mySettings.removeNewDataSource(o);
        }
        this.mySettings.getPsiFacade().clearCaches(null);
    }

    public String getHelpTopic() {
        Object configurable = this.mySelectedItem == null ? null : this.mySelectedItem.getConfigurable();
        return configurable == null ? null : configurable.getHelpTopic();
    }

    public boolean isAnyEditorModified() {
        if (!this.myRemovedObjects.isEmpty()) {
            return true;
        }
        for (SidePanelItem item : this.mySidePanelItems.values()) {
            if (!this.isObjectModified(item)) continue;
            return true;
        }
        return false;
    }

    protected void resetEditorFrom(@NotNull DataSourceSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/view/ui/DatabaseConfigEditor", "resetEditorFrom"));
        }
        this.resetTreeModel(settings);
        for (SidePanelItem item : this.mySidePanelItems.values()) {
            if (!item.isModified()) continue;
            ((Configurable)ObjectUtils.assertNotNull(item.getConfigurable())).reset();
        }
        this.clearModifiedCache();
    }

    protected void applyEditorTo(@NotNull DataSourceSettings settings) throws ConfigurationException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/view/ui/DatabaseConfigEditor", "applyEditorTo"));
        }
        for (SidePanelItem item : ContainerUtil.newArrayList(this.mySidePanelItems.values())) {
            boolean created = this.isObjectCreated(item);
            if (!item.isModified() && !created) continue;
            item.apply();
            if (!created) continue;
            this.ensureNewObjectDropped(item.getObject());
        }
        DdlActions.closeAllFilesBeforeDataSourceRemoval(this.mySettings.getProject(), (Set)JBIterable.from(this.myRemovedObjects).filter(DbDataSourceImpl.class).addAllTo((Collection)ContainerUtil.newLinkedHashSet()));
        Iterator<Object> it = this.myRemovedObjects.iterator();
        while (it.hasNext()) {
            this.removeObject(it.next());
            it.remove();
        }
        this.clearModifiedCache();
        Set selection = this.getSelectedItems().toSet();
        this.refillSidePanel(this.mySettings);
        this.restoreSelection(selection);
    }

    private void resetTreeModel(DataSourceSettings settings) {
        this.refillSidePanel(settings);
        this.navigateTo(this.mySettings.getCurrentDataSource());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditor", "createEditor"));
        }
        return jPanel;
    }

    private <I extends SidePanelItem> I createItem(@NotNull I item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/view/ui/DatabaseConfigEditor", "createItem"));
        }
        this.mySidePanelItems.put(item.getObject(), item);
        this.ensureErrorProviderExistence(item);
        return item;
    }

    private SidePanelItem.DataSourceItem createItem(@NotNull DbDataSource obj) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/view/ui/DatabaseConfigEditor", "createItem"));
        }
        SidePanelItem.DataSourceItem item = (SidePanelItem.DataSourceItem)this.mySidePanelItems.get(obj);
        if (item == null) {
            item = new SidePanelItem.DataSourceItem(this, obj);
        }
        return this.createItem(item);
    }

    private SidePanelItem.DriverItem createItem(@NotNull DatabaseDriver obj) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/view/ui/DatabaseConfigEditor", "createItem"));
        }
        SidePanelItem.DriverItem item = (SidePanelItem.DriverItem)this.mySidePanelItems.get(obj);
        if (item == null) {
            item = new SidePanelItem.DriverItem(this, obj);
        }
        return this.createItem(item);
    }

    private SidePanelItem.ErrorsItem createItem(@NotNull DataSourceErrorsConfigurable obj) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/view/ui/DatabaseConfigEditor", "createItem"));
        }
        SidePanelItem.ErrorsItem item = (SidePanelItem.ErrorsItem)this.mySidePanelItems.get(obj);
        if (item == null) {
            item = new SidePanelItem.ErrorsItem(this, obj);
        }
        return this.createItem(item);
    }

    private SidePanelItem addToSidePanel(@NotNull SidePanelItem item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/view/ui/DatabaseConfigEditor", "addToSidePanel"));
        }
        Place place = item.createPlace();
        this.mySidePanel.addPlace(place);
        return item;
    }

    private void ensureErrorProviderExistence(@NotNull SidePanelItem item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/view/ui/DatabaseConfigEditor", "ensureErrorProviderExistence"));
        }
        DataSourceProblemsProvider provider = (DataSourceProblemsProvider)ObjectUtils.tryCast((Object)item, DataSourceProblemsProvider.class);
        if (provider == null || this.myErrorsCollector.contains(item)) {
            return;
        }
        this.myErrorsCollector.add(item, provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refillSidePanel(@NotNull DataSourceSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/view/ui/DatabaseConfigEditor", "refillSidePanel"));
        }
        this.myFilling = true;
        try {
            this.mySidePanel.getList().getSelectionModel().setValueIsAdjusting(true);
            this.mySidePanel.clear();
            ArrayList localDataSources = ContainerUtil.newArrayList();
            ArrayList globalDataSources = ContainerUtil.newArrayList();
            ArrayList importedDataSources = ContainerUtil.newArrayList();
            for (DbDataSource element : this.getAllDataSources()) {
                SidePanelItem.DataSourceItem item = this.createItem(element);
                if (item.isImported()) {
                    importedDataSources.add(item);
                    continue;
                }
                if (item.isGlobal()) {
                    globalDataSources.add(item);
                    continue;
                }
                localDataSources.add(item);
            }
            Comparator dataSourceElementComparator = (o1, o2) -> StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName());
            Collections.sort(importedDataSources, dataSourceElementComparator);
            Collections.sort(localDataSources, dataSourceElementComparator);
            Collections.sort(globalDataSources, dataSourceElementComparator);
            HashSet addedItems = ContainerUtil.newHashSet();
            this.mySidePanel.addSeparator("Project Data Sources");
            for (Object ds : localDataSources) {
                addedItems.add(this.addToSidePanel((SidePanelItem)ds));
            }
            this.mySidePanel.addSeparator("Global Data Sources");
            for (Object ds : globalDataSources) {
                addedItems.add(this.addToSidePanel((SidePanelItem)ds));
            }
            this.mySidePanel.addSeparator("Imported Data Sources");
            for (Object ds : importedDataSources) {
                addedItems.add(this.addToSidePanel((SidePanelItem)ds));
            }
            this.mySidePanel.addSeparator("--");
            this.mySidePanel.addSeparator("Drivers");
            HashSet newDrivers = ContainerUtil.newHashSet(this.mySettings.getNewDrivers());
            for (DatabaseDriver driver : this.getAllDrivers(settings)) {
                SidePanelItem item = this.createItem(driver);
                if (newDrivers.contains(driver)) {
                    DatabaseConfigEditor.createEditorIfNeeded(item);
                }
                addedItems.add(this.addToSidePanel(item));
            }
            this.mySidePanel.addSeparator("---");
            SidePanelItem.ErrorsItem errorsItem = this.createItem(this.myErrorsConfigurable);
            addedItems.add(this.addToSidePanel(errorsItem));
            for (SidePanelItem item : ContainerUtil.newArrayList(this.mySidePanelItems.values())) {
                if (addedItems.contains(item)) continue;
                this.removeSidePanelItem(item);
            }
            this.mySidePanel.setMinimumWidth(this.mySidePanel.getItemWidth(this.getPlace(this.myErrorsConfigurable)));
        }
        finally {
            this.myFilling = false;
            this.mySidePanel.getList().getSelectionModel().setValueIsAdjusting(false);
        }
    }

    public int getDataSourceGroup(@Nullable Object object) {
        switch (Kind.kindOf(object)) {
            case DATABASE: {
                return 2;
            }
            case DRIVER: {
                return 1;
            }
        }
        return 0;
    }

    @NotNull
    private JComponent createToolbarComponent(AnAction ... actions) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/database/view/ui/DatabaseConfigEditor", "createToolbarComponent"));
        }
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.addAll(actions);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ProjectViewToolbar", (ActionGroup)toolbarGroup, true);
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.setTargetComponent((JComponent)this.myRootPanel);
        JComponent component = toolbar.getComponent();
        component.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        JComponent jComponent = component;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditor", "createToolbarComponent"));
        }
        return jComponent;
    }

    private JComponent createLeftPanel() {
        this.mySidePanel = new DataSourceSidePanel(new MyComponentConfigurator(), (Function<Place, String>)((Function)place -> {
            SidePanelItem item = SidePanelItem.getItem(place);
            return item == null ? null : item.getName();
        }));
        this.mySidePanel.getList().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                Object o = ((JList)e.getSource()).getSelectedValue();
                DatabaseConfigEditor.this.navigateTo(SidePanelItem.getObject(SidePanelItem.getItem((Place)ObjectUtils.tryCast(o, Place.class))));
            }
        });
        ActionManager actionManager = ActionManager.getInstance();
        JList target = this.mySidePanel.getList();
        this.myAddAction = new AddAction();
        this.myAddAction.registerCustomShortcutSet(CommonShortcuts.getNewForDialogs(), target);
        RemoveAction removeAction = new RemoveAction();
        removeAction.registerCustomShortcutSet(CommonShortcuts.getDelete(), target);
        CopyAction copyAction = new CopyAction();
        copyAction.registerCustomShortcutSet(CommonShortcuts.getDuplicate(), target);
        GoToDriverAction editDefaultsAction = new GoToDriverAction();
        editDefaultsAction.registerCustomShortcutSet(actionManager.getAction("GotoDeclaration").getShortcutSet(), target);
        ForwardAction forwardAction = new ForwardAction((JComponent)this.myRootPanel);
        BackAction backAction = new BackAction((JComponent)this.myRootPanel);
        ShowUsagesAction showUsagesAction = new ShowUsagesAction();
        ResetToPredefinedAction resetToPredefAction = new ResetToPredefinedAction();
        DataSourceScopeAction scopeAction = new DataSourceScopeAction();
        showUsagesAction.registerCustomShortcutSet(actionManager.getAction("FindUsages").getShortcutSet(), target);
        ResetAction revertAction = new ResetAction();
        revertAction.registerCustomShortcutSet(actionManager.getAction("ChangesView.Revert").getShortcutSet(), target);
        JPanel toolbarsPanel = new JPanel(new BorderLayout());
        toolbarsPanel.add((Component)this.createToolbarComponent(new AnAction[]{this.myAddAction, removeAction, copyAction, editDefaultsAction, scopeAction}), "Center");
        toolbarsPanel.add((Component)this.createToolbarComponent(new AnAction[]{backAction, forwardAction}), "East");
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)toolbarsPanel, "North");
        result.add((Component)this.mySidePanel.getComponent(), "Center");
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)this.myAddAction);
        group.add((AnAction)removeAction);
        group.add((AnAction)copyAction);
        group.add((AnAction)scopeAction);
        group.addSeparator();
        group.add((AnAction)editDefaultsAction);
        group.add((AnAction)new ChooseDriverGroup());
        group.add((AnAction)showUsagesAction);
        group.addSeparator();
        group.add((AnAction)revertAction);
        group.add((AnAction)resetToPredefAction);
        PopupHandler.installPopupHandler((JComponent)target, (ActionGroup)group, (String)"unknown", (ActionManager)actionManager);
        return result;
    }

    private void showUsagesPopup(final @Nullable SidePanelItem.DriverItem item) {
        JBPopupFactory popupFactory = JBPopupFactory.getInstance();
        final ArrayList actions = new ArrayList();
        if (item != null) {
            ContainerUtil.process(this.mySidePanelItems.values(), (Processor)new SidePanelItem.ItemsVisitor(){

                @Override
                boolean visit(final SidePanelItem.DataSourceItem dataSourceItem) {
                    LocalDataSource dataSource = dataSourceItem.extractActualLocalDataSource();
                    if (dataSource != null && dataSource.getDatabaseDriver() == item.getObject()) {
                        actions.add(new DumbAwareAction(dataSourceItem.getName(), null, ((DbDataSource)dataSourceItem.getObject()).getIcon()){

                            public void actionPerformed(AnActionEvent e) {
                                DatabaseConfigEditor.this.navigateTo(dataSourceItem.getObject());
                            }
                        });
                    }
                    return true;
                }
            });
        }
        if (actions.isEmpty()) {
            Messages.showInfoMessage((Component)this.mySidePanel.getComponent(), (String)"No usages found", (String)"Driver Usages");
        } else {
            int selectedRow = this.mySidePanel.getList().getSelectedIndex();
            Rectangle rowBounds = this.mySidePanel.getList().getCellBounds(selectedRow, selectedRow);
            Point location = rowBounds.getLocation();
            location.x += rowBounds.width;
            ListPopup popup = popupFactory.createActionGroupPopup("Used By", (ActionGroup)new DefaultActionGroup(actions), (DataContext)new DataManagerImpl.MyDataContext((Component)this.mySidePanel.getList()), null, true);
            popup.show(new RelativePoint((Component)this.mySidePanel.getList(), location));
        }
    }

    @Nullable
    public String getObjectName(@Nullable Object object) {
        SidePanelItem item = this.mySidePanelItems.get(object);
        return item == null ? null : item.getName();
    }

    private boolean isObjectCreated(@Nullable SidePanelItem item) {
        if (item == null) {
            return false;
        }
        final Ref result = Ref.create((Object)false);
        item.accept(new SidePanelItem.ItemsVisitor(){

            @Override
            boolean visit(SidePanelItem.DataSourceItem dataSourceItem) {
                result.set((Object)DatabaseConfigEditor.this.mySettings.getNewDataSources().contains(dataSourceItem.getObject()));
                return true;
            }

            @Override
            boolean visit(SidePanelItem.DriverItem driverItem) {
                result.set((Object)DatabaseConfigEditor.this.mySettings.getNewDrivers().contains(driverItem.getObject()));
                return true;
            }
        });
        return (Boolean)result.get();
    }

    private boolean isObjectModified(@Nullable SidePanelItem item) {
        return this.isObjectCreated(item) || item != null && item.isModified();
    }

    private boolean isObjectValid(@Nullable SidePanelItem item) {
        return ContainerUtil.isEmpty(this.myErrorsCollector.getProblems(item));
    }

    private static Configurable createEditorIfNeeded(@Nullable SidePanelItem item) {
        if (item != null && item.getConfigurable() == null) {
            item.createConfigurable();
        }
        return item == null ? null : (Configurable)item.getConfigurable();
    }

    private void setSelectedEditor(@Nullable SidePanelItem item) {
        if (item == this.mySelectedItem && this.myRightPanel.getComponentCount() != 0) {
            return;
        }
        this.myRightPanel.removeAll();
        this.mySelectedItem = item;
        DatabaseConfigEditor.createEditorIfNeeded(item);
        if (item != null && item.getConfigurable() != null) {
            if (item.getConfigurable() instanceof AbstractDataSourceConfigurable) {
                ((AbstractDataSourceConfigurable)((Object)item.getConfigurable())).beforeShowNotify();
            }
            this.myRightPanel.add((Component)ObjectUtils.assertNotNull((Object)item.getComponent()), "Center");
            this.myRightPanel.add((Component)this.myInfoPanel, "South");
        } else {
            JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
            panel.setBorder((Border)JBUI.Borders.empty((int)10, (int)10));
            panel.add(new JLabel("Press the"));
            ActionButton addIcon = new ActionButton((AnAction)this.myAddAction, this.myAddAction.getTemplatePresentation(), "MainToolbar", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            addIcon.setBorder((Border)JBUI.Borders.empty((int)0, (int)4));
            panel.add((Component)addIcon);
            panel.add(new JLabel("button to create a new data source"));
            JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)panel, (boolean)true);
            this.myRightPanel.add((Component)scrollPane, "Center");
        }
        UIUtil.setupEnclosingDialogBounds((JComponent)this.myRootPanel);
    }

    @Override
    public boolean isObjectNameUnique(@Nullable Object source, String name) {
        Kind kind = Kind.kindOf(source);
        if (kind == Kind.OTHER) {
            return true;
        }
        for (SidePanelItem item : this.mySidePanelItems.values()) {
            Object o = item.getObject();
            if (Kind.kindOf(o) != kind || o == source || o instanceof DbElement && ((DbElement)o).getDelegate() == source || !Comparing.equal((String)item.getName(), (String)name)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String generateObjectName(final @Nullable Object source, String baseName) {
        final HashSet existingNames = ContainerUtil.newHashSet();
        ContainerUtil.process(this.mySidePanelItems.values(), (Processor)new SidePanelItem.ItemsVisitor(){

            @Override
            boolean visit(SidePanelItem.DataSourceItem dataSourceItem) {
                if (((DbDataSource)dataSourceItem.getObject()).getDelegate() != source) {
                    existingNames.add(dataSourceItem.getName());
                }
                return true;
            }
        });
        return DbUtil.createNewDataSourceName((String)baseName, (Set)existingNames);
    }

    private void createDataSource(@NotNull DbPsiManager manager, @NotNull DataSourceTemplate type, @Nullable DatabaseSystem copyFrom, @Nullable String url) {
        LocalDataSource dataSource;
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/view/ui/DatabaseConfigEditor", "createDataSource"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/view/ui/DatabaseConfigEditor", "createDataSource"));
        }
        DatabaseSystem dataSourceInfo = type.createDataSource(this.mySettings.getProject(), copyFrom, copyFrom == null ? null : this.generateObjectName(null, copyFrom.getName()));
        if (url != null && (dataSource = (LocalDataSource)((Object)ObjectUtils.tryCast((Object)dataSourceInfo, LocalDataSource.class))) != null) {
            dataSource.setUrlSmart(url);
        }
        DbDataSource dataSourceElement = ((DbPsiFacadeImpl)this.mySettings.getPsiFacade()).createDataSourceWrapperElement(dataSourceInfo, (DbPsiManagerSpi)manager);
        this.mySettings.addNewDataSource(dataSourceElement);
        DatabaseConfigEditor.createEditorIfNeeded(this.createItem(dataSourceElement));
        this.refillSidePanel(this.mySettings);
        this.navigateTo(dataSourceElement);
    }

    private DatabaseDriver createDatabaseDriver() {
        return DatabaseDriverManager.createDefaultDatabaseDriver(this.getAllDrivers(this.mySettings));
    }

    private void addNewDriverAndNavigate(@NotNull DatabaseDriver newDriver) {
        if (newDriver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDriver", "com/intellij/database/view/ui/DatabaseConfigEditor", "addNewDriverAndNavigate"));
        }
        this.mySettings.addNewDriver(newDriver);
        this.refillSidePanel(this.mySettings);
        this.navigateTo(newDriver);
    }

    private void removeObject(Object object) {
        block2: {
            block3: {
                if (!(object instanceof DbDataSource)) break block3;
                DbDataSource element = (DbDataSource)object;
                for (DbDataSource dbDataSource : this.mySettings.getPsiFacade().getDataSources()) {
                    if (dbDataSource.getDelegate() != element.getDelegate()) continue;
                    element.getDbManager().removeDataSource(element);
                    break block2;
                }
                break block2;
            }
            if (!(object instanceof DatabaseDriver)) break block2;
            DatabaseDriver driver = (DatabaseDriver)object;
            for (DatabaseDriver databaseDriver : DatabaseDriverManager.getInstance().getDrivers()) {
                if (databaseDriver != driver) continue;
                DatabaseDriverManager.getInstance().removeDriver(driver);
                break;
            }
        }
    }

    @NotNull
    private JBIterable<SidePanelItem> getSelectedItems() {
        Object[] values = this.mySidePanel.getList().getSelectedValues();
        if (values == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditor", "getSelectedItems"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.of((Object[])values).transform(o -> {
            Place place = (Place)ObjectUtils.tryCast((Object)o, Place.class);
            return SidePanelItem.getItem(place);
        }).filter(Condition.NOT_NULL);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditor", "getSelectedItems"));
        }
        return jBIterable;
    }

    @NotNull
    private JBIterable<SidePanelItem.DataSourceItem> getSelectedDataSources() {
        JBIterable jBIterable = this.getSelectedItems().filter(SidePanelItem.DataSourceItem.class);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditor", "getSelectedDataSources"));
        }
        return jBIterable;
    }

    @NotNull
    private JBIterable<SidePanelItem.DataSourceItem> getSelectedLocalDataSources() {
        JBIterable jBIterable = this.getSelectedDataSources().filter(item -> item.extractActualLocalDataSource() != null);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditor", "getSelectedLocalDataSources"));
        }
        return jBIterable;
    }

    @NotNull
    private JBIterable<SidePanelItem.DriverItem> getSelectedDrivers() {
        JBIterable jBIterable = this.getSelectedItems().filter(SidePanelItem.DriverItem.class);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditor", "getSelectedDrivers"));
        }
        return jBIterable;
    }

    void restoreSelection(@NotNull Set<SidePanelItem> sel) {
        if (sel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sel", "com/intellij/database/view/ui/DatabaseConfigEditor", "restoreSelection"));
        }
        TIntArrayList newSelection = new TIntArrayList(sel.size());
        int count = this.mySidePanel.getList().getModel().getSize();
        for (int i = 0; i < count; ++i) {
            SidePanelItem item = this.getItem((Place)ObjectUtils.tryCast(this.mySidePanel.getList().getModel().getElementAt(i), Place.class));
            if (!sel.contains(item)) continue;
            newSelection.add(i);
        }
        this.mySidePanel.getList().setSelectedIndices(newSelection.toNativeArray());
    }

    @NotNull
    public DataSourceSettings getSettings() {
        DataSourceSettings dataSourceSettings = this.mySettings;
        if (dataSourceSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditor", "getSettings"));
        }
        return dataSourceSettings;
    }

    private List<AnAction> getAddActions() {
        ArrayList actions = ContainerUtil.newArrayList();
        PairConsumer consumer = (manager, template) -> this.createDataSource((DbPsiManager)manager, (DataSourceTemplate)template, null, null);
        final DefaultDbPsiManager defaultManager = (DefaultDbPsiManager)((Object)ContainerUtil.findInstance((Iterable)this.mySettings.getPsiFacade().getDbManagers(), DefaultDbPsiManager.class));
        Project project = this.mySettings.getProject();
        DatabaseView.addNewDataSourceActions(project, (List<AnAction>)actions, defaultManager, this.mySettings.getNewDrivers(), this.ACTUALIZE_WRAPPER, (PairConsumer<DbPsiManager, DataSourceTemplate>)consumer);
        if (!actions.isEmpty()) {
            actions.add(Separator.getInstance());
        }
        DatabaseView.addNewDataSourceActions(project, (List<AnAction>)actions, true, this.mySettings.getPsiFacade(), this.ACTUALIZE_WRAPPER, (PairConsumer<DbPsiManager, DataSourceTemplate>)consumer);
        actions.add(new AddDataSourceFromUrl(new DatabaseView.DataSourceFactory(){

            @Override
            public void create(@NotNull DbPsiFacade facade, @NotNull DbPsiManager manager, @NotNull DataSourceTemplate template, @Nullable String s) {
                if (facade == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/database/view/ui/DatabaseConfigEditor$11", "create"));
                }
                if (manager == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/view/ui/DatabaseConfigEditor$11", "create"));
                }
                if (template == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/view/ui/DatabaseConfigEditor$11", "create"));
                }
                DatabaseConfigEditor.this.createDataSource(manager, template, null, s);
            }
        }));
        actions.add(Separator.getInstance());
        actions.add(new DumbAwareAction("Driver and Data Source", null, DatabaseIcons.UserDriver){

            public void actionPerformed(AnActionEvent e) {
                DatabaseDriver driver = DatabaseConfigEditor.this.createDatabaseDriver();
                DatabaseConfigEditor.this.mySettings.addNewDriver(driver);
                DatabaseConfigEditor.this.createDataSource(defaultManager, driver, null, null);
            }
        });
        actions.add(new DumbAwareAction("Driver", null, DatabaseIcons.UserDriver){

            public void actionPerformed(AnActionEvent e) {
                DatabaseConfigEditor.this.addNewDriverAndNavigate(DatabaseConfigEditor.this.createDatabaseDriver());
            }
        });
        return actions;
    }

    private void ensureNewObjectDropped(Object object) {
        if (object instanceof DbDataSource) {
            this.mySettings.removeNewDataSource((DbDataSource)object);
        } else if (object instanceof DatabaseDriver) {
            this.mySettings.removeNewDriver((DatabaseDriver)object);
        }
    }

    private boolean canRemove(SidePanelItem item) {
        final Ref result = Ref.create((Object)false);
        item.accept(new SidePanelItem.ItemsVisitor(){

            @Override
            boolean visit(SidePanelItem.DataSourceItem dataSourceItem) {
                result.set((Object)true);
                return true;
            }

            @Override
            boolean visit(SidePanelItem.DriverItem driverItem) {
                DatabaseDriver driver = (DatabaseDriver)driverItem.getObject();
                if (driver.isPredefined()) {
                    return false;
                }
                for (DbDataSource ds : DatabaseConfigEditor.this.getAllDataSources()) {
                    SidePanelItem.DataSourceItem item;
                    LocalDataSource dataSource;
                    if (DatabaseConfigEditor.this.myRemovedObjects.contains(ds) || (dataSource = (item = (SidePanelItem.DataSourceItem)ObjectUtils.tryCast(DatabaseConfigEditor.this.mySidePanelItems.get(ds), SidePanelItem.DataSourceItem.class)) == null ? null : item.extractActualLocalDataSource()) == null || dataSource.getDatabaseDriver() != driver) continue;
                    return false;
                }
                result.set((Object)true);
                return true;
            }
        });
        return (Boolean)result.get();
    }

    private Collection<DbDataSource> getAllDataSources() {
        LinkedHashSet result = ContainerUtil.newLinkedHashSet(this.mySettings.getDataSources());
        result.addAll(this.mySettings.getNewDataSources());
        result.removeAll(this.myRemovedObjects);
        return result;
    }

    private Collection<DatabaseDriver> getAllDrivers(DataSourceSettings settings) {
        DatabaseDriverManager driverManager = DatabaseDriverManager.getInstance();
        ArrayList result = ContainerUtil.newArrayList(driverManager.getDrivers());
        result.addAll(settings.getNewDrivers());
        result.removeAll(this.myRemovedObjects);
        Collections.sort(result, (o1, o2) -> StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName()));
        return result;
    }

    @Override
    @NotNull
    public ActionCallback navigateTo(final Object object) {
        final Ref place = Ref.create((Object)this.getPlace(object));
        if (place.get() == null) {
            ContainerUtil.process(this.mySidePanelItems.values(), (Processor)new SidePanelItem.ItemsVisitor(){

                @Override
                boolean visit(SidePanelItem.DataSourceItem dataSourceItem) {
                    if (dataSourceItem.getConfigurable() == null || ((AbstractDataSourceConfigurable)((Object)dataSourceItem.getConfigurable())).getTempDataSource() != object) {
                        return true;
                    }
                    place.set((Object)dataSourceItem.getPlace());
                    return false;
                }

                @Override
                boolean visit(SidePanelItem.DriverItem driverItem) {
                    if (driverItem.getConfigurable() == null || ((DatabaseDriverConfigurable)((Object)driverItem.getConfigurable())).getTempDriver() != object) {
                        return true;
                    }
                    place.set((Object)driverItem.getPlace());
                    return false;
                }
            });
        }
        ActionCallback actionCallback = this.navigateTo((Place)place.get(), false);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditor", "navigateTo"));
        }
        return actionCallback;
    }

    @Override
    public void showErrorNotification(@NotNull Configurable source, @NotNull Object id, @Nullable Exception e) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/view/ui/DatabaseConfigEditor", "showErrorNotification"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/database/view/ui/DatabaseConfigEditor", "showErrorNotification"));
        }
        if (e == null) {
            this.showErrorNotification(source, id, null, null, new Object[0]);
            return;
        }
        final String longText = JdbcEngine.getErrorMessage(e, source.getDisplayName(), DatabaseFamilyId.UNKNOWN);
        if (longText.isEmpty()) {
            return;
        }
        String shortText = longText;
        int div = longText.indexOf(10);
        if (div > 5) {
            shortText = shortText.substring(0, div);
        }
        if (!Comparing.equal((String)longText, (String)(shortText = StringUtil.escapeXml((String)StringUtil.trimLog((String)shortText, (int)80))))) {
            shortText = shortText + " (<a href=\"$ACTION0\">view</a>)";
        }
        this.showErrorNotification(source, id, "Error", shortText, new Runnable(){

            @Override
            public void run() {
                Messages.showIdeaMessageDialog(null, (String)longText, (String)DatabaseMessages.message((String)"message.title.connection.error", (Object[])new Object[0]), (String[])new String[]{CommonBundle.getOkButtonText()}, (int)0, (Icon)Messages.getErrorIcon(), null);
            }
        });
    }

    @Override
    public void showErrorNotification(@NotNull Configurable source, @NotNull Object id, @Nullable String title, @Nullable String message, Object ... linkActions) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/view/ui/DatabaseConfigEditor", "showErrorNotification"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/database/view/ui/DatabaseConfigEditor", "showErrorNotification"));
        }
        if (linkActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkActions", "com/intellij/database/view/ui/DatabaseConfigEditor", "showErrorNotification"));
        }
        DataSourceProblem dataSourceProblem = title != null && message != null ? new DataSourceProblem((Object)source, id, title, message, null, linkActions) : null;
        for (SidePanelItem item : this.mySidePanelItems.values()) {
            if (item.getConfigurable() != source) continue;
            if (dataSourceProblem == null && item.getDataSourceProblem() != null && !Comparing.equal((Object)item.getDataSourceProblem().getId(), (Object)id)) break;
            item.setDataSourceProblem(dataSourceProblem);
            break;
        }
        if (this.mySelectedItem != null && this.mySelectedItem.getConfigurable() == source) {
            this.updateValidationProblem(this.mySelectedItem);
        }
    }

    @Override
    @NotNull
    public DatabaseCredentials getSecretService() {
        DatabaseCredentials databaseCredentials = this.myDatabaseCredentials;
        if (databaseCredentials == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditor", "getSecretService"));
        }
        return databaseCredentials;
    }

    @Override
    public boolean isObjectApplied(Object object) {
        JBIterable objects = JBIterable.from(this.myRemovedObjects).append(this.mySettings.getNewDataSources()).append(this.mySettings.getNewDrivers());
        for (Object o : objects) {
            if (!(o instanceof DbDataSource) || ((DbDataSource)o).getDelegate() != object) continue;
            return false;
        }
        return !objects.contains(object);
    }

    @Override
    @Nullable
    public JComponent createResetAction(@Nullable Configurable configurable) {
        Ref ritem = Ref.create();
        ContainerUtil.process(this.mySidePanelItems.values(), sitem -> {
            if (sitem.getConfigurable() == configurable) {
                ritem.set(sitem);
                return false;
            }
            return true;
        });
        SidePanelItem item = (SidePanelItem)ritem.get();
        if (item == null) {
            return null;
        }
        JPanel component = new JPanel(new BorderLayout());
        component.add((Component)item.getResetComponent(), "East");
        Dimension size = component.getPreferredSize();
        Dimension constraint = new Dimension((int)size.getWidth(), (int)size.getHeight());
        component.setMinimumSize(constraint);
        component.setPreferredSize(constraint);
        return component;
    }

    @Override
    public DatabaseDriver actualize(DatabaseDriver object, boolean forced) {
        DatabaseDriverConfigurable configurable;
        SidePanelItem.DriverItem item = (SidePanelItem.DriverItem)ObjectUtils.tryCast((Object)this.mySidePanelItems.get(object), SidePanelItem.DriverItem.class);
        DatabaseDriverConfigurable databaseDriverConfigurable = item == null ? null : (configurable = forced ? (DatabaseDriverConfigurable)((Object)item.createConfigurable()) : (DatabaseDriverConfigurable)((Object)item.getConfigurable()));
        if (configurable == null) {
            return object;
        }
        DatabaseDriverImpl temp = configurable.getTempDriver();
        return (DatabaseDriver)ObjectUtils.chooseNotNull((Object)temp, (Object)object);
    }

    @Override
    public LocalDataSource actualize(final @NotNull LocalDataSource object, final boolean withCredentials, final boolean forced) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/ui/DatabaseConfigEditor", "actualize"));
        }
        final Ref actual = Ref.create();
        ContainerUtil.process(this.mySidePanelItems.values(), (Processor)new SidePanelItem.ItemsVisitor(){

            @Override
            boolean visit(SidePanelItem.DataSourceItem dataSourceItem) {
                AbstractDataSourceConfigurable configurable;
                if (object != ((DbDataSource)dataSourceItem.getObject()).getDelegate()) {
                    return true;
                }
                AbstractDataSourceConfigurable abstractDataSourceConfigurable = configurable = forced ? (AbstractDataSourceConfigurable)((Object)dataSourceItem.createConfigurable()) : (AbstractDataSourceConfigurable)((Object)dataSourceItem.getConfigurable());
                if (configurable == null) {
                    return false;
                }
                Object temp = withCredentials && configurable instanceof DataSourceConfigurable ? ((DataSourceConfigurable)configurable).getTempDataSourceForConnection() : configurable.getTempDataSource();
                actual.set(ObjectUtils.tryCast(temp, LocalDataSource.class));
                return false;
            }
        });
        return (LocalDataSource)((Object)ObjectUtils.chooseNotNull((Object)actual.get(), (Object)((Object)object)));
    }

    Object actualizeObject(Object o, Boolean forced) {
        if (o instanceof LocalDataSource) {
            return this.actualize((LocalDataSource)((Object)o), false, forced);
        }
        if (o instanceof DatabaseDriver) {
            return this.actualize((DatabaseDriver)o, forced);
        }
        return o;
    }

    private void updateValidationProblem(@Nullable SidePanelItem item) {
        DataSourceProblem error = item == null ? null : item.getDataSourceProblem();
        this.myErrorInfoComponent.updateWarning(error);
        DataSourceProblem problem = (DataSourceProblem)ContainerUtil.getFirstItem(this.myErrorsCollector.getProblems(item));
        this.myValidationComponent.updateWarning(problem);
    }

    void processAction(final Object action) {
        if (action instanceof Runnable) {
            ((Runnable)action).run();
        } else if (action instanceof Computable) {
            ((Computable)action).compute();
        } else if (action instanceof Progressive) {
            NamedProgressive named = (NamedProgressive)ObjectUtils.tryCast((Object)action, NamedProgressive.class);
            new Task.Modal(null, named == null ? "" : named.getName(), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/view/ui/DatabaseConfigEditor$18", "run"));
                    }
                    ((Progressive)action).run(indicator);
                }
            }.queue();
        } else if (action instanceof DataSourceProblem.Navigate) {
            this.navigateTo(((DataSourceProblem.Navigate)action).target);
        } else if (action instanceof DataSourceProblem.NewUrlTemplate) {
            DataSourceProblem.NewUrlTemplate newUrlTemplate = (DataSourceProblem.NewUrlTemplate)action;
            this.addTemplate(this.actualize(newUrlTemplate.driver, true), newUrlTemplate.template);
        } else if (action instanceof DataSourceProblem.FocusDriverClass) {
            DataSourceProblem.FocusDriverClass focusDriverClass = (DataSourceProblem.FocusDriverClass)action;
            this.focusDriverClassSelector(focusDriverClass.driver);
        }
        this.updateSidePanelImpl();
    }

    private void addTemplate(@NotNull DatabaseDriver driver, @NotNull String template) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/view/ui/DatabaseConfigEditor", "addTemplate"));
        }
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/view/ui/DatabaseConfigEditor", "addTemplate"));
        }
        this.navigateTo(driver).doWhenDone(() -> {
            DatabaseDriverConfigurable configurable;
            if (template == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/view/ui/DatabaseConfigEditor", "lambda$addTemplate$11"));
            }
            DatabaseDriverConfigurable databaseDriverConfigurable = configurable = this.mySelectedItem == null ? null : (DatabaseDriverConfigurable)((Object)((Object)ObjectUtils.tryCast(this.mySelectedItem.getConfigurable(), DatabaseDriverConfigurable.class)));
            if (configurable == null) {
                return;
            }
            configurable.addNewUrlTemplate(template);
        });
    }

    private void focusDriverClassSelector(@NotNull DatabaseDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/view/ui/DatabaseConfigEditor", "focusDriverClassSelector"));
        }
        this.navigateTo(driver).doWhenDone(() -> {
            DatabaseDriverConfigurable configurable;
            DatabaseDriverConfigurable databaseDriverConfigurable = configurable = this.mySelectedItem == null ? null : (DatabaseDriverConfigurable)((Object)((Object)ObjectUtils.tryCast(this.mySelectedItem.getConfigurable(), DatabaseDriverConfigurable.class)));
            if (configurable == null) {
                return;
            }
            configurable.focusDriverClassSelector();
        });
    }

    private class MyComponentConfigurator
    implements DataSourceSidePanel.ComponentConfigurator {
        private final Map<Icon, Icon> myCache = ContainerUtil.newHashMap();

        private MyComponentConfigurator() {
        }

        @Nullable
        private Icon getGrayIcon(@Nullable Icon icon) {
            if (icon == null) {
                return null;
            }
            Icon res = this.myCache.get(icon);
            if (res == null) {
                res = IconUtil.desaturate((Icon)icon);
                this.myCache.put(icon, res);
            }
            return res;
        }

        @Override
        public void configure(final @NotNull SimpleColoredComponent component, @NotNull Place place, boolean isSelected) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/view/ui/DatabaseConfigEditor$MyComponentConfigurator", "configure"));
            }
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/database/view/ui/DatabaseConfigEditor$MyComponentConfigurator", "configure"));
            }
            SidePanelItem item = SidePanelItem.getItem(place);
            if (item == null) {
                return;
            }
            boolean created = DatabaseConfigEditor.this.isObjectCreated(item);
            boolean modified = created || DatabaseConfigEditor.this.isObjectModified(item);
            boolean valid = DatabaseConfigEditor.this.isObjectValid(item);
            Object fgColor = isSelected ? UIUtil.getListSelectionForeground() : (created ? (UIUtil.isUnderDarcula() ? JBColor.GREEN : JBColor.GREEN.darker().darker()) : (modified ? JBColor.BLUE : component.getForeground()));
            SimpleTextAttributes textAttributes = new SimpleTextAttributes(valid ? 0 : 8, (Color)fgColor, (Color)JBColor.RED);
            String name = item.getName();
            if (name != null) {
                SpeedSearchUtil.appendColoredFragmentForMatcher((String)name, (SimpleColoredComponent)component, (SimpleTextAttributes)textAttributes, (Matcher)DatabaseConfigEditor.this.mySidePanel.getSpeedSearchMatcher(), (Color)UIUtil.getTreeSelectionBackground(), (boolean)isSelected);
            }
            component.setIcon(EmptyIcon.create((int)16));
            item.accept(new SidePanelItem.ItemsVisitor(){

                @Override
                boolean visit(SidePanelItem.DataSourceItem dataSourceItem) {
                    component.setIcon(MyComponentConfigurator.this.getGrayIcon(((DbDataSourceImpl)((Object)dataSourceItem.getObject())).getIcon(true)));
                    String remarks = ((DbDataSource)dataSourceItem.getObject()).getComment();
                    if (StringUtil.isNotEmpty((String)remarks)) {
                        component.append(" (" + remarks + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                    return true;
                }

                @Override
                boolean visit(SidePanelItem.DriverItem driverItem) {
                    component.setIcon(MyComponentConfigurator.this.getGrayIcon(((DatabaseDriver)driverItem.getObject()).getIcon(0)));
                    return true;
                }
            });
        }

        @Override
        public void updateCount(@NotNull SidePanelCountLabel count, @NotNull Place place) {
            if (count == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "count", "com/intellij/database/view/ui/DatabaseConfigEditor$MyComponentConfigurator", "updateCount"));
            }
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/database/view/ui/DatabaseConfigEditor$MyComponentConfigurator", "updateCount"));
            }
            SidePanelItem.ErrorsItem item = (SidePanelItem.ErrorsItem)ObjectUtils.tryCast((Object)SidePanelItem.getItem(place), SidePanelItem.ErrorsItem.class);
            count.setVisible(item != null && ((DataSourceErrorsConfigurable)item.getObject()).getErrorsCount() > 0);
            if (item != null) {
                count.setText(String.valueOf(((DataSourceErrorsConfigurable)item.getObject()).getErrorsCount()));
            }
        }
    }

    private class MyRootPanel
    extends NonOpaquePanel
    implements DataProvider {
        public MyRootPanel(LayoutManager layout) {
            super(layout);
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (History.KEY.is(dataId)) {
                return DatabaseConfigEditor.this.myHistory;
            }
            return null;
        }
    }

    public class ValidationComponent
    extends JPanel {
        private final JEditorPane myWarningLabel;
        private final List<Object> myActions = ContainerUtil.newArrayList();
        private DataSourceProblem myProblem;

        public ValidationComponent(boolean closeable) {
            this.setLayout(new BorderLayout(5, 5));
            this.setBorder(new CompoundBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)1, (int)0, (int)0, (int)0), DsUiDefaults.DEFAULT_PANEL_BORDER));
            this.setVisible(false);
            JLabel iconLabel = new JLabel(UIUtil.getBalloonWarningIcon());
            iconLabel.setHorizontalAlignment(2);
            iconLabel.setVerticalAlignment(1);
            this.myWarningLabel = IdeTooltipManager.initPane((String)"", (HintHint)new HintHint(), null);
            this.myWarningLabel.setEditable(false);
            NonOpaquePanel.setTransparent((JComponent)this.myWarningLabel);
            this.myWarningLabel.setBorder(null);
            this.myWarningLabel.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED || ValidationComponent.this.myProblem == null) {
                        return;
                    }
                    Object action = DataSourceProblem.extractAction(e.getDescription(), ValidationComponent.this.myActions);
                    if (action != null) {
                        DatabaseConfigEditor.this.processAction(action);
                    }
                }
            });
            this.add((Component)iconLabel, "West");
            this.add((Component)this.myWarningLabel, "Center");
            if (closeable) {
                JPanel comp = new JPanel(new BorderLayout());
                comp.add((Component)new LinkLabel(null, AllIcons.Actions.Close, (aSource, aLinkData) -> {
                    Configurable configurable;
                    Configurable configurable2 = configurable = this.myProblem.getId() == null ? null : (Configurable)ObjectUtils.tryCast((Object)this.myProblem.getOwner(), Configurable.class);
                    if (configurable != null) {
                        DatabaseConfigEditor.this.showErrorNotification(configurable, this.myProblem.getId(), null);
                    }
                }), "North");
                this.add((Component)comp, "East");
            }
        }

        private void updateWarning(@Nullable DataSourceProblem problem) {
            if (Comparing.equal((Object)problem, (Object)this.myProblem)) {
                return;
            }
            if (problem != null) {
                this.setVisible(true);
                this.myProblem = problem;
                this.myActions.clear();
                this.myWarningLabel.setText(this.generateWarningLabelText());
            } else {
                this.setVisible(false);
                this.myActions.clear();
                this.myProblem = null;
            }
        }

        private String generateWarningLabelText() {
            StringBuilder builder = new StringBuilder("<html><body>");
            String title = this.myProblem.getTitle();
            builder.append("<font face=\"verdana\">");
            if (!StringUtil.isEmptyOrSpaces((String)title)) {
                builder.append("<b>");
                DataSourceProblem.formatText(builder, this.myActions, title, this.myProblem.getLinkActions());
                builder.append("</b>: ");
            }
            DataSourceProblem.formatText(builder, this.myActions, this.myProblem.getShortDescription(), this.myProblem.getLinkActions());
            builder.append("</font></body></html>");
            return builder.toString();
        }
    }

    private class GoToDriverAction
    extends DumbAwareAction
    implements AnActionButtonUpdater {
        public GoToDriverAction() {
            super("Go to Driver", null, AllIcons.General.Settings);
        }

        public void update(AnActionEvent e) {
            boolean enabled = this.isEnabled(e);
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(AnActionEvent e) {
            LocalDataSource localDataSource;
            JBIterable selection = DatabaseConfigEditor.this.getSelectedDataSources();
            SidePanelItem.DataSourceItem dataSource = (SidePanelItem.DataSourceItem)selection.first();
            LocalDataSource localDataSource2 = localDataSource = dataSource == null ? null : dataSource.extractActualLocalDataSource();
            if (localDataSource == null) {
                return;
            }
            DatabaseConfigEditor.this.navigateTo(localDataSource.getDatabaseDriver());
        }

        public boolean isEnabled(AnActionEvent e) {
            JBIterable selection = DatabaseConfigEditor.this.getSelectedDataSources();
            if (selection.size() != 1) {
                return false;
            }
            LocalDataSource localDataSource = ((SidePanelItem.DataSourceItem)ObjectUtils.assertNotNull((Object)selection.first())).extractActualLocalDataSource();
            return localDataSource != null && localDataSource.getDatabaseDriver() != null;
        }
    }

    private class CopyAction
    extends DumbAwareAction
    implements AnActionButtonUpdater {
        private CopyAction() {
            super("Duplicate", null, PlatformIcons.COPY_ICON);
        }

        public void update(AnActionEvent e) {
            boolean enabled = this.isEnabled(e);
            e.getPresentation().setEnabled(enabled);
        }

        public void actionPerformed(AnActionEvent e) {
            SidePanelItem.DataSourceItem dataSourceItem = this.getSelectedDatasourceItem();
            SidePanelItem.DriverItem databaseDriverItem = this.getSelectedDriverItem();
            if (dataSourceItem != null) {
                DbDataSource dataSource = (DbDataSource)dataSourceItem.getObject();
                DataSourceTemplate template = dataSource.getDbManager().getDataSourceTemplate(dataSource);
                if (template == null) {
                    return;
                }
                AbstractDataSourceConfigurable configurable = (AbstractDataSourceConfigurable)((Object)dataSourceItem.getConfigurable());
                Object delegate = configurable instanceof DataSourceConfigurable ? ((DataSourceConfigurable)configurable).getTempDataSourceForConnection() : (configurable != null ? configurable.getTempDataSource() : dataSource.getDelegate());
                DatabaseConfigEditor.this.createDataSource(dataSource.getDbManager(), template, (DatabaseSystem)delegate, null);
            } else if (databaseDriverItem != null) {
                DatabaseDriverImpl databaseDriver = (DatabaseDriverImpl)DatabaseConfigEditor.this.actualize((DatabaseDriver)databaseDriverItem.getObject(), false);
                DatabaseConfigEditor.this.addNewDriverAndNavigate(databaseDriver.copy(DatabaseDriverManager.chooseNewDriverName(DatabaseConfigEditor.this.getAllDrivers(DatabaseConfigEditor.this.mySettings), databaseDriver.getName()), false));
            }
        }

        public boolean isEnabled(AnActionEvent e) {
            return this.getSelectedDatasourceItem() != null ^ this.getSelectedDriverItem() != null;
        }

        public SidePanelItem.DataSourceItem getSelectedDatasourceItem() {
            JBIterable selection = DatabaseConfigEditor.this.getSelectedDataSources();
            if (selection.size() != 1) {
                return null;
            }
            SidePanelItem.DataSourceItem item = (SidePanelItem.DataSourceItem)selection.first();
            assert (item != null);
            DbDataSource dbDataSource = (DbDataSource)item.getObject();
            if (dbDataSource.getDbManager().getDataSourceTemplate(dbDataSource) != null) {
                return item;
            }
            return null;
        }

        public SidePanelItem.DriverItem getSelectedDriverItem() {
            JBIterable selection = DatabaseConfigEditor.this.getSelectedDrivers();
            return selection.size() == 1 ? (SidePanelItem.DriverItem)selection.first() : null;
        }
    }

    private class ResetAction
    extends DumbAwareAction {
        public ResetAction() {
            super("Reset Changes", "Reset modifications to item", AllIcons.Actions.Rollback);
        }

        public void update(AnActionEvent e) {
            boolean modified = false;
            for (SidePanelItem item : DatabaseConfigEditor.this.getSelectedItems()) {
                if (!item.isModified()) continue;
                modified = true;
                break;
            }
            e.getPresentation().setEnabled(modified);
        }

        public void actionPerformed(AnActionEvent e) {
            Set selection = DatabaseConfigEditor.this.getSelectedItems().toSet();
            for (SidePanelItem item : DatabaseConfigEditor.this.getSelectedItems()) {
                if (!item.isModified()) continue;
                if (item.getConfigurable() != null) {
                    item.getConfigurable().reset();
                }
                item.resetModifiedCache();
            }
            DatabaseConfigEditor.this.refillSidePanel(DatabaseConfigEditor.this.mySettings);
            DatabaseConfigEditor.this.restoreSelection(selection);
        }
    }

    private class DataSourceScopeAction
    extends DumbAwareAction {
        public DataSourceScopeAction() {
            super("Data Source Scope", null, AllIcons.ToolbarDecorator.Import);
        }

        boolean isIDEScopeSelected() {
            boolean isIDEScope = true;
            for (SidePanelItem.DataSourceItem item : DatabaseConfigEditor.this.getSelectedLocalDataSources()) {
                isIDEScope &= item.isGlobal();
            }
            return isIDEScope;
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(!DatabaseConfigEditor.this.getSelectedLocalDataSources().isEmpty());
            e.getPresentation().setText(this.isIDEScopeSelected() ? "Move to Project" : "Make Global");
        }

        public void actionPerformed(AnActionEvent e) {
            Set selection = DatabaseConfigEditor.this.getSelectedItems().toSet();
            boolean isIDEScope = this.isIDEScopeSelected();
            for (SidePanelItem.DataSourceItem item : DatabaseConfigEditor.this.getSelectedLocalDataSources()) {
                DataSourceConfigurable configurable = (DataSourceConfigurable)((Object)ObjectUtils.tryCast((Object)DatabaseConfigEditor.createEditorIfNeeded(item), DataSourceConfigurable.class));
                if (configurable == null) continue;
                configurable.setGlobal(!isIDEScope);
            }
            DatabaseConfigEditor.this.refillSidePanel(DatabaseConfigEditor.this.mySettings);
            DatabaseConfigEditor.this.restoreSelection(selection);
        }
    }

    private class ChooseDriverGroup
    extends ActionGroup
    implements DumbAware {
        public ChooseDriverGroup() {
            super("Change Driver", "Change data source driver", DatabaseIcons.UserDriver);
        }

        public boolean isPopup() {
            return true;
        }

        public void update(AnActionEvent e) {
            JBIterable dataSources = DatabaseConfigEditor.this.getSelectedLocalDataSources();
            e.getPresentation().setVisible(!dataSources.isEmpty());
            e.getPresentation().setEnabled(!this.getDrivers((JBIterable<SidePanelItem.DataSourceItem>)dataSources).isEmpty());
        }

        @NotNull
        JBIterable<DatabaseDriver> getDrivers(JBIterable<SidePanelItem.DataSourceItem> dataSources) {
            JBIterable drivers = dataSources.transform(item -> ((LocalDataSource)((Object)((Object)ObjectUtils.assertNotNull((Object)((Object)item.extractActualLocalDataSource()))))).getDatabaseDriver());
            JBIterable dialects = dataSources.transform(item -> {
                SqlLanguageDialect lang = DbImplUtil.getSqlDialect(DatabaseConfigEditor.this.mySettings.getProject(), (DatabaseSystem)item.extractActualLocalDataSource());
                return lang.getID();
            });
            if (dialects.toSet().size() != 1) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditor$ChooseDriverGroup", "getDrivers"));
                }
                return jBIterable;
            }
            DatabaseDriver onlyDriver = drivers.toSet().size() == 1 ? (DatabaseDriver)drivers.first() : null;
            String dialectName = (String)ObjectUtils.assertNotNull((Object)dialects.first());
            JBIterable jBIterable = JBIterable.from(DatabaseDriverManager.getInstance().getDrivers()).filter(DatabaseDriver.class).filter(driver -> dialectName.equals(DatabaseConfigEditor.this.actualize((DatabaseDriver)driver, false).getDialect())).filter(Conditions.notEqualTo((Object)onlyDriver));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditor$ChooseDriverGroup", "getDrivers"));
            }
            return jBIterable;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            final JBIterable dataSources = DatabaseConfigEditor.this.getSelectedLocalDataSources();
            JBIterable<DatabaseDriver> drivers = this.getDrivers((JBIterable<SidePanelItem.DataSourceItem>)dataSources);
            if (drivers.isEmpty()) {
                if (EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditor$ChooseDriverGroup", "getChildren"));
                }
                return EMPTY_ARRAY;
            }
            final Set selection = DatabaseConfigEditor.this.getSelectedItems().toSet();
            ArrayList res = ContainerUtil.newArrayList();
            for (final DatabaseDriver driver : drivers) {
                DatabaseDriver actual = DatabaseConfigEditor.this.actualize(driver, false);
                res.add(new DumbAwareAction(actual.getName(), null, actual.getIcon(0)){

                    public void actionPerformed(AnActionEvent e) {
                        for (SidePanelItem.DataSourceItem item : dataSources) {
                            DataSourceConfigurable configurable = (DataSourceConfigurable)((Object)ObjectUtils.tryCast((Object)DatabaseConfigEditor.createEditorIfNeeded(item), DataSourceConfigurable.class));
                            if (configurable == null) continue;
                            configurable.setDriver(driver);
                        }
                        DatabaseConfigEditor.this.restoreSelection(selection);
                    }
                });
            }
            AnAction[] anActionArray = res.toArray(new AnAction[res.size()]);
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditor$ChooseDriverGroup", "getChildren"));
            }
            return anActionArray;
        }
    }

    private class ResetToPredefinedAction
    extends DumbAwareAction {
        public ResetToPredefinedAction() {
            super("Reset to Predefined", null, AllIcons.Actions.Undo);
        }

        public void actionPerformed(AnActionEvent e) {
            JBIterable drivers = DatabaseConfigEditor.this.getSelectedDrivers().filter(this.isPredefinedChangedCondition());
            for (SidePanelItem.DriverItem driverItem : drivers) {
                DatabaseDriverConfigurable configurable = (DatabaseDriverConfigurable)((Object)driverItem.createConfigurable());
                DatabaseDriverImpl orig = configurable.getDriver();
                DatabaseDriverImpl driver = new DatabaseDriverImpl(orig.getId(), true);
                driver.loadState(orig.getState(true), false, true, Integer.MAX_VALUE);
                DatabaseDriverManager.getInstance().resetToPredefined(driver);
                configurable.reset(driver);
            }
        }

        public void update(AnActionEvent e) {
            JBIterable selectedDrivers = DatabaseConfigEditor.this.getSelectedDrivers().filter(this.isPredefinedChangedCondition());
            e.getPresentation().setEnabledAndVisible(!selectedDrivers.isEmpty());
        }

        @NotNull
        private Condition<SidePanelItem.DriverItem> isPredefinedChangedCondition() {
            Condition condition = item -> !DatabaseDriverManager.getInstance().isInPredefinedState((DatabaseDriver)item.getObject());
            if (condition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditor$ResetToPredefinedAction", "isPredefinedChangedCondition"));
            }
            return condition;
        }
    }

    private class ShowUsagesAction
    extends DumbAwareAction {
        public ShowUsagesAction() {
            super("Show Driver Usages", null, AllIcons.Actions.Find);
        }

        public void actionPerformed(AnActionEvent e) {
            DatabaseConfigEditor.this.showUsagesPopup((SidePanelItem.DriverItem)DatabaseConfigEditor.this.getSelectedDrivers().first());
        }

        public void update(AnActionEvent e) {
            JBIterable selectedDrivers = DatabaseConfigEditor.this.getSelectedDrivers();
            e.getPresentation().setEnabledAndVisible(selectedDrivers.size() == 1);
        }
    }

    private class RemoveAction
    extends DumbAwareAction
    implements AnActionButtonRunnable,
    AnActionButtonUpdater {
        private RemoveAction() {
            super("Remove", null, IconUtil.getRemoveIcon());
        }

        public void actionPerformed(AnActionEvent e) {
            this.run(null);
        }

        public void update(AnActionEvent e) {
            boolean enabled = this.isEnabled(e);
            e.getPresentation().setEnabled(enabled);
        }

        public boolean isEnabled(AnActionEvent e) {
            Set selection = DatabaseConfigEditor.this.getSelectedItems().toSet();
            if (selection.size() == 1 && e.getInputEvent() instanceof KeyEvent && ListWithFilter.isSearchActive((JList)DatabaseConfigEditor.this.mySidePanel.getList())) {
                return false;
            }
            for (SidePanelItem item : selection) {
                if (DatabaseConfigEditor.this.canRemove(item)) continue;
                return false;
            }
            return !selection.isEmpty();
        }

        public void run(AnActionButton button) {
            JList list = DatabaseConfigEditor.this.mySidePanel.getList();
            int index = list.getSelectionModel().getMinSelectionIndex();
            for (SidePanelItem item : DatabaseConfigEditor.this.getSelectedItems()) {
                if (!DatabaseConfigEditor.this.canRemove(item)) continue;
                DatabaseConfigEditor.this.myRemovedObjects.add(item.getObject());
                DatabaseConfigEditor.this.ensureNewObjectDropped(item.getObject());
            }
            DatabaseConfigEditor.this.refillSidePanel(DatabaseConfigEditor.this.mySettings);
            index = Math.max(0, Math.min(list.getModel().getSize() - 2, index));
            list.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    private class AddAction
    extends ActionGroup
    implements DumbAware {
        private AddAction() {
            super("Add", null, IconUtil.getAddIcon());
        }

        public boolean isPopup() {
            return true;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            List actions = DatabaseConfigEditor.this.getAddActions();
            AnAction[] anActionArray = actions.toArray(new AnAction[actions.size()]);
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditor$AddAction", "getChildren"));
            }
            return anActionArray;
        }
    }

    static enum Kind {
        DATABASE,
        DRIVER,
        OTHER;


        static Kind kindOf(Object o) {
            if (o instanceof DatabaseSystem) {
                return DATABASE;
            }
            if (o instanceof DatabaseDriver) {
                return DRIVER;
            }
            return OTHER;
        }
    }
}

