/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.dbm.common.DbmNamespace;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmSchema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbmMajor
extends DbmObject
implements BasicMajorObject {
    @NotNull
    private final DbmSchema mySchema;

    protected DbmMajor(@NotNull DbmSchema schema, @Nullable String name) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/common/DbmMajor", "<init>"));
        }
        super(schema.model, name);
        this.mySchema = schema;
    }

    @Override
    @NotNull
    public DbmSchema getDbParent() {
        DbmSchema dbmSchema = this.mySchema;
        if (dbmSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmMajor", "getDbParent"));
        }
        return dbmSchema;
    }

    @Override
    @NotNull
    public DbmSchema getSchema() {
        DbmSchema dbmSchema = this.mySchema;
        if (dbmSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmMajor", "getSchema"));
        }
        return dbmSchema;
    }

    @Override
    @NotNull
    public DbmNamespace getNamespace() {
        DbmSchema dbmSchema = this.mySchema;
        if (dbmSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmMajor", "getNamespace"));
        }
        return dbmSchema;
    }
}

