/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.dbm.common.DbmMajor;
import com.intellij.dbm.common.DbmNamespace;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmSchema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbmMinor
extends DbmObject {
    private final DbmMajor myMajor;
    private final DbmObject myParent;

    protected DbmMinor(@NotNull DbmMajor parent, @Nullable String name) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/dbm/common/DbmMinor", "<init>"));
        }
        super(parent.model, name);
        this.myParent = parent;
        this.myMajor = parent;
    }

    @Deprecated
    protected DbmMinor(@NotNull DbmObject parent, @Nullable String name) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/dbm/common/DbmMinor", "<init>"));
        }
        super(parent.model, name);
        this.myParent = parent;
        if (parent instanceof DbmMajor) {
            this.myMajor = (DbmMajor)parent;
        } else if (parent instanceof DbmMinor) {
            this.myMajor = ((DbmMinor)parent).myMajor;
        } else {
            throw new IllegalArgumentException("The parent of a minor object must be a major or another minor.");
        }
    }

    @Override
    @NotNull
    public DbmSchema getSchema() {
        DbmSchema dbmSchema = this.myMajor.getSchema();
        if (dbmSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmMinor", "getSchema"));
        }
        return dbmSchema;
    }

    @Override
    @NotNull
    public DbmNamespace getNamespace() {
        DbmNamespace dbmNamespace = this.myMajor.getNamespace();
        if (dbmNamespace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmMinor", "getNamespace"));
        }
        return dbmNamespace;
    }

    @NotNull
    public DbmMajor getMajorObject() {
        DbmMajor dbmMajor = this.myMajor;
        if (dbmMajor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmMinor", "getMajorObject"));
        }
        return dbmMajor;
    }

    @Override
    @NotNull
    public DbmObject getDbParent() {
        DbmObject dbmObject = this.myParent;
        if (dbmObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmMinor", "getDbParent"));
        }
        return dbmObject;
    }
}

