/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.util.Casing;
import com.intellij.dbm.common.DbmDatabase;
import com.intellij.dbm.common.DbmKey;
import com.intellij.dbm.common.DbmLikeTable;
import com.intellij.dbm.common.DbmMajor;
import com.intellij.dbm.common.DbmMatView;
import com.intellij.dbm.common.DbmNamespace;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmOperator;
import com.intellij.dbm.common.DbmRoot;
import com.intellij.dbm.common.DbmSequence;
import com.intellij.dbm.common.DbmSingleRoutine;
import com.intellij.dbm.common.DbmSynonym;
import com.intellij.dbm.common.DbmTable;
import com.intellij.dbm.common.DbmUserDefinedType;
import com.intellij.dbm.common.DbmView;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.RelativeReference;
import com.intellij.dbm.common.Resolver;
import com.intellij.dbm.common.StateProperty;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Dates;
import java.util.Arrays;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbmSchema
extends DbmNamespace
implements BasicModSchema {
    @NotNull
    public final DbmRoot myRoot;
    @Nullable
    public final DbmDatabase myDatabase;
    @StateProperty
    public long myIntrospectionStateNumber;
    @StateProperty
    @Nullable
    public Date myIntrospectionTimestamp;
    protected final Family<? extends DbmSequence> mySequences;
    protected final Family<? extends DbmTable> myTables;
    protected final Family<? extends DbmView> myViews;
    protected final Family<? extends DbmMatView> myMatViews;
    protected final Family<? extends DbmSingleRoutine> myRoutines;
    protected final Family<? extends DbmOperator> myOperators;
    protected final Family<? extends DbmSynonym> mySynonyms;
    private final SimpleKeyResolver mySimpleKeyResolver;
    private final SimpleSchemaObjectResolver mySimpleSchemaObjectResolver;

    @NotNull
    public Family<? extends DbmSequence> getSequences() {
        Family<? extends DbmSequence> family = this.mySequences;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSchema", "getSequences"));
        }
        return family;
    }

    @NotNull
    public Family<? extends DbmTable> getTables() {
        Family<? extends DbmTable> family = this.myTables;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSchema", "getTables"));
        }
        return family;
    }

    @NotNull
    public Family<? extends DbmView> getViews() {
        Family<? extends DbmView> family = this.myViews;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSchema", "getViews"));
        }
        return family;
    }

    @NotNull
    public Family<? extends DbmMatView> getMatViews() {
        Family<? extends DbmMatView> family = this.myMatViews;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSchema", "getMatViews"));
        }
        return family;
    }

    @NotNull
    public Family<? extends DbmSingleRoutine> getRoutines() {
        Family<? extends DbmSingleRoutine> family = this.myRoutines;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSchema", "getRoutines"));
        }
        return family;
    }

    @NotNull
    public Family<? extends DbmOperator> getOperators() {
        Family<? extends DbmOperator> family = this.myOperators;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSchema", "getOperators"));
        }
        return family;
    }

    @NotNull
    public Family<? extends DbmSynonym> getSynonyms() {
        Family<? extends DbmSynonym> family = this.mySynonyms;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSchema", "getSynonyms"));
        }
        return family;
    }

    public DbmSchema(@NotNull DbmObject parent, @Nullable String name) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/dbm/common/DbmSchema", "<init>"));
        }
        super(parent, name);
        this.mySequences = Family.of(this, ObjectKind.SEQUENCE);
        this.myTables = Family.of(this, ObjectKind.TABLE);
        this.myViews = Family.of(this, ObjectKind.VIEW);
        this.myMatViews = Family.of(this, ObjectKind.MAT_VIEW);
        this.myRoutines = Family.of(this, ObjectKind.ROUTINE);
        this.myOperators = Family.of(this, ObjectKind.OPERATOR);
        this.mySynonyms = Family.of(this, ObjectKind.SYNONYM);
        this.mySimpleKeyResolver = new SimpleKeyResolver();
        this.mySimpleSchemaObjectResolver = new SimpleSchemaObjectResolver();
        if (parent instanceof DbmDatabase) {
            this.myDatabase = (DbmDatabase)parent;
            this.myRoot = this.myDatabase.getRoot();
        } else if (parent instanceof DbmRoot) {
            this.myRoot = (DbmRoot)parent;
            this.myDatabase = null;
        } else {
            throw new IllegalArgumentException("The parent of a schema should be a database or the root, but got " + parent.getClass().getSimpleName());
        }
        this.assignFamilies(this.mySequences, this.myTables, this.myViews, this.myMatViews, this.myRoutines, this.mySynonyms);
    }

    @Override
    @NotNull
    public Family<? extends DbmSchema> getParentFamily() {
        com.intellij.database.model.families.Family family = super.getParentFamily();
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSchema", "getParentFamily"));
        }
        return family;
    }

    @Override
    @NotNull
    public DbmObject getDbParent() {
        DbmObject dbmObject = this.myDatabase != null ? this.myDatabase : this.myRoot;
        if (dbmObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSchema", "getDbParent"));
        }
        return dbmObject;
    }

    @Override
    @NotNull
    public final ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.SCHEMA;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSchema", "getKind"));
        }
        return objectKind;
    }

    @NotNull
    public Family<? extends DbmMajor> family(ObjectKind kind) {
        if (kind == ObjectKind.SEQUENCE) {
            Family<? extends DbmSequence> family = this.getSequences();
            if (family == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSchema", "family"));
            }
            return family;
        }
        if (kind == ObjectKind.TABLE) {
            Family<? extends DbmTable> family = this.getTables();
            if (family == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSchema", "family"));
            }
            return family;
        }
        if (kind == ObjectKind.VIEW) {
            Family<? extends DbmView> family = this.getViews();
            if (family == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSchema", "family"));
            }
            return family;
        }
        if (kind == ObjectKind.MAT_VIEW) {
            Family<? extends DbmMatView> family = this.getMatViews();
            if (family == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSchema", "family"));
            }
            return family;
        }
        if (kind == ObjectKind.ROUTINE) {
            Family<? extends DbmSingleRoutine> family = this.getRoutines();
            if (family == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSchema", "family"));
            }
            return family;
        }
        if (kind == ObjectKind.OPERATOR) {
            Family<? extends DbmOperator> family = this.getOperators();
            if (family == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSchema", "family"));
            }
            return family;
        }
        if (kind == ObjectKind.SYNONYM) {
            Family<? extends DbmSynonym> family = this.getSynonyms();
            if (family == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSchema", "family"));
            }
            return family;
        }
        Family<? extends DbmMajor> specificFamily = this.getSpecificFamily(kind);
        if (specificFamily != null) {
            Family<? extends DbmMajor> family = specificFamily;
            if (family == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSchema", "family"));
            }
            return family;
        }
        throw new IllegalArgumentException(this.getClass().getSimpleName() + " has no children of type " + kind);
    }

    protected void justObjectIdChanged(DbmObject object, long oldId, long newId) {
    }

    @Override
    @NotNull
    public DbmSchema getSchema() {
        DbmSchema dbmSchema = this;
        if (dbmSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSchema", "getSchema"));
        }
        return dbmSchema;
    }

    @Nullable
    public DbmKey findKeyByName(@NotNull String keyName) {
        if (keyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyName", "com/intellij/dbm/common/DbmSchema", "findKeyByName"));
        }
        for (DbmTable dbmTable : this.myTables) {
            DbmKey key = (DbmKey)((Family)dbmTable.getKeys()).get(keyName);
            if (key == null) continue;
            return key;
        }
        return null;
    }

    public long getIntrospectionStateNumber() {
        return this.myIntrospectionStateNumber;
    }

    @Override
    @Nullable
    public Date getIntrospectionTimestamp() {
        return Dates.clone(this.myIntrospectionTimestamp);
    }

    @Override
    public void setIntrospectionTimestamp(@Nullable Date introspectionTimestamp) {
        this.modifying();
        this.myIntrospectionTimestamp = Dates.clone(introspectionTimestamp);
    }

    public void setIntrospectionActualPoint(long introspectionStateNumber, @Nullable Date introspectionTimestamp) {
        this.modifying();
        this.myIntrospectionStateNumber = introspectionStateNumber;
        this.myIntrospectionTimestamp = Dates.clone(introspectionTimestamp);
    }

    @Nullable
    public DbmLikeTable getTableOrView(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/common/DbmSchema", "getTableOrView"));
        }
        DbmLikeTable table = (DbmLikeTable)this.getTables().get(name);
        if (table == null) {
            table = (DbmLikeTable)this.getViews().get(name);
        }
        return table;
    }

    @Nullable
    protected Family<? extends DbmMajor> getSpecificFamily(@NotNull ObjectKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/dbm/common/DbmSchema", "getSpecificFamily"));
        }
        return null;
    }

    public boolean catalogNamesAreEqual(@NotNull String nameA, @NotNull String nameB) {
        if (nameA == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameA", "com/intellij/dbm/common/DbmSchema", "catalogNamesAreEqual"));
        }
        if (nameB == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameB", "com/intellij/dbm/common/DbmSchema", "catalogNamesAreEqual"));
        }
        if (this.myDatabase != null) {
            return this.myDatabase.catalogNamesAreEqual(nameA, nameB);
        }
        return StringUtil.equals((CharSequence)nameA, (CharSequence)nameB);
    }

    @Override
    public boolean isCurrent() {
        if (this.myDatabase == null) {
            return this.myRoot.getCurrentSchema() == this;
        }
        return this.myDatabase.getCurrentSchema() == this;
    }

    @Override
    public void setCurrent(boolean current) {
        if (this.myDatabase == null) {
            this.myRoot.setCurrentNamespace(this);
        } else {
            this.myDatabase.setCurrentSchema(this);
        }
    }

    @NotNull
    public Resolver<? extends DbmKey> keyResolver() {
        SimpleKeyResolver simpleKeyResolver = this.mySimpleKeyResolver;
        if (simpleKeyResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSchema", "keyResolver"));
        }
        return simpleKeyResolver;
    }

    @NotNull
    public Resolver<? extends DbmMajor> schemaObjectResolver() {
        SimpleSchemaObjectResolver simpleSchemaObjectResolver = this.mySimpleSchemaObjectResolver;
        if (simpleSchemaObjectResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSchema", "schemaObjectResolver"));
        }
        return simpleSchemaObjectResolver;
    }

    @Nullable
    public DbmUserDefinedType resolveOwnCustomType(@NotNull String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/dbm/common/DbmSchema", "resolveOwnCustomType"));
        }
        return null;
    }

    @Nullable
    public DbmUserDefinedType resolveCustomType(@NotNull DataType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/dbm/common/DbmSchema", "resolveCustomType"));
        }
        return null;
    }

    @Override
    protected Resolver<? extends DbmObject> generalResolver() {
        return this.mySimpleSchemaObjectResolver;
    }

    @Override
    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/dbm/common/DbmSchema", "getCasing"));
        }
        assert (this.myDatabase != null) : "The function DbmSchema.getCasing() must be overloaded for single-database models";
        Casing casing = this.myDatabase.getCasing(kind, context);
        if (casing == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSchema", "getCasing"));
        }
        return casing;
    }

    private final class SimpleSchemaObjectResolver
    extends Resolver.Base<DbmMajor> {
        private SimpleSchemaObjectResolver() {
        }

        @Override
        @Nullable
        public DbmMajor resolve(@NotNull RelativeReference p) {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/dbm/common/DbmSchema$SimpleSchemaObjectResolver", "resolve"));
            }
            return this.resolve2(p.path, p.args);
        }

        @Override
        public DbmMajor resolve2(@NotNull String[] path, @Nullable String[] args) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/dbm/common/DbmSchema$SimpleSchemaObjectResolver", "resolve2"));
            }
            int n = path.length;
            switch (n) {
                case 1: {
                    for (Family family : DbmSchema.this.getFamilies()) {
                        if (!family.isNotEmpty() || !DbmMajor.class.isAssignableFrom(family.getChildClass())) continue;
                        for (DbmObject object : family) {
                            if (!(object instanceof DbmMajor) || !object.isName(path[0])) continue;
                            return (DbmMajor)object;
                        }
                    }
                    return null;
                }
                case 2: {
                    BasicNamedElement sibling = ((Family)DbmSchema.this.getParentFamily()).get(path[0]);
                    if (sibling != null && sibling instanceof DbmSchema) {
                        String[] restPath = new String[]{path[1]};
                        return ((DbmSchema)sibling).schemaObjectResolver().resolve2(restPath, args);
                    }
                    return null;
                }
                case 3: {
                    DbmSchema anotherSchema;
                    DbmDatabase anotherDB;
                    if (DbmSchema.this.myDatabase != null && (anotherDB = (DbmDatabase)((Family)DbmSchema.this.myDatabase.getParentFamily()).get(path[0])) != null && (anotherSchema = (DbmSchema)((Family)anotherDB.getSchemas()).get(path[1])) != null) {
                        return anotherSchema.schemaObjectResolver().resolve2(new String[]{path[2]}, args);
                    }
                    return null;
                }
            }
            return null;
        }
    }

    private final class SimpleKeyResolver
    extends Resolver.Base<DbmKey> {
        private SimpleKeyResolver() {
        }

        @Override
        @Nullable
        public DbmKey resolve(@NotNull RelativeReference p) {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/dbm/common/DbmSchema$SimpleKeyResolver", "resolve"));
            }
            return this.resolve2(p.path, null);
        }

        @Override
        @Nullable
        public DbmKey resolve2(@NotNull String[] pathAndName, @Nullable String[] subItems) {
            DbmKey key;
            if (pathAndName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathAndName", "com/intellij/dbm/common/DbmSchema$SimpleKeyResolver", "resolve2"));
            }
            int n = pathAndName.length;
            switch (n) {
                case 0: {
                    key = null;
                    break;
                }
                case 1: {
                    key = DbmSchema.this.findKeyByName(pathAndName[0]);
                    if (key != null) break;
                    key = this.resolveByTableAndColumns(pathAndName[0], subItems);
                    break;
                }
                case 2: {
                    key = this.resolveByTableAndKey(pathAndName[0], pathAndName[1]);
                    break;
                }
                default: {
                    key = null;
                }
            }
            if (key == null && n >= 2) {
                String schemaName = pathAndName[0];
                DbmSchema anotherSchema = (DbmSchema)((Family)DbmSchema.this.getParentFamily()).get(schemaName);
                if (anotherSchema != null) {
                    String[] path2 = Arrays.copyOfRange(pathAndName, 1, n);
                    key = anotherSchema.keyResolver().resolve2(path2, subItems);
                }
            }
            return key;
        }

        @Nullable
        private DbmKey resolveByTableAndColumns(String tableName, String[] columnNames) {
            DbmTable table = (DbmTable)DbmSchema.this.myTables.get(tableName);
            if (table == null) {
                return null;
            }
            return columnNames.length == 0 ? table.getPrimaryKey() : table.getKeyByColumns(columnNames);
        }

        @Nullable
        private DbmKey resolveByTableAndKey(@NotNull String tableName, @NotNull String keyName) {
            if (tableName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableName", "com/intellij/dbm/common/DbmSchema$SimpleKeyResolver", "resolveByTableAndKey"));
            }
            if (keyName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyName", "com/intellij/dbm/common/DbmSchema$SimpleKeyResolver", "resolveByTableAndKey"));
            }
            DbmTable table = (DbmTable)DbmSchema.this.getTables().get(tableName);
            if (table == null) {
                return null;
            }
            return (DbmKey)((Family)table.getKeys()).get(keyName);
        }
    }
}

