/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableMap;
import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.DbmKey;
import com.intellij.dbm.common.DbmLikeTable;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.StateProperty;
import com.intellij.dbm.common.TableOrganization;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbmTable
extends DbmLikeTable {
    @StateProperty
    public TableOrganization myOrganization;
    @StateProperty
    public boolean myTemporary;

    public DbmTable(@NotNull DbmSchema schema, @Nullable String name) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/common/DbmTable", "<init>"));
        }
        super(schema, name);
    }

    @Override
    @NotNull
    public final ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.TABLE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmTable", "getKind"));
        }
        return objectKind;
    }

    @Override
    @NotNull
    public String description(boolean includeSurrogates) {
        String string = this.myTemporary ? "temporary table" : "table";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmTable", "description"));
        }
        return string;
    }

    public TableOrganization getOrganization() {
        return this.myOrganization;
    }

    public void setOrganization(TableOrganization organization) {
        if (this.myOrganization == organization) {
            return;
        }
        this.modifying();
        this.myOrganization = organization;
    }

    @Override
    public boolean isTemporary() {
        return this.myTemporary;
    }

    public void setTemporary(boolean temporary) {
        if (this.myTemporary == temporary) {
            return;
        }
        this.modifying();
        this.myTemporary = temporary;
    }

    @Nullable
    public DbmKey getKeyByColumns(String ... columnNames) {
        int n = columnNames.length;
        if (n == 0) {
            return null;
        }
        for (DbmKey key : this.getKeys()) {
            if (!key.isExactlyByColumns(columnNames)) continue;
            return key;
        }
        return null;
    }

    @Override
    protected void collectState(@NotNull ImmutableMap.Builder<String, Object> stateBuilder, boolean surrogates) {
        if (stateBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateBuilder", "com/intellij/dbm/common/DbmTable", "collectState"));
        }
        super.collectState(stateBuilder, surrogates);
        this.putState(stateBuilder, "temporary", this.myTemporary);
        if (this.myOrganization != null) {
            this.putState(stateBuilder, "organization", this.myOrganization.name());
        }
    }
}

