/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableList;
import com.intellij.coding.CodeTextBuilder;
import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DeltaItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.util.Strings;

public final class DeltaObject {
    @NotNull
    public final ObjectKind kind;
    @Nullable
    public final DbmObject objectA;
    @Nullable
    public final DbmObject objectB;
    @NotNull
    public final ImmutableList<DeltaItem> items;
    @NotNull
    public final ImmutableList<DeltaObject> inner;
    public final transient boolean both;

    public DeltaObject(@Nullable DbmObject objectA, @Nullable DbmObject objectB, @NotNull ImmutableList<DeltaItem> items, @NotNull ImmutableList<DeltaObject> inner) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/dbm/common/DeltaObject", "<init>"));
        }
        if (inner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inner", "com/intellij/dbm/common/DeltaObject", "<init>"));
        }
        assert (objectA != null || objectB != null);
        if (objectA != null && objectB != null && objectA.getKind() != objectB.getKind()) {
            throw new IllegalArgumentException("Cannot compare objects of different kinds: " + objectA.getKind() + " and " + objectB.getKind());
        }
        this.both = objectA != null && objectB != null;
        this.kind = objectA != null ? objectA.getKind() : objectB.getKind();
        this.objectA = objectA;
        this.objectB = objectB;
        this.items = items;
        this.inner = inner;
    }

    @NotNull
    public String identity() {
        if (this.objectA != null) {
            String string = this.objectA.identity();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DeltaObject", "identity"));
            }
            return string;
        }
        if (this.objectB != null) {
            String string = this.objectB.identity();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DeltaObject", "identity"));
            }
            return string;
        }
        throw new InternalError("Both objects of an instance of " + this.getClass().getSimpleName() + " are null");
    }

    @Nullable
    public String getName() {
        String name = null;
        if (this.objectA != null) {
            name = this.objectA.getName();
        }
        if (name == null && this.objectB != null) {
            name = this.objectB.getName();
        }
        return name;
    }

    public boolean isCreated() {
        return this.objectA == null;
    }

    public boolean isDeleted() {
        return this.objectB == null;
    }

    public boolean isRenamed() {
        if (!this.both) {
            return false;
        }
        assert (this.objectA != null);
        assert (this.objectB != null);
        String nameA = this.objectA.hasNaturalName() ? this.objectA.getName() : null;
        String nameB = this.objectB.hasNaturalName() ? this.objectB.getName() : null;
        return this.both && !Strings.eq((String)nameA, (String)nameB);
    }

    public boolean isModified() {
        return this.both && (!this.items.isEmpty() || !this.inner.isEmpty());
    }

    public boolean areEqual() {
        return this.both && !this.isRenamed() && this.items.isEmpty() && this.inner.isEmpty();
    }

    @NotNull
    public String descriptionLine() {
        StringBuilder b = new StringBuilder();
        b.append(this.identity()).append(':');
        if (this.isCreated()) {
            b.append(" created");
        }
        if (this.isDeleted()) {
            b.append(" deleted");
        }
        if (this.isRenamed()) {
            b.append(" renamed");
        }
        int m = this.items.size();
        int n = this.inner.size();
        if (m > 0 || n > 0) {
            b.append(" modified (");
        }
        if (m == 1) {
            b.append("1 property");
        }
        if (m >= 2) {
            b.append(m).append(" properties");
        }
        if (m > 0 && n > 0) {
            b.append(" and ");
        }
        if (n == 1) {
            b.append("1 child");
        }
        if (n >= 2) {
            b.append(n).append(" children");
        }
        if (m > 0 || n > 0) {
            b.append(")");
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DeltaObject", "descriptionLine"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void describe(CodeTextBuilder builder) {
        builder.addText(this.descriptionLine());
        if (this.isRenamed() || this.isModified()) {
            builder.indent();
            try {
                if (this.isRenamed()) {
                    assert (this.objectA != null);
                    assert (this.objectB != null);
                    String nameA = this.objectA.hasNaturalName() ? this.objectA.getNameOrEmpty() : "<unnamed>";
                    String nameB = this.objectB.hasNaturalName() ? this.objectB.getNameOrEmpty() : "<unnamed>";
                    builder.addText("name: " + nameA + " -- " + nameB);
                }
                for (DeltaItem item : this.items) {
                    builder.addText(item.toString());
                }
                for (DeltaObject deltaObject : this.inner) {
                    deltaObject.describe(builder);
                }
            }
            finally {
                builder.unindent();
            }
        }
    }

    public String toString() {
        if (this.isModified()) {
            CodeTextBuilder builder = new CodeTextBuilder();
            this.describe(builder);
            return builder.getText();
        }
        return this.descriptionLine();
    }
}

