/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.generic;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.util.JdbcUtil;
import com.intellij.dbm.common.DbmArgument;
import com.intellij.dbm.common.DbmColumn;
import com.intellij.dbm.common.DbmDatabase;
import com.intellij.dbm.common.DbmForeignKey;
import com.intellij.dbm.common.DbmIndex;
import com.intellij.dbm.common.DbmKey;
import com.intellij.dbm.common.DbmLikeTable;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.DbmNamespace;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmRoutine;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.db2.Db2Model;
import com.intellij.dbm.derby.DerbyModel;
import com.intellij.dbm.generic.DatabaseLegacyModelUtils;
import com.intellij.dbm.generic.legacy.TableType;
import com.intellij.dbm.generic.meta.ClosableIt;
import com.intellij.dbm.generic.meta.DatabaseMetaDataWrapper;
import com.intellij.dbm.generic.meta.MetaDataUtil;
import com.intellij.dbm.hsqldb.HsqldbModel;
import com.intellij.dbm.sqlite.SqliteModel;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.H2db;
import org.jetbrains.dekaf.Mssql;
import org.jetbrains.dekaf.Mysql;
import org.jetbrains.dekaf.Oracle;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.Sybase;

class GenericIntrospectorHelper {
    private static final Map<Rdbms, DatabaseFamilyId> FAMILIES = ContainerUtil.immutableMapBuilder().put((Object)Db2Model.RDBMS, (Object)DatabaseFamilyId.DB2).put((Object)DerbyModel.RDBMS, (Object)DatabaseFamilyId.DERBY).put((Object)H2db.RDBMS, (Object)DatabaseFamilyId.H2).put((Object)HsqldbModel.RDBMS, (Object)DatabaseFamilyId.HSQLDB).put((Object)Mssql.RDBMS, (Object)DatabaseFamilyId.MSSQL).put((Object)Mysql.RDBMS, (Object)DatabaseFamilyId.MYSQL).put((Object)Oracle.RDBMS, (Object)DatabaseFamilyId.ORACLE).put((Object)Postgres.RDBMS, (Object)DatabaseFamilyId.POSTGRES).put((Object)SqliteModel.RDBMS, (Object)DatabaseFamilyId.SQLITE).put((Object)Sybase.RDBMS, (Object)DatabaseFamilyId.SYBASE).build();
    private final DbmModel<?, ?> myModel;
    private final DatabaseFamilyId myFamilyId;
    private final boolean mySchemaDbMode;
    private final Map<DbmObject, String> myProcSpecNames;

    public GenericIntrospectorHelper(@NotNull DbmModel<?, ?> model, @NotNull Rdbms rdbms) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dbm/generic/GenericIntrospectorHelper", "<init>"));
        }
        if (rdbms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rdbms", "com/intellij/dbm/generic/GenericIntrospectorHelper", "<init>"));
        }
        this.myProcSpecNames = ContainerUtil.newHashMap();
        this.myModel = model;
        this.myFamilyId = (DatabaseFamilyId)ContainerUtil.getOrElse(FAMILIES, (Object)rdbms, (Object)DatabaseFamilyId.UNKNOWN);
        this.mySchemaDbMode = DatabaseLegacyModelUtils.isSchemaDbMode(this.myModel, this.myFamilyId);
    }

    @NotNull
    public DbmModel<?, ?> getModel() {
        DbmModel<?, ?> dbmModel = this.myModel;
        if (dbmModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/GenericIntrospectorHelper", "getModel"));
        }
        return dbmModel;
    }

    @Nullable
    public DbmNamespace getCatalog(@NotNull DbmSchema schema) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/GenericIntrospectorHelper", "getCatalog"));
        }
        return this.mySchemaDbMode ? schema : schema.myDatabase;
    }

    @NotNull
    public DatabaseMetaDataWrapper.Schema asSchema(@NotNull DbmSchema schema) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/GenericIntrospectorHelper", "asSchema"));
        }
        String database = schema.myDatabase == null ? null : schema.myDatabase.getName();
        DatabaseMetaDataWrapper.Schema schema2 = this.mySchemaDbMode ? new DatabaseMetaDataWrapper.Schema(StringUtil.notNullize((String)database), StringUtil.nullize((String)schema.getName())) : new DatabaseMetaDataWrapper.Schema(schema.getName(), database);
        if (schema2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/GenericIntrospectorHelper", "asSchema"));
        }
        return schema2;
    }

    @NotNull
    public DatabaseMetaDataWrapper.Table asTable(@NotNull DbmLikeTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/generic/GenericIntrospectorHelper", "asTable"));
        }
        DatabaseMetaDataWrapper.Table table2 = new DatabaseMetaDataWrapper.Table(this.asSchema(table.getSchema()), table.getName());
        if (table2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/GenericIntrospectorHelper", "asTable"));
        }
        return table2;
    }

    public void createTable(@NotNull DbmSchema schema, @NotNull DatabaseMetaDataWrapper.Table table) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/GenericIntrospectorHelper", "createTable"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/generic/GenericIntrospectorHelper", "createTable"));
        }
        ObjectKind kind = TableType.findByName(table.type).getKind();
        Family family = (Family)ObjectUtils.chooseNotNull(schema.findFamilyByChildKind(kind), schema.getTables());
        if (family == null || !family.isPopulatable()) {
            return;
        }
        Object res = family.getOrCreate(table.name);
        ((DbmObject)res).setComment(table.comment);
    }

    public void createKeys(@NotNull DbmLikeTable table, @NotNull ClosableIt.GroupingIt<DatabaseMetaDataWrapper.TableKey, DatabaseMetaDataWrapper.TableKeyColumn> keyIt) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/generic/GenericIntrospectorHelper", "createKeys"));
        }
        if (keyIt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyIt", "com/intellij/dbm/generic/GenericIntrospectorHelper", "createKeys"));
        }
        DatabaseMetaDataWrapper.TableKey storedKey = new DatabaseMetaDataWrapper.TableKey(this.asTable(table), null);
        for (DatabaseMetaDataWrapper.TableKey key : JBIterable.once(keyIt)) {
            storedKey.assign(key);
            this.createKey(table, key, (Iterator<DatabaseMetaDataWrapper.TableKeyColumn>)keyIt.groupIt());
        }
    }

    public void createKey(@NotNull DbmLikeTable table, @NotNull DatabaseMetaDataWrapper.TableKey key, @NotNull Iterator<DatabaseMetaDataWrapper.TableKeyColumn> keyColumnIt) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/generic/GenericIntrospectorHelper", "createKey"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/dbm/generic/GenericIntrospectorHelper", "createKey"));
        }
        if (keyColumnIt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyColumnIt", "com/intellij/dbm/generic/GenericIntrospectorHelper", "createKey"));
        }
        DbmKey res = (DbmKey)((Family)table.getKeys()).getOrCreate(StringUtil.notNullize((String)key.name));
        TreeMap columns = ContainerUtil.newTreeMap();
        res.setPrimary(key.primary);
        for (DatabaseMetaDataWrapper.TableKeyColumn col : JBIterable.once(keyColumnIt)) {
            columns.put(col.position, col.name);
        }
        res.setColumnNames(ArrayUtil.toStringArray(columns.values()));
        res.setNameSurrogate(this.isSurrogate(key));
    }

    public void createRoutine(@NotNull DbmSchema schema, @NotNull DatabaseMetaDataWrapper.Routine routine) {
        DbmSchema parent;
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/GenericIntrospectorHelper", "createRoutine"));
        }
        if (routine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/dbm/generic/GenericIntrospectorHelper", "createRoutine"));
        }
        String pkg = this.getRealPackage(routine);
        DbmObject dbmObject = parent = pkg == null ? schema : GenericIntrospectorHelper.getOrCreatePackage(schema, pkg);
        if (parent == null) {
            return;
        }
        Object procedure = this.getOrCreateRoutineBySpecName((Family)parent.familyOf(ObjectKind.ROUTINE), routine.name, routine.specificName);
        ((DbmRoutine)procedure).setRoutineKind(routine.kind);
        ((DbmObject)procedure).setComment(routine.comment);
    }

    public void createColumns(@Nullable DbmLikeTable table, @NotNull Iterator<DatabaseMetaDataWrapper.TableColumn> columnIt) {
        if (columnIt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIt", "com/intellij/dbm/generic/GenericIntrospectorHelper", "createColumns"));
        }
        if (table == null) {
            return;
        }
        for (DatabaseMetaDataWrapper.TableColumn column : JBIterable.once(columnIt)) {
            this.createColumn(table, column);
        }
    }

    public void createColumn(@NotNull DbmLikeTable table, @NotNull DatabaseMetaDataWrapper.TableColumn col) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/generic/GenericIntrospectorHelper", "createColumn"));
        }
        if (col == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "col", "com/intellij/dbm/generic/GenericIntrospectorHelper", "createColumn"));
        }
        DbmColumn column = (DbmColumn)((Family)table.getColumns()).getOrCreate(StringUtil.notNullize((String)col.name));
        column.setComment(col.comment);
        column.setPosition((short)col.position);
        column.setDataType(DataTypeFactory.of(null, StringUtil.notNullize((String)col.typeName), col.length, col.scale, null, null, false, false, col.type));
        column.setMandatory(!col.nullable);
        column.setDefaultExpression(DatabaseLegacyModelUtils.fixDefaultValue(this.myFamilyId, column, col.def));
        if (col.autoIncrement) {
            column.setSequenceIdentity(DatabaseLegacyModelUtils.SEQUENCE_IDENTITY);
        }
    }

    @Nullable
    public DbmSchema createSchema(@NotNull DatabaseMetaDataWrapper.Schema schema) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/GenericIntrospectorHelper", "createSchema"));
        }
        Family<?> root = this.myModel.getRootNamespaces();
        if (root.getChildKind() == ObjectKind.DATABASE) {
            DbmDatabase db = (DbmDatabase)root.getOrCreate(StringUtil.notNullize((String)schema.database));
            return (DbmSchema)((Family)db.getSchemas()).getOrCreate(schema.schema);
        }
        if (root.getChildKind() == ObjectKind.SCHEMA) {
            return (DbmSchema)root.getOrCreate(this.mySchemaDbMode ? StringUtil.notNullize((String)schema.database) : schema.schema);
        }
        return null;
    }

    public void createIndices(@NotNull DbmLikeTable table, @NotNull ClosableIt.GroupingIt<DatabaseMetaDataWrapper.TableIndex, DatabaseMetaDataWrapper.TableIndexColumn> indexColumnIt) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/generic/GenericIntrospectorHelper", "createIndices"));
        }
        if (indexColumnIt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexColumnIt", "com/intellij/dbm/generic/GenericIntrospectorHelper", "createIndices"));
        }
        DatabaseMetaDataWrapper.TableIndex storedIdx = new DatabaseMetaDataWrapper.TableIndex(new DatabaseMetaDataWrapper.Table(this.asSchema(table.getSchema()), table.getName()), "");
        for (DatabaseMetaDataWrapper.TableIndex idx : JBIterable.once(indexColumnIt)) {
            storedIdx.assign(idx);
            this.createIndex(table, storedIdx, (Iterator<DatabaseMetaDataWrapper.TableIndexColumn>)indexColumnIt.groupIt());
        }
    }

    private void createIndex(@NotNull DbmLikeTable table, @NotNull DatabaseMetaDataWrapper.TableIndex idx, @NotNull Iterator<DatabaseMetaDataWrapper.TableIndexColumn> columnIt) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/generic/GenericIntrospectorHelper", "createIndex"));
        }
        if (idx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idx", "com/intellij/dbm/generic/GenericIntrospectorHelper", "createIndex"));
        }
        if (columnIt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIt", "com/intellij/dbm/generic/GenericIntrospectorHelper", "createIndex"));
        }
        TreeMap columns = ContainerUtil.newTreeMap();
        for (Object column : JBIterable.once(columnIt)) {
            columns.put(((DatabaseMetaDataWrapper.TableIndexColumn)column).position, Pair.create((Object)((DatabaseMetaDataWrapper.TableIndexColumn)column).name, (Object)((DatabaseMetaDataWrapper.TableIndexColumn)column).sorting));
        }
        DbmIndex index = (DbmIndex)((Family)table.getIndices()).getOrCreate(StringUtil.notNullize((String)idx.name));
        index.setUnique(!idx.nonUnique);
        index.clearColumnsList();
        for (Pair column : columns.values()) {
            index.addColumn((String)column.first, (DasIndex.Sorting)column.second);
        }
        index.setNameSurrogate(this.isSurrogate(idx));
        List<String> names = index.myColumns.namesOrdered();
        DbmKey key = table.getKeyByColumns(names);
        if (key != null && key.getUnderlyingIndex() == null) {
            index.drop();
        } else {
            for (DbmForeignKey foreignKey : ((Family)table.getForeignKeys()).asList()) {
                if (!foreignKey.myColumns.namesOrdered().equals(names)) continue;
                index.drop();
                break;
            }
        }
    }

    public void createForeignKeys(@NotNull DbmLikeTable table, @NotNull ClosableIt.GroupingIt<DatabaseMetaDataWrapper.TableFKey, DatabaseMetaDataWrapper.TableFKeyColumn> fkColumnIt) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/generic/GenericIntrospectorHelper", "createForeignKeys"));
        }
        if (fkColumnIt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fkColumnIt", "com/intellij/dbm/generic/GenericIntrospectorHelper", "createForeignKeys"));
        }
        DatabaseMetaDataWrapper.TableFKey storedFkey = new DatabaseMetaDataWrapper.TableFKey(new DatabaseMetaDataWrapper.Table(new DatabaseMetaDataWrapper.Schema("", null), ""), new DatabaseMetaDataWrapper.Table(new DatabaseMetaDataWrapper.Schema("", null), ""), "");
        for (DatabaseMetaDataWrapper.TableFKey fkey : JBIterable.once(fkColumnIt)) {
            storedFkey.assign(fkey);
            this.createForeignKey(table, fkey, (Iterator<DatabaseMetaDataWrapper.TableFKeyColumn>)fkColumnIt.groupIt());
        }
    }

    public void createForeignKey(@NotNull DbmLikeTable table, @NotNull DatabaseMetaDataWrapper.TableFKey key, @NotNull Iterator<DatabaseMetaDataWrapper.TableFKeyColumn> columnIt) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/generic/GenericIntrospectorHelper", "createForeignKey"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/dbm/generic/GenericIntrospectorHelper", "createForeignKey"));
        }
        if (columnIt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIt", "com/intellij/dbm/generic/GenericIntrospectorHelper", "createForeignKey"));
        }
        TreeMap columns = ContainerUtil.newTreeMap();
        DbmForeignKey foreignKey = (DbmForeignKey)((Family)table.getForeignKeys()).getOrCreate(StringUtil.notNullize((String)key.name));
        foreignKey.setCascadeUpdateRule(DatabaseLegacyModelUtils.asCascadeRule(JdbcUtil.getRuleAction((short)key.updateRule), true));
        foreignKey.setCascadeDeleteRule(DatabaseLegacyModelUtils.asCascadeRule(JdbcUtil.getRuleAction((short)key.deleteRule), false));
        DasForeignKey.Deferrability deferrability = JdbcUtil.getDeferrability((short)key.deferrability);
        foreignKey.setDeferrable(deferrability != DasForeignKey.Deferrability.NOT_DEFERRABLE);
        foreignKey.setInitiallyDeferred(deferrability == DasForeignKey.Deferrability.INITIALLY_DEFERRED);
        String[] tPath = this.buildSearchPath(key.table, key.targetTable);
        columns.clear();
        for (DatabaseMetaDataWrapper.TableFKeyColumn column : JBIterable.once(columnIt)) {
            columns.put(column.position, Pair.create((Object)column.name, (Object)column.targetName));
        }
        String[] sCols = new String[columns.size()];
        String[] tCols = new String[columns.size()];
        int i = 0;
        for (Pair column : columns.values()) {
            sCols[i] = (String)column.first;
            tCols[i] = (String)column.second;
            ++i;
        }
        foreignKey.setColumnNames(sCols);
        foreignKey.refKey.set(tPath, tCols);
        foreignKey.setNameSurrogate(key.surrogateName || this.isSurrogate(key));
    }

    public void createArguments(@Nullable DbmRoutine procedure, @NotNull Iterator<DatabaseMetaDataWrapper.RoutineArgument> argumentIt) {
        if (argumentIt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentIt", "com/intellij/dbm/generic/GenericIntrospectorHelper", "createArguments"));
        }
        if (procedure == null) {
            return;
        }
        for (DatabaseMetaDataWrapper.RoutineArgument argument : JBIterable.once(argumentIt)) {
            this.createArgument(procedure, argument);
        }
    }

    public void createArgument(@NotNull DbmRoutine procedure, @NotNull DatabaseMetaDataWrapper.RoutineArgument arg) {
        DbmArgument argument;
        if (procedure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "procedure", "com/intellij/dbm/generic/GenericIntrospectorHelper", "createArgument"));
        }
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/intellij/dbm/generic/GenericIntrospectorHelper", "createArgument"));
        }
        if (arg.direction == DasArgument.Direction.RETURN) {
            argument = procedure.getOrCreateReturnArgument();
            argument.setName(arg.name);
        } else {
            argument = (DbmArgument)((Family)procedure.getArguments()).getOrCreate(StringUtil.notNullize((String)arg.name));
            argument.setDirection(arg.direction);
        }
        argument.setDataType(DataTypeFactory.of(null, StringUtil.notNullize((String)arg.typeName), arg.length, arg.scale, null, null, false, false, arg.type));
        argument.setDefaultExpression(arg.def);
        argument.setPosition((short)arg.position);
    }

    private boolean isSurrogate(@NotNull DatabaseMetaDataWrapper.TableIndex index) {
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/dbm/generic/GenericIntrospectorHelper", "isSurrogate"));
        }
        return this.isSurrogate(StringUtil.notNullize((String)index.name), ObjectKind.INDEX) || this.myFamilyId.isDb2() && "SYSIBM".equalsIgnoreCase(index.qualifier);
    }

    private boolean isSurrogate(@NotNull DatabaseMetaDataWrapper.TableKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/dbm/generic/GenericIntrospectorHelper", "isSurrogate"));
        }
        return this.isSurrogate(StringUtil.notNullize((String)key.name), ObjectKind.KEY);
    }

    private boolean isSurrogate(@NotNull DatabaseMetaDataWrapper.TableFKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/dbm/generic/GenericIntrospectorHelper", "isSurrogate"));
        }
        return this.isSurrogate(StringUtil.notNullize((String)key.name), ObjectKind.FOREIGN_KEY);
    }

    private boolean isSurrogate(@NotNull String safeName, @NotNull ObjectKind kind) {
        if (safeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "safeName", "com/intellij/dbm/generic/GenericIntrospectorHelper", "isSurrogate"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/dbm/generic/GenericIntrospectorHelper", "isSurrogate"));
        }
        if (this.myFamilyId.isSqlite() && safeName.startsWith("sqlite_autoindex_")) {
            return true;
        }
        if (this.myFamilyId.isHsqldb()) {
            return kind == ObjectKind.INDEX && safeName.startsWith("SYS_IDX") || kind == ObjectKind.KEY && safeName.startsWith("SYS_PK") || kind == ObjectKind.FOREIGN_KEY && safeName.startsWith("SYS_FK");
        }
        if (this.myFamilyId.isH2()) {
            return kind == ObjectKind.INDEX && (safeName.startsWith("PRIMARY_KEY_") || safeName.startsWith("CONSTRAINT_INDEX_")) || (kind == ObjectKind.KEY || kind == ObjectKind.FOREIGN_KEY) && safeName.startsWith("CONSTRAINT_");
        }
        if (this.myFamilyId.isDerby() && safeName.matches("SQL\\d{15}")) {
            return true;
        }
        if (this.myFamilyId.isSybase() && safeName.matches("^.*_\\d{5,}$")) {
            return true;
        }
        if (this.myFamilyId.isOracle() && safeName.startsWith("SYS_")) {
            return true;
        }
        if (this.myFamilyId.isMicrosoft()) {
            return kind == ObjectKind.INDEX && safeName.startsWith("PK__") || kind == ObjectKind.KEY && safeName.startsWith("PK__") || kind == ObjectKind.FOREIGN_KEY && safeName.startsWith("FK__");
        }
        return this.myFamilyId.isMysql() && safeName.equals("PRIMARY") && (kind == ObjectKind.INDEX || kind == ObjectKind.KEY);
    }

    private String[] buildSearchPath(@NotNull DatabaseMetaDataWrapper.Table src, @NotNull DatabaseMetaDataWrapper.Table tgt) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/dbm/generic/GenericIntrospectorHelper", "buildSearchPath"));
        }
        if (tgt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tgt", "com/intellij/dbm/generic/GenericIntrospectorHelper", "buildSearchPath"));
        }
        String tCat = tgt.schema.database;
        String sCat = src.schema.database;
        String tSchema = tgt.schema.schema;
        String sSchema = src.schema.schema;
        if (this.mySchemaDbMode) {
            String tmp = tCat;
            tCat = tSchema;
            tSchema = tmp;
            tmp = sCat;
            sCat = sSchema;
            sSchema = tmp;
        }
        String[] tPath = !Comparing.equal((String)tCat, (String)sCat) ? new String[]{tCat, tSchema, tgt.name} : (!Comparing.equal((String)tSchema, (String)sSchema) ? new String[]{tSchema, tgt.name} : new String[]{tgt.name});
        return tPath;
    }

    @Nullable
    private String getRealPackage(@NotNull DatabaseMetaDataWrapper.Routine routine) {
        if (routine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/dbm/generic/GenericIntrospectorHelper", "getRealPackage"));
        }
        if (routine.pkg == null && this.myFamilyId.isSybase() && routine.kind == DasRoutine.Kind.PROCEDURE) {
            return routine.name;
        }
        return routine.pkg;
    }

    @Nullable
    private static DbmObject getOrCreatePackage(@NotNull DbmObject schema, @NotNull String cat) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/GenericIntrospectorHelper", "getOrCreatePackage"));
        }
        if (cat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cat", "com/intellij/dbm/generic/GenericIntrospectorHelper", "getOrCreatePackage"));
        }
        Family<?> packages = schema.findFamilyByChildKind(ObjectKind.PACKAGE);
        return packages == null || !packages.isPopulatable() ? null : (DbmObject)packages.getOrCreate(cat);
    }

    @NotNull
    public String getProcName(@NotNull DatabaseMetaDataWrapper.Routine routine) {
        if (routine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/dbm/generic/GenericIntrospectorHelper", "getProcName"));
        }
        String string = MetaDataUtil.getProcName(routine.specificName, this.getRealPackage(routine));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/GenericIntrospectorHelper", "getProcName"));
        }
        return string;
    }

    @NotNull
    public String getSpecName(@NotNull DbmRoutine routine) {
        if (routine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/dbm/generic/GenericIntrospectorHelper", "getSpecName"));
        }
        String string = (String)ContainerUtil.getOrElse(this.myProcSpecNames, (Object)((DbmObject)((Object)routine)), (Object)routine.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/GenericIntrospectorHelper", "getSpecName"));
        }
        return string;
    }

    @NotNull
    private <T extends DbmObject> T getOrCreateRoutineBySpecName(@NotNull Family<T> f, @NotNull String name, @NotNull String specName) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/dbm/generic/GenericIntrospectorHelper", "getOrCreateRoutineBySpecName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/generic/GenericIntrospectorHelper", "getOrCreateRoutineBySpecName"));
        }
        if (specName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specName", "com/intellij/dbm/generic/GenericIntrospectorHelper", "getOrCreateRoutineBySpecName"));
        }
        DbmObject res = f.find(x -> {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/generic/GenericIntrospectorHelper", "lambda$getOrCreateRoutineBySpecName$0"));
            }
            if (specName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specName", "com/intellij/dbm/generic/GenericIntrospectorHelper", "lambda$getOrCreateRoutineBySpecName$0"));
            }
            return x != null && name.equals(x.getName()) && specName.equals(this.myProcSpecNames.get(x));
        });
        if (res == null && (res = f.find(x -> {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/generic/GenericIntrospectorHelper", "lambda$getOrCreateRoutineBySpecName$1"));
            }
            return x != null && name.equals(x.getName()) && this.myProcSpecNames.get(x) == null;
        })) != null) {
            this.myProcSpecNames.put(res, specName);
        }
        if (res != null) {
            res.resetSyncPending();
        } else {
            res = f.create(name);
            this.myProcSpecNames.put(res, specName);
        }
        DbmObject dbmObject = res;
        if (dbmObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/GenericIntrospectorHelper", "getOrCreateRoutineBySpecName"));
        }
        return (T)dbmObject;
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = this.myFamilyId;
        if (databaseFamilyId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/GenericIntrospectorHelper", "getFamilyId"));
        }
        return databaseFamilyId;
    }

    @NotNull
    public RoutineMap createRoutineMap() {
        RoutineMap routineMap = new RoutineMap();
        if (routineMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/GenericIntrospectorHelper", "createRoutineMap"));
        }
        return routineMap;
    }

    public boolean isSchemaDbMode() {
        return this.mySchemaDbMode;
    }

    public class RoutineMap {
        private final Map<String, DbmRoutine> name2Routine = ContainerUtil.newHashMap();

        @Nullable
        public DasRoutine.Kind guessType(DatabaseMetaDataWrapper.Routine r) {
            DbmRoutine routine = this.name2Routine.get(MetaDataUtil.getProcName(r.specificName, r.pkg));
            if (routine == null && GenericIntrospectorHelper.this.getFamilyId().isSybase()) {
                routine = this.name2Routine.get(MetaDataUtil.getProcName(r.specificName, r.name));
            }
            return routine == null ? DasRoutine.Kind.NONE : routine.getRoutineKind();
        }

        @Nullable
        public DbmRoutine get(DatabaseMetaDataWrapper.Routine r) {
            return this.name2Routine.get(GenericIntrospectorHelper.this.getProcName(r));
        }

        public void put(@NotNull DbmRoutine routine) {
            if (routine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/dbm/generic/GenericIntrospectorHelper$RoutineMap", "put"));
            }
            this.name2Routine.put(MetaDataUtil.getProcName(GenericIntrospectorHelper.this.getSpecName(routine), this.getPackage(routine)), routine);
        }

        @Nullable
        private String getPackage(DbmRoutine routine) {
            BasicElement parent = routine.getDbParent();
            return parent == null || parent.getKind() != ObjectKind.PACKAGE ? null : parent.getName();
        }
    }
}

