/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.generic.meta;

import com.intellij.database.util.ErrorHandler;
import com.intellij.dbm.generic.meta.MetaDataUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Factory;
import com.intellij.util.containers.JBIterator;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClosableIt<T>
extends JBIterator<T>
implements AutoCloseable {
    private static final ClosableIt<Object> EMPTY = new ClosableIt<Object>(){

        @Override
        public void close() {
        }

        protected Object nextImpl() {
            return this.stop();
        }
    };

    public static <T> ClosableIt<T> empty() {
        return EMPTY;
    }

    @NotNull
    static <T> ClosableIt<T> lazyAppend(@NotNull ClosableIt<T> it1, final @NotNull Factory<ClosableIt<T>> next) {
        if (it1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "it1", "com/intellij/dbm/generic/meta/ClosableIt", "lazyAppend"));
        }
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/dbm/generic/meta/ClosableIt", "lazyAppend"));
        }
        LazyAppendableClosableIt lazyAppendableClosableIt = new LazyAppendableClosableIt<T>(it1){
            boolean myFirst;
            {
                super(init);
                this.myFirst = true;
            }

            @Override
            @Nullable
            protected ClosableIt<? extends T> nextIt() {
                if (!this.myFirst) {
                    return null;
                }
                this.myFirst = false;
                return (ClosableIt)next.create();
            }
        };
        if (lazyAppendableClosableIt == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/ClosableIt", "lazyAppend"));
        }
        return lazyAppendableClosableIt;
    }

    @NotNull
    static <T> ClosableIt<T> lazyAppendIfEmpty(@NotNull ClosableIt<T> it1, @NotNull Factory<ClosableIt<T>> next) {
        if (it1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "it1", "com/intellij/dbm/generic/meta/ClosableIt", "lazyAppendIfEmpty"));
        }
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/dbm/generic/meta/ClosableIt", "lazyAppendIfEmpty"));
        }
        final boolean[] empty = new boolean[]{true};
        ClosableIt<T> closableIt = ClosableIt.lazyAppend(new DelegateIt<T, T>((Iterator)it1){

            @Override
            protected T calcValue(T cur) {
                empty[0] = false;
                return cur;
            }
        }, () -> {
            if (next == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/dbm/generic/meta/ClosableIt", "lambda$lazyAppendIfEmpty$0"));
            }
            return empty[0] ? (ClosableIt)next.create() : null;
        });
        if (closableIt == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/ClosableIt", "lazyAppendIfEmpty"));
        }
        return closableIt;
    }

    @Override
    public abstract void close();

    static abstract class GroupingItImpl<Item, SubItem, Delegate>
    extends GroupingIt<Item, SubItem> {
        protected final ClosableIt<Delegate> myDelegate;
        private GroupIt<SubItem> mySubIt;

        protected GroupingItImpl(@NotNull ClosableIt<Delegate> delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/dbm/generic/meta/ClosableIt$GroupingItImpl", "<init>"));
            }
            this.mySubIt = null;
            this.myDelegate = delegate;
        }

        @NotNull
        protected abstract GroupIt<SubItem> createGroupIt(ClosableIt<Delegate> var1);

        protected abstract Item getItem(ClosableIt<Delegate> var1);

        @Override
        public void close() {
            this.myDelegate.close();
        }

        protected Item nextImpl() {
            if (this.mySubIt == null) {
                if (!this.myDelegate.hasNext()) {
                    return (Item)this.stop();
                }
                this.myDelegate.next();
            }
            while (this.mySubIt != null && this.mySubIt.hasNext()) {
                this.mySubIt.next();
            }
            if (!this.myDelegate.hasNext() && this.mySubIt != null && this.mySubIt.isEof()) {
                return (Item)this.stop();
            }
            this.mySubIt = this.createGroupIt(this.myDelegate);
            return this.getItem(this.myDelegate);
        }

        @Override
        @NotNull
        public JBIterator<SubItem> groupIt() {
            GroupIt<SubItem> groupIt = this.mySubIt;
            if (groupIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/ClosableIt$GroupingItImpl", "groupIt"));
            }
            return groupIt;
        }

        protected static abstract class GroupIt<T>
        extends JBIterator<T> {
            private final JBIterator<T> myIt;
            private boolean myFirst = true;
            private boolean myEof = false;

            public GroupIt(JBIterator<T> it) {
                this.myIt = it;
            }

            protected T nextImpl() {
                if (this.myFirst) {
                    this.myFirst = false;
                    return (T)this.myIt.current();
                }
                if (!this.myIt.advance()) {
                    this.myEof = true;
                    return (T)this.stop();
                }
                return (T)(this.isInGroup(this.myIt.current()) ? this.myIt.current() : this.stop());
            }

            protected abstract boolean isInGroup(T var1);

            public boolean isEof() {
                return this.myEof;
            }
        }
    }

    public static abstract class GroupingIt<Item, SubItem>
    extends ClosableIt<Item> {
        @NotNull
        public abstract JBIterator<SubItem> groupIt();
    }

    static abstract class ResultSetDelegateIt<T>
    extends ClosableIt<T> {
        protected final MetaDataUtil.ResultSetWrapper myRs;
        protected final ErrorHandler myErrorHandler;
        private final AutoCloseable myHook;
        private Boolean myInitialHasNext;

        public ResultSetDelegateIt(@NotNull ResultSet rs, @NotNull ErrorHandler handler, @Nullable AutoCloseable hook) throws SQLException {
            if (rs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rs", "com/intellij/dbm/generic/meta/ClosableIt$ResultSetDelegateIt", "<init>"));
            }
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/dbm/generic/meta/ClosableIt$ResultSetDelegateIt", "<init>"));
            }
            this(MetaDataUtil.ResultSetWrapper.wrap(rs), handler, hook, null);
        }

        public ResultSetDelegateIt(@NotNull MetaDataUtil.ResultSetWrapper rs, @NotNull ErrorHandler handler, @Nullable AutoCloseable hook, @Nullable Boolean initialHasNext) throws SQLException {
            if (rs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rs", "com/intellij/dbm/generic/meta/ClosableIt$ResultSetDelegateIt", "<init>"));
            }
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/dbm/generic/meta/ClosableIt$ResultSetDelegateIt", "<init>"));
            }
            this.myRs = rs;
            this.myErrorHandler = handler;
            this.myHook = hook;
            this.myInitialHasNext = initialHasNext;
        }

        @Override
        public void close() {
            try {
                MetaDataUtil.ResultSetWrapper.close(this.myRs);
            }
            finally {
                if (this.myHook != null) {
                    try {
                        this.myHook.close();
                    }
                    catch (Exception e) {
                        this.myErrorHandler.addError(null, (Throwable)e);
                    }
                }
            }
        }

        protected T nextImpl() {
            try {
                if (this.myInitialHasNext != null) {
                    boolean hasNext = this.myInitialHasNext;
                    this.myInitialHasNext = null;
                    return (T)(hasNext ? this.calcValue() : this.stop());
                }
                if (this.myRs.next()) {
                    return this.calcValue();
                }
            }
            catch (SQLException e) {
                this.onError(null, e);
            }
            return (T)this.stop();
        }

        protected abstract T calcValue() throws SQLException;

        public void onError(T cur, SQLException e) {
            this.myErrorHandler.addError(null, (Throwable)e);
        }
    }

    static class AutoCloseableGuard<T extends AutoCloseable>
    implements AutoCloseable {
        private final Logger LOG = Logger.getInstance(AutoCloseableGuard.class);
        private T myStored;

        public AutoCloseableGuard(@Nullable T stored) {
            this.myStored = stored;
        }

        @Override
        public void close() {
            if (this.myStored == null) {
                return;
            }
            try {
                this.myStored.close();
            }
            catch (Exception e) {
                this.LOG.warn((Throwable)e);
            }
        }

        public T get() {
            return this.myStored;
        }

        public T release() {
            T stored = this.myStored;
            this.myStored = null;
            return stored;
        }
    }

    static abstract class ResultSetClosableIt<T>
    extends ResultSetDelegateIt<T> {
        private MutableStorage<T> myStorage;

        public ResultSetClosableIt(@NotNull ResultSet rs, @NotNull ErrorHandler handler) throws SQLException {
            if (rs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rs", "com/intellij/dbm/generic/meta/ClosableIt$ResultSetClosableIt", "<init>"));
            }
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/dbm/generic/meta/ClosableIt$ResultSetClosableIt", "<init>"));
            }
            super(rs, handler, null);
        }

        public ResultSetClosableIt(@NotNull MetaDataUtil.ResultSetWrapper rs, @NotNull ErrorHandler handler, @Nullable Boolean initialHasNext) throws SQLException {
            if (rs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rs", "com/intellij/dbm/generic/meta/ClosableIt$ResultSetClosableIt", "<init>"));
            }
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/dbm/generic/meta/ClosableIt$ResultSetClosableIt", "<init>"));
            }
            super(rs, handler, null, initialHasNext);
        }

        private MutableStorage<T> getStorage() {
            if (this.myStorage == null) {
                this.myStorage = new MutableStorage<T>(this.createStorage(), this.createStorage());
            }
            return this.myStorage;
        }

        @NotNull
        protected T getStorageToFill() {
            T t = this.getStorage().current();
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/ClosableIt$ResultSetClosableIt", "getStorageToFill"));
            }
            return t;
        }

        @NotNull
        protected abstract T createStorage();

        protected void currentChanged() {
            this.getStorage().flip();
        }
    }

    static abstract class DelegateIt<E, T>
    extends ClosableIt<T> {
        private final Iterator<? extends E> myIt;

        public DelegateIt(Iterator<? extends E> it) {
            this.myIt = it;
        }

        @Override
        public void close() {
            if (this.myIt instanceof ClosableIt) {
                ((ClosableIt)((Object)this.myIt)).close();
            }
        }

        protected T nextImpl() {
            if (!this.myIt.hasNext()) {
                return (T)this.stop();
            }
            return this.calcValue(this.myIt.next());
        }

        protected abstract T calcValue(E var1);
    }

    static abstract class DelegateMutableIt<E, T>
    extends DelegateIt<E, T> {
        private MutableStorage<T> myStorage;

        public DelegateMutableIt(Iterator<? extends E> it) {
            super(it);
        }

        private MutableStorage<T> getStorage() {
            if (this.myStorage == null) {
                this.myStorage = new MutableStorage<T>(this.createStorage(), this.createStorage());
            }
            return this.myStorage;
        }

        @NotNull
        protected T getStorageToFill() {
            T t = this.getStorage().current();
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/ClosableIt$DelegateMutableIt", "getStorageToFill"));
            }
            return t;
        }

        @NotNull
        protected abstract T createStorage();

        protected void currentChanged() {
            this.getStorage().flip();
        }
    }

    static class MutableStorage<T> {
        private T myCurStorage;
        private T myBackStorage;

        public MutableStorage(T curStorage, T backStorage) {
            this.myCurStorage = curStorage;
            this.myBackStorage = backStorage;
        }

        @NotNull
        protected T current() {
            T t = this.myBackStorage;
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/ClosableIt$MutableStorage", "current"));
            }
            return t;
        }

        protected void flip() {
            T tmp = this.myCurStorage;
            this.myCurStorage = this.myBackStorage;
            this.myBackStorage = tmp;
        }
    }

    static abstract class LazyAppendableClosableIt<T>
    extends ClosableIt<T> {
        private ClosableIt<? extends T> myIt;

        public LazyAppendableClosableIt(@Nullable ClosableIt<? extends T> init) {
            this.myIt = init;
        }

        @Override
        public void close() {
            if (this.myIt != null) {
                this.myIt.close();
            }
        }

        @Nullable
        protected abstract ClosableIt<? extends T> nextIt();

        protected T nextImpl() {
            if (this.myIt != null && this.myIt.hasNext()) {
                return (T)this.myIt.next();
            }
            if (this.myIt != null) {
                this.myIt.close();
                this.myIt = null;
            }
            do {
                this.myIt = this.nextIt();
            } while (this.myIt != null && !this.myIt.hasNext());
            return (T)(this.myIt == null ? this.stop() : this.myIt.next());
        }
    }
}

