/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.mssql;

import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.dbm.common.DbmMajor;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.mssql.MsDatabase;
import com.intellij.dbm.mssql.MsType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MsIntrospectorUtils {
    private static final Pattern MuffledWords = Pattern.compile("\\(\\d+(\\.\\d+)?\\)", 2);

    @Nullable
    static String normalizePredicateExpression(@Nullable String expression) {
        return MsIntrospectorUtils.normalizeExpression(expression);
    }

    @Contract(pure=true)
    @Nullable
    static String normalizeExpression(@Nullable String expression) {
        if (expression == null || expression.length() == 0) {
            return null;
        }
        String exp = expression.trim();
        if (exp.length() == 0) {
            return null;
        }
        int n = exp.length();
        if (n > 2 && exp.charAt(0) == '(' && exp.charAt(n - 1) == ')') {
            exp = exp.substring(1, n - 1).trim();
            n = exp.length();
        }
        Matcher m = MuffledWords.matcher(exp);
        while (exp.length() >= 3 && m.find()) {
            int p1 = m.start();
            int p2 = m.end();
            exp = (exp.substring(0, p1) + exp.substring(p1 + 1, p2 - 1) + exp.substring(p2)).trim();
            m = MuffledWords.matcher(exp);
        }
        return exp;
    }

    @NotNull
    static <T extends MsType> T renewType(MsDatabase db, Family<?> family, int typeId, String name) {
        MsType type = db.getTypeById(typeId);
        if (type != null && type.getParentFamily() == family) {
            DbmMajor typeObject = (DbmMajor)((Object)type);
            typeObject.setName(name);
            typeObject.resetSyncPending();
            MsType msType = type;
            if (msType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mssql/MsIntrospectorUtils", "renewType"));
            }
            return (T)msType;
        }
        BasicNamedElement typeObject = family.get(name);
        if (typeObject != null && typeObject instanceof MsType && ((MsType)((Object)typeObject)).getTypeId() == 0) {
            ((MsType)((Object)typeObject)).setTypeId(typeId);
            ((DbmObject)typeObject).setName(name);
            typeObject.resetSyncPending();
            MsType msType = (MsType)((Object)typeObject);
            if (msType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mssql/MsIntrospectorUtils", "renewType"));
            }
            return (T)msType;
        }
        typeObject = family.create(name);
        ((MsType)((Object)typeObject)).setTypeId(typeId);
        MsType msType = (MsType)((Object)typeObject);
        if (msType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mssql/MsIntrospectorUtils", "renewType"));
        }
        return (T)msType;
    }
}

