/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.oracle;

import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.DbmUserDefinedType;
import com.intellij.dbm.common.SchemaObjectRef;
import com.intellij.dbm.common.StateProperty;
import com.intellij.dbm.oracle.OraModule;
import com.intellij.dbm.oracle.OraSchema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraObjectType
extends OraModule
implements DbmUserDefinedType {
    @StateProperty
    public final SchemaObjectRef<OraObjectType> superObject;
    @StateProperty
    public boolean myIncomplete;
    @StateProperty
    public boolean myFinal;
    @StateProperty
    public boolean myInstantiable;

    public OraObjectType(@NotNull OraSchema schema, @Nullable String name) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/oracle/OraObjectType", "<init>"));
        }
        super(schema, name);
        this.superObject = new SchemaObjectRef((DbmModel)schema.getModel(), ObjectKind.OBJECT_TYPE);
    }

    @Override
    @NotNull
    public final ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.OBJECT_TYPE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraObjectType", "getKind"));
        }
        return objectKind;
    }

    public boolean isIncomplete() {
        return this.myIncomplete;
    }

    public void setIncomplete(boolean incomplete) {
        if (this.myIncomplete == incomplete) {
            return;
        }
        this.modifying();
        this.myIncomplete = incomplete;
    }

    public boolean isFinal() {
        return this.myFinal;
    }

    public void setFinal(boolean itIsFinal) {
        if (this.myFinal == itIsFinal) {
            return;
        }
        this.modifying();
        this.myFinal = itIsFinal;
    }

    public boolean isInstantiable() {
        return this.myInstantiable;
    }

    public void setInstantiable(boolean instantiable) {
        if (this.myInstantiable == instantiable) {
            return;
        }
        this.modifying();
        this.myInstantiable = instantiable;
    }
}

