/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.postgres;

import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.DbmTable;
import com.intellij.dbm.common.DbmTrigger;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.StateProperty;
import com.intellij.dbm.postgres.PostgresLikeTable;
import com.intellij.dbm.postgres.PostgresRule;
import com.intellij.dbm.postgres.PostgresTrigger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostgresTable
extends DbmTable
implements PostgresLikeTable {
    private final Family<PostgresRule> myRules;
    @StateProperty
    public boolean myWithOids;

    public PostgresTable(@NotNull DbmSchema schema, @Nullable String name) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/postgres/PostgresTable", "<init>"));
        }
        super(schema, name);
        this.myRules = Family.of(this, ObjectKind.RULE);
        this.assignFamilies(this.myColumns, this.myIndices, this.myKeys, this.myForeignKeys, this.myChecks, this.myRules, this.myTriggers);
    }

    @Override
    @NotNull
    public Family<PostgresRule> getRules() {
        Family<PostgresRule> family = this.myRules;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/postgres/PostgresTable", "getRules"));
        }
        return family;
    }

    @Override
    @NotNull
    public Family<PostgresTrigger> getTriggers() {
        Family<? extends DbmTrigger> family = super.getTriggers();
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/postgres/PostgresTable", "getTriggers"));
        }
        return family;
    }

    public boolean isWithOids() {
        return this.myWithOids;
    }

    public void setWithOids(boolean withOids) {
        if (this.myWithOids == withOids) {
            return;
        }
        this.modifying();
        this.myWithOids = withOids;
    }
}

