/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.serialization;

import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.serialization.DbmModelMem;
import com.intellij.dbm.serialization.DbmObjectMem;
import com.intellij.dbm.serialization.DbmObjectMemBuilder;
import com.intellij.dbm.serialization.DbmVersions;
import com.intellij.dbm.serialization.NameAndValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.util.Version;

final class DbmConverters {
    DbmConverters() {
    }

    DbmModelMem convertMem(@NotNull DbmModelMem modelMem) {
        if (modelMem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelMem", "com/intellij/dbm/serialization/DbmConverters", "convertMem"));
        }
        Version ver = modelMem.version;
        if (ver.isOrGreater(DbmVersions.CURRENT_VERSION)) {
            return modelMem;
        }
        DbmModelMem mm = modelMem;
        if (ver.less(new int[]{2, 7})) {
            mm = new Converter_2_7().convert(modelMem);
        }
        return mm;
    }

    @Nullable
    static DbmObjectMem findFirst(@NotNull DbmModelMem mm, @NotNull Predicate<DbmObjectMem> predicate) {
        if (mm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mm", "com/intellij/dbm/serialization/DbmConverters", "findFirst"));
        }
        if (predicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "com/intellij/dbm/serialization/DbmConverters", "findFirst"));
        }
        for (DbmObjectMem node : mm.nodes) {
            if (!predicate.test(node)) continue;
            return node;
        }
        return null;
    }

    @Nullable
    static String getProperty(@NotNull DbmObjectMem node, @NotNull String propertyName) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dbm/serialization/DbmConverters", "getProperty"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/dbm/serialization/DbmConverters", "getProperty"));
        }
        for (NameAndValue<String> p : node.properties) {
            if (!p.name.equals(propertyName)) continue;
            return (String)p.value;
        }
        return null;
    }

    static class Converter_2_7
    implements Converter {
        Converter_2_7() {
        }

        @Override
        @NotNull
        public DbmModelMem convert(@NotNull DbmModelMem mm) {
            DbmModelMem newModelMem;
            if (mm == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mm", "com/intellij/dbm/serialization/DbmConverters$Converter_2_7", "convert"));
            }
            DbmObjectMem root = DbmConverters.findFirst(mm, m -> m.kind.equals(ObjectKind.ROOT.code()));
            if (root == null) {
                root = new DbmObjectMem(-1, null, ObjectKind.ROOT.code(), null, Collections.emptyList());
            }
            List<DbmObjectMem> nodes2 = mm.nodes;
            int n = nodes2.size();
            ArrayList<DbmObjectMem> newNodes = new ArrayList<DbmObjectMem>(n + 1);
            newNodes.add(root);
            for (DbmObjectMem node : nodes2) {
                if (node == root) continue;
                if (node.parentId == null) {
                    node = new DbmObjectMem(node.id, root.id, node.kind, node.name, node.properties);
                } else if (node.kind.equals("trigger") && mm.rdbms == Postgres.RDBMS) {
                    DbmObjectMemBuilder b = new DbmObjectMemBuilder(node);
                    String subKind = b.excludeProperty("sub-kind");
                    if (subKind != null && subKind.startsWith("R")) {
                        b.kind = "rule";
                    }
                    node = b.build();
                }
                newNodes.add(node);
            }
            DbmModelMem dbmModelMem = newModelMem = new DbmModelMem(mm.rdbms, newNodes, mm.properties, DbmVersions.CURRENT_VERSION);
            if (dbmModelMem == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/serialization/DbmConverters$Converter_2_7", "convert"));
            }
            return dbmModelMem;
        }
    }

    static interface Converter {
        @NotNull
        public DbmModelMem convert(@NotNull DbmModelMem var1);
    }
}

