/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.serialization;

import com.intellij.database.model.DasModel;
import com.intellij.database.model.ModelSerializer;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.serialization.DbmExporter;
import com.intellij.dbm.serialization.DbmImporter;
import com.intellij.dbm.serialization.DbmModelMem;
import com.intellij.dbm.serialization.FixHierarchicalStreamReader;
import com.intellij.dbm.serialization.FixHierarchicalStreamWriter;
import com.intellij.dbm.serialization.ImportException;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/dbm/serialization/DbmSerializer;", "Lcom/intellij/database/model/ModelSerializer;", "()V", "myExporter", "Lcom/intellij/dbm/serialization/DbmExporter;", "myImporter", "Lcom/intellij/dbm/serialization/DbmImporter;", "canSerialize", "", "model", "Lcom/intellij/database/model/DasModel;", "deserialize", "Lcom/intellij/dbm/common/DbmModel;", "reader", "Lcom/thoughtworks/xstream/io/HierarchicalStreamReader;", "serialize", "", "writer", "Lcom/thoughtworks/xstream/io/HierarchicalStreamWriter;", "database-introspection"})
public final class DbmSerializer
implements ModelSerializer {
    private final DbmExporter myExporter = new DbmExporter();
    private final DbmImporter myImporter = new DbmImporter();

    @NotNull
    public DbmModel<?, ?> deserialize(@NotNull HierarchicalStreamReader reader) throws ImportException {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        DbmModelMem modelMem = this.myImporter.deserializeModel(new FixHierarchicalStreamReader(reader));
        DbmModel dbmModel = this.myImporter.buildModel(modelMem);
        Intrinsics.checkExpressionValueIsNotNull((Object)dbmModel, (String)"myImporter.buildModel(modelMem)");
        return dbmModel;
    }

    public boolean canSerialize(@NotNull DasModel model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        return model instanceof DbmModel;
    }

    public void serialize(@NotNull DasModel model, @NotNull HierarchicalStreamWriter writer) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        DasModel dasModel = model;
        if (dasModel == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.dbm.common.DbmModel<*, *>");
        }
        this.myExporter.writeModel((DbmModel)dasModel, new FixHierarchicalStreamWriter(writer));
    }
}

