/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import icons.DatabaseIcons;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDataSourceImpl
extends SimpleModificationTracker
implements SqlDataSource,
PersistentStateComponent<State>,
Iconable,
ModificationTracker {
    private final Project myProject;
    private String myName;
    private String myUniqueID;
    private String myParentID;
    private String myComment;
    private String[] myUrls;
    private Disposable myDisposable;
    private VirtualFilePointerContainer myContainer;

    public SqlDataSourceImpl(@Nullable String name, @NotNull Project project, @Nullable DatabaseSystem parent) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/database/SqlDataSourceImpl", "<init>"));
        }
        this.myUrls = ArrayUtil.EMPTY_STRING_ARRAY;
        this.myName = name;
        this.myProject = project;
        this.myParentID = parent == null ? null : parent.getUniqueId();
    }

    public void init() {
        if (this.myUniqueID == null) {
            this.myUniqueID = UUID.randomUUID().toString();
        }
    }

    @Nullable
    public RawConnectionConfig getConnectionConfig() {
        return null;
    }

    public String getName() {
        return this.myName;
    }

    public String getUniqueId() {
        return this.myUniqueID;
    }

    @Nullable
    public String getComment() {
        return this.myComment;
    }

    public void setComment(@Nullable String comment) {
        this.myComment = comment;
    }

    public String getDatabaseProductName() {
        DbDataSource parent = this.getParentDataSource();
        return parent != null ? parent.getDatabaseProductName() : null;
    }

    public String getDatabaseProductVersion() {
        DbDataSource parent = this.getParentDataSource();
        return parent != null ? parent.getDatabaseProductVersion() : null;
    }

    public void setName(String name) {
        this.myName = name;
    }

    @NotNull
    public List<String> getUrls() {
        List<String> list = Arrays.asList(this.myContainer != null ? this.myContainer.getUrls() : this.myUrls);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlDataSourceImpl", "getUrls"));
        }
        return list;
    }

    public List<VirtualFile> getFiles() {
        return Arrays.asList(this.myContainer != null ? this.myContainer.getFiles() : VirtualFile.EMPTY_ARRAY);
    }

    public void setUrls(@NotNull List<String> urls) {
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "com/intellij/sql/database/SqlDataSourceImpl", "setUrls"));
        }
        this.incModificationCount();
        this.myUrls = ArrayUtil.toStringArray(urls);
        if (this.myContainer != null) {
            this.myContainer.clear();
            for (String url : urls) {
                this.myContainer.add(url);
            }
        }
    }

    public void setParent(DatabaseSystem parent) {
        this.myParentID = parent == null ? null : parent.getUniqueId();
    }

    @NotNull
    public JBIterable<SqlFile> getSqlFiles() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        JBIterable jBIterable = JBIterable.of((Object[])this.myContainer.getFiles()).transform(file -> (SqlFile)ObjectUtils.tryCast((Object)psiManager.findFile(file), SqlFile.class)).filter(Condition.NOT_NULL);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlDataSourceImpl", "getSqlFiles"));
        }
        return jBIterable;
    }

    @NotNull
    private JBIterable<DasObject> getModelRootsImpl(@Nullable DbDataSource parentDataSource) {
        JBIterable result = JBIterable.empty();
        if (this.myContainer == null) {
            JBIterable jBIterable = result;
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlDataSourceImpl", "getModelRootsImpl"));
            }
            return jBIterable;
        }
        if (parentDataSource != null) {
            result = result.append((Iterable)parentDataSource.getModel().getModelRoots());
        }
        for (SqlFile file : this.getSqlFiles()) {
            result = result.append((Iterable)file.getModelRoots());
        }
        JBIterable jBIterable = result;
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlDataSourceImpl", "getModelRootsImpl"));
        }
        return jBIterable;
    }

    @NotNull
    public DasModel getModel() {
        final DbDataSource parentDataSource = this.getParentDataSource();
        DasModel dasModel = new DasModel(){

            @NotNull
            public JBIterable<? extends DasObject> getModelRoots() {
                JBIterable jBIterable = SqlDataSourceImpl.this.getModelRootsImpl(parentDataSource);
                if (jBIterable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlDataSourceImpl$1", "getModelRoots"));
                }
                return jBIterable;
            }

            @Nullable
            public DasNamespace getCurrentRootNamespace() {
                return null;
            }

            @NotNull
            public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
                if (kind == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/database/SqlDataSourceImpl$1", "getCasing"));
                }
                if (context instanceof SqlElement) {
                    SqlElement e = (SqlElement)context;
                    Casing casing = SqlImplUtil.getSqlDialectSafe((PsiElement)e).getCasing(kind, context);
                    if (casing == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlDataSourceImpl$1", "getCasing"));
                    }
                    return casing;
                }
                if (parentDataSource != null) {
                    parentDataSource.getModel().getCasing(kind, context);
                }
                Casing casing = ((DatabaseDialectEx)ObjectUtils.notNull((Object)SqlDataSourceImpl.this.getDatabaseDialect(), (Object)GenericDialect.INSTANCE)).getCasing(kind, context);
                if (casing == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlDataSourceImpl$1", "getCasing"));
                }
                return casing;
            }

            @NotNull
            public JBTreeTraverser<DasObject> traverser() {
                JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)DasUtil.dasTraverser().withRoots((Iterable)SqlDataSourceImpl.this.getModelRootsImpl(parentDataSource));
                if (jBTreeTraverser == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlDataSourceImpl$1", "traverser"));
                }
                return jBTreeTraverser;
            }

            @NotNull
            public JBIterable<? extends DasConstraint> getExportedKeys(DasTable table) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlDataSourceImpl$1", "getExportedKeys"));
                }
                return jBIterable;
            }
        };
        if (dasModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlDataSourceImpl", "getModel"));
        }
        return dasModel;
    }

    @Nullable
    public DbDataSource getParentDataSource() {
        return this.myParentID == null ? null : DbPsiFacade.getInstance((Project)this.myProject).findDataSource(this.myParentID);
    }

    public String getParentID() {
        return this.myParentID;
    }

    public SqlDataSourceImpl copy() {
        SqlDataSourceImpl result = new SqlDataSourceImpl(this.myName, this.myProject, null);
        result.myParentID = this.myParentID;
        result.myUrls = ArrayUtil.toStringArray(this.getUrls());
        return result;
    }

    public State getState() {
        State state = new State();
        state.id = this.myUniqueID;
        state.name = this.myName;
        state.parent = this.myParentID;
        state.urls = ArrayUtil.toStringArray(this.getUrls());
        return state;
    }

    public void loadState(State state) {
        this.myUniqueID = state.id;
        this.myName = state.name;
        this.myUrls = state.urls != null ? state.urls : ArrayUtil.EMPTY_STRING_ARRAY;
        this.myParentID = state.parent;
        this.myDisposable = null;
        this.myContainer = null;
    }

    void dropFilePointers() {
        if (this.myDisposable != null) {
            this.myUrls = this.myContainer.getUrls();
            Disposer.dispose((Disposable)this.myDisposable);
            this.myDisposable = null;
            this.myContainer = null;
        }
    }

    void initFilePointers() {
        assert (this.myDisposable == null);
        this.myDisposable = Disposer.newDisposable();
        Disposer.register((Disposable)this.myProject, (Disposable)this.myDisposable);
        this.myContainer = VirtualFilePointerManager.getInstance().createContainer(this.myDisposable);
        for (String url : this.myUrls) {
            this.myContainer.add(url);
        }
    }

    public void setFiles(VirtualFile[] virtualFiles) {
        this.incModificationCount();
        if (this.myContainer != null) {
            this.myContainer.clear();
        }
        this.myUrls = new String[virtualFiles.length];
        for (int i = 0; i < virtualFiles.length; ++i) {
            this.myUrls[i] = virtualFiles[i].getUrl();
            if (this.myContainer == null) continue;
            this.myContainer.add(virtualFiles[i]);
        }
    }

    @Nullable
    public DatabaseDialectEx getDatabaseDialect() {
        DatabaseDialectEx result = null;
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (VirtualFile file : this.getFiles()) {
            PsiFile psiFile = psiManager.findFile(file);
            if (!(psiFile instanceof SqlFile)) continue;
            result = (DatabaseDialectEx)((SqlFile)psiFile).getSqlLanguage().getDatabaseDialect();
            break;
        }
        if (result == null) {
            DbDataSource parent = this.getParentDataSource();
            result = parent == null ? null : DbImplUtil.getDatabaseDialect((DbElement)parent);
        }
        return result;
    }

    public Icon getIcon(int flags) {
        return DatabaseIcons.DdlDbms;
    }

    public long getModificationCount() {
        long result = super.getModificationCount();
        for (VirtualFile file : this.getFiles()) {
            result += file.getModificationCount();
        }
        return result;
    }

    public boolean equalConfiguration(@NotNull SqlDataSourceImpl o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/database/SqlDataSourceImpl", "equalConfiguration"));
        }
        if (!StringUtil.equals((CharSequence)this.myParentID, (CharSequence)o.myParentID)) {
            return false;
        }
        return this.getUrls().equals(o.getUrls());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SqlDataSourceImpl that = (SqlDataSourceImpl)((Object)o);
        return !(this.myUniqueID != null ? !this.myUniqueID.equals(that.myUniqueID) : that.myUniqueID != null);
    }

    public int hashCode() {
        return this.myUniqueID != null ? this.myUniqueID.hashCode() : 0;
    }

    public static class State {
        public String id;
        public String name;
        public String parent;
        public String[] urls;
    }
}

