/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlImportState;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternUtils;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlUseDatabaseStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDialectImplUtil {
    public static final Logger LOG = Logger.getInstance((String)"com.intellij.sql.dialects.DialectSupport");

    private SqlDialectImplUtil() {
    }

    @NotNull
    public static String getDialectHelpResource(Class dialectClass, @NonNls String name) throws IOException {
        String text;
        String resourceName = null;
        InputStream zipIs = null;
        for (Class c = dialectClass; c != null; c = c.getSuperclass()) {
            String specificResourceName = "help/" + SqlDialectImplUtil.getSqlDialectName(c) + "-help.zip";
            zipIs = c.getClassLoader().getResourceAsStream(specificResourceName);
            String string = resourceName = zipIs != null || resourceName == null ? specificResourceName : resourceName;
            if (zipIs != null) break;
        }
        if (zipIs == null) {
            throw new IOException(SqlMessages.message("help.file.0.not.found", resourceName));
        }
        try {
            text = SqlDialectImplUtil.loadFileFromZip(zipIs, name);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            throw new IOException(SqlMessages.message("help.file.0.not.found", name) + "\n" + e.getMessage(), e);
        }
        if (text == null) {
            throw new IOException(SqlMessages.message("help.file.0.not.found", resourceName + "!/" + name));
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlDialectImplUtil", "getDialectHelpResource"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String loadFileFromZip(InputStream stream, @NonNls String fileName) throws IOException {
        if (stream == null) {
            return null;
        }
        try (ZipInputStream zip = new ZipInputStream(stream);){
            ZipEntry zipEntry = zip.getNextEntry();
            while (zipEntry != null) {
                if (zipEntry.getName().equalsIgnoreCase(fileName)) {
                    String string = new String(FileUtil.adaptiveLoadText((Reader)new InputStreamReader(zip)));
                    return string;
                }
                zipEntry = zip.getNextEntry();
            }
        }
        return null;
    }

    public static Set<String> getAllKeywordsFromDefinition(Collection<SqlFunctionDefinition> definitions, Set<String> keywords) {
        for (SqlFunctionDefinition definition : definitions) {
            for (SqlFunctionDefinition.Prototype prototype : definition.getPrototypes()) {
                SqlDialectImplUtil.getAllKeywordsFromDefinition(prototype, keywords);
            }
        }
        return keywords;
    }

    public static void getAllKeywordsFromDefinition(SqlFunctionDefinition.ParameterBlock block, Set<String> keywords) {
        for (SqlFunctionDefinition.Parameter parameter : block.getParams()) {
            if (parameter instanceof SqlFunctionDefinition.Keyword) {
                keywords.add(((SqlFunctionDefinition.Keyword)parameter).getName());
                continue;
            }
            if (!(parameter instanceof SqlFunctionDefinition.ParameterBlock)) continue;
            SqlDialectImplUtil.getAllKeywordsFromDefinition((SqlFunctionDefinition.ParameterBlock)parameter, keywords);
        }
    }

    @NotNull
    private static String getSqlDialectName(@NotNull Class<?> dialectClass) {
        if (dialectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialectClass", "com/intellij/sql/dialects/SqlDialectImplUtil", "getSqlDialectName"));
        }
        String className = dialectClass.getName();
        int endIndex = className.indexOf("Dialect");
        String string = className.substring(className.lastIndexOf(46) + 1, endIndex > -1 ? endIndex : className.length()).toLowerCase(Locale.ENGLISH);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlDialectImplUtil", "getSqlDialectName"));
        }
        return string;
    }

    @NotNull
    public static Map<String, DasObject> buildEntities(@NotNull ObjectKind kind, String ... names) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/dialects/SqlDialectImplUtil", "buildEntities"));
        }
        LinkedHashMap result = ContainerUtil.newLinkedHashMap();
        for (String name : names) {
            result.put(name, new ReservedEntity(name, kind));
        }
        LinkedHashMap linkedHashMap = result;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlDialectImplUtil", "buildEntities"));
        }
        return linkedHashMap;
    }

    public static boolean checkImports(@NotNull SqlImportState checker, DbDataSource dataSource, DasObject object) {
        if (checker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checker", "com/intellij/sql/dialects/SqlDialectImplUtil", "checkImports"));
        }
        return checker.isImported(dataSource, SqlDialectImplUtil.trace(object));
    }

    @NotNull
    public static SqlImportState getImportCheckerAt(SqlFile sqlFile, @Nullable PsiElement place) {
        SqlImportState sqlImportState = SqlDialectImplUtil.getNearestImportState(place, SqlDialectImplUtil.buildImports(sqlFile));
        if (sqlImportState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlDialectImplUtil", "getImportCheckerAt"));
        }
        return sqlImportState;
    }

    @NotNull
    public static SqlImportState getNearestImportState(PsiElement place, SqlImportState state) {
        PsiElement p;
        if (state.prevState == null) {
            SqlImportState sqlImportState = state;
            if (sqlImportState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlDialectImplUtil", "getNearestImportState"));
            }
            return sqlImportState;
        }
        for (p = place; p != null; p = p.getContext()) {
            if (p instanceof DummyHolder) continue;
            if (p instanceof StubBasedPsiElement && ((StubBasedPsiElement)p).getStub() != null || p instanceof PsiFileWithStubSupport && ((PsiFileWithStubSupport)p).getStubTree() != null) break;
            if (!(p instanceof PsiFile)) continue;
            p = null;
            break;
        }
        if (p == null) {
            p = place;
        }
        while (state.prevState != null) {
            if (SqlDialectImplUtil.placeBefore(state.element, p)) {
                SqlImportState sqlImportState = state;
                if (sqlImportState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlDialectImplUtil", "getNearestImportState"));
                }
                return sqlImportState;
            }
            state = state.prevState;
        }
        SqlImportState sqlImportState = state;
        if (sqlImportState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlDialectImplUtil", "getNearestImportState"));
        }
        return sqlImportState;
    }

    public static boolean placeBefore(PsiElement p1, PsiElement p2) {
        if (p1 == null || p2 == null) {
            return true;
        }
        if (p1 instanceof StubBasedPsiElement && p2 instanceof StubBasedPsiElement) {
            StubElement s1 = ((StubBasedPsiElement)p1).getStub();
            StubElement s2 = ((StubBasedPsiElement)p2).getStub();
            if (s1 != null && s2 != null) {
                StubElement e;
                ArrayList<StubElement> parents1 = new ArrayList<StubElement>();
                for (e = s1; e != null; e = e.getParentStub()) {
                    parents1.add(e);
                }
                StubElement prevE = null;
                for (e = s2; e != null; e = e.getParentStub()) {
                    if (e == s1) {
                        return true;
                    }
                    int idx = parents1.indexOf(e);
                    if (idx != -1) {
                        if (idx == 0 || prevE == null) {
                            return true;
                        }
                        StubElement prev1 = (StubElement)parents1.get(idx - 1);
                        for (StubElement element : e.getChildrenStubs()) {
                            if (element == prev1) {
                                return true;
                            }
                            if (element != prevE) continue;
                            return false;
                        }
                        throw new AssertionError();
                    }
                    prevE = e;
                }
            }
        }
        return p1.getTextRange().getStartOffset() < p2.getTextRange().getStartOffset();
    }

    @Nullable
    public static String getUserName(@Nullable RawConnectionConfig config) {
        if (config == null) {
            return null;
        }
        Credentials credentials = DatabaseCredentials.getInstance().getCredentials((DatabaseSystem)config);
        return credentials == null ? null : StringUtil.nullize((String)credentials.getUserName());
    }

    @Nullable
    public static JdbcUrlParser getParsed(@Nullable RawConnectionConfig config) {
        if (config == null) {
            return null;
        }
        JdbcUrlParser statefull = JdbcUrlParserUtil.statefull(JdbcUrlParserUtil.select(config));
        if (statefull != null) {
            statefull.setUrlText(config.getUrl());
            return statefull;
        }
        return null;
    }

    @Nullable
    public static String getDatabaseName(@Nullable RawConnectionConfig config) {
        JdbcUrlParser statefull = SqlDialectImplUtil.getParsed(config);
        return statefull != null ? StringUtil.nullize((String)statefull.getParameter("database")) : null;
    }

    @NotNull
    public static SqlImportState buildImports(SqlFile sqlFile) {
        SqlImportState sqlImportState = (SqlImportState)CachedValuesManager.getCachedValue((PsiElement)sqlFile, () -> new CachedValueProvider.Result((Object)SqlDialectImplUtil.calcImports(sqlFile), new Object[]{sqlFile, DbPsiFacade.getInstance((Project)sqlFile.getProject())}));
        if (sqlImportState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlDialectImplUtil", "buildImports"));
        }
        return sqlImportState;
    }

    @Nullable
    public static TreePattern buildOverlayPattern(SqlFile sqlFile) {
        return (TreePattern)CachedValuesManager.getCachedValue((PsiElement)sqlFile, () -> new CachedValueProvider.Result((Object)SqlDialectImplUtil.calcOverlayPattern(sqlFile), new Object[]{sqlFile, DbPsiFacade.getInstance((Project)sqlFile.getProject())}));
    }

    @Contract(value="null,null->null")
    public static TreePattern createObjectPattern(@Nullable DbDataSource dataSource, @Nullable DasObject object) {
        if (object == null && dataSource == null) {
            return null;
        }
        List kinds = ContainerUtil.newSmartList();
        List names = ContainerUtil.newSmartList();
        SqlImportState.getTrace(dataSource, SqlDialectImplUtil.trace(object), kinds, names);
        return SqlImportUtil.createPattern(names, kinds);
    }

    protected static TreePattern calcOverlayPattern(SqlFile sqlFile) {
        return TreePatternUtils.union((Iterable<TreePattern>)JBIterable.from(DatabaseEditorHelper.getSearchPath((PsiFile)sqlFile)).filter(DbElement.class).transform(n -> SqlDialectImplUtil.createObjectPattern(n.getDataSource(), (DasObject)n)));
    }

    @NotNull
    protected static SqlImportState calcImports(SqlFile sqlFile) {
        SqlImportState.Shared shared = new SqlImportState.Shared(sqlFile, SqlDialectImplUtil.buildOverlayPattern(sqlFile));
        SqlImportState current = new SqlImportState(null, shared, SqlDialectImplUtil.calcInitialImportState(sqlFile), null);
        SqlLanguageDialectEx language = (SqlLanguageDialectEx)sqlFile.getSqlLanguage();
        for (SqlUseDatabaseStatement statement : JBIterable.from((Iterable)sqlFile.getDdl()).filter(SqlUseDatabaseStatement.class)) {
            current = new SqlImportState((PsiElement)statement, shared, language.processImports(statement, current.state), current);
        }
        SqlImportState sqlImportState = current;
        if (sqlImportState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlDialectImplUtil", "calcImports"));
        }
        return sqlImportState;
    }

    @NotNull
    private static TreePattern calcInitialImportState(@NotNull SqlFile sqlFile) {
        if (sqlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sqlFile", "com/intellij/sql/dialects/SqlDialectImplUtil", "calcInitialImportState"));
        }
        SqlLanguageDialectEx language = (SqlLanguageDialectEx)sqlFile.getSqlLanguage();
        JBIterable dataSources = JBIterable.from(SqlImplUtil.getDataSources((PsiElement)sqlFile));
        JBIterable patterns = dataSources.transform(ds -> SqlImportUtil.createResolveScopePattern(ds, language)).append((Iterable)dataSources.transform(ds -> SqlImportUtil.createDefaultScopePattern(ds, language))).append((Object)SqlImportUtil.createDefaultScopePattern(null, language)).filter(Conditions.notNull());
        TreePattern treePattern = TreePatternUtils.union((Iterable<TreePattern>)patterns);
        if (treePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlDialectImplUtil", "calcInitialImportState"));
        }
        return treePattern;
    }

    public static Set<String> loadSystemVars(SqlLanguageDialect dialect) {
        return SqlDialectImplUtil.loadTokens(dialect, "systemVars.txt");
    }

    public static <T> JBIterable<T> staticFields(@NotNull Class<?> clazz, @NotNull Class<T> fieldC) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/sql/dialects/SqlDialectImplUtil", "staticFields"));
        }
        if (fieldC == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldC", "com/intellij/sql/dialects/SqlDialectImplUtil", "staticFields"));
        }
        return JBIterable.of((Object[])clazz.getFields()).filter(field -> {
            if (fieldC == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldC", "com/intellij/sql/dialects/SqlDialectImplUtil", "lambda$staticFields$5"));
            }
            return Modifier.isStatic(field.getModifiers()) && fieldC.isAssignableFrom(field.getType());
        }).transform(field -> {
            try {
                return field.get(null);
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }).filter(Conditions.notNull()).filter(fieldC);
    }

    public static List<ReservedEntity.Typed> loadEntities(SqlLanguageDialect dialect) {
        ArrayList result = ContainerUtil.newArrayList();
        String invalid = null;
        THashMap kindMap = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        for (Object kind : SqlDialectImplUtil.staticFields(SqlDbElementType.class, ObjectKind.class)) {
            kindMap.put(kind.name(), kind);
        }
        THashMap typeMap = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        for (SqlType type : SqlDialectImplUtil.staticFields(SqlType.class, SqlType.class)) {
            typeMap.put(type.getDisplayName(), type);
        }
        try {
            String tokens = SqlDialectImplUtil.loadDialectResource(dialect.getClass(), "simpleEntities.txt");
            if (StringUtil.isNotEmpty((String)tokens)) {
                for (String typed : tokens.split("(?m)\\n")) {
                    String[] split = typed.split(":");
                    String name = split[0].trim();
                    ObjectKind objectType = (ObjectKind)kindMap.get(split[1].trim());
                    SqlType type = (SqlType)typeMap.get(split[2].trim());
                    if (split.length != 3 || objectType == null || type == null) {
                        if (invalid != null) continue;
                        invalid = typed;
                        continue;
                    }
                    result.add(new ReservedEntity.Typed(name, objectType, type));
                }
            }
            if (invalid != null) {
                LOG.error("Invalid entity: `" + invalid + "`");
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return result;
    }

    public static Set<String> loadTokens(SqlLanguageDialect dialect, String fileName) {
        THashSet result = new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        try {
            String tokens = SqlDialectImplUtil.loadDialectResource(dialect.getClass(), fileName);
            if (StringUtil.isNotEmpty((String)tokens)) {
                Collections.addAll(result, tokens.split("(?m)\\s+"));
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return result;
    }

    public static String loadDialectResource(Class dialectClass, String name) throws IOException {
        String dialectName = dialectClass.getName();
        String packageName = dialectName.substring(0, dialectName.lastIndexOf(46) + 1).replace('.', '/');
        String xmlResource = packageName + name;
        InputStream xmlIs = dialectClass.getClassLoader().getResourceAsStream(xmlResource);
        return xmlIs == null ? "" : FileUtil.loadTextAndClose((Reader)new InputStreamReader(xmlIs));
    }

    @Nullable
    public static ObjectTracer<DasObject> trace(@Nullable DasObject element) {
        return element == null || element.getKind() == ObjectKind.NONE || element.getKind() == ObjectKind.ROOT ? null : new DasObjectTracer(element);
    }

    private static class DasObjectTracer
    extends ObjectTracer<DasObject> {
        private final DasObject myElement;

        public DasObjectTracer(@NotNull DasObject element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/SqlDialectImplUtil$DasObjectTracer", "<init>"));
            }
            this.myElement = element;
        }

        @Override
        public ObjectTracer.ObjectTraceIt<DasObject> trace() {
            return new ObjectTracer.ObjectTraceIt<DasObject>(DasUtil.dasParents((DasObject)this.myElement).filter(o -> o.getKind() != ObjectKind.ROOT).iterator()){
                private DasObject myCurrent;

                @Override
                public DasObject next() {
                    this.myCurrent = (DasObject)super.next();
                    return this.myCurrent;
                }

                @Override
                public ObjectKind getKind() {
                    return this.myCurrent.getKind();
                }

                @Override
                public String getName() {
                    return this.myCurrent.getName();
                }

                @Override
                public boolean isQuoted() {
                    SqlLanguageDialect language;
                    DatabaseDialectEx dialect = null;
                    if (this.myCurrent instanceof DbElement) {
                        if (!(((DbElement)this.myCurrent).getDelegate() instanceof SqlElement)) {
                            return true;
                        }
                        dialect = DbImplUtil.getDatabaseDialect((DbElement)this.myCurrent);
                    } else if (this.myCurrent instanceof SqlElement && (language = DbSqlUtil.getSqlDialect((PsiElement)((SqlElement)this.myCurrent))) != null) {
                        dialect = language.getDatabaseDialect();
                    }
                    return dialect == null || !SqlImplUtil.hasPlainIdentifier(this.myCurrent, dialect);
                }

                @Override
                public String getCorrectName() {
                    return this.myCurrent.getName();
                }
            };
        }

        @Override
        public ObjectKind getKind() {
            return this.myElement.getKind();
        }

        @Override
        public String getName() {
            return this.myElement.getName();
        }

        @Override
        @Nullable
        public ObjectTracer<DasObject> getParent(int steps) {
            if (steps == 0) {
                return this;
            }
            DasObject parent = this.myElement;
            for (int i = 0; i < steps && parent != null; parent = parent.getDbParent(), ++i) {
            }
            return parent == null ? null : SqlDialectImplUtil.trace(parent);
        }
    }

    public static abstract class ObjectTracer<T> {
        public abstract ObjectTraceIt<T> trace();

        public abstract ObjectKind getKind();

        public abstract String getName();

        @Nullable
        public abstract ObjectTracer<T> getParent(int var1);

        public static abstract class ObjectTraceIt<T>
        implements Iterator<T> {
            private JBIterator<? extends T> myIt;

            public ObjectTraceIt(Iterator<? extends T> it) {
                this.myIt = JBIterator.from(it);
            }

            @Override
            public boolean hasNext() {
                return this.myIt.hasNext();
            }

            @Override
            public T next() {
                return (T)this.myIt.next();
            }

            @Override
            public void remove() {
                this.myIt.remove();
            }

            public abstract ObjectKind getKind();

            public abstract String getName();

            public abstract boolean isQuoted();

            public abstract String getCorrectName();
        }
    }
}

