/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreePatternUtils {
    public static final GroupedGroupFactory UNION_PROCESSOR = new GroupedGroupFactory(){

        @Override
        protected boolean checkGroup(@NotNull Collection<TreePatternNode.Group[]> value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/sql/dialects/TreePatternUtils$1", "checkGroup"));
            }
            return true;
        }
    };
    public static final GroupedGroupFactory INTERSECTION_PROCESSOR = new GroupedGroupFactory(){

        @Override
        protected boolean checkGroup(@NotNull Collection<TreePatternNode.Group[]> value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/sql/dialects/TreePatternUtils$2", "checkGroup"));
            }
            return !value.contains(null);
        }
    };
    public static final GroupedGroupFactory MINUS_PROCESSOR = new GroupedGroupFactory(){

        @Override
        protected boolean checkGroup(@NotNull Collection<TreePatternNode.Group[]> value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/sql/dialects/TreePatternUtils$3", "checkGroup"));
            }
            Iterator<TreePatternNode.Group[]> it = value.iterator();
            if (!it.hasNext()) {
                return false;
            }
            TreePatternNode.Group[] first = it.next();
            if (first == null) {
                return false;
            }
            while (it.hasNext()) {
                TreePatternNode.Group[] g = it.next();
                if (g == null || first.length != 0 && g.length != 0) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean willDestroyEmpty(Iterable<TreePatternNode.Group[]> ggroups) {
            for (TreePatternNode.Group[] group : ggroups) {
                if (group == null || group.length != 0) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean mergeChildren() {
            return false;
        }
    };
    public static TreePatternNode.Group SKIP_PROCESSING = new TreePatternNode.Group(ObjectKind.NONE, null, null);

    @NotNull
    public static String[] toStringArray(@NotNull Collection<String> names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/sql/dialects/TreePatternUtils", "toStringArray"));
        }
        String[] stringArray = ArrayUtil.toStringArray(names);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "toStringArray"));
        }
        return stringArray;
    }

    @NotNull
    public static String[] toStringArray(@NotNull Iterable<String> names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/sql/dialects/TreePatternUtils", "toStringArray"));
        }
        List list = ContainerUtil.collect(names.iterator());
        String[] stringArray = TreePatternUtils.toStringArray(list);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "toStringArray"));
        }
        return stringArray;
    }

    public static boolean isValid(@NotNull TreePatternNode.Group g) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/sql/dialects/TreePatternUtils", "isValid"));
        }
        HashSet unique = ContainerUtil.newHashSet();
        if (g.positiveChildren != null) {
            for (TreePatternNode<TreePatternNode.PositiveNaming> child : g.positiveChildren) {
                for (ObjectName name : ((TreePatternNode.PositiveNaming)child.naming).getNames()) {
                    assert (unique.add(name)) : "Duplicate `" + name + "` " + new TreePattern(g).toString();
                }
            }
        }
        if (g.negativeChild != null) {
            List<ObjectName> anti = Arrays.asList(((TreePatternNode.NegativeNaming)g.negativeChild.naming).getAntiNames());
            assert (anti.containsAll(unique)) : "Neg. covers pos. `" + ContainerUtil.newArrayList((Iterable)unique).removeAll(anti) + "` " + new TreePattern(g).toString();
        }
        return true;
    }

    @NotNull
    public static Iterable<ObjectName> getSinkNames(@NotNull TreePatternNode.Group g) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/sql/dialects/TreePatternUtils", "getSinkNames"));
        }
        if (g.negativeChild == null) {
            JBIterable jBIterable = JBIterable.of((Object[])g.positiveChildren).flatten(c -> JBIterable.of((Object[])((TreePatternNode.PositiveNaming)c.naming).getNames()));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "getSinkNames"));
            }
            return jBIterable;
        }
        LinkedHashSet res = ContainerUtil.newLinkedHashSet((Object[])((TreePatternNode.NegativeNaming)g.negativeChild.naming).getAntiNames());
        if (g.positiveChildren != null) {
            for (TreePatternNode<TreePatternNode.PositiveNaming> child : g.positiveChildren) {
                ContainerUtil.removeAll((Collection)res, (Object[])((TreePatternNode.PositiveNaming)child.naming).getNames());
            }
        }
        LinkedHashSet linkedHashSet = res;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "getSinkNames"));
        }
        return linkedHashSet;
    }

    @NotNull
    public static TreePatternNode.NegativeNaming subdivideChildren(@NotNull Iterable<TreePatternNode.Group> groups, @NotNull MultiMap<TreePatternNode.PositiveNaming, TreePatternNode.Group[]> pSubdiv, @NotNull Collection<TreePatternNode.Group[]> nSubdiv, boolean mergeChildren) {
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/sql/dialects/TreePatternUtils", "subdivideChildren"));
        }
        if (pSubdiv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pSubdiv", "com/intellij/sql/dialects/TreePatternUtils", "subdivideChildren"));
        }
        if (nSubdiv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nSubdiv", "com/intellij/sql/dialects/TreePatternUtils", "subdivideChildren"));
        }
        LinkedHashSet allNames = ContainerUtil.newLinkedHashSet();
        for (TreePatternNode.Group group : groups) {
            if (group == null) continue;
            if (group.positiveChildren != null) {
                for (TreePatternNode<TreePatternNode.PositiveNaming> child : group.positiveChildren) {
                    ContainerUtil.addAll((Collection)allNames, (Object[])((TreePatternNode.PositiveNaming)child.naming).getNames());
                }
            }
            if (group.negativeChild == null) continue;
            ContainerUtil.addAll((Collection)allNames, (Object[])((TreePatternNode.NegativeNaming)group.negativeChild.naming).getAntiNames());
        }
        MultiMap broadSubdiv = mergeChildren ? MultiMap.createLinkedSet() : MultiMap.createLinked();
        for (TreePatternNode.Group group : groups) {
            TreePatternNode.Group[] value;
            HashSet antiNames;
            if (group == null) {
                for (ObjectName name : allNames) {
                    broadSubdiv.putValue((Object)name, null);
                }
                nSubdiv.add(null);
                continue;
            }
            if (group.positiveChildren != null) {
                for (TreePatternNode<TreePatternNode.PositiveNaming> child : group.positiveChildren) {
                    for (ObjectName name : ((TreePatternNode.PositiveNaming)child.naming).getNames()) {
                        broadSubdiv.putValue((Object)name, (Object)child.groups);
                    }
                }
            }
            LinkedHashSet sinks = ContainerUtil.newLinkedHashSet(TreePatternUtils.getSinkNames(group));
            if (group.negativeChild != null) {
                for (ObjectName sink : sinks) {
                    broadSubdiv.putValue((Object)sink, null);
                }
                antiNames = ContainerUtil.newHashSet((Object[])((TreePatternNode.NegativeNaming)group.negativeChild.naming).getAntiNames());
                value = group.negativeChild.groups;
            } else {
                antiNames = sinks;
                value = null;
            }
            for (ObjectName name : allNames) {
                if (antiNames.contains(name)) continue;
                broadSubdiv.putValue((Object)name, (Object)value);
            }
            nSubdiv.add(value);
        }
        MultiMap multiMap = MultiMap.createLinkedSet();
        for (Map.Entry entry : broadSubdiv.entrySet()) {
            multiMap.putValue(entry.getValue(), entry.getKey());
        }
        for (Map.Entry entry : multiMap.entrySet()) {
            pSubdiv.put((Object)new TreePatternNode.PositiveNaming(ObjectName.toArray((Iterable)((Iterable)entry.getValue()))), (Collection)entry.getKey());
        }
        TreePatternNode.NegativeNaming negativeNaming = new TreePatternNode.NegativeNaming(ObjectName.toArray((Iterable)broadSubdiv.keySet()));
        if (negativeNaming == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "subdivideChildren"));
        }
        return negativeNaming;
    }

    @Nullable
    public static TreePatternNode.Group[] processGrouped(@NotNull Iterable<TreePatternNode.Group[]> ggroups, @NotNull GroupedGroupFactory fac) {
        if (ggroups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ggroups", "com/intellij/sql/dialects/TreePatternUtils", "processGrouped"));
        }
        if (fac == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fac", "com/intellij/sql/dialects/TreePatternUtils", "processGrouped"));
        }
        MultiMap grouped = fac.mergeChildren() ? MultiMap.createLinkedSet() : MultiMap.createLinked();
        LinkedHashSet allKinds = ContainerUtil.newLinkedHashSet();
        for (TreePatternNode.Group[] groups : ggroups) {
            if (groups == null) continue;
            for (TreePatternNode.Group group : groups) {
                allKinds.add(group.kind);
            }
        }
        for (TreePatternNode.Group[] groups : ggroups) {
            if (groups == null) continue;
            HashSet currentKinds = ContainerUtil.newHashSet();
            for (TreePatternNode.Group group : groups) {
                grouped.putValue((Object)group.kind, (Object)group);
                currentKinds.add(group.kind);
            }
            for (ObjectKind kind : allKinds) {
                if (currentKinds.contains(kind)) continue;
                grouped.putValue((Object)kind, null);
            }
        }
        List res = ContainerUtil.newSmartList();
        for (Map.Entry entry : grouped.entrySet()) {
            MultiMap positive = fac.mergeChildren() ? MultiMap.createLinkedSet() : MultiMap.createLinked();
            SequencedCollection negative = fac.mergeChildren() ? ContainerUtil.newLinkedHashSet() : ContainerUtil.newSmartList();
            TreePatternNode.NegativeNaming negativeNaming = TreePatternUtils.subdivideChildren((Iterable)entry.getValue(), (MultiMap<TreePatternNode.PositiveNaming, TreePatternNode.Group[]>)positive, negative, fac.mergeChildren());
            ContainerUtil.addAllNotNull((Collection)res, (Object[])new TreePatternNode.Group[]{fac.create((MultiMap<TreePatternNode.PositiveNaming, TreePatternNode.Group[]>)positive, negativeNaming, negative, (ObjectKind)entry.getKey())});
        }
        if (res.isEmpty()) {
            return fac.willDestroyEmpty(ggroups) ? null : TreePatternNode.NO_GROUPS;
        }
        return res.toArray(new TreePatternNode.Group[res.size()]);
    }

    public static boolean isValid(TreePatternNode node) {
        HashSet kinds = ContainerUtil.newHashSet();
        for (TreePatternNode.Group group : node.groups) {
            if (kinds.add(group.kind)) continue;
            return false;
        }
        return true;
    }

    public static void print(@NotNull StringBuilder builder, @NotNull TreePatternNode.Group group, int depth) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/sql/dialects/TreePatternUtils", "print"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/sql/dialects/TreePatternUtils", "print"));
        }
        builder.append(StringUtil.repeat((String)"  ", (int)depth)).append("kind: ");
        builder.append(group.kind).append("\n");
        JBIterable.of((Object[])group.positiveChildren).append(group.negativeChild).forEach(n -> {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/sql/dialects/TreePatternUtils", "lambda$print$1"));
            }
            TreePatternUtils.print(builder, n, depth + 1);
        });
    }

    public static void print(@NotNull StringBuilder builder, @NotNull TreePatternNode<?> node, int depth) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/sql/dialects/TreePatternUtils", "print"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/dialects/TreePatternUtils", "print"));
        }
        builder.append(StringUtil.repeat((String)"  ", (int)depth)).append("name: ").append(node.naming).append("\n");
        JBIterable.of((Object[])node.groups).forEach(n -> {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/sql/dialects/TreePatternUtils", "lambda$print$2"));
            }
            TreePatternUtils.print(builder, n, depth + 1);
        });
    }

    private static TreePatternNode.Group[] preserve(@NotNull TreePatternNode.Group[] groups, boolean preserveOthers, @Nullable TreePatternNode.Group res, int pos) {
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/sql/dialects/TreePatternUtils", "preserve"));
        }
        if (pos == -1) {
            TreePatternNode.Group[] groupArray;
            if (preserveOthers) {
                groupArray = res == null ? groups : (TreePatternNode.Group[])ArrayUtil.append((Object[])groups, (Object)res);
            } else if (res == null) {
                groupArray = null;
            } else {
                TreePatternNode.Group[] groupArray2 = new TreePatternNode.Group[1];
                groupArray = groupArray2;
                groupArray2[0] = res;
            }
            return groupArray;
        }
        if (res == null) {
            return preserveOthers && groups.length != 1 ? (TreePatternNode.Group[])ArrayUtil.remove((Object[])groups, (int)pos) : null;
        }
        if (!preserveOthers) {
            return new TreePatternNode.Group[]{res};
        }
        TreePatternNode.Group[] clone = (TreePatternNode.Group[])groups.clone();
        clone[pos] = res;
        return clone;
    }

    @Nullable
    private static TreePatternNode.Group[] mask(@NotNull TreePatternNode.Group[] groups, @NotNull ObjectKind[] kinds, @NotNull boolean[] mask, int i, boolean preserveOthers) {
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/sql/dialects/TreePatternUtils", "mask"));
        }
        if (kinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kinds", "com/intellij/sql/dialects/TreePatternUtils", "mask"));
        }
        if (mask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mask", "com/intellij/sql/dialects/TreePatternUtils", "mask"));
        }
        if (i >= kinds.length) {
            return TreePatternNode.NO_GROUPS;
        }
        boolean wildcard = !mask[i];
        int idx = -1;
        for (int k = 0; k < groups.length; ++k) {
            if (groups[k].kind != kinds[i]) continue;
            idx = k;
            break;
        }
        if (idx == -1) {
            TreePatternNode.Group res = null;
            if (wildcard) {
                TreePatternNode.Group[] children = TreePatternUtils.mask(TreePatternNode.NO_GROUPS, kinds, mask, i + 1, preserveOthers);
                res = children == null ? null : new TreePatternNode.Group(kinds[i], null, new TreePatternNode<TreePatternNode.NegativeNaming>(TreePatternNode.NegativeNaming.WILDCARD, children));
            }
            return TreePatternUtils.preserve(groups, preserveOthers, res, -1);
        }
        TreePatternNode.Group group = groups[idx];
        if (!wildcard) {
            TreePatternNode.Group[] masked;
            MultiMap positive = MultiMap.createLinkedSet();
            if (group.positiveChildren != null) {
                for (TreePatternNode<TreePatternNode.PositiveNaming> child : group.positiveChildren) {
                    TreePatternNode.Group[] masked2 = TreePatternUtils.mask(child.groups, kinds, mask, i + 1, preserveOthers);
                    if (masked2 == null) continue;
                    positive.putValue(new AW<TreePatternNode.Group>(masked2), child.naming);
                }
            }
            TreePatternNode<Object> negChild = null;
            if (group.negativeChild != null && (masked = TreePatternUtils.mask(group.negativeChild.groups, kinds, mask, i + 1, preserveOthers)) != null) {
                Collection removed = positive.remove(new AW<TreePatternNode.Group>(masked));
                if (removed != null) {
                    ArrayList names = ContainerUtil.newArrayList((Object[])((TreePatternNode.NegativeNaming)group.negativeChild.naming).getAntiNames());
                    for (TreePatternNode.PositiveNaming naming : removed) {
                        ContainerUtil.removeAll((Collection)names, (Object[])naming.getNames());
                    }
                    negChild = new TreePatternNode<TreePatternNode.NegativeNaming>(new TreePatternNode.NegativeNaming(ObjectName.toArray((Iterable)names)), masked);
                } else {
                    negChild = new TreePatternNode(group.negativeChild.naming, masked);
                }
            }
            TreePatternNode.Group result = null;
            if (negChild != null || !positive.isEmpty()) {
                TreePatternNode[] res;
                TreePatternNode[] treePatternNodeArray = res = positive.isEmpty() ? null : new TreePatternNode[positive.size()];
                if (res != null) {
                    int k = 0;
                    for (Map.Entry entry : positive.entrySet()) {
                        res[k] = new TreePatternNode<TreePatternNode.PositiveNaming>(new TreePatternNode.PositiveNaming(ObjectName.toArray((Iterable)JBIterable.from((Iterable)((Iterable)entry.getValue())).flatten(x -> JBIterable.of((Object[])x.getNames())))), (TreePatternNode.Group[])((AW)entry.getKey()).array);
                        ++k;
                    }
                }
                result = new TreePatternNode.Group(kinds[i], res, negChild);
            }
            return TreePatternUtils.preserve(groups, preserveOthers, result, idx);
        }
        LinkedHashSet res = ContainerUtil.newLinkedHashSet();
        for (TreePatternNode node : JBIterable.of((Object[])group.positiveChildren).append(group.negativeChild)) {
            TreePatternNode.Group[] grouped = TreePatternUtils.mask(node.groups, kinds, mask, i + 1, preserveOthers);
            if (grouped == null) continue;
            res.add(grouped);
        }
        TreePatternNode.Group[] merged = UNION_PROCESSOR.merge(res);
        TreePatternNode.Group result = merged == null ? null : new TreePatternNode.Group(kinds[i], null, new TreePatternNode<TreePatternNode.NegativeNaming>(TreePatternNode.NegativeNaming.WILDCARD, merged));
        return TreePatternUtils.preserve(groups, preserveOthers, result, idx);
    }

    @NotNull
    public static TreePattern union(TreePattern ... patterns) {
        if (patterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "com/intellij/sql/dialects/TreePatternUtils", "union"));
        }
        TreePattern treePattern = TreePatternUtils.union(Arrays.asList(patterns));
        if (treePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "union"));
        }
        return treePattern;
    }

    @NotNull
    public static TreePattern union(@NotNull Iterable<TreePattern> patterns) {
        if (patterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "com/intellij/sql/dialects/TreePatternUtils", "union"));
        }
        TreePattern treePattern = new TreePattern(UNION_PROCESSOR.merge((Iterable<TreePatternNode.Group[]>)JBIterable.from(patterns).transform(p -> p.root.groups)));
        if (treePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "union"));
        }
        return treePattern;
    }

    @NotNull
    public static TreePattern intersect(TreePattern ... patterns) {
        if (patterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "com/intellij/sql/dialects/TreePatternUtils", "intersect"));
        }
        TreePattern treePattern = new TreePattern(INTERSECTION_PROCESSOR.merge((Iterable<TreePatternNode.Group[]>)JBIterable.of((Object[])patterns).transform(p -> p.root.groups)));
        if (treePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "intersect"));
        }
        return treePattern;
    }

    @NotNull
    public static TreePattern minus(TreePattern ... patterns) {
        if (patterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "com/intellij/sql/dialects/TreePatternUtils", "minus"));
        }
        TreePattern treePattern = new TreePattern(MINUS_PROCESSOR.merge((Iterable<TreePatternNode.Group[]>)JBIterable.of((Object[])patterns).transform(p -> p.root.groups)));
        if (treePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "minus"));
        }
        return treePattern;
    }

    @NotNull
    public static TreePattern mask(@NotNull TreePattern pattern, @NotNull ObjectKind[] kinds, @NotNull boolean[] mask, boolean preserveOthers) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/sql/dialects/TreePatternUtils", "mask"));
        }
        if (kinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kinds", "com/intellij/sql/dialects/TreePatternUtils", "mask"));
        }
        if (mask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mask", "com/intellij/sql/dialects/TreePatternUtils", "mask"));
        }
        TreePattern treePattern = new TreePattern(TreePatternUtils.mask(pattern.root.groups, kinds, mask, 0, preserveOthers));
        if (treePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "mask"));
        }
        return treePattern;
    }

    @NotNull
    public static TreePatternNode.Group create(@Nullable ObjectName name, @NotNull ObjectKind kind, TreePatternNode.Group ... children) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/dialects/TreePatternUtils", "create"));
        }
        TreePatternNode.Group group = TreePatternUtils.create(name == null ? null : Collections.singletonList(name), kind, children);
        if (group == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "create"));
        }
        return group;
    }

    @NotNull
    public static TreePatternNode.Group create(@Nullable List<ObjectName> names, @NotNull ObjectKind kind, TreePatternNode.Group ... children) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/dialects/TreePatternUtils", "create"));
        }
        if (children == null) {
            children = TreePatternNode.NO_GROUPS;
        }
        int nonNulls = 0;
        for (TreePatternNode.Group child : children) {
            if (child == null) continue;
            ++nonNulls;
        }
        if (nonNulls != children.length) {
            if (nonNulls == 0) {
                children = TreePatternNode.NO_GROUPS;
            } else {
                TreePatternNode.Group[] children2 = new TreePatternNode.Group[nonNulls];
                nonNulls = 0;
                for (TreePatternNode.Group child : children) {
                    if (child == null) continue;
                    children2[nonNulls++] = child;
                }
                children = children2;
            }
        }
        TreePatternNode.Group res = names == null ? new TreePatternNode.Group(kind, null, new TreePatternNode<TreePatternNode.NegativeNaming>(TreePatternNode.NegativeNaming.WILDCARD, children)) : new TreePatternNode.Group(kind, new TreePatternNode[]{new TreePatternNode<TreePatternNode.PositiveNaming>(new TreePatternNode.PositiveNaming(ObjectName.toArray(names)), children)}, null);
        TreePatternNode.Group group = res;
        if (group == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "create"));
        }
        return group;
    }

    @NotNull
    public static TreePattern patternProcessor(@NotNull TreePattern processed, @NotNull TreePattern mask, final @NotNull PatternProcessor processor) {
        if (processed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processed", "com/intellij/sql/dialects/TreePatternUtils", "patternProcessor"));
        }
        if (mask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mask", "com/intellij/sql/dialects/TreePatternUtils", "patternProcessor"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/dialects/TreePatternUtils", "patternProcessor"));
        }
        TreePatternNode.Group[] newRoot = new Object(){

            @Nullable
            public TreePatternNode.Group[] visit(@Nullable TreePatternNode.Group[] groups, @Nullable TreePatternNode.Group[] checker, @Nullable TreePatternNode.BaseNaming parent, @Nullable ObjectKind parentKind) {
                TreePatternNode.Group processed;
                if (checker == null) {
                    return groups;
                }
                NodeBuilder b = null;
                LinkedHashMap newGroups = ContainerUtil.newLinkedHashMap();
                for (TreePatternNode.Group group : checker) {
                    newGroups.put(group.kind, group);
                }
                if (groups != null) {
                    for (int i = 0; i < groups.length; ++i) {
                        TreePatternNode.Group group = groups[i];
                        newGroups.remove(group.kind);
                        TreePatternNode.Group checkerGroup = TreePatternNode.getGroup(checker, group.kind);
                        processed = group;
                        if (checkerGroup != null) {
                            processed = this.visit(group, checkerGroup, parent, parentKind);
                        }
                        if (processed != group && b == null) {
                            b = new NodeBuilder();
                            for (int k = 0; k < i; ++k) {
                                b.addGroup(groups[k]);
                            }
                        }
                        if (b == null || processed == null) continue;
                        b.addGroup(processed);
                    }
                }
                Iterator iterator = newGroups.values().iterator();
                while (iterator.hasNext()) {
                    TreePatternNode.Group group;
                    TreePatternNode.Group temp = new TreePatternNode.Group(group.kind, null, null);
                    group = (TreePatternNode.Group)iterator.next();
                    processed = this.visit(temp, group, parent, parentKind);
                    if (processed == temp || processed == null) continue;
                    if (b == null) {
                        b = NodeBuilder.from(groups);
                    }
                    b.addGroup(processed);
                }
                return b == null ? groups : b.buildGroupsOpt();
            }

            @Nullable
            public TreePatternNode.Group visit(@NotNull TreePatternNode.Group group, @NotNull TreePatternNode.Group checker, @Nullable TreePatternNode.BaseNaming parent, @Nullable ObjectKind parentKind) {
                TreePatternNode.Group[] n2;
                if (group == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/sql/dialects/TreePatternUtils$4", "visit"));
                }
                if (checker == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checker", "com/intellij/sql/dialects/TreePatternUtils$4", "visit"));
                }
                TreePatternNode.Group procRes = processor.process(group, parent, parentKind);
                if (procRes == SKIP_PROCESSING) {
                    return group;
                }
                if (procRes == null) {
                    return null;
                }
                group = procRes;
                MultiMap gluedPositive = MultiMap.createLinked();
                MultiMap p = MultiMap.createLinked();
                List n = ContainerUtil.newSmartList();
                TreePatternNode.NegativeNaming negativeNaming = TreePatternUtils.subdivideChildren((Iterable<TreePatternNode.Group>)JBIterable.of((Object[])new TreePatternNode.Group[]{group, checker}), (MultiMap<TreePatternNode.PositiveNaming, TreePatternNode.Group[]>)p, n, false);
                for (Map.Entry entry : p.entrySet()) {
                    Iterator it = ((Collection)entry.getValue()).iterator();
                    TreePatternNode.Group[] p1 = (TreePatternNode.Group[])it.next();
                    TreePatternNode.Group[] p2 = (TreePatternNode.Group[])it.next();
                    TreePatternNode.Group[] processed = this.visit(p1, p2, (TreePatternNode.BaseNaming)entry.getKey(), group.kind);
                    gluedPositive.putValue(new AW<TreePatternNode.Group>(processed), entry.getKey());
                }
                Iterator it = n.iterator();
                TreePatternNode.Group[] n1 = (TreePatternNode.Group[])it.next();
                TreePatternNode.Group[] processedNegative = this.visit(n1, n2 = (TreePatternNode.Group[])it.next(), (TreePatternNode.BaseNaming)negativeNaming, group.kind);
                Collection extra = gluedPositive.remove(new AW<TreePatternNode.Group>(processedNegative));
                if (extra != null) {
                    LinkedHashSet names = ContainerUtil.newLinkedHashSet((Object[])negativeNaming.getAntiNames());
                    for (TreePatternNode.PositiveNaming naming : extra) {
                        ContainerUtil.removeAll((Collection)names, (Object[])naming.getNames());
                    }
                    negativeNaming = new TreePatternNode.NegativeNaming(ObjectName.toArray((Iterable)names));
                }
                return this.createNewIfChanged(group, (MultiMap<AW<TreePatternNode.Group>, TreePatternNode.PositiveNaming>)gluedPositive, processedNegative, negativeNaming);
            }

            private TreePatternNode.Group createNewIfChanged(@NotNull TreePatternNode.Group group, @NotNull MultiMap<AW<TreePatternNode.Group>, TreePatternNode.PositiveNaming> positive, @Nullable TreePatternNode.Group[] negative, @NotNull TreePatternNode.NegativeNaming negativeNaming) {
                if (group == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/sql/dialects/TreePatternUtils$4", "createNewIfChanged"));
                }
                if (positive == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "positive", "com/intellij/sql/dialects/TreePatternUtils$4", "createNewIfChanged"));
                }
                if (negativeNaming == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "negativeNaming", "com/intellij/sql/dialects/TreePatternUtils$4", "createNewIfChanged"));
                }
                HashMap pool = ContainerUtil.newHashMap();
                if (group.positiveChildren != null) {
                    for (TreePatternNode<TreePatternNode.PositiveNaming> child : group.positiveChildren) {
                        pool.put(child.naming, child);
                    }
                }
                boolean changed = false;
                GroupBuilder builder = new GroupBuilder();
                if (negative != null) {
                    if (group.negativeChild != null && negativeNaming.equals(group.negativeChild.naming) && Arrays.equals(group.negativeChild.groups, negative)) {
                        builder.negative = group.negativeChild;
                    } else {
                        changed = true;
                        builder.negative = new TreePatternNode<TreePatternNode.NegativeNaming>(negativeNaming, negative);
                    }
                } else {
                    changed = group.negativeChild != null;
                }
                changed |= pool.size() != positive.size();
                for (Map.Entry entry : positive.entrySet()) {
                    List names = ContainerUtil.newSmartList();
                    for (TreePatternNode.PositiveNaming naming : (Collection)entry.getValue()) {
                        ContainerUtil.addAll((Collection)names, (Object[])naming.getNames());
                    }
                    TreePatternNode.PositiveNaming naming = new TreePatternNode.PositiveNaming(ObjectName.toArray((Iterable)names));
                    TreePatternNode node = (TreePatternNode)pool.get(naming);
                    if (node == null || node.groups != ((AW)entry.getKey()).array) {
                        changed = true;
                        node = ((AW)entry.getKey()).array == null ? null : new TreePatternNode<TreePatternNode.PositiveNaming>(naming, (TreePatternNode.Group[])((AW)entry.getKey()).array);
                    }
                    ContainerUtil.addIfNotNull(builder.positives, (Object)node);
                }
                return changed ? builder.build(group.kind) : group;
            }
        }.visit(processed.root.groups, mask.root.groups, null, null);
        TreePattern treePattern = newRoot == processed.root.groups ? processed : new TreePattern(newRoot);
        if (treePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "patternProcessor"));
        }
        return treePattern;
    }

    public static interface PatternProcessor {
        @Nullable
        public TreePatternNode.Group process(@NotNull TreePatternNode.Group var1, @Nullable TreePatternNode.BaseNaming var2, @Nullable ObjectKind var3);
    }

    public static class NodeBuilder {
        public final List<TreePatternNode.Group> groups = ContainerUtil.newSmartList();

        public NodeBuilder addGroup(@Nullable TreePatternNode.Group g) {
            if (g != null) {
                this.groups.add(g);
            }
            return this;
        }

        @NotNull
        public <T extends TreePatternNode.BaseNaming> TreePatternNode<T> build(T naming) {
            TreePatternNode<T> treePatternNode = new TreePatternNode<T>(naming, this.buildGroups());
            if (treePatternNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils$NodeBuilder", "build"));
            }
            return treePatternNode;
        }

        @Nullable
        public TreePatternNode.Group[] buildGroupsOpt() {
            return this.groups.isEmpty() ? null : this.groups.toArray(new TreePatternNode.Group[this.groups.size()]);
        }

        @NotNull
        public TreePatternNode.Group[] buildGroups() {
            TreePatternNode.Group[] groupArray = (TreePatternNode.Group[])ObjectUtils.chooseNotNull((Object)this.buildGroupsOpt(), (Object)TreePatternNode.NO_GROUPS);
            if (groupArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils$NodeBuilder", "buildGroups"));
            }
            return groupArray;
        }

        @NotNull
        public static NodeBuilder from(@Nullable TreePatternNode<?> node) {
            NodeBuilder nodeBuilder = NodeBuilder.from(node == null ? null : node.groups);
            if (nodeBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils$NodeBuilder", "from"));
            }
            return nodeBuilder;
        }

        @NotNull
        public static NodeBuilder from(@Nullable TreePatternNode.Group[] groups) {
            NodeBuilder b = new NodeBuilder();
            if (groups != null) {
                ContainerUtil.addAll(b.groups, (Object[])groups);
            }
            NodeBuilder nodeBuilder = b;
            if (nodeBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils$NodeBuilder", "from"));
            }
            return nodeBuilder;
        }
    }

    public static class GroupBuilder {
        public final List<TreePatternNode<TreePatternNode.PositiveNaming>> positives = ContainerUtil.newSmartList();
        public TreePatternNode<TreePatternNode.NegativeNaming> negative = null;

        @Nullable
        public TreePatternNode.Group build(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/dialects/TreePatternUtils$GroupBuilder", "build"));
            }
            TreePatternNode[] p = this.positives.isEmpty() ? null : this.positives.toArray(new TreePatternNode[this.positives.size()]);
            return p == null && this.negative == null ? null : new TreePatternNode.Group(kind, p, this.negative);
        }

        @NotNull
        public static GroupBuilder from(@Nullable TreePatternNode.Group g) {
            GroupBuilder builder = new GroupBuilder();
            if (g != null) {
                if (g.positiveChildren != null) {
                    ContainerUtil.addAll(builder.positives, (Object[])g.positiveChildren);
                }
                builder.negative = g.negativeChild;
            }
            GroupBuilder groupBuilder = builder;
            if (groupBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils$GroupBuilder", "from"));
            }
            return groupBuilder;
        }
    }

    private static abstract class GroupedGroupFactory {
        private GroupedGroupFactory() {
        }

        @Nullable
        public TreePatternNode.Group create(@NotNull MultiMap<TreePatternNode.PositiveNaming, TreePatternNode.Group[]> p, @NotNull TreePatternNode.NegativeNaming nn, @NotNull Collection<TreePatternNode.Group[]> n, ObjectKind kind) {
            TreePatternNode[] positive;
            TreePatternNode.Group[] negGroups;
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/sql/dialects/TreePatternUtils$GroupedGroupFactory", "create"));
            }
            if (nn == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nn", "com/intellij/sql/dialects/TreePatternUtils$GroupedGroupFactory", "create"));
            }
            if (n == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "n", "com/intellij/sql/dialects/TreePatternUtils$GroupedGroupFactory", "create"));
            }
            MultiMap mergedBranches = MultiMap.createLinkedSet();
            for (Map.Entry entry : p.entrySet()) {
                TreePatternNode.Group[] merged;
                if (!this.checkGroup((Collection)entry.getValue()) || (merged = this.merge((Iterable)entry.getValue())) == null) continue;
                mergedBranches.putValue(new AW<TreePatternNode.Group>(merged), entry.getKey());
            }
            TreePatternNode.Group[] groupArray = negGroups = this.checkGroup(n) ? this.merge(n) : null;
            if (mergedBranches.isEmpty() && negGroups == null) {
                return null;
            }
            TreePatternNode<TreePatternNode.NegativeNaming> negative = null;
            if (negGroups != null) {
                Collection namings = mergedBranches.remove(new AW<TreePatternNode.Group>(negGroups));
                if (namings != null) {
                    ArrayList antiNames = ContainerUtil.newArrayList((Object[])nn.getAntiNames());
                    for (TreePatternNode.PositiveNaming naming : namings) {
                        ContainerUtil.removeAll((Collection)antiNames, (Object[])naming.getNames());
                    }
                    negative = new TreePatternNode<TreePatternNode.NegativeNaming>(new TreePatternNode.NegativeNaming(ObjectName.toArray((Iterable)antiNames)), negGroups);
                } else {
                    negative = new TreePatternNode<TreePatternNode.NegativeNaming>(nn, negGroups);
                }
            }
            TreePatternNode[] treePatternNodeArray = positive = mergedBranches.isEmpty() ? null : new TreePatternNode[mergedBranches.size()];
            if (positive != null) {
                int i = 0;
                for (Map.Entry entry : mergedBranches.entrySet()) {
                    List names = ContainerUtil.newSmartList();
                    ((Collection)entry.getValue()).forEach(x -> {
                        List cfr_ignored_0 = (List)ContainerUtil.addAll((Collection)names, (Object[])x.getNames());
                    });
                    positive[i] = new TreePatternNode<TreePatternNode.PositiveNaming>(new TreePatternNode.PositiveNaming(ObjectName.toArray((Iterable)names)), (TreePatternNode.Group[])((AW)entry.getKey()).array);
                    ++i;
                }
            }
            return new TreePatternNode.Group(kind, positive, negative);
        }

        @Nullable
        public TreePatternNode.Group[] merge(@NotNull Iterable<TreePatternNode.Group[]> groups) {
            if (groups == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/sql/dialects/TreePatternUtils$GroupedGroupFactory", "merge"));
            }
            return TreePatternUtils.processGrouped(groups, this);
        }

        protected abstract boolean checkGroup(@NotNull Collection<TreePatternNode.Group[]> var1);

        public boolean willDestroyEmpty(Iterable<TreePatternNode.Group[]> ggroups) {
            for (TreePatternNode.Group[] groups : ggroups) {
                if (groups == null) continue;
                return false;
            }
            return true;
        }

        public boolean mergeChildren() {
            return true;
        }
    }

    private static final class AW<T> {
        public final T[] array;
        private Integer myHashCode;

        public AW(@Nullable T[] array) {
            this.array = array;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AW aw = (AW)o;
            return Arrays.equals(this.array, aw.array);
        }

        public int hashCode() {
            if (this.myHashCode != null) {
                return this.myHashCode;
            }
            this.myHashCode = Arrays.hashCode(this.array);
            return this.myHashCode;
        }
    }
}

