/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.database.util.DbSqlUtil;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingModelProvider;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.SqlFormattingBlock;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlTokens;
import org.jetbrains.annotations.NotNull;

public class SqlFormattingModelBuilder
implements FormattingModelBuilder {
    public TextRange getRangeAffectingIndent(PsiFile file, int offset, ASTNode elementAtOffset) {
        return null;
    }

    @NotNull
    public FormattingModel createModel(@NotNull PsiElement element, @NotNull CodeStyleSettings settings) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/formatter/SqlFormattingModelBuilder", "createModel"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/sql/formatter/SqlFormattingModelBuilder", "createModel"));
        }
        PsiFile file = element.getContainingFile();
        Language language = file instanceof SqlFile ? ((SqlFile)file).getSqlLanguage() : file.getLanguage();
        SqlFormattingBlock.ReadOnlyBlock block = language == DbSqlUtil.getGenericDialect() || ((SqlCodeStyleSettings)settings.getCustomSettings(SqlCodeStyleSettings.class)).DISABLE_FORMATTING ? new SqlFormattingBlock.ReadOnlyBlock((ASTNode)file.getNode()) : SqlFormattingModelBuilder.createRootBlock(settings, file);
        FormattingModel formattingModel = FormattingModelProvider.createFormattingModelForPsiFile((PsiFile)file, (Block)block, (CodeStyleSettings)settings);
        if (formattingModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/formatter/SqlFormattingModelBuilder", "createModel"));
        }
        return formattingModel;
    }

    @NotNull
    public static FormattingModel createDocumentFormattingModel(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @NotNull CodeStyleSettings settings, @NotNull CharSequence text) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/formatter/SqlFormattingModelBuilder", "createDocumentFormattingModel"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/formatter/SqlFormattingModelBuilder", "createDocumentFormattingModel"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/sql/formatter/SqlFormattingModelBuilder", "createDocumentFormattingModel"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/formatter/SqlFormattingModelBuilder", "createDocumentFormattingModel"));
        }
        SqlFile file = SqlPsiFacade.getInstance((Project)project).createSqlReader().getReadOnlyPsi(dialect, text);
        SqlFormattingBlock block = SqlFormattingModelBuilder.createRootBlock(settings, (PsiFile)file);
        DocumentImpl document = new DocumentImpl(text, true);
        file.putUserData(FileDocumentManagerImpl.HARD_REF_TO_DOCUMENT_KEY, (Object)document);
        DocumentBasedFormattingModel documentBasedFormattingModel = new DocumentBasedFormattingModel((Block)block, (Document)document, project, settings, file.getFileType(), (PsiFile)file);
        if (documentBasedFormattingModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/formatter/SqlFormattingModelBuilder", "createDocumentFormattingModel"));
        }
        return documentBasedFormattingModel;
    }

    @NotNull
    private static SqlFormattingBlock createRootBlock(@NotNull CodeStyleSettings settings, @NotNull PsiFile file) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/sql/formatter/SqlFormattingModelBuilder", "createRootBlock"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/formatter/SqlFormattingModelBuilder", "createRootBlock"));
        }
        SqlFormattingBlock sqlFormattingBlock = new SqlFormattingBlock((ASTNode)file.getNode(), null, null, null, null, null, new Context(settings));
        if (sqlFormattingBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/formatter/SqlFormattingModelBuilder", "createRootBlock"));
        }
        return sqlFormattingBlock;
    }

    private static SpacingBuilder createSpacingBuilder(Context context) {
        CommonCodeStyleSettings s = context.commonSettings;
        SqlCodeStyleSettings c = context.customSettings;
        SpacingBuilder builder = new SpacingBuilder(s).after((IElementType)SqlTokens.SQL_LINE_COMMENT).lineBreakInCode().betweenInside((IElementType)SqlTokens.SQL_OP_MINUS, (IElementType)SqlTokens.SQL_INTEGER_TOKEN, (IElementType)SqlCompositeElementTypes.SQL_NUMERIC_LITERAL).none().betweenInside((IElementType)SqlTokens.SQL_OP_PLUS, (IElementType)SqlTokens.SQL_INTEGER_TOKEN, (IElementType)SqlCompositeElementTypes.SQL_NUMERIC_LITERAL).none().aroundInside((IElementType)SqlTokens.SQL_OP_EQ, (IElementType)SqlCompositeElementTypes.SQL_SET_ASSIGNMENT).spaces(1).aroundInside((IElementType)SqlTokens.SQL_OP_ASSIGN, (IElementType)SqlCompositeElementTypes.SQL_SET_ASSIGNMENT).spaces(1).before((IElementType)SqlCompositeElementTypes.SQL_TABLE_EXPRESSION).lineBreakInCodeIf(c.NEW_LINE_BEFORE_FROM).before((IElementType)SqlCompositeElementTypes.SQL_WHERE_CLAUSE).lineBreakInCodeIf(c.NEW_LINE_BEFORE_WHERE).before((IElementType)SqlCompositeElementTypes.SQL_GROUP_BY_CLAUSE).lineBreakInCodeIf(c.NEW_LINE_BEFORE_GROUP_BY).before((IElementType)SqlCompositeElementTypes.SQL_ORDER_BY_CLAUSE).lineBreakInCodeIf(c.NEW_LINE_BEFORE_ORDER_BY).before((IElementType)SqlCompositeElementTypes.SQL_HAVING_CLAUSE).lineBreakInCodeIf(c.NEW_LINE_BEFORE_HAVING).before((IElementType)SqlCompositeElementTypes.SQL_THEN_CLAUSE).lineBreakInCodeIf(c.NEW_LINE_BEFORE_THEN).before((IElementType)SqlCompositeElementTypes.SQL_ELSE_CLAUSE).lineBreakInCodeIf(c.NEW_LINE_BEFORE_ELSE).beforeInside((IElementType)SqlCompositeElementTypes.SQL_QUERY_EXPRESSION, (IElementType)SqlCompositeElementTypes.SQL_PARENTHESIZED_EXPRESSION).lineBreakInCodeIf(c.NEW_LINE_BEFORE_QUERY_INSIDE_PARENTHESIS).betweenInside((IElementType)SqlCompositeElementTypes.SQL_TABLE_REFERENCE, (IElementType)SqlTokens.SQL_COMMA, (IElementType)SqlCompositeElementTypes.SQL_JOIN_EXPRESSION).none().betweenInside((IElementType)SqlCompositeElementTypes.SQL_TABLE_REFERENCE, (IElementType)SqlCompositeElementTypes.SQL_JOIN_CONDITION_CLAUSE, (IElementType)SqlCompositeElementTypes.SQL_JOIN_EXPRESSION).lineBreakInCodeIf(c.NEW_LINE_BEFORE_JOIN_CONDITION).betweenInside((IElementType)SqlCompositeElementTypes.SQL_TABLE_REFERENCE, (IElementType)SqlCompositeElementTypes.SQL_JOIN_CONDITION_CLAUSE, (IElementType)SqlCompositeElementTypes.SQL_JOIN_EXPRESSION).spaceIf(!c.NEW_LINE_BEFORE_JOIN_CONDITION).afterInside((IElementType)SqlCompositeElementTypes.SQL_JOIN_CONDITION_CLAUSE, (IElementType)SqlCompositeElementTypes.SQL_JOIN_EXPRESSION).lineBreakInCodeIf(c.NEW_LINE_BEFORE_JOIN_CONDITION).beforeInside((IElementType)SqlCompositeElementTypes.SQL_USING_CLAUSE, (IElementType)SqlCompositeElementTypes.SQL_JOIN_EXPRESSION).lineBreakInCodeIf(c.NEW_LINE_BEFORE_JOIN_CONDITION).beforeInside((IElementType)SqlCompositeElementTypes.SQL_USING_CLAUSE, (IElementType)SqlCompositeElementTypes.SQL_JOIN_EXPRESSION).spaceIf(!c.NEW_LINE_BEFORE_JOIN_CONDITION).before((IElementType)SqlCompositeElementTypes.SQL_JOIN_CONDITION_CLAUSE).lineBreakInCodeIf(c.NEW_LINE_BEFORE_JOIN_CONDITION).before((IElementType)SqlCompositeElementTypes.SQL_JOIN_CONDITION_CLAUSE).spaceIf(!c.NEW_LINE_BEFORE_JOIN_CONDITION).afterInside((IElementType)SqlCompositeElementTypes.SQL_TABLE_REFERENCE, (IElementType)SqlCompositeElementTypes.SQL_JOIN_EXPRESSION).lineBreakInCodeIf(c.NEW_LINE_BEFORE_JOIN).afterInside((IElementType)SqlCompositeElementTypes.SQL_TABLE_REFERENCE, (IElementType)SqlCompositeElementTypes.SQL_QUERY_EXPRESSION).lineBreakInCodeIf(c.NEW_LINE_BEFORE_JOIN).afterInside((IElementType)SqlCompositeElementTypes.SQL_JOIN_EXPRESSION, (IElementType)SqlCompositeElementTypes.SQL_JOIN_EXPRESSION).lineBreakInCodeIf(c.NEW_LINE_BEFORE_JOIN).betweenInside((IElementType)SqlCompositeElementTypes.SQL_AS_EXPRESSION, (IElementType)SqlTokens.SQL_JOIN, (IElementType)SqlCompositeElementTypes.SQL_JOIN_EXPRESSION).lineBreakInCodeIf(c.NEW_LINE_BEFORE_JOIN).beforeInside((IElementType)SqlCompositeElementTypes.SQL_QUERY_EXPRESSION, (IElementType)SqlCompositeElementTypes.SQL_CREATE_VIEW_STATEMENT).lineBreakInCode().beforeInside((IElementType)SqlTokens.SQL_UNION, (IElementType)SqlCompositeElementTypes.SQL_UNION_EXPRESSION).lineBreakInCode();
        if (c.NEW_LINE_BEFORE_COMMA) {
            builder.beforeInside((IElementType)SqlTokens.SQL_COMMA, (IElementType)SqlCompositeElementTypes.SQL_SELECT_CLAUSE).lineBreakInCode();
            builder.afterInside((IElementType)SqlTokens.SQL_COMMA, (IElementType)SqlCompositeElementTypes.SQL_SELECT_CLAUSE).spacing(s.SPACE_AFTER_COMMA ? 1 : 0, 1, 0, false, 0);
        }
        if (c.NEW_LINE_AFTER_SELECT_ITEM) {
            builder.afterInside((IElementType)SqlTokens.SQL_COMMA, (IElementType)SqlCompositeElementTypes.SQL_SELECT_CLAUSE).lineBreakInCode();
            builder.beforeInside((IElementType)SqlTokens.SQL_COMMA, (IElementType)SqlCompositeElementTypes.SQL_SELECT_CLAUSE).spacing(s.SPACE_BEFORE_COMMA ? 1 : 0, 0, 0, false, 0);
        }
        if (c.NEW_LINE_AROUND_SEMICOLON) {
            builder.after((IElementType)SqlTokens.SQL_SEMICOLON).blankLines(1);
        } else {
            builder.between((IElementType)SqlTokens.SQL_SEMICOLON, (IElementType)SqlTokens.SQL_LINE_COMMENT).spacing(1, 0, 0, true, 1);
            builder.between((IElementType)SqlTokens.SQL_SEMICOLON, (IElementType)SqlTokens.MYSQL_LINE_COMMENT).spacing(1, 0, 0, true, 1);
            builder.after((IElementType)SqlTokens.SQL_SEMICOLON).lineBreakInCode();
        }
        builder.after((IElementType)SqlTokens.SQL_AT_SIGN).none().around((IElementType)SqlCommonKeywords.SQL_AS).spaces(1).after((IElementType)SqlCommonKeywords.SQL_DELIMITER).spaces(1).before((IElementType)SqlTokens.SQL_SEMICOLON).none().after((IElementType)SqlTokens.SQL_COMMA).spaceIf(s.SPACE_AFTER_COMMA).before((IElementType)SqlTokens.SQL_COMMA).spaceIf(s.SPACE_BEFORE_COMMA).around((IElementType)SqlTokens.SQL_PERIOD).none().after((IElementType)SqlTokens.SQL_LEFT_BRACE).none().before((IElementType)SqlTokens.SQL_RIGHT_BRACE).none().after((IElementType)SqlTokens.SQL_LEFT_BRACKET).none().before((IElementType)SqlTokens.SQL_RIGHT_BRACKET).none().beforeInside((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_FUNCTION_CALL).spaceIf(s.SPACE_BEFORE_METHOD_CALL_PARENTHESES).beforeInside((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_PARAMETER_LIST).spaceIf(s.SPACE_BEFORE_METHOD_PARENTHESES).beforeInside((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_CREATE_TABLE_STATEMENT).spaceIf(true).beforeInside((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_CREATE_ASSERTION_STATEMENT).spaceIf(true).withinPairInside((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlTokens.SQL_RIGHT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_FUNCTION_CALL).spaceIf(s.SPACE_WITHIN_METHOD_CALL_PARENTHESES).withinPairInside((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlTokens.SQL_RIGHT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_PARAMETER_LIST).spaceIf(s.SPACE_WITHIN_METHOD_PARENTHESES).withinPairInside((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlTokens.SQL_RIGHT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_PARENTHESIZED_EXPRESSION).spaceIf(s.SPACE_WITHIN_PARENTHESES).withinPairInside((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlTokens.SQL_RIGHT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_CREATE_TABLE_STATEMENT).spaceIf(false).withinPairInside((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlTokens.SQL_RIGHT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_CREATE_ASSERTION_STATEMENT).spaceIf(false).withinPairInside((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlTokens.SQL_RIGHT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_REFERENCE_LIST).spaceIf(false).beforeInside((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_TYPE_ELEMENT).none().beforeInside((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_CLAUSE).none().withinPairInside((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlTokens.SQL_RIGHT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_TYPE_ELEMENT).none().withinPairInside((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlTokens.SQL_RIGHT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_CLAUSE).none().betweenInside((TokenSet)null, null, (IElementType)SqlCompositeElementTypes.SQL_IDENTIFIER).none().after((IElementType)SqlCompositeElementTypes.SQL_ANY_CALLABLE_REFERENCE).none().between((IElementType)SqlCompositeElementTypes.SQL_TABLE_REFERENCE, (IElementType)SqlCompositeElementTypes.SQL_REFERENCE_LIST).spaces(1).betweenInside((IElementType)SqlTokens.SQL_VALUES, (IElementType)SqlCompositeElementTypes.SQL_PARENTHESIZED_EXPRESSION, (IElementType)SqlCompositeElementTypes.SQL_VALUES_EXPRESSION).spaces(1).between((IElementType)SqlCompositeElementTypes.SQL_IDENTIFIER, (IElementType)SqlCompositeElementTypes.SQL_TYPE_ELEMENT).spaces(1).around((IElementType)SqlCompositeElementTypes.SQL_TYPE_ELEMENT).spaces(1).betweenInside((IElementType)SqlCompositeElementTypes.SQL_TABLE_REFERENCE, (IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_CREATE_TABLE_STATEMENT).spaceIf(false).aroundInside((IElementType)SqlTokens.SQL_PERCENT_SIGN, (IElementType)SqlCompositeElementTypes.SQL_UNARY_EXPRESSION).none().aroundInside((IElementType)SqlTokens.SQL_PERCENT_SIGN, (IElementType)SqlCompositeElementTypes.SQL_TYPE_ELEMENT).none().after((IElementType)SqlTokens.SQL_AT_SIGN).none().after((IElementType)SqlTokens.SQL_COLON).none();
        return builder;
    }

    public static class Context {
        final CodeStyleSettings codeStyleSettings;
        final CommonCodeStyleSettings commonSettings;
        final SqlCodeStyleSettings customSettings;
        final SpacingBuilder spacingBuilder;

        public Context(CodeStyleSettings settings) {
            this.codeStyleSettings = settings;
            this.commonSettings = this.codeStyleSettings.getCommonSettings((Language)SqlLanguage.INSTANCE);
            this.customSettings = (SqlCodeStyleSettings)this.codeStyleSettings.getCustomSettings(SqlCodeStyleSettings.class);
            this.spacingBuilder = SqlFormattingModelBuilder.createSpacingBuilder(this);
        }
    }
}

