/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.script;

import com.intellij.lang.FileASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.stubs.StubTree;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ReadOnlySqlFile
extends SqlFileImpl {
    private final FileASTNode myFileNode;

    public ReadOnlySqlFile(SingleRootFileViewProvider viewProvider, FileASTNode fileNode) {
        super((FileViewProvider)viewProvider);
        this.myFileNode = fileNode;
    }

    @Nullable
    public StubTree getStubTree() {
        return null;
    }

    @NotNull
    public FileASTNode getNode() {
        FileASTNode fileASTNode = this.myFileNode;
        if (fileASTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/ReadOnlySqlFile", "getNode"));
        }
        return fileASTNode;
    }

    public int getTextLength() {
        return this.myFileNode.getTextLength();
    }

    public String getText() {
        return this.myFileNode.getText();
    }

    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = JBIterable.of((Object[])this.myFileNode.getChildren(null)).transform(node -> node.getPsi()).filter(Condition.NOT_NULL).toList().toArray(PsiElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/ReadOnlySqlFile", "getChildren"));
        }
        return psiElementArray;
    }

    public PsiElement getFirstChild() {
        return (PsiElement)ArrayUtil.getFirstElement((Object[])this.getChildren());
    }

    public PsiElement getLastChild() {
        return (PsiElement)ArrayUtil.getLastElement((Object[])this.getChildren());
    }
}

