/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.smartenter;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import org.jetbrains.annotations.NotNull;

public class SqlCallExpressionFixer
extends SmartEnterProcessorWithFixers.Fixer {
    public void apply(@NotNull Editor editor, @NotNull SmartEnterProcessorWithFixers processor, @NotNull PsiElement element) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/smartenter/SqlCallExpressionFixer", "apply"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/smartenter/SqlCallExpressionFixer", "apply"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/smartenter/SqlCallExpressionFixer", "apply"));
        }
        if ((element.getNode().getElementType() == SqlCompositeElementTypes.SQL_CALL_STATEMENT || element instanceof SqlFunctionCallExpression) && !StringUtil.endsWithChar((CharSequence)element.getText(), (char)')')) {
            int offset = element.getTextRange().getEndOffset();
            editor.getDocument().insertString(offset, (CharSequence)")");
        }
    }
}

