/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vaadin.actions;

import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.facet.GwtSdkPathEditor;
import com.intellij.gwt.packaging.GwtCompilerOutputElement;
import com.intellij.gwt.sdk.GwtSdk;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vaadin.framework.VaadinVersion;
import com.intellij.vaadin.framework.VaadinVersionUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateWidgetDialog
extends DialogWrapper {
    @NotNull
    private final Module myModule;
    @NotNull
    private final InputValidator myValidator;
    private JPanel myMainPanel;
    private JTextField myNameField;
    private JPanel myGwtSdkPathPanel;
    private JLabel mySetupGwtSdkLabel;
    private final GwtSdkPathEditor mySdkPathEditor;

    public CreateWidgetDialog(@NotNull Module module, @NotNull InputValidator validator) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/vaadin/actions/CreateWidgetDialog", "<init>"));
        }
        if (validator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "validator", "com/intellij/vaadin/actions/CreateWidgetDialog", "<init>"));
        }
        super(module.getProject());
        this.$$$setupUI$$$();
        this.setTitle("Create New Widget");
        this.myModule = module;
        this.myValidator = validator;
        GwtFacet gwtFacet = GwtFacet.getInstance((Module)module);
        if (gwtFacet == null) {
            String path;
            this.mySdkPathEditor = new GwtSdkPathEditor(module.getProject());
            VaadinVersion version = VaadinVersionUtil.getVaadinVersion(module);
            if (version.isFullDistributionRequired() && (path = VaadinVersionUtil.detectVaadinHome(module)) != null) {
                this.mySdkPathEditor.setPath(path);
            }
            this.myGwtSdkPathPanel.add((Component)this.mySdkPathEditor.getMainComponent());
        } else {
            this.mySdkPathEditor = null;
            this.myGwtSdkPathPanel.setVisible(false);
            this.mySetupGwtSdkLabel.setVisible(false);
        }
        this.init();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    @Nullable
    protected JComponent createNorthPanel() {
        return this.myMainPanel;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return null;
    }

    protected void doOKAction() {
        String name = this.myNameField.getText().trim();
        if (this.myValidator.checkInput(name)) {
            if (this.mySdkPathEditor != null) {
                final GwtSdk sdk = this.mySdkPathEditor.getSelectedSdk();
                new WriteAction(){

                    protected void run(@NotNull Result result) {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/vaadin/actions/CreateWidgetDialog$1", "run"));
                        }
                        GwtFacet gwtFacet = GwtFacet.createNewFacet((Module)CreateWidgetDialog.this.myModule, (GwtSdk)sdk);
                        WebFacet webFacet = (WebFacet)ContainerUtil.getFirstItem((Collection)WebFacet.getInstances((Module)CreateWidgetDialog.this.myModule));
                        if (webFacet != null) {
                            ((GwtFacetConfiguration)gwtFacet.getConfiguration()).setWebFacetName(webFacet.getName());
                            Project project = CreateWidgetDialog.this.myModule.getProject();
                            ArtifactManager artifactManager = ArtifactManager.getInstance((Project)project);
                            PackagingElementResolvingContext context = artifactManager.getResolvingContext();
                            Collection types = WebArtifactUtil.getInstance().getWebArtifactTypes();
                            for (Artifact artifact : JavaeeArtifactUtil.getInstance().getArtifactsContainingFacet((JavaeeFacet)webFacet, context, types, false)) {
                                artifactManager.addElementsToDirectory(artifact, "VAADIN/widgetsets", (PackagingElement)new GwtCompilerOutputElement(project, gwtFacet));
                            }
                        }
                    }
                }.execute();
            }
            if (this.myValidator.canClose(name)) {
                this.close(0);
            }
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel;
        JTextField jTextField;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Enter name for new widget:");
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
        this.myGwtSdkPathPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null, 1));
        this.mySetupGwtSdkLabel = jLabel = new JLabel();
        jLabel.setText("Custom widget requires a GWT SDK. Specify path to GWT installation:");
        jPanel2.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

