/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.google.common.collect.Sets;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsAdapter;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.options.FontSize;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.HashMap;
import com.jediterm.pty.PtyProcessTtyConnector;
import com.jediterm.terminal.TerminalColor;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.emulator.ColorPalette;
import com.jediterm.terminal.ui.settings.DefaultTabbedSettingsProvider;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.KeyStroke;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.JBTerminalSchemeColorPalette;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalSettingsListener;

public class JBTerminalSystemSettingsProvider
extends DefaultTabbedSettingsProvider
implements Disposable {
    private Set<TerminalSettingsListener> myListeners = Sets.newHashSet();
    private final MyColorSchemeDelegate myColorScheme = JBTerminalSystemSettingsProvider.createBoundColorSchemeDelegate(null);

    public JBTerminalSystemSettingsProvider() {
        UISettings.getInstance().addUISettingsListener(new UISettingsListener(){

            public void uiSettingsChanged(UISettings source) {
                int size = JBTerminalSystemSettingsProvider.consoleFontSize(JBTerminalSystemSettingsProvider.this.myColorScheme);
                if (JBTerminalSystemSettingsProvider.this.myColorScheme.getConsoleFontSize() != size) {
                    JBTerminalSystemSettingsProvider.this.myColorScheme.setConsoleFontSize(size);
                    JBTerminalSystemSettingsProvider.this.fireFontChanged();
                }
            }
        }, (Disposable)this);
        EditorColorsManager.getInstance().addEditorColorsListener((EditorColorsListener)new EditorColorsAdapter(){

            public void globalSchemeChange(EditorColorsScheme scheme) {
                JBTerminalSystemSettingsProvider.this.myColorScheme.updateGlobalScheme(scheme);
                JBTerminalSystemSettingsProvider.this.fireFontChanged();
            }
        }, (Disposable)this);
    }

    private static int consoleFontSize(MyColorSchemeDelegate colorScheme) {
        int size = UISettings.getInstance().PRESENTATION_MODE ? UISettings.getInstance().PRESENTATION_MODE_FONT_SIZE : colorScheme.getGlobal().getConsoleFontSize();
        return size;
    }

    public KeyStroke[] getCopyKeyStrokes() {
        return this.getKeyStrokesByActionId("$Copy");
    }

    public KeyStroke[] getPasteKeyStrokes() {
        return this.getKeyStrokesByActionId("$Paste");
    }

    public KeyStroke[] getNextTabKeyStrokes() {
        return this.getKeyStrokesByActionId("NextTab");
    }

    public KeyStroke[] getPreviousTabKeyStrokes() {
        return this.getKeyStrokesByActionId("PreviousTab");
    }

    public KeyStroke[] getFindKeyStrokes() {
        return this.getKeyStrokesByActionId("Find");
    }

    public ColorPalette getTerminalColorPalette() {
        return new JBTerminalSchemeColorPalette(this.myColorScheme);
    }

    private KeyStroke[] getKeyStrokesByActionId(String actionId) {
        Shortcut[] shortcuts;
        ArrayList<KeyStroke> keyStrokes = new ArrayList<KeyStroke>();
        for (Shortcut sc : shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts(actionId)) {
            if (!(sc instanceof KeyboardShortcut)) continue;
            KeyStroke ks = ((KeyboardShortcut)sc).getFirstKeyStroke();
            keyStrokes.add(ks);
        }
        return keyStrokes.toArray(new KeyStroke[keyStrokes.size()]);
    }

    public boolean shouldCloseTabOnLogout(TtyConnector ttyConnector) {
        return TerminalOptionsProvider.getInstance().closeSessionOnLogout();
    }

    public String tabName(TtyConnector ttyConnector, String sessionName) {
        if (ttyConnector instanceof PtyProcessTtyConnector) {
            return TerminalOptionsProvider.getInstance().getTabName();
        }
        return sessionName;
    }

    public float getLineSpace() {
        return this.myColorScheme.getConsoleLineSpacing();
    }

    public boolean useInverseSelectionColor() {
        return false;
    }

    public TextStyle getSelectionColor() {
        return new TextStyle(TerminalColor.awt((Color)this.myColorScheme.getColor(EditorColors.SELECTION_FOREGROUND_COLOR)), TerminalColor.awt((Color)this.myColorScheme.getColor(EditorColors.SELECTION_BACKGROUND_COLOR)));
    }

    public TextStyle getFoundPatternColor() {
        return new TextStyle(TerminalColor.awt((Color)this.myColorScheme.getAttributes(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES).getForegroundColor()), TerminalColor.awt((Color)this.myColorScheme.getAttributes(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES).getBackgroundColor()));
    }

    public TextStyle getDefaultStyle() {
        return new TextStyle(TerminalColor.awt((Color)this.myColorScheme.getDefaultForeground()), TerminalColor.awt((Color)this.myColorScheme.getDefaultBackground()));
    }

    public Font getTerminalFont() {
        Font normalFont = Font.decode(this.getFontName());
        if (normalFont == null) {
            normalFont = super.getTerminalFont();
        }
        normalFont = normalFont.deriveFont(this.getTerminalFontSize());
        return normalFont;
    }

    public String getFontName() {
        List fonts = this.myColorScheme.getConsoleFontPreferences().getEffectiveFontFamilies();
        if (fonts.size() > 0) {
            return (String)fonts.get(0);
        }
        return "Monospaced-14";
    }

    public float getTerminalFontSize() {
        return this.myColorScheme.getConsoleFontSize();
    }

    public boolean useAntialiasing() {
        return true;
    }

    public int caretBlinkingMs() {
        if (!EditorSettingsExternalizable.getInstance().isBlinkCaret()) {
            return 0;
        }
        return EditorSettingsExternalizable.getInstance().getBlinkPeriod();
    }

    public int getBufferMaxLinesCount() {
        int linesCount = Registry.get((String)"terminal.buffer.max.lines.count").asInteger();
        if (linesCount > 0) {
            return linesCount;
        }
        return super.getBufferMaxLinesCount();
    }

    public EditorColorsScheme getColorScheme() {
        return this.myColorScheme;
    }

    public boolean audibleBell() {
        return TerminalOptionsProvider.getInstance().audibleBell();
    }

    public boolean enableMouseReporting() {
        return TerminalOptionsProvider.getInstance().enableMouseReporting();
    }

    public boolean copyOnSelect() {
        return TerminalOptionsProvider.getInstance().copyOnSelection();
    }

    public boolean pasteOnMiddleMouseClick() {
        return TerminalOptionsProvider.getInstance().pasteOnMiddleMouseButton();
    }

    @NotNull
    private static MyColorSchemeDelegate createBoundColorSchemeDelegate(@Nullable EditorColorsScheme customGlobalScheme) {
        MyColorSchemeDelegate myColorSchemeDelegate = new MyColorSchemeDelegate(customGlobalScheme);
        if (myColorSchemeDelegate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/terminal/JBTerminalSystemSettingsProvider", "createBoundColorSchemeDelegate"));
        }
        return myColorSchemeDelegate;
    }

    public boolean forceActionOnMouseReporting() {
        return true;
    }

    public void dispose() {
    }

    public void addListener(TerminalSettingsListener listener) {
        this.myListeners.add(listener);
    }

    public void removeListener(TerminalSettingsListener listener) {
        this.myListeners.remove(listener);
    }

    public void fireFontChanged() {
        for (TerminalSettingsListener l : this.myListeners) {
            l.fontChanged();
        }
    }

    private static class MyColorSchemeDelegate
    implements EditorColorsScheme {
        private final FontPreferences myFontPreferences = new FontPreferences();
        private final HashMap<TextAttributesKey, TextAttributes> myOwnAttributes = new HashMap();
        private final HashMap<ColorKey, Color> myOwnColors = new HashMap();
        private Map<EditorFontType, Font> myFontsMap = null;
        private String myFaceName = null;
        private EditorColorsScheme myGlobalScheme;
        private int myConsoleFontSize;

        private MyColorSchemeDelegate(@Nullable EditorColorsScheme globalScheme) {
            this.updateGlobalScheme(globalScheme);
            this.myConsoleFontSize = JBTerminalSystemSettingsProvider.consoleFontSize(this);
            this.initFonts();
        }

        private EditorColorsScheme getGlobal() {
            return this.myGlobalScheme;
        }

        @NotNull
        public String getName() {
            String string = this.getGlobal().getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/terminal/JBTerminalSystemSettingsProvider$MyColorSchemeDelegate", "getName"));
            }
            return string;
        }

        protected void initFonts() {
            String consoleFontName = this.getConsoleFontName();
            int consoleFontSize = this.getConsoleFontSize();
            this.myFontPreferences.clear();
            this.myFontPreferences.register(consoleFontName, consoleFontSize);
            this.myFontsMap = new EnumMap<EditorFontType, Font>(EditorFontType.class);
            Font plainFont = new Font(consoleFontName, 0, consoleFontSize);
            Font boldFont = new Font(consoleFontName, 1, consoleFontSize);
            Font italicFont = new Font(consoleFontName, 2, consoleFontSize);
            Font boldItalicFont = new Font(consoleFontName, 3, consoleFontSize);
            this.myFontsMap.put(EditorFontType.PLAIN, plainFont);
            this.myFontsMap.put(EditorFontType.BOLD, boldFont);
            this.myFontsMap.put(EditorFontType.ITALIC, italicFont);
            this.myFontsMap.put(EditorFontType.BOLD_ITALIC, boldItalicFont);
        }

        public void setName(String name) {
            this.getGlobal().setName(name);
        }

        public TextAttributes getAttributes(TextAttributesKey key) {
            if (this.myOwnAttributes.containsKey((Object)key)) {
                return (TextAttributes)this.myOwnAttributes.get((Object)key);
            }
            return this.getGlobal().getAttributes(key);
        }

        public void setAttributes(TextAttributesKey key, TextAttributes attributes) {
            this.myOwnAttributes.put((Object)key, (Object)attributes);
        }

        @NotNull
        public Color getDefaultBackground() {
            Color color = this.getGlobal().getColor(ConsoleViewContentType.CONSOLE_BACKGROUND_KEY);
            Color color2 = color != null ? color : this.getGlobal().getDefaultBackground();
            if (color2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/terminal/JBTerminalSystemSettingsProvider$MyColorSchemeDelegate", "getDefaultBackground"));
            }
            return color2;
        }

        @NotNull
        public Color getDefaultForeground() {
            Color foregroundColor = this.getGlobal().getAttributes(ConsoleViewContentType.NORMAL_OUTPUT_KEY).getForegroundColor();
            Color color = foregroundColor != null ? foregroundColor : this.getGlobal().getDefaultForeground();
            if (color == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/terminal/JBTerminalSystemSettingsProvider$MyColorSchemeDelegate", "getDefaultForeground"));
            }
            return color;
        }

        public Color getColor(ColorKey key) {
            if (this.myOwnColors.containsKey((Object)key)) {
                return (Color)this.myOwnColors.get((Object)key);
            }
            return this.getGlobal().getColor(key);
        }

        public void setColor(ColorKey key, Color color) {
            this.myOwnColors.put((Object)key, (Object)color);
        }

        @NotNull
        public FontPreferences getFontPreferences() {
            FontPreferences fontPreferences = this.myGlobalScheme.getFontPreferences();
            if (fontPreferences == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/terminal/JBTerminalSystemSettingsProvider$MyColorSchemeDelegate", "getFontPreferences"));
            }
            return fontPreferences;
        }

        public void setFontPreferences(@NotNull FontPreferences preferences) {
            if (preferences == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "org/jetbrains/plugins/terminal/JBTerminalSystemSettingsProvider$MyColorSchemeDelegate", "setFontPreferences"));
            }
            throw new IllegalStateException();
        }

        public int getEditorFontSize() {
            return this.getGlobal().getEditorFontSize();
        }

        public void setEditorFontSize(int fontSize) {
        }

        public FontSize getQuickDocFontSize() {
            return this.myGlobalScheme.getQuickDocFontSize();
        }

        public void setQuickDocFontSize(@NotNull FontSize fontSize) {
            if (fontSize == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontSize", "org/jetbrains/plugins/terminal/JBTerminalSystemSettingsProvider$MyColorSchemeDelegate", "setQuickDocFontSize"));
            }
            this.myGlobalScheme.setQuickDocFontSize(fontSize);
        }

        public String getEditorFontName() {
            return this.getGlobal().getEditorFontName();
        }

        public void setEditorFontName(String fontName) {
            throw new IllegalStateException();
        }

        public Font getFont(EditorFontType key) {
            Font font;
            if (this.myFontsMap != null && (font = this.myFontsMap.get(key)) != null) {
                return font;
            }
            return this.getGlobal().getFont(key);
        }

        public void setFont(EditorFontType key, Font font) {
            if (this.myFontsMap == null) {
                this.initFonts();
            }
            this.myFontsMap.put(key, font);
        }

        public float getLineSpacing() {
            return this.getGlobal().getLineSpacing();
        }

        public void setLineSpacing(float lineSpacing) {
            this.getGlobal().setLineSpacing(lineSpacing);
        }

        @Nullable
        public Object clone() {
            return null;
        }

        public void readExternal(Element element) {
        }

        public void updateGlobalScheme(EditorColorsScheme scheme) {
            this.myFontsMap = null;
            this.myGlobalScheme = scheme == null ? EditorColorsManager.getInstance().getGlobalScheme() : scheme;
        }

        @NotNull
        public FontPreferences getConsoleFontPreferences() {
            FontPreferences fontPreferences = this.myFontPreferences;
            if (fontPreferences == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/terminal/JBTerminalSystemSettingsProvider$MyColorSchemeDelegate", "getConsoleFontPreferences"));
            }
            return fontPreferences;
        }

        public void setConsoleFontPreferences(@NotNull FontPreferences preferences) {
            if (preferences == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "org/jetbrains/plugins/terminal/JBTerminalSystemSettingsProvider$MyColorSchemeDelegate", "setConsoleFontPreferences"));
            }
            preferences.copyTo(this.myFontPreferences);
            this.initFonts();
        }

        public String getConsoleFontName() {
            if (this.myFaceName == null) {
                return this.getGlobal().getConsoleFontName();
            }
            return this.myFaceName;
        }

        public void setConsoleFontName(String fontName) {
            this.myFaceName = fontName;
            this.initFonts();
        }

        public int getConsoleFontSize() {
            if (this.myConsoleFontSize == -1) {
                return this.getGlobal().getConsoleFontSize();
            }
            return this.myConsoleFontSize;
        }

        public void setConsoleFontSize(int fontSize) {
            this.myConsoleFontSize = fontSize;
            this.initFonts();
        }

        public float getConsoleLineSpacing() {
            return this.getGlobal().getConsoleLineSpacing();
        }

        public void setConsoleLineSpacing(float lineSpacing) {
            this.getGlobal().setConsoleLineSpacing(lineSpacing);
        }

        @NotNull
        public Properties getMetaProperties() {
            Properties properties = this.myGlobalScheme.getMetaProperties();
            if (properties == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/terminal/JBTerminalSystemSettingsProvider$MyColorSchemeDelegate", "getMetaProperties"));
            }
            return properties;
        }
    }
}

