/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.google.common.collect.Lists;
import com.intellij.execution.TaskExecutor;
import com.intellij.execution.configurations.EncodingEnvironmentUtil;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessWaitFor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.HashMap;
import com.jediterm.pty.PtyProcessTtyConnector;
import com.jediterm.terminal.TtyConnector;
import com.pty4j.PtyProcess;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;

public class LocalTerminalDirectRunner
extends AbstractTerminalRunner<PtyProcess> {
    private static final Logger LOG = Logger.getInstance(LocalTerminalDirectRunner.class);
    private final Charset myDefaultCharset = CharsetToolkit.UTF8_CHARSET;

    public LocalTerminalDirectRunner(Project project) {
        super(project);
    }

    private static boolean hasLoginArgument(String name) {
        return name.equals("bash") || name.equals("sh") || name.equals("zsh");
    }

    private static String getShellName(String path) {
        return new File(path).getName();
    }

    private static String findRCFile(String shellName) {
        if (shellName != null) {
            if ("bash".equals(shellName)) {
                shellName = "sh";
            }
            try {
                URL resource = LocalTerminalDirectRunner.class.getClassLoader().getResource("jediterm-" + shellName + ".in");
                if (resource != null) {
                    URI uri = resource.toURI();
                    return uri.getPath();
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to find jediterm-" + shellName + ".in configuration file", (Throwable)e);
            }
        }
        return null;
    }

    @NotNull
    public static LocalTerminalDirectRunner createTerminalRunner(Project project) {
        LocalTerminalDirectRunner localTerminalDirectRunner = new LocalTerminalDirectRunner(project);
        if (localTerminalDirectRunner == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner", "createTerminalRunner"));
        }
        return localTerminalDirectRunner;
    }

    @Override
    protected PtyProcess createProcess(@Nullable String directory) throws ExecutionException {
        HashMap envs = new HashMap(System.getenv());
        if (!SystemInfo.isWindows) {
            envs.put("TERM", "xterm-256color");
        }
        EncodingEnvironmentUtil.setLocaleEnvironmentIfMac((Map)envs, (Charset)this.myDefaultCharset);
        String[] command = this.getCommand();
        for (LocalTerminalCustomizer customizer : (LocalTerminalCustomizer[])LocalTerminalCustomizer.EP_NAME.getExtensions()) {
            command = customizer.customizeCommandAndEnvironment(this.myProject, command, (Map<String, String>)envs);
            if (directory != null) continue;
            directory = customizer.getDefaultFolder();
        }
        try {
            return PtyProcess.exec((String[])command, (Map)envs, (String)(directory != null ? directory : this.currentProjectFolder()));
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
    }

    private String currentProjectFolder() {
        VirtualFile baseDir;
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.myProject);
        VirtualFile[] roots = projectRootManager.getContentRoots();
        if (roots.length == 1) {
            roots[0].getCanonicalPath();
        }
        return (baseDir = this.myProject.getBaseDir()) == null ? null : baseDir.getCanonicalPath();
    }

    @Override
    protected ProcessHandler createProcessHandler(PtyProcess process) {
        return new PtyProcessHandler(process, this.getCommand()[0]);
    }

    @Override
    protected TtyConnector createTtyConnector(PtyProcess process) {
        return new PtyProcessTtyConnector(process, this.myDefaultCharset);
    }

    @Override
    public String runningTargetName() {
        return "Local Terminal";
    }

    @Override
    protected String getTerminalConnectionName(PtyProcess process) {
        return "Local Terminal";
    }

    public String[] getCommand() {
        String shellPath = TerminalOptionsProvider.getInstance().getShellPath();
        return LocalTerminalDirectRunner.getCommand(shellPath);
    }

    @NotNull
    public static String[] getCommand(String shellPath) {
        if (SystemInfo.isUnix) {
            String shellName;
            ArrayList command = Lists.newArrayList((Object[])shellPath.split(" "));
            String string = shellName = command.size() > 0 ? LocalTerminalDirectRunner.getShellName((String)command.get(0)) : null;
            if (shellName != null) {
                command.remove(0);
                ArrayList result = Lists.newArrayList((Object[])new String[]{shellName});
                String rcFilePath = LocalTerminalDirectRunner.findRCFile(shellName);
                if (rcFilePath != null && TerminalOptionsProvider.getInstance().shellIntegration() && (shellName.equals("bash") || shellName.equals("sh"))) {
                    result.add("--rcfile");
                    result.add(rcFilePath);
                }
                if (!LocalTerminalDirectRunner.loginOrInteractive(command)) {
                    if (LocalTerminalDirectRunner.hasLoginArgument(shellName) && SystemInfo.isMac) {
                        result.add("--login");
                    }
                    result.add("-i");
                }
                result.addAll(command);
                String[] stringArray = ArrayUtil.toStringArray((Collection)result);
                if (stringArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner", "getCommand"));
                }
                return stringArray;
            }
            String[] stringArray = ArrayUtil.toStringArray((Collection)command);
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner", "getCommand"));
            }
            return stringArray;
        }
        String[] stringArray = new String[]{shellPath};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner", "getCommand"));
        }
        return stringArray;
    }

    private static boolean loginOrInteractive(List<String> command) {
        return command.contains("-i") || command.contains("--login") || command.contains("-l");
    }

    private static class PtyProcessHandler
    extends ProcessHandler
    implements TaskExecutor {
        private final PtyProcess myProcess;
        private final ProcessWaitFor myWaitFor;

        public PtyProcessHandler(PtyProcess process, @NotNull String presentableName) {
            if (presentableName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner$PtyProcessHandler", "<init>"));
            }
            this.myProcess = process;
            this.myWaitFor = new ProcessWaitFor((Process)process, (TaskExecutor)this, presentableName);
        }

        public void startNotify() {
            this.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(ProcessEvent event) {
                    try {
                        myWaitFor.setTerminationCallback(integer -> this.notifyProcessTerminated(integer));
                    }
                    finally {
                        this.removeProcessListener((ProcessListener)this);
                    }
                }
            });
            super.startNotify();
        }

        protected void destroyProcessImpl() {
            this.myProcess.destroy();
        }

        protected void detachProcessImpl() {
            this.destroyProcessImpl();
        }

        public boolean detachIsDefault() {
            return false;
        }

        public boolean isSilentlyDestroyOnClose() {
            return true;
        }

        @Nullable
        public OutputStream getProcessInput() {
            return this.myProcess.getOutputStream();
        }

        @NotNull
        public Future<?> executeTask(@NotNull Runnable task) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner$PtyProcessHandler", "executeTask"));
            }
            Future<?> future = AppExecutorUtil.getAppExecutorService().submit(task);
            if (future == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner$PtyProcessHandler", "executeTask"));
            }
            return future;
        }
    }
}

