/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.chart;

import com.intellij.chart.layout.ChartLayoutCoordinator;
import com.intellij.chart.render.size.ChartNodeSizeEnhancer;
import com.intellij.jboss.jbpm.BpmnUtils;
import com.intellij.jboss.jbpm.chart.model.BpmnChartDataModel;
import com.intellij.jboss.jbpm.chart.model.BpmnChartEdge;
import com.intellij.jboss.jbpm.chart.model.BpmnChartNode;
import com.intellij.jboss.jbpm.model.xml.bpmndc.Bounds;
import com.intellij.jboss.jbpm.model.xml.bpmndc.Point;
import com.intellij.jboss.jbpm.model.xml.bpmndi.BPMNEdge;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BpmnChartLayoutCoordinator
implements ChartLayoutCoordinator {
    @NotNull
    private final Project project;
    @NotNull
    private final BpmnChartDataModel dataModel;

    public BpmnChartLayoutCoordinator(@NotNull Project project, @NotNull BpmnChartDataModel dataModel) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jboss/jbpm/chart/BpmnChartLayoutCoordinator", "<init>"));
        }
        if (dataModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataModel", "com/intellij/jboss/jbpm/chart/BpmnChartLayoutCoordinator", "<init>"));
        }
        this.project = project;
        this.dataModel = dataModel;
    }

    @Nullable
    public List<ChartLayoutCoordinator.Point> getEdgePoints(@NotNull String sourceNodeId, @NotNull String targetNodeId) {
        if (sourceNodeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceNodeId", "com/intellij/jboss/jbpm/chart/BpmnChartLayoutCoordinator", "getEdgePoints"));
        }
        if (targetNodeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetNodeId", "com/intellij/jboss/jbpm/chart/BpmnChartLayoutCoordinator", "getEdgePoints"));
        }
        BpmnChartEdge chartEdge = (BpmnChartEdge)this.dataModel.getEdge(Pair.create((Object)sourceNodeId, (Object)targetNodeId));
        if (chartEdge == null || chartEdge.getLayout() == null) {
            return null;
        }
        return JBIterable.from(chartEdge.getLayout().getWaypoints()).transform((Function)new Function<Point, ChartLayoutCoordinator.Point>(){

            public ChartLayoutCoordinator.Point fun(Point point) {
                return new ChartLayoutCoordinator.Point(BpmnUtils.getAttributeValue(point.getX()), BpmnUtils.getAttributeValue(point.getY()));
            }
        }).toList();
    }

    @Nullable
    public Runnable getChangeEdgePointsAction(@NotNull String sourceNodeId, @NotNull String targetNodeId, final @NotNull List<ChartLayoutCoordinator.Point> points) {
        if (sourceNodeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceNodeId", "com/intellij/jboss/jbpm/chart/BpmnChartLayoutCoordinator", "getChangeEdgePointsAction"));
        }
        if (targetNodeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetNodeId", "com/intellij/jboss/jbpm/chart/BpmnChartLayoutCoordinator", "getChangeEdgePointsAction"));
        }
        if (points == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "points", "com/intellij/jboss/jbpm/chart/BpmnChartLayoutCoordinator", "getChangeEdgePointsAction"));
        }
        BpmnChartEdge chartEdge = (BpmnChartEdge)this.dataModel.getEdge(Pair.create((Object)sourceNodeId, (Object)targetNodeId));
        if (chartEdge == null) {
            return null;
        }
        final BPMNEdge edgeLayout = chartEdge.getLayout();
        if (edgeLayout == null) {
            return null;
        }
        if (points.equals(this.getEdgePoints(sourceNodeId, targetNodeId))) {
            return null;
        }
        return new Runnable(){

            @Override
            public void run() {
                List<Point> wayPoints = edgeLayout.getWaypoints();
                for (Point point : wayPoints) {
                    point.undefine();
                }
                for (Point point : points) {
                    Point wayPoint = edgeLayout.addWaypoint();
                    wayPoint.getX().setValue((Object)((ChartLayoutCoordinator.Point)point).x);
                    wayPoint.getY().setValue((Object)((ChartLayoutCoordinator.Point)point).y);
                }
            }
        };
    }

    @Nullable
    public ChartLayoutCoordinator.NodeLayout getNodeLayout(@NotNull String fqn, ChartNodeSizeEnhancer enhancer) {
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "com/intellij/jboss/jbpm/chart/BpmnChartLayoutCoordinator", "getNodeLayout"));
        }
        BpmnChartNode chartNode = (BpmnChartNode)this.dataModel.getNode(fqn);
        if (chartNode == null || chartNode.getLayout() == null) {
            return null;
        }
        Bounds bounds = chartNode.getLayout().getBounds();
        return BpmnChartLayoutCoordinator.createNodeLayout(bounds, enhancer);
    }

    @NotNull
    private static ChartLayoutCoordinator.Size createNodeSize(Bounds bounds, @Nullable ChartNodeSizeEnhancer enhancer) {
        ChartLayoutCoordinator.Size size = new ChartLayoutCoordinator.Size(BpmnUtils.getAttributeValue(bounds.getWidth()), BpmnUtils.getAttributeValue(bounds.getHeight()));
        if (enhancer != null) {
            size = enhancer.enhance(size);
        }
        ChartLayoutCoordinator.Size size2 = size;
        if (size2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/chart/BpmnChartLayoutCoordinator", "createNodeSize"));
        }
        return size2;
    }

    @NotNull
    private static ChartLayoutCoordinator.NodeLayout createNodeLayout(Bounds bounds, @Nullable ChartNodeSizeEnhancer enhancer) {
        ChartLayoutCoordinator.Size size = BpmnChartLayoutCoordinator.createNodeSize(bounds, enhancer);
        double x = BpmnUtils.getAttributeValue(bounds.getX());
        double y = BpmnUtils.getAttributeValue(bounds.getY());
        ChartLayoutCoordinator.NodeLayout nodeLayout = ChartLayoutCoordinator.NodeLayout.createByEdges((double)x, (double)y, (double)(x + size.width), (double)(y + size.height));
        if (nodeLayout == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/chart/BpmnChartLayoutCoordinator", "createNodeLayout"));
        }
        return nodeLayout;
    }

    @Nullable
    public Runnable getChangeNodeLayoutAction(final @NotNull String fqn, final @Nullable ChartLayoutCoordinator.NodeLayout layout, @Nullable ChartNodeSizeEnhancer enhancer) {
        ChartLayoutCoordinator.Size newSize;
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "com/intellij/jboss/jbpm/chart/BpmnChartLayoutCoordinator", "getChangeNodeLayoutAction"));
        }
        final BpmnChartNode chartNode = (BpmnChartNode)this.dataModel.getNode(fqn);
        if (chartNode == null) {
            return null;
        }
        if (chartNode.getLayout() == null) {
            if (layout == null) {
                return null;
            }
            return new Runnable(){

                @Override
                public void run() {
                    chartNode.setLayout(BpmnChartLayoutCoordinator.this.dataModel.createNodeShape(fqn, layout.getCenter(), layout.getSize()));
                }
            };
        }
        if (layout == null) {
            return new Runnable(){

                @Override
                public void run() {
                    ((BpmnChartNode)BpmnChartLayoutCoordinator.this.dataModel.getNode(fqn)).removeLayout();
                }
            };
        }
        Bounds bounds = chartNode.getLayout().getBounds();
        ChartLayoutCoordinator.NodeLayout oldLayout = BpmnChartLayoutCoordinator.createNodeLayout(bounds, enhancer);
        if (oldLayout.equals((Object)layout)) {
            return null;
        }
        ChartLayoutCoordinator.Size oldSize = BpmnChartLayoutCoordinator.createNodeSize(bounds, enhancer);
        final boolean resizeNode = !oldSize.equals((Object)(newSize = new ChartLayoutCoordinator.Size(layout.getWidth(), layout.getHeight())));
        return new Runnable(){

            @Override
            public void run() {
                Bounds bounds = chartNode.getLayout().getBounds();
                bounds.getX().setValue((Object)layout.getLeft());
                bounds.getY().setValue((Object)layout.getTop());
                if (resizeNode) {
                    bounds.getWidth().setValue((Object)layout.getWidth());
                    bounds.getHeight().setValue((Object)layout.getHeight());
                }
            }
        };
    }
}

