/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.chart.dnd;

import com.intellij.chart.dnd.ChartDnDNodeDefinition;
import com.intellij.jboss.jbpm.BpmnBundle;
import com.intellij.jboss.jbpm.chart.dnd.BpmnDnDUtils;
import com.intellij.jboss.jbpm.chart.model.BpmnChartDataModel;
import com.intellij.jboss.jbpm.chart.model.BpmnChartNode;
import com.intellij.jboss.jbpm.model.xml.bpmn20.EventDefinitionExplicitOwner;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TBaseElement;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TEventDefinition;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TFlowElement;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TFlowNode;
import com.intellij.util.Function;
import icons.JbpmIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum BpmnDnDNodeType implements ChartDnDNodeDefinition<TFlowElement, BpmnChartNode, BpmnChartDataModel>
{
    StartEvents("Create.StartEvents", JbpmIcons.Bpmn.Events.Start_16_Empty),
    StartCompensation("Create.Compensation", JbpmIcons.Bpmn.Events.Start_16_Compensation, BpmnDnDUtils.createStartEventFn, BpmnDnDUtils.createCompensateEventDefinitionFn),
    StartConditional("Create.Conditional", JbpmIcons.Bpmn.Events.Start_16_Conditional, BpmnDnDUtils.createStartEventFn, BpmnDnDUtils.createConditionalEventDefinitionFn),
    StartError("Create.Error", JbpmIcons.Bpmn.Events.Start_16_Error, BpmnDnDUtils.createStartEventFn, BpmnDnDUtils.createErrorEventDefinitionFn),
    StartEscalation("Create.Escalation", JbpmIcons.Bpmn.Events.Start_16_Escalation, BpmnDnDUtils.createStartEventFn, BpmnDnDUtils.createEscalationEventDefinitionFn),
    Start("Create.Start", JbpmIcons.Bpmn.Events.Start_16_Empty, BpmnDnDUtils.createStartEventFn, null),
    StartMessage("Create.Message", JbpmIcons.Bpmn.Events.Start_16_Message, BpmnDnDUtils.createStartEventFn, BpmnDnDUtils.createMessageEventDefinitionFn),
    StartSignal("Create.Signal", JbpmIcons.Bpmn.Events.Start_16_Signal, BpmnDnDUtils.createStartEventFn, BpmnDnDUtils.createSignalEventDefinitionFn),
    StartTimer("Create.Timer", JbpmIcons.Bpmn.Events.Start_16_Timer, BpmnDnDUtils.createStartEventFn, BpmnDnDUtils.createTimerEventDefinitionFn),
    IntermediateThrowEvents("Create.IntermediateThrowEvents", JbpmIcons.Bpmn.Events.IntermediateThrow_16_Empty),
    IntermediateThrowCompensation("Create.Compensation", JbpmIcons.Bpmn.Events.IntermediateThrow_16_Compensation, BpmnDnDUtils.createIntermediateThrowEventFn, BpmnDnDUtils.createCompensateEventDefinitionFn),
    IntermediateThrowEscalation("Create.Escalation", JbpmIcons.Bpmn.Events.IntermediateThrow_16_Escalation, BpmnDnDUtils.createIntermediateThrowEventFn, BpmnDnDUtils.createEscalationEventDefinitionFn),
    IntermediateThrow("Create.Intermediate", JbpmIcons.Bpmn.Events.IntermediateThrow_16_Empty, BpmnDnDUtils.createIntermediateThrowEventFn, null),
    IntermediateThrowLink("Create.Link", JbpmIcons.Bpmn.Events.IntermediateThrow_16_Link, BpmnDnDUtils.createIntermediateThrowEventFn, BpmnDnDUtils.createLinkEventDefinitionFn),
    IntermediateThrowMessage("Create.Message", JbpmIcons.Bpmn.Events.IntermediateThrow_16_Message, BpmnDnDUtils.createIntermediateThrowEventFn, BpmnDnDUtils.createMessageEventDefinitionFn),
    IntermediateThrowSignal("Create.Signal", JbpmIcons.Bpmn.Events.IntermediateThrow_16_Signal, BpmnDnDUtils.createIntermediateThrowEventFn, BpmnDnDUtils.createSignalEventDefinitionFn),
    IntermediateCatchEvents("Create.IntermediateCatchEvents", JbpmIcons.Bpmn.Events.IntermediateCatch_16_Empty),
    IntermediateCatchConditional("Create.Conditional", JbpmIcons.Bpmn.Events.IntermediateCatch_16_Conditional, BpmnDnDUtils.createIntermediateCatchEventFn, BpmnDnDUtils.createConditionalEventDefinitionFn),
    IntermediateCatchLink("Create.Link", JbpmIcons.Bpmn.Events.IntermediateCatch_16_Link, BpmnDnDUtils.createIntermediateCatchEventFn, BpmnDnDUtils.createLinkEventDefinitionFn),
    IntermediateCatchMessage("Create.Message", JbpmIcons.Bpmn.Events.IntermediateCatch_16_Message, BpmnDnDUtils.createIntermediateCatchEventFn, BpmnDnDUtils.createMessageEventDefinitionFn),
    IntermediateCatchSignal("Create.Signal", JbpmIcons.Bpmn.Events.IntermediateCatch_16_Signal, BpmnDnDUtils.createIntermediateCatchEventFn, BpmnDnDUtils.createSignalEventDefinitionFn),
    IntermediateCatchTimer("Create.Timer", JbpmIcons.Bpmn.Events.IntermediateCatch_16_Timer, BpmnDnDUtils.createIntermediateCatchEventFn, BpmnDnDUtils.createTimerEventDefinitionFn),
    EndEvents("Create.EndEvents", JbpmIcons.Bpmn.Events.End_16_Empty),
    EndCompensation("Create.Compensation", JbpmIcons.Bpmn.Events.End_16_Compensation, BpmnDnDUtils.createEndEventFn, BpmnDnDUtils.createCompensateEventDefinitionFn),
    End("Create.End", JbpmIcons.Bpmn.Events.End_16_Empty, BpmnDnDUtils.createEndEventFn, null),
    EndError("Create.Error", JbpmIcons.Bpmn.Events.End_16_Error, BpmnDnDUtils.createEndEventFn, BpmnDnDUtils.createErrorEventDefinitionFn),
    EndEscalation("Create.Escalation", JbpmIcons.Bpmn.Events.End_16_Escalation, BpmnDnDUtils.createEndEventFn, BpmnDnDUtils.createEscalationEventDefinitionFn),
    EndMessage("Create.Message", JbpmIcons.Bpmn.Events.End_16_Message, BpmnDnDUtils.createEndEventFn, BpmnDnDUtils.createMessageEventDefinitionFn),
    EndSignal("Create.Signal", JbpmIcons.Bpmn.Events.End_16_Signal, BpmnDnDUtils.createEndEventFn, BpmnDnDUtils.createSignalEventDefinitionFn),
    EndTerminate("Create.Terminate", JbpmIcons.Bpmn.Events.End_16_Terminate, BpmnDnDUtils.createEndEventFn, BpmnDnDUtils.createTerminateEventDefinitionFn),
    Gateways("Create.Gateways", JbpmIcons.Bpmn.Gateways.EventBased),
    GatewayDataBasedExclusive("Create.DataBasedExclusive", JbpmIcons.Bpmn.Gateways.DataBasedExclusive, new Function<BpmnChartDataModel, TFlowNode>(){

        public TFlowNode fun(BpmnChartDataModel model) {
            return model.getProcess().addExclusiveGateway();
        }
    }),
    GatewayEventBased("Create.EventBased", JbpmIcons.Bpmn.Gateways.EventBased, new Function<BpmnChartDataModel, TFlowNode>(){

        public TFlowNode fun(BpmnChartDataModel model) {
            return model.getProcess().addEventBasedGateway();
        }
    }),
    GatewayInclusive("Create.Inclusive", JbpmIcons.Bpmn.Gateways.Inclusive, new Function<BpmnChartDataModel, TFlowNode>(){

        public TFlowNode fun(BpmnChartDataModel model) {
            return model.getProcess().addInclusiveGateway();
        }
    }),
    GatewayParallel("Create.Parallel", JbpmIcons.Bpmn.Gateways.Parallel, new Function<BpmnChartDataModel, TFlowNode>(){

        public TFlowNode fun(BpmnChartDataModel model) {
            return model.getProcess().addParallelGateway();
        }
    }),
    Tasks("Create.Task", JbpmIcons.Bpmn.Tasks.Task),
    ServiceTask("ServiceTask", JbpmIcons.Bpmn.Tasks.ServiceTask, new Function<BpmnChartDataModel, TFlowNode>(){

        public TFlowNode fun(BpmnChartDataModel model) {
            return model.getProcess().addServiceTask();
        }
    });

    private final boolean isLeaf;
    @NotNull
    private final String name;
    @NotNull
    private final Icon icon;
    @Nullable
    private final Function<BpmnChartDataModel, BpmnChartNode> createFunction;

    private BpmnDnDNodeType(@NotNull String name, Icon icon, final Function<BpmnChartDataModel, TFlowNode> createFunction) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/jboss/jbpm/chart/dnd/BpmnDnDNodeType", "<init>"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/jboss/jbpm/chart/dnd/BpmnDnDNodeType", "<init>"));
        }
        if (createFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "createFunction", "com/intellij/jboss/jbpm/chart/dnd/BpmnDnDNodeType", "<init>"));
        }
        this.isLeaf = true;
        this.name = name;
        this.icon = icon;
        this.createFunction = new Function<BpmnChartDataModel, BpmnChartNode>(){

            public BpmnChartNode fun(BpmnChartDataModel model) {
                return model.addElement((TFlowElement)BpmnDnDUtils.createIdAndName(model, (TBaseElement)createFunction.fun((Object)model)));
            }
        };
    }

    private BpmnDnDNodeType(@NotNull String name, @Nullable Icon icon, final BpmnDnDUtils.CreateEventFn createEventFn, final BpmnDnDUtils.CreateEventDefinitionFn createEventDefinitionFn) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/jboss/jbpm/chart/dnd/BpmnDnDNodeType", "<init>"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/jboss/jbpm/chart/dnd/BpmnDnDNodeType", "<init>"));
        }
        if (createEventFn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "createEventFn", "com/intellij/jboss/jbpm/chart/dnd/BpmnDnDNodeType", "<init>"));
        }
        this.isLeaf = true;
        this.name = name;
        this.icon = icon;
        this.createFunction = new Function<BpmnChartDataModel, BpmnChartNode>(){

            public BpmnChartNode fun(BpmnChartDataModel model) {
                EventDefinitionExplicitOwner eventDefinitionExplicitOwner = (EventDefinitionExplicitOwner)createEventFn.fun((Object)model);
                return model.addElement(BpmnDnDUtils.createIdsAndNames(model, eventDefinitionExplicitOwner, createEventDefinitionFn == null ? null : (TEventDefinition)createEventDefinitionFn.fun(eventDefinitionExplicitOwner)));
            }
        };
    }

    private BpmnDnDNodeType(String name, Icon icon) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/jboss/jbpm/chart/dnd/BpmnDnDNodeType", "<init>"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/jboss/jbpm/chart/dnd/BpmnDnDNodeType", "<init>"));
        }
        this.isLeaf = false;
        this.name = name;
        this.icon = icon;
        this.createFunction = null;
    }

    @NotNull
    public String getName() {
        String string = BpmnBundle.message(this.name, new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/chart/dnd/BpmnDnDNodeType", "getName"));
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = this.icon;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/chart/dnd/BpmnDnDNodeType", "getIcon"));
        }
        return icon;
    }

    @Nullable
    public Function<BpmnChartDataModel, BpmnChartNode> getCreateFunction() {
        return this.createFunction;
    }

    public boolean isLeafNode() {
        return this.isLeaf;
    }
}

