/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.chart.dnd;

import com.intellij.chart.annotation.AnnotationCoordinator;
import com.intellij.jboss.jbpm.chart.model.BpmnChartDataModel;
import com.intellij.jboss.jbpm.model.render.annotation.DefaultNamePrefix;
import com.intellij.jboss.jbpm.model.xml.bpmn20.EventDefinitionExplicitOwner;
import com.intellij.jboss.jbpm.model.xml.bpmn20.NameAttributedElement;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TBaseElement;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TCompensateEventDefinition;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TConditionalEventDefinition;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TEvent;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TEventDefinition;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TFlowNode;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;

class BpmnDnDUtils {
    private static AnnotationCoordinator<DefaultNamePrefix> namePrefixCoordinator = new AnnotationCoordinator(DefaultNamePrefix.class);
    static CreateEventFn createStartEventFn = new CreateEventFn(){

        public EventDefinitionExplicitOwner fun(BpmnChartDataModel model) {
            return model.getProcess() == null ? null : model.getProcess().addStartEvent();
        }
    };
    static CreateEventFn createIntermediateThrowEventFn = new CreateEventFn(){

        public EventDefinitionExplicitOwner fun(BpmnChartDataModel model) {
            return model.getProcess() == null ? null : model.getProcess().addIntermediateThrowEvent();
        }
    };
    static CreateEventFn createIntermediateCatchEventFn = new CreateEventFn(){

        public EventDefinitionExplicitOwner fun(BpmnChartDataModel model) {
            return model.getProcess() == null ? null : model.getProcess().addIntermediateCatchEvent();
        }
    };
    static CreateEventFn createEndEventFn = new CreateEventFn(){

        public EventDefinitionExplicitOwner fun(BpmnChartDataModel model) {
            return model.getProcess() == null ? null : model.getProcess().addEndEvent();
        }
    };
    static CreateEventDefinitionFn createCancelEventDefinitionFn = new CreateEventDefinitionFn(){

        public TEventDefinition fun(EventDefinitionExplicitOwner event) {
            return event.addCancelEventDefinition();
        }
    };
    static CreateEventDefinitionFn createCompensateEventDefinitionFn = new CreateEventDefinitionFn(){

        public TEventDefinition fun(EventDefinitionExplicitOwner event) {
            TCompensateEventDefinition definition = event.addCompensateEventDefinition();
            definition.getWaitForCompletion().setValue((Object)false);
            return definition;
        }
    };
    static CreateEventDefinitionFn createConditionalEventDefinitionFn = new CreateEventDefinitionFn(){

        public TEventDefinition fun(EventDefinitionExplicitOwner event) {
            TConditionalEventDefinition definition = event.addConditionalEventDefinition();
            definition.getCondition().setValue((Object)"true");
            return definition;
        }
    };
    static CreateEventDefinitionFn createErrorEventDefinitionFn = new CreateEventDefinitionFn(){

        public TEventDefinition fun(EventDefinitionExplicitOwner event) {
            return event.addErrorEventDefinition();
        }
    };
    static CreateEventDefinitionFn createEscalationEventDefinitionFn = new CreateEventDefinitionFn(){

        public TEventDefinition fun(EventDefinitionExplicitOwner event) {
            return event.addEscalationEventDefinition();
        }
    };
    static CreateEventDefinitionFn createLinkEventDefinitionFn = new CreateEventDefinitionFn(){

        public TEventDefinition fun(EventDefinitionExplicitOwner event) {
            return event.addLinkEventDefinition();
        }
    };
    static CreateEventDefinitionFn createMessageEventDefinitionFn = new CreateEventDefinitionFn(){

        public TEventDefinition fun(EventDefinitionExplicitOwner event) {
            return event.addMessageEventDefinition();
        }
    };
    static CreateEventDefinitionFn createSignalEventDefinitionFn = new CreateEventDefinitionFn(){

        public TEventDefinition fun(EventDefinitionExplicitOwner event) {
            return event.addSignalEventDefinition();
        }
    };
    static CreateEventDefinitionFn createTerminateEventDefinitionFn = new CreateEventDefinitionFn(){

        public TEventDefinition fun(EventDefinitionExplicitOwner event) {
            return event.addTerminateEventDefinition();
        }
    };
    static CreateEventDefinitionFn createTimerEventDefinitionFn = new CreateEventDefinitionFn(){

        public TEventDefinition fun(EventDefinitionExplicitOwner event) {
            return event.addTimerEventDefinition();
        }
    };

    BpmnDnDUtils() {
    }

    static TFlowNode createIdsAndNames(BpmnChartDataModel model, TEvent event, TEventDefinition eventDefinition) {
        BpmnDnDUtils.createIdAndName(model, event);
        if (eventDefinition != null) {
            BpmnDnDUtils.createIdAndName(model, eventDefinition);
        }
        return event;
    }

    static <T extends TBaseElement> T createIdAndName(BpmnChartDataModel model, T element) {
        DefaultNamePrefix annotation = (DefaultNamePrefix)namePrefixCoordinator.getAnnotation(element.getClass());
        String namePrefix = annotation == null ? "Event" : annotation.value();
        Pair<String, String> idAndName = model.createUniqueNodeIdAndName(namePrefix);
        element.getId().setStringValue((String)idAndName.first);
        if (element instanceof NameAttributedElement) {
            ((NameAttributedElement)((Object)element)).getName().setStringValue((String)idAndName.second);
        }
        return element;
    }

    static interface CreateEventDefinitionFn
    extends Function<EventDefinitionExplicitOwner, TEventDefinition> {
    }

    static interface CreateFlowNodeFn
    extends Function<BpmnChartDataModel, TFlowNode> {
    }

    static interface CreateEventFn
    extends Function<BpmnChartDataModel, EventDefinitionExplicitOwner> {
    }
}

