/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.model.xml.bpmn20;

import com.intellij.jboss.jbpm.model.xml.bpmn20.TDataOutput;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TInputOutputSpecification;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TOutputSet;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionalAndWhileExecutingOutputRefConvertor
extends ResolvingConverter<TDataOutput> {
    @NotNull
    public Collection<TDataOutput> getVariants(ConvertContext context) {
        List<TDataOutput> impl = this.getVariantsImpl(context);
        List<Object> list = impl == null ? Collections.emptyList() : impl;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/model/xml/bpmn20/OptionalAndWhileExecutingOutputRefConvertor", "getVariants"));
        }
        return list;
    }

    private List<TDataOutput> getVariantsImpl(ConvertContext context) {
        DomElement element = context.getInvocationElement();
        DomElement outputSet = element.getParent();
        if (outputSet == null || !TOutputSet.class.equals((Object)outputSet.getDomElementType())) {
            return null;
        }
        DomElement ioSpecDomElement = outputSet.getParent();
        if (ioSpecDomElement == null || !TInputOutputSpecification.class.equals((Object)ioSpecDomElement.getDomElementType())) {
            return null;
        }
        ArrayList<TDataOutput> result = new ArrayList<TDataOutput>();
        List<GenericDomValue<TDataOutput>> inputRefses = ((TOutputSet)outputSet).getDataOutputRefses();
        for (GenericDomValue<TDataOutput> refse : inputRefses) {
            TDataOutput value;
            if (!refse.isValid() || (value = (TDataOutput)refse.getValue()) == null || !value.isValid()) continue;
            result.add(value);
        }
        return result;
    }

    public TDataOutput fromString(@Nullable @NonNls String s, ConvertContext context) {
        List<TDataOutput> impl = this.getVariantsImpl(context);
        if (impl == null) {
            return null;
        }
        for (TDataOutput output : impl) {
            if (!output.getId().isValid() || !Comparing.equal((String)output.getId().getStringValue(), (String)s)) continue;
            return output;
        }
        return null;
    }

    public String toString(@Nullable TDataOutput output, ConvertContext context) {
        return output == null ? null : output.getId().getStringValue();
    }
}

