/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jpdl.actions;

import com.intellij.jboss.jpdl.resources.messages.JpdlBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public class CreateJpdlDialog
extends DialogWrapper {
    private JPanel myContentPane;
    private JTextField myFileName;
    private JTextField myProcessName;
    private final InputValidator myValidator;
    private boolean myProcessNameWasEdited;

    public CreateJpdlDialog(@Nullable Project project, InputValidator validator) {
        super(project, true);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(JpdlBundle.message("create.jpdl.process.dialog.title", objectArray));
        this.myValidator = validator;
        this.myFileName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                CreateJpdlDialog.this.recalculateTextAndValidity();
            }
        });
        this.myFileName.addInputMethodListener(new InputMethodListener(){

            @Override
            public void inputMethodTextChanged(InputMethodEvent event) {
                CreateJpdlDialog.this.recalculateTextAndValidity();
            }

            @Override
            public void caretPositionChanged(InputMethodEvent event) {
                CreateJpdlDialog.this.recalculateTextAndValidity();
            }
        });
        FocusAdapter adapter = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                CreateJpdlDialog.this.myProcessName.removeFocusListener(this);
                CreateJpdlDialog.this.myProcessNameWasEdited = true;
            }
        };
        this.myProcessName.addFocusListener(adapter);
        this.init();
    }

    private void recalculateTextAndValidity() {
        String text = this.myFileName.getText().trim();
        if (!this.myProcessNameWasEdited) {
            this.myProcessName.setText(text);
        }
        this.setOKActionEnabled(this.myValidator == null || this.myValidator.checkInput(text));
        if (this.myValidator instanceof InputValidatorEx) {
            this.setErrorText(((InputValidatorEx)this.myValidator).getErrorText(text));
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myFileName;
    }

    protected JComponent createCenterPanel() {
        return this.myContentPane;
    }

    protected void doOKAction() {
        String inputString = this.myFileName.getText().trim();
        if (this.myValidator == null || this.myValidator.checkInput(inputString) && this.myValidator.canClose(inputString)) {
            this.close(0);
        }
    }

    public String getFileName() {
        return this.myFileName.getText().trim();
    }

    public String getProcessName() {
        return this.myProcessName.getText().trim();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Name:");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myFileName = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Process Name:");
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProcessName = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

