/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class TomcatSystemBaseDirManager {
    private Set<String> myUsedNames = new HashSet<String>();
    private File myParentDirectory;

    public static TomcatSystemBaseDirManager getInstance() {
        return (TomcatSystemBaseDirManager)ServiceManager.getService(TomcatSystemBaseDirManager.class);
    }

    public TomcatSystemBaseDirManager() {
        File parent = this.getParentDirectory();
        File[] children = parent.listFiles();
        if (children != null) {
            for (File child : children) {
                this.myUsedNames.add(child.getName());
            }
        }
    }

    private File getParentDirectory() {
        if (this.myParentDirectory != null) {
            return this.myParentDirectory;
        }
        File dir = new File(PathManager.getSystemPath(), "tomcat");
        try {
            this.myParentDirectory = dir.getCanonicalFile();
            return this.myParentDirectory;
        }
        catch (IOException e) {
            return dir;
        }
    }

    public File getDirectory(String directoryName) {
        return new File(this.getParentDirectory(), directoryName);
    }

    public String suggestNewDirectoryName(String prefix) {
        String baseName = PathUtil.suggestFileName((String)prefix);
        File parent = this.getParentDirectory();
        int i = 1;
        String nameCandidate = baseName;
        while (this.myUsedNames.contains(nameCandidate) || new File(parent, nameCandidate).exists()) {
            nameCandidate = baseName + "_" + ++i;
        }
        this.myUsedNames.add(nameCandidate);
        return nameCandidate;
    }
}

