/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.initializr;

import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.PsiNameHelperImpl;
import com.intellij.spring.initializr.SpringInitializrFormBuilder;
import com.intellij.spring.initializr.SpringInitializrModuleBuilder;
import com.intellij.spring.initializr.SpringInitializrOptions;
import com.intellij.spring.initializr.SpringInitializrOptionsLoader;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class SpringInitializrApplicationInfoStep
extends ModuleWizardStep
implements Disposable {
    private static final String NAME = "Name";
    private static final String GROUP = "Group";
    private static final String ARTIFACT = "Artifact";
    private static final String VERSION = "Version";
    private static final String PACKAGE = "Package";
    private final SpringInitializrModuleBuilder myBuilder;
    private final JBLoadingPanel myPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 300);
    private JBTextField myGroupField;
    private JBTextField myArtifactField;
    private JBTextField myVersionField;
    private JBTextField myNameField;
    private JBTextField myDescriptionField;
    private JBTextField myPackageNameField;

    SpringInitializrApplicationInfoStep(SpringInitializrModuleBuilder builder) {
        this.myBuilder = builder;
    }

    public boolean validate() throws ConfigurationException {
        if (this.myBuilder.getOptions() == null) {
            throw new ConfigurationException("Initialization failed for\n'" + this.myBuilder.getServiceUrl() + "'\ncannot proceed");
        }
        SpringInitializrApplicationInfoStep.validateRequiredField(this.myNameField, NAME);
        SpringInitializrApplicationInfoStep.validateRequiredField(this.myGroupField, GROUP);
        SpringInitializrApplicationInfoStep.validateRequiredField(this.myArtifactField, ARTIFACT);
        SpringInitializrApplicationInfoStep.validateRequiredField(this.myVersionField, VERSION);
        SpringInitializrApplicationInfoStep.validateRequiredField(this.myPackageNameField, PACKAGE);
        SpringInitializrApplicationInfoStep.validateSanitizedField(this.myArtifactField, ARTIFACT);
        String packageNameValue = this.myPackageNameField.getText();
        if (!PsiNameHelperImpl.getInstance().isQualifiedName(packageNameValue)) {
            throw new ConfigurationException(packageNameValue + " is not a valid package name");
        }
        return true;
    }

    private static void validateRequiredField(JBTextField field, String name) throws ConfigurationException {
        if (field.getText().isEmpty()) {
            throw new ConfigurationException(name + " must be set");
        }
    }

    private static void validateSanitizedField(JBTextField field, String name) throws ConfigurationException {
        String text = field.getText();
        if (!text.equals(SpringInitializrApplicationInfoStep.sanitize(text))) {
            throw new ConfigurationException(name + " contains illegal characters");
        }
    }

    private static String sanitize(String input) {
        String fileName = FileUtil.sanitizeFileName((String)input, (boolean)false);
        return StringUtil.toLowerCase((String)StringUtil.replaceChar((String)fileName, (char)' ', (char)'-'));
    }

    public void _init() {
        SpringInitializrOptions options = this.myBuilder.getOptions();
        if (options == null) {
            this.loadSpringInitializrOptions();
        }
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    public JComponent getPreferredFocusedComponent() {
        return UIUtil.findComponentOfType((JComponent)this.myPanel, JBTextField.class);
    }

    private void loadSpringInitializrOptions() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            SwingUtilities.invokeLater(() -> {
                this.myPanel.getContentPanel().removeAll();
                this.myPanel.startLoading();
            });
            String serviceUrl = this.myBuilder.getServiceUrl();
            try {
                EmptyProgressIndicator delegatingProgressIndicator = new EmptyProgressIndicator(){

                    public void setText(String text) {
                        SwingUtilities.invokeLater(() -> SpringInitializrApplicationInfoStep.this.myPanel.setLoadingText(text));
                    }
                };
                SpringInitializrOptionsLoader loader = new SpringInitializrOptionsLoader(serviceUrl);
                SpringInitializrOptions options = loader.loadOptions((ProgressIndicator)delegatingProgressIndicator);
                this.myBuilder.setOptions(options);
                SwingUtilities.invokeLater(() -> this.createSpringBootPanel(options));
            }
            catch (IOException e) {
                SwingUtilities.invokeLater(() -> Messages.showErrorDialog((String)("Initialization failed for '" + serviceUrl + "'\nPlease check URL, network and proxy settings.\n\nError message:\n" + e.getMessage()), (String)"Spring Initializr Error"));
            }
            finally {
                SwingUtilities.invokeLater(() -> {
                    this.myPanel.stopLoading();
                    this.myPanel.revalidate();
                });
            }
        });
    }

    private void createSpringBootPanel(SpringInitializrOptions options) {
        if (options == null) {
            return;
        }
        SpringInitializrFormBuilder builder = new SpringInitializrFormBuilder();
        this.myGroupField = builder.addTextField(GROUP, options.group);
        this.myGroupField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                SpringInitializrApplicationInfoStep.this.myPackageNameField.setText(StringUtil.toLowerCase((String)SpringInitializrApplicationInfoStep.this.myGroupField.getText()));
            }
        });
        this.myArtifactField = builder.addTextField(ARTIFACT, options.artifact);
        this.myArtifactField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                SpringInitializrApplicationInfoStep.this.myNameField.setText(SpringInitializrApplicationInfoStep.this.myArtifactField.getText());
            }
        });
        builder.addVerticalSpacing();
        builder.addComboBox("Type", options.type);
        builder.addComboBox("Packaging", options.packaging);
        builder.addComboBox("Java Version", options.javaVersion);
        builder.addComboBox("Language", options.language);
        builder.addVerticalSpacing();
        this.myVersionField = builder.addTextField(VERSION, options.version);
        this.myNameField = builder.addTextField(NAME, options.name);
        this.myDescriptionField = builder.addTextField("Description", options.description);
        this.myPackageNameField = builder.addTextField(PACKAGE, options.packageName);
        this.myPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)builder.getPanel(), (boolean)true), (Object)"North");
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void dispose() {
    }

    public void updateDataModel() {
        SpringInitializrOptions options = this.myBuilder.getOptions();
        options.name = this.myNameField.getText();
        options.group = this.myGroupField.getText();
        options.artifact = this.myArtifactField.getText();
        options.version = this.myVersionField.getText();
        options.description = this.myDescriptionField.getText();
        options.packageName = this.myPackageNameField.getText();
    }

    public String getHelpId() {
        return "reference.spring.boot";
    }
}

