/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.initializr;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.spring.initializr.DependenciesTable;
import com.intellij.spring.initializr.SpringInitializrModuleBuilder;
import com.intellij.spring.initializr.SpringInitializrOptions;
import com.intellij.spring.initializr.Version;
import com.intellij.spring.initializr.VersionRange;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

class SpringInitializrNewDependenciesStep
extends ModuleWizardStep {
    private final SpringInitializrModuleBuilder myBuilder;
    private JPanel myPanel;
    private JBList myCategoriesList;
    private DependenciesTable myDependenciesTable;
    private final SearchDependenciesFilter myFilter = new SearchDependenciesFilter();
    private Version myCurrentSpringBootVersion;

    SpringInitializrNewDependenciesStep(SpringInitializrModuleBuilder builder) {
        this.myBuilder = builder;
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void _init() {
        if (this.myPanel == null) {
            this.createPanel();
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCategoriesList;
    }

    private void createPanel() {
        SpringInitializrOptions options = this.myBuilder.getOptions();
        if (options == null) {
            return;
        }
        JPanel dependenciesPanel = new JPanel(new BorderLayout());
        JPanel toolbarPanel = new JPanel(new BorderLayout());
        toolbarPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)4, (int)4, (int)0));
        toolbarPanel.add((Component)((Object)this.myFilter), "West");
        DefaultActionGroup group = new DefaultActionGroup();
        group.addAction((AnAction)new ChangeSpringBootVersionAction());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true);
        toolbar.updateActionsImmediately();
        toolbarPanel.add((Component)toolbar.getComponent(), "East");
        AnAction activateSearchAction = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                SpringInitializrNewDependenciesStep.this.myFilter.getTextEditor().requestFocus();
            }
        };
        dependenciesPanel.add((Component)toolbarPanel, "North");
        this.myDependenciesTable = new DependenciesTable(options.selectedDependenciesIds);
        JBSplitter depsSplitter = new JBSplitter(false, 0.5f, 0.2f, 0.5f);
        depsSplitter.setDividerWidth(1);
        depsSplitter.setShowDividerIcon(false);
        depsSplitter.setShowDividerControls(false);
        this.myCategoriesList = new JBList(this.myBuilder.getOptions().dependencies);
        this.myCategoriesList.setFixedCellHeight(JBUI.scale((int)22));
        ColoredListCellRenderer<SpringInitializrOptions.MultiSelectGroup> categoryRenderer = new ColoredListCellRenderer<SpringInitializrOptions.MultiSelectGroup>(){

            protected void customizeCellRenderer(@NotNull JList<? extends SpringInitializrOptions.MultiSelectGroup> list, SpringInitializrOptions.MultiSelectGroup value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/spring/initializr/SpringInitializrNewDependenciesStep$2", "customizeCellRenderer"));
                }
                this.append(value.name);
                SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)SpringInitializrNewDependenciesStep.this.myCategoriesList, (SimpleColoredComponent)this, (boolean)true, (boolean)selected);
            }
        };
        this.myCategoriesList.setCellRenderer((ListCellRenderer)categoryRenderer);
        new ListSpeedSearch((JList)this.myCategoriesList, (Function)new Function<Object, String>(){

            public String fun(Object entry) {
                return ((SpringInitializrOptions.MultiSelectGroup)entry).name;
            }
        });
        this.myCategoriesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                SpringInitializrOptions.MultiSelectGroup selectedValue = (SpringInitializrOptions.MultiSelectGroup)SpringInitializrNewDependenciesStep.this.myCategoriesList.getSelectedValue();
                if (selectedValue == null) {
                    return;
                }
                SpringInitializrNewDependenciesStep.this.myDependenciesTable.setDependencies(SpringInitializrNewDependenciesStep.this.myCurrentSpringBootVersion, selectedValue.options);
            }
        });
        depsSplitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myCategoriesList, (boolean)true));
        JBSplitter depsAndDescriptionSplitter = new JBSplitter(true, 0.7f);
        depsAndDescriptionSplitter.setDividerWidth(1);
        depsAndDescriptionSplitter.setShowDividerIcon(false);
        depsAndDescriptionSplitter.setShowDividerControls(false);
        depsAndDescriptionSplitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)this.myDependenciesTable), (boolean)true));
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        descriptionPanel.setBackground(UIUtil.getListBackground());
        descriptionPanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.setBackground(UIUtil.getListBackground());
        final JBLabel descriptionHeader = new JBLabel();
        descriptionHeader.setFont(UIUtil.getLabelFont().deriveFont(1));
        descriptionHeader.setBorder((Border)JBUI.Borders.empty((int)4, (int)0));
        final JBLabel descriptionVersion = new JBLabel();
        descriptionVersion.setIcon(AllIcons.General.BalloonWarning);
        descriptionVersion.setBorder((Border)JBUI.Borders.empty((int)4, (int)0, (int)8, (int)0));
        descriptionVersion.setVisible(false);
        headerPanel.add((Component)descriptionHeader, "North");
        headerPanel.add((Component)descriptionVersion, "Center");
        descriptionPanel.add((Component)headerPanel, "North");
        final JTextArea descriptionText = new JTextArea();
        descriptionText.setBackground(UIUtil.getListBackground());
        descriptionText.setLineWrap(true);
        descriptionText.setWrapStyleWord(true);
        descriptionText.setEditable(false);
        descriptionText.setFont((Font)JBUI.Fonts.smallFont());
        descriptionPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)descriptionText, (boolean)true), "Center");
        this.myDependenciesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                SpringInitializrOptions.Option value = SpringInitializrNewDependenciesStep.this.myDependenciesTable.getSelectedValue();
                if (value == null) {
                    return;
                }
                descriptionHeader.setText(value.display);
                descriptionVersion.setVisible(false);
                VersionRange range = (VersionRange)value.getUserData(SpringInitializrOptions.Option.VERSION_RANGE);
                if (range != null && !range.match(SpringInitializrNewDependenciesStep.this.myCurrentSpringBootVersion)) {
                    descriptionVersion.setText("Requires Spring Boot Version " + range.displayText());
                    descriptionVersion.setVisible(true);
                }
                descriptionText.setText(value.description);
                descriptionText.setCaretPosition(0);
            }
        });
        depsAndDescriptionSplitter.setSecondComponent((JComponent)descriptionPanel);
        depsSplitter.setSecondComponent((JComponent)depsAndDescriptionSplitter);
        JPanel depsSplitterPanel = new JPanel(new BorderLayout());
        depsSplitterPanel.setBorder(JBUI.Borders.merge((Border)JBUI.Borders.customLine((Color)JBColor.border()), (Border)JBUI.Borders.empty((int)0, (int)4), (boolean)true));
        depsSplitterPanel.add((Component)depsSplitter, "Center");
        dependenciesPanel.add((Component)depsSplitterPanel, "Center");
        JPanel selectedDepsPanel = new JPanel(new BorderLayout());
        JLabel selectedDepsLabel = new JLabel("Selected Dependencies");
        selectedDepsLabel.setFont(UIUtil.getLabelFont().deriveFont(1));
        selectedDepsLabel.setBorder((Border)JBUI.Borders.empty((int)4, (int)0));
        selectedDepsPanel.add((Component)selectedDepsLabel, "North");
        JBList selectedList = new JBList(new Object[]{"1", "2", "3", "4", "5", "6", "7"});
        selectedList.setBorder(JBUI.Borders.customLine((Color)JBColor.border()));
        selectedDepsPanel.add((Component)selectedList, "Center");
        JBSplitter mainSplitter = new JBSplitter(false, 0.7f, 0.6f, 0.8f);
        mainSplitter.setShowDividerIcon(false);
        mainSplitter.setShowDividerControls(false);
        mainSplitter.setDividerWidth(JBUI.scale((int)36));
        mainSplitter.setFirstComponent((JComponent)dependenciesPanel);
        mainSplitter.setSecondComponent((JComponent)selectedDepsPanel);
        this.myPanel = mainSplitter;
        activateSearchAction.registerCustomShortcutSet(CommonShortcuts.getFind(), (JComponent)this.myPanel);
        this.myFilter.getTextEditor().setToolTipText(KeymapUtil.createTooltipText((String)"Search in dependencies", (AnAction)activateSearchAction));
        this.onSpringBootVersionChanged((SpringInitializrOptions.Option)((Object)this.myBuilder.getOptions().bootVersion.getSelected()));
        this.myCategoriesList.setSelectedIndex(0);
    }

    private void onSpringBootVersionChanged(SpringInitializrOptions.Option option) {
        this.myBuilder.getOptions().bootVersion.setSelectedItem((Object)option);
        this.myCurrentSpringBootVersion = Version.parse(option.id);
        int index = this.myCategoriesList.getSelectedIndex();
        this.myCategoriesList.clearSelection();
        this.myCategoriesList.setSelectedIndex(index);
    }

    public void updateDataModel() {
    }

    public String getHelpId() {
        return "reference.spring.boot";
    }

    private class SearchDependenciesFilter
    extends FilterComponent {
        private final SimpleTextAttributes DESCRIPTION_TEXT_ATTRIBUTES;
        private final SimpleTextAttributes DESCRIPTION_TEXT_DISABLED_ATTRIBUTES;
        private final JBList myList;
        private JBPopup mySearchResultsPopup;

        private SearchDependenciesFilter() {
            super("SPRING_INITIALIZR_DEPENDENCIES_FILTER", 10);
            this.DESCRIPTION_TEXT_ATTRIBUTES = new SimpleTextAttributes(128, null);
            this.DESCRIPTION_TEXT_DISABLED_ATTRIBUTES = SimpleTextAttributes.merge((SimpleTextAttributes)this.DESCRIPTION_TEXT_ATTRIBUTES, (SimpleTextAttributes)SimpleTextAttributes.GRAYED_ATTRIBUTES);
            this.myList = new JBList();
            this.myList.setEmptyText("No matching results");
        }

        protected void onEscape(KeyEvent e) {
            this.hideSearchResults();
        }

        public void filter() {
            String filterText = this.getFilter();
            if (filterText.trim().length() <= 2) {
                this.hideSearchResults();
                return;
            }
            MultiMap<Integer, SpringInitializrOptions.Option> matchingDegreeResultsMap = new MultiMap<Integer, SpringInitializrOptions.Option>(){

                @NotNull
                protected Map<Integer, Collection<SpringInitializrOptions.Option>> createMap() {
                    TreeMap<Integer, Collection<SpringInitializrOptions.Option>> treeMap = new TreeMap<Integer, Collection<SpringInitializrOptions.Option>>((o1, o2) -> o2.compareTo((Integer)o1));
                    if (treeMap == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/initializr/SpringInitializrNewDependenciesStep$SearchDependenciesFilter$1", "createMap"));
                    }
                    return treeMap;
                }
            };
            final MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + filterText)).build();
            final SpringInitializrOptions options = SpringInitializrNewDependenciesStep.this.myBuilder.getOptions();
            for (SpringInitializrOptions.MultiSelectGroup dependency : options.dependencies) {
                for (SpringInitializrOptions.Option option : dependency.options) {
                    if (!matcher.matches(option.display) && !matcher.matches(option.description)) continue;
                    matchingDegreeResultsMap.putValue((Object)(matcher.matchingDegree(option.display) * 2 + matcher.matchingDegree(option.description)), (Object)option);
                }
            }
            this.myList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<SpringInitializrOptions.Option>(){

                protected void customizeCellRenderer(@NotNull JList<? extends SpringInitializrOptions.Option> list, SpringInitializrOptions.Option value, int index, boolean selected, boolean hasFocus) {
                    if (list == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/spring/initializr/SpringInitializrNewDependenciesStep$SearchDependenciesFilter$2", "customizeCellRenderer"));
                    }
                    boolean alreadySelectedDependency = options.selectedDependenciesIds.contains(value.id);
                    boolean available = SearchDependenciesFilter.this.isDependencyAvailable(value);
                    SpeedSearchUtil.appendColoredFragmentForMatcher((String)(value.display + "   "), (SimpleColoredComponent)this, (SimpleTextAttributes)(alreadySelectedDependency ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : (available ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES)), (Matcher)matcher, (Color)UIUtil.getListBackground((boolean)selected), (boolean)true);
                    String shortenedDescription = StringUtil.shortenTextWithEllipsis((String)value.description, (int)100, (int)0);
                    SpeedSearchUtil.appendColoredFragmentForMatcher((String)shortenedDescription, (SimpleColoredComponent)this, (SimpleTextAttributes)(available ? SearchDependenciesFilter.this.DESCRIPTION_TEXT_ATTRIBUTES : SearchDependenciesFilter.this.DESCRIPTION_TEXT_DISABLED_ATTRIBUTES), (Matcher)matcher, (Color)UIUtil.getListBackground((boolean)selected), (boolean)true);
                }
            });
            ArrayList matches = new ArrayList(matchingDegreeResultsMap.values());
            this.myList.setModel((ListModel)new CollectionListModel(matches));
            if (this.mySearchResultsPopup == null || this.mySearchResultsPopup.isDisposed()) {
                this.mySearchResultsPopup = JBPopupFactory.getInstance().createListPopupBuilder((JList)this.myList).setItemChoosenCallback(() -> {
                    SpringInitializrOptions.Option selectedValue = (SpringInitializrOptions.Option)((Object)((Object)this.myList.getSelectedValue()));
                    if (this.isDependencyAvailable(selectedValue)) {
                        ((SpringInitializrNewDependenciesStep)SpringInitializrNewDependenciesStep.this).myBuilder.getOptions().selectedDependenciesIds.add(selectedValue.id);
                    }
                    this.reset();
                }).setRequestFocus(false).createPopup();
            }
            this.mySearchResultsPopup.pack(true, true);
            if (!this.mySearchResultsPopup.isVisible()) {
                this.mySearchResultsPopup.showUnderneathOf((Component)this.getTextEditor());
            }
        }

        private void hideSearchResults() {
            if (this.mySearchResultsPopup != null) {
                this.mySearchResultsPopup.cancel();
            }
        }

        private boolean isDependencyAvailable(SpringInitializrOptions.Option value) {
            VersionRange versionRange = (VersionRange)value.getUserData(SpringInitializrOptions.Option.VERSION_RANGE);
            return versionRange == null || versionRange.match(SpringInitializrNewDependenciesStep.this.myCurrentSpringBootVersion);
        }
    }

    private class ChangeSpringBootVersionAction
    extends ComboBoxAction {
        private ChangeSpringBootVersionAction() {
        }

        public JComponent createCustomComponent(Presentation presentation) {
            JComponent component = super.createCustomComponent(presentation);
            JPanel panel = new JPanel(new BorderLayout());
            panel.setOpaque(false);
            panel.add((Component)component, "Center");
            panel.add((Component)new JLabel("Spring Boot"), "West");
            return panel;
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            SpringInitializrOptions.Option selectedVersion = (SpringInitializrOptions.Option)((Object)((SpringInitializrNewDependenciesStep)SpringInitializrNewDependenciesStep.this).myBuilder.getOptions().bootVersion.getSelected());
            assert (selectedVersion != null);
            presentation.setText(selectedVersion.display);
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button) {
            DefaultActionGroup versionGroup = new DefaultActionGroup();
            final SpringInitializrOptions.Option selected = (SpringInitializrOptions.Option)((Object)((SpringInitializrNewDependenciesStep)SpringInitializrNewDependenciesStep.this).myBuilder.getOptions().bootVersion.getSelected());
            for (final SpringInitializrOptions.Option option : ((SpringInitializrNewDependenciesStep)SpringInitializrNewDependenciesStep.this).myBuilder.getOptions().bootVersion.getItems()) {
                versionGroup.add((AnAction)new ToggleAction(option.display){

                    public boolean isSelected(AnActionEvent e) {
                        return ((Object)((Object)option)).equals((Object)selected);
                    }

                    public void setSelected(AnActionEvent e, boolean state) {
                        SpringInitializrNewDependenciesStep.this.onSpringBootVersionChanged(option);
                    }
                });
            }
            DefaultActionGroup defaultActionGroup = versionGroup;
            if (defaultActionGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/initializr/SpringInitializrNewDependenciesStep$ChangeSpringBootVersionAction", "createPopupActionGroup"));
            }
            return defaultActionGroup;
        }
    }
}

