/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang.psi.impl;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.thymeleaf.lang.psi.ThymeleafTemplateNameReference;
import com.intellij.thymeleaf.lang.psi.impl.ThymeleafPsiCompositeElementImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ThymeleafTemplateNameReferenceImpl
extends ThymeleafPsiCompositeElementImpl
implements ThymeleafTemplateNameReference {
    public ThymeleafTemplateNameReferenceImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/thymeleaf/lang/psi/impl/ThymeleafTemplateNameReferenceImpl", "<init>"));
        }
        super(node);
    }

    public PsiElement getElement() {
        return this;
    }

    public PsiReference getReference() {
        return this;
    }

    public TextRange getRangeInElement() {
        TextRange textRange = this.getTextRange();
        return new TextRange(0, textRange.getEndOffset() - textRange.getStartOffset());
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/psi/impl/ThymeleafTemplateNameReferenceImpl", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/thymeleaf/lang/psi/impl/ThymeleafTemplateNameReferenceImpl", "bindToElement"));
        }
        if (element instanceof PsiFile) {
            return this.handleElementRename(((PsiFile)element).getName());
        }
        return element;
    }

    public boolean isReferenceTo(PsiElement element) {
        PsiElement resolve = this.resolve();
        if (resolve instanceof PsiFile && element.getText().equals(FileUtil.getNameWithoutExtension((String)((PsiFile)resolve).getName()))) {
            return true;
        }
        return element.equals(resolve);
    }

    @NotNull
    public Object[] getVariants() {
        Object[] objectArray = this.getVariants(this.getContainingFile());
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/psi/impl/ThymeleafTemplateNameReferenceImpl", "getVariants"));
        }
        return objectArray;
    }

    public Object[] getVariants(PsiFile thFile) {
        HashSet results = ContainerUtil.newHashSet();
        PsiDirectory directory = ThymeleafTemplateNameReferenceImpl.getContextDirectory(thFile);
        if (directory != null) {
            for (PsiFile file : directory.getFiles()) {
                if (file.getFileType() != HtmlFileType.INSTANCE) continue;
                results.add(LookupElementBuilder.create((PsiNamedElement)file));
            }
        }
        return ArrayUtil.toObjectArray((Collection)results);
    }

    public boolean isSoft() {
        return false;
    }

    public PsiElement resolve() {
        String name = this.getText();
        PsiDirectory directory = ThymeleafTemplateNameReferenceImpl.getContextDirectory(this.getContainingFile());
        if (directory != null) {
            PsiFile[] files;
            for (PsiFile file : files = directory.getFiles()) {
                if (!FileUtil.getNameWithoutExtension((String)file.getName()).equals(name)) continue;
                return file;
            }
        }
        return null;
    }

    @Nullable
    public static PsiDirectory getContextDirectory(PsiFile thFile) {
        PsiFile containingFile;
        PsiElement context;
        if (thFile != null && (context = thFile.getContext()) != null && (containingFile = context.getContainingFile()) != null) {
            return containingFile.getOriginalFile().getContainingDirectory();
        }
        return null;
    }
}

