/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.providers.contexts.spring;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.spring.security.model.xml.converters.SecurityExpressionRootMethodsUtil;
import com.intellij.thymeleaf.dialects.springSecurity.springSecurity3.ThymeleafSpringSecurityDialect3;
import com.intellij.thymeleaf.dialects.springSecurity.springSecurity4.ThymeleafSpringSecurityDialect4;
import com.intellij.thymeleaf.lang.support.ThymeleafContextVariablesProvider;
import com.intellij.thymeleaf.lang.support.beans.ThymeleafVariable;
import com.intellij.thymeleaf.lang.support.utils.ThymeleafCommonUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ThymeleafSpringSecurityContextVariableProvider
extends ThymeleafContextVariablesProvider {
    private static Map<String, String> myImplicitSecurityVariablesMap = new HashMap();

    @Override
    @NotNull
    public Collection<? extends PsiVariable> getContextVariables(@NotNull PsiElement contextElement) {
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/thymeleaf/providers/contexts/spring/ThymeleafSpringSecurityContextVariableProvider", "getContextVariables"));
        }
        HashSet variables = ContainerUtil.newHashSet();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)contextElement);
        if (module != null) {
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)contextElement.getProject()).findClass("org.springframework.security.core.Authentication", scope);
            if (psiClass != null) {
                Map properties = PropertyUtil.getAllProperties((PsiClass)psiClass, (boolean)false, (boolean)true);
                for (Map.Entry entry : properties.entrySet()) {
                    PsiMethod method = (PsiMethod)entry.getValue();
                    PsiType propertyType = PropertyUtil.getPropertyType((PsiMember)method);
                    if (propertyType == null) continue;
                    variables.add(new ThymeleafVariable((String)entry.getKey(), propertyType, (PsiElement)method));
                }
            }
            for (Map.Entry<String, String> entry : myImplicitSecurityVariablesMap.entrySet()) {
                PsiClass aClass = JavaPsiFacade.getInstance((Project)contextElement.getProject()).findClass(entry.getValue(), scope);
                if (aClass == null) continue;
                variables.add(new ThymeleafVariable(entry.getKey(), (PsiType)PsiTypesUtil.getClassType((PsiClass)aClass), (PsiElement)aClass));
            }
        }
        HashSet hashSet = variables;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/providers/contexts/spring/ThymeleafSpringSecurityContextVariableProvider", "getContextVariables"));
        }
        return hashSet;
    }

    @Override
    public Collection<PsiMethod> getContextMethods(@NotNull PsiElement contextElement) {
        Module module;
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/thymeleaf/providers/contexts/spring/ThymeleafSpringSecurityContextVariableProvider", "getContextMethods"));
        }
        if (ThymeleafSpringSecurityContextVariableProvider.isSpringSecurityDialect(contextElement) && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)contextElement)) != null) {
            return SecurityExpressionRootMethodsUtil.getExpressionRootMethods((Module)module, (String)"org.springframework.security.web.access.expression.WebSecurityExpressionRoot");
        }
        return super.getContextMethods(contextElement);
    }

    private static boolean isSpringSecurityDialect(PsiElement contextElement) {
        XmlAttribute contextAttribute = ThymeleafCommonUtil.getContextAttribute(contextElement);
        if (contextAttribute != null) {
            String ns = contextAttribute.getNamespace();
            for (String sec_ns : ThymeleafSpringSecurityContextVariableProvider.collectUris()) {
                if (!sec_ns.equals(ns)) continue;
                return true;
            }
        }
        return false;
    }

    private static String[] collectUris() {
        return ArrayUtil.mergeArrays((String[])ThymeleafSpringSecurityDialect3.THYMELEAF_SECURITY_URIS, (String[])ThymeleafSpringSecurityDialect4.THYMELEAF_SECURITY_URIS);
    }

    static {
        myImplicitSecurityVariablesMap.put("_csrf", "org.springframework.security.web.csrf.CsrfToken");
    }
}

