/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.model.converters;

import com.intellij.openapi.util.Comparing;
import com.intellij.spring.webflow.model.xml.ActionState;
import com.intellij.spring.webflow.model.xml.Attribute;
import com.intellij.spring.webflow.model.xml.EndState;
import com.intellij.spring.webflow.model.xml.Evaluate;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.spring.webflow.model.xml.Identified;
import com.intellij.spring.webflow.model.xml.SubflowState;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransitionOnConverter
extends ResolvingConverter<Object> {
    private static final String EVALUATE_VALUE_SUFFIX = ".success";

    @NotNull
    public Collection<?> getVariants(ConvertContext context) {
        if (TransitionOnConverter.hasParentOfType(context, SubflowState.class)) {
            List<Identified> list = TransitionOnConverter.getIdentifiedVariants(context);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/converters/TransitionOnConverter", "getVariants"));
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/converters/TransitionOnConverter", "getVariants"));
        }
        return list;
    }

    @NotNull
    public Set<String> getAdditionalVariants(@NotNull ConvertContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/webflow/model/converters/TransitionOnConverter", "getAdditionalVariants"));
        }
        if (TransitionOnConverter.hasParentOfType(context, ActionState.class)) {
            Set set = ContainerUtil.map2Set(TransitionOnConverter.getEvaluateAttributes(context), attribute -> attribute.getValueAttr().getStringValue() + EVALUATE_VALUE_SUFFIX);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/converters/TransitionOnConverter", "getAdditionalVariants"));
            }
            return set;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/converters/TransitionOnConverter", "getAdditionalVariants"));
        }
        return set;
    }

    public Object fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        if (TransitionOnConverter.hasParentOfType(context, SubflowState.class)) {
            return ContainerUtil.find(TransitionOnConverter.getIdentifiedVariants(context), identified -> Comparing.strEqual((String)identified.getId().getStringValue(), (String)s));
        }
        if (TransitionOnConverter.hasParentOfType(context, ActionState.class)) {
            return ContainerUtil.find(TransitionOnConverter.getEvaluateAttributes(context), attribute -> Comparing.equal((String)(attribute.getValueAttr().getStringValue() + EVALUATE_VALUE_SUFFIX), (String)s));
        }
        return null;
    }

    public String toString(@Nullable Object o, ConvertContext context) {
        if (o instanceof Identified) {
            return ((Identified)o).getId().getStringValue();
        }
        return null;
    }

    private static boolean hasParentOfType(ConvertContext context, Class<? extends DomElement> parentClass) {
        return context.getInvocationElement().getParentOfType(parentClass, true) != null;
    }

    private static List<Attribute> getEvaluateAttributes(ConvertContext context) {
        ActionState actionState = (ActionState)context.getInvocationElement().getParentOfType(ActionState.class, true);
        assert (actionState != null);
        SmartList result = new SmartList();
        for (Evaluate evaluate : actionState.getEvaluates()) {
            for (Attribute attribute : evaluate.getAttributes()) {
                String attributeName = attribute.getName().getStringValue();
                if (!Comparing.equal((String)attributeName, (String)"name")) continue;
                result.add(attribute);
            }
        }
        return result;
    }

    private static List<Identified> getIdentifiedVariants(ConvertContext context) {
        DomElement element = context.getInvocationElement();
        SubflowState subflowState = (SubflowState)element.getParentOfType(SubflowState.class, true);
        assert (subflowState != null);
        Flow subflow = (Flow)subflowState.getSubflow().getValue();
        if (subflow == null) {
            return Collections.emptyList();
        }
        ArrayList<Identified> variants = new ArrayList<Identified>();
        List<EndState> states = subflow.getEndStates();
        variants.addAll(states);
        return variants;
    }
}

