/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import org.jetbrains.annotations.NotNull;

class SpringBootApplicationMetaConfigKeyLookupElementBuilder {
    private static final Key<SpringBootApplicationMetaConfigKey> MY_KEY = Key.create((String)"CONFIG_KEY");
    private static final LookupElementRenderer<LookupElement> MY_RENDERER = new LookupElementRenderer<LookupElement>(){

        public void renderElement(LookupElement element, LookupElementPresentation presentation) {
            String shortDescription;
            SpringBootApplicationMetaConfigKey configKey = (SpringBootApplicationMetaConfigKey)element.getUserData(MY_KEY);
            assert (configKey != null);
            presentation.setIcon(configKey.getIcon());
            presentation.setStrikeout(configKey.isDeprecated());
            String lookupString = element.getLookupString();
            presentation.setItemText(lookupString);
            if (!lookupString.equals(configKey.getName())) {
                presentation.setItemTextBold(true);
            }
            if (configKey.getDefaultValue() != null) {
                String shortenedDefaultValue = StringUtil.shortenTextWithEllipsis((String)configKey.getDefaultValue(), (int)60, (int)0, (boolean)true);
                TextAttributes attrs = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(PropertiesHighlighter.PROPERTY_VALUE);
                presentation.setTailText("=" + shortenedDefaultValue, attrs.getForegroundColor());
            }
            if (StringUtil.isNotEmpty((String)(shortDescription = configKey.getDescriptionText().getShortText()))) {
                presentation.appendTailText(" (" + shortDescription + ")", true);
            }
            if (configKey.getType() != null) {
                presentation.setTypeText(configKey.getType().getPresentableText());
            }
        }
    };

    SpringBootApplicationMetaConfigKeyLookupElementBuilder() {
    }

    @NotNull
    static LookupElementBuilder create(SpringBootApplicationMetaConfigKey configKey, String lookupString) {
        LookupElementBuilder builder = LookupElementBuilder.create((Object)configKey.getDeclaration(), (String)lookupString).withRenderer(MY_RENDERER);
        builder.putUserData(MY_KEY, (Object)configKey);
        LookupElementBuilder lookupElementBuilder = builder;
        if (lookupElementBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyLookupElementBuilder", "create"));
        }
        return lookupElementBuilder;
    }
}

