/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata.additional;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.boot.application.metadata.MetaConfigKeyReference;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringBootAdditionalConfigMetaConfigKeyReference
extends MetaConfigKeyReference
implements EmptyResolveMessageProvider {
    SpringBootAdditionalConfigMetaConfigKeyReference(PsiElement element) {
        super(element, ElementManipulators.getValueText((PsiElement)element));
        SpringBootApplicationMetaConfigKey key = this.getResolvedKey();
        if (key != null && key.isMapType()) {
            String keyName = key.getName();
            this.setRangeInElement(TextRange.allOf((String)keyName).shiftRight(ElementManipulators.getOffsetInElement((PsiElement)element)));
        }
    }

    @Override
    @NotNull
    protected List<SpringBootApplicationMetaConfigKey> getAllKeys(String keyText) {
        List allKeys = SpringBootApplicationMetaConfigKeyManager.getInstance().getAllMetaConfigKeys(this.getElement());
        List list = ContainerUtil.filter((Collection)allKeys, configKey -> {
            String keyName = configKey.getName();
            if (configKey.isMapType()) {
                return keyText.equals(keyName + ".keys") || keyText.equals(keyName + ".values");
            }
            return keyText.equals(keyName);
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigMetaConfigKeyReference", "getAllKeys"));
        }
        return list;
    }

    @Override
    @NotNull
    public String getReferenceDisplayText() {
        String string = "Hint for " + ElementManipulators.getValueText((PsiElement)this.getElement());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigMetaConfigKeyReference", "getReferenceDisplayText"));
        }
        return string;
    }

    @NotNull
    public Object[] getVariants() {
        Set<String> existingKeys = this.collectExistingKeys();
        List allKeys = SpringBootApplicationMetaConfigKeyManager.getInstance().getAllMetaConfigKeys(this.getElement());
        ArrayList<LookupElement> allVariants = new ArrayList<LookupElement>(allKeys.size());
        for (SpringBootApplicationMetaConfigKey key : allKeys) {
            if (key.isMapType()) {
                String dotValuesName;
                String dotKeysName = key.getName() + ".keys";
                if (!existingKeys.contains(dotKeysName)) {
                    allVariants.add(key.tuneLookupElement((LookupElement)key.getLookupElement(dotKeysName)));
                }
                if (existingKeys.contains(dotValuesName = key.getName() + ".values")) continue;
                allVariants.add(key.tuneLookupElement((LookupElement)key.getLookupElement(dotValuesName)));
                continue;
            }
            if (existingKeys.contains(key.getName())) continue;
            allVariants.add(key.tuneLookupElement((LookupElement)key.getLookupElement()));
        }
        Object[] objectArray = allVariants.toArray(new LookupElement[allVariants.size()]);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigMetaConfigKeyReference", "getVariants"));
        }
        return objectArray;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = "Can not resolve configuration key reference '" + this.getValue() + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigMetaConfigKeyReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }

    private Set<String> collectExistingKeys() {
        PsiFile file = this.getElement().getContainingFile();
        if (!(file instanceof JsonFile)) {
            return Collections.emptySet();
        }
        JsonObject rootObject = (JsonObject)ObjectUtils.tryCast((Object)((JsonFile)file).getTopLevelValue(), JsonObject.class);
        if (rootObject == null) {
            return Collections.emptySet();
        }
        JsonProperty hintsRoot = rootObject.findProperty("hints");
        if (hintsRoot == null) {
            return Collections.emptySet();
        }
        JsonArray hintsArray = (JsonArray)ObjectUtils.tryCast((Object)hintsRoot.getValue(), JsonArray.class);
        if (hintsArray == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (JsonValue value : hintsArray.getValueList()) {
            String nameValue;
            JsonObject entry = (JsonObject)ObjectUtils.tryCast((Object)value, JsonObject.class);
            if (entry == null || (nameValue = SpringBootAdditionalConfigMetaConfigKeyReference.getJsonStringLiteral(entry, "name")) == null) continue;
            String strippedValueAsString = JsonPsiUtil.stripQuotes((String)nameValue);
            result.add(strippedValueAsString);
        }
        return result;
    }

    @Nullable
    private static String getJsonStringLiteral(JsonObject valueObject, String propertyName) {
        JsonProperty property = valueObject.findProperty(propertyName);
        if (property == null) {
            return null;
        }
        JsonStringLiteral literal = (JsonStringLiteral)ObjectUtils.tryCast((Object)property.getValue(), JsonStringLiteral.class);
        if (literal == null) {
            return null;
        }
        return literal.getValue();
    }
}

