/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.spring.boot.application.config.SpringBootHintReferencesProvider;
import com.intellij.spring.boot.application.config.hints.LoggerNameReferenceProvider;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.application.properties.MapKeyPropertyEnumReferenceSet;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesKeyReferenceProvider;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesUtil;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesValueReferenceProvider;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class SpringBootApplicationPropertiesReferenceContributor
extends PsiReferenceContributor {
    private static final PatternCondition<PsiElement> APPLICATION_PROPERTIES_SB_1_2_OR_HIGHER = new PatternCondition<PsiElement>("isApplicationPropertiesAndSB_1_2"){

        public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributor$1", "accepts"));
            }
            PsiFile containingFile = element.getContainingFile().getOriginalFile();
            if (!(containingFile instanceof PropertiesFile)) {
                return false;
            }
            if (!SpringBootApplicationPropertiesUtil.isApplicationPropertiesFile((PropertiesFile)containingFile)) {
                return false;
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            return SpringBootLibraryUtil.isAtLeastVersion(module, SpringBootLibraryUtil.SpringBootVersion.VERSION_1_2_0);
        }
    };
    private static final PatternCondition<PsiElement> SB_1_3_OR_HIGHER = new PatternCondition<PsiElement>("SpringBoot13OrHigher"){

        public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributor$2", "accepts"));
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            return SpringBootLibraryUtil.isAtLeastVersion(module, SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0);
        }
    };
    private static final Key<SpringBootApplicationMetaConfigKey> META_CONFIG_KEY = Key.create((String)"metaConfigKey");
    private static final String LOGGING_LEVEL_KEY_PREFIX = "logging.level.";

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributor", "registerReferenceProviders"));
        }
        SpringBootApplicationPropertiesReferenceContributor.registerKeyProviders(registrar);
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(PropertyValueImpl.class).with(APPLICATION_PROPERTIES_SB_1_2_OR_HIGHER), (PsiReferenceProvider)new SpringBootApplicationPropertiesValueReferenceProvider(), 100.0);
    }

    private static void registerKeyProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributor", "registerKeyProviders"));
        }
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(PropertyKeyImpl.class).with(APPLICATION_PROPERTIES_SB_1_2_OR_HIGHER), (PsiReferenceProvider)new SpringBootApplicationPropertiesKeyReferenceProvider());
        registrar.registerReferenceProvider((ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PropertyKeyImpl.class).with(APPLICATION_PROPERTIES_SB_1_2_OR_HIGHER)).without(SB_1_3_OR_HIGHER)).with((PatternCondition)new PatternCondition<PropertyKeyImpl>("logging.level"){

            public boolean accepts(@NotNull PropertyKeyImpl key, ProcessingContext context) {
                if (key == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributor$3", "accepts"));
                }
                return StringUtil.startsWith((CharSequence)key.getText(), (CharSequence)SpringBootApplicationPropertiesReferenceContributor.LOGGING_LEVEL_KEY_PREFIX);
            }
        }), (PsiReferenceProvider)new LoggerNameReferenceProvider(LOGGING_LEVEL_KEY_PREFIX));
        final Condition mapTypeKeyCondition = configKey -> configKey.isMapType() && configKey.getKeyItemHint() != SpringBootApplicationMetaConfigKey.ItemHint.NONE;
        registrar.registerReferenceProvider((ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PropertyKeyImpl.class).with(APPLICATION_PROPERTIES_SB_1_2_OR_HIGHER)).with(SB_1_3_OR_HIGHER)).with((PatternCondition)new PatternCondition<PropertyKeyImpl>("mapTypeKey"){

            public boolean accepts(@NotNull PropertyKeyImpl key, ProcessingContext context) {
                if (key == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributor$5", "accepts"));
                }
                return SpringBootApplicationPropertiesReferenceContributor.findAndStoreMetaConfigKeyIfMatches(key, context, (Condition<SpringBootApplicationMetaConfigKey>)mapTypeKeyCondition);
            }
        }), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributor$4", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributor$4", "getReferencesByElement"));
                }
                SpringBootApplicationMetaConfigKey configKey = (SpringBootApplicationMetaConfigKey)context.get(META_CONFIG_KEY);
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
                assert (module != null);
                SpringBootHintReferencesProvider hintReferencesProvider = SpringBootHintReferencesProvider.getInstance();
                PsiReference[] psiReferenceArray = hintReferencesProvider.getReferences(module, configKey, SpringBootHintReferencesProvider.ItemHintType.KEY, element, context);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributor$4", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
        final Condition enumMapKeyCondition = configKey -> configKey.isEnumMapType() || configKey.isIndexedType();
        registrar.registerReferenceProvider((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PropertyKeyImpl.class).with(APPLICATION_PROPERTIES_SB_1_2_OR_HIGHER)).with((PatternCondition)new PatternCondition<PropertyKeyImpl>("isMapWithEnumKey"){

            public boolean accepts(@NotNull PropertyKeyImpl key, ProcessingContext context) {
                if (key == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributor$7", "accepts"));
                }
                return SpringBootApplicationPropertiesReferenceContributor.findAndStoreMetaConfigKeyIfMatches(key, context, (Condition<SpringBootApplicationMetaConfigKey>)enumMapKeyCondition);
            }
        }), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributor$6", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributor$6", "getReferencesByElement"));
                }
                SpringBootApplicationMetaConfigKey configKey = (SpringBootApplicationMetaConfigKey)context.get(META_CONFIG_KEY);
                String elementText = element.getText();
                if (configKey.isIndexedType()) {
                    int closingBracketIdx = elementText.indexOf("].");
                    if (closingBracketIdx == -1) {
                        if (PsiReference.EMPTY_ARRAY == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributor$6", "getReferencesByElement"));
                        }
                        return PsiReference.EMPTY_ARRAY;
                    }
                    int firstPropertyIdx = closingBracketIdx + 2;
                    String text = elementText.substring(firstPropertyIdx);
                    MapKeyPropertyEnumReferenceSet set = new MapKeyPropertyEnumReferenceSet(element, text, firstPropertyIdx, configKey);
                    PsiReference[] psiReferenceArray = set.getReferences();
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributor$6", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
                int offset = configKey.getName().length() + 1;
                if (offset > elementText.length()) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributor$6", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                String text = elementText.substring(offset);
                MapKeyPropertyEnumReferenceSet set = new MapKeyPropertyEnumReferenceSet(element, text, offset, configKey);
                PsiReference[] psiReferenceArray = set.getReferences();
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributor$6", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
    }

    private static boolean findAndStoreMetaConfigKeyIfMatches(PropertyKeyImpl key, ProcessingContext context, Condition<SpringBootApplicationMetaConfigKey> additionalCondition) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)key);
        if (module == null) {
            return false;
        }
        SpringBootApplicationMetaConfigKey configKey = SpringBootApplicationMetaConfigKeyManager.getInstance().findApplicationMetaConfigKey(module, additionalCondition, key.getText());
        if (configKey == null) {
            return false;
        }
        context.put(META_CONFIG_KEY, (Object)configKey);
        return true;
    }
}

