/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi.stubs;

import com.intellij.coldFusion.model.psi.CfmlComponent;
import com.intellij.coldFusion.model.psi.stubs.CfmlComponentIndex;
import com.intellij.coldFusion.model.psi.stubs.CfmlComponentStub;
import com.intellij.coldFusion.model.psi.stubs.CfmlComponentStubImpl;
import com.intellij.coldFusion.model.psi.stubs.CfmlInheritanceIndex;
import com.intellij.coldFusion.model.psi.stubs.CfmlInterfaceIndex;
import com.intellij.coldFusion.model.psi.stubs.CfmlStubElementType;
import com.intellij.lang.Language;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CfmlComponentElementType
extends CfmlStubElementType<CfmlComponentStub, CfmlComponent> {
    public CfmlComponentElementType(@NotNull @NonNls String debugName, @Nullable Language language) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/coldFusion/model/psi/stubs/CfmlComponentElementType", "<init>"));
        }
        super(debugName, language);
    }

    @NotNull
    public CfmlComponentStub createStub(@NotNull CfmlComponent psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/coldFusion/model/psi/stubs/CfmlComponentElementType", "createStub"));
        }
        CfmlComponentStubImpl cfmlComponentStubImpl = new CfmlComponentStubImpl(parentStub, this, psi.getName(), psi.isInterface(), psi.getSuperName(), psi.getInterfaceNames());
        if (cfmlComponentStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/stubs/CfmlComponentElementType", "createStub"));
        }
        return cfmlComponentStubImpl;
    }

    public void serialize(@NotNull CfmlComponentStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/coldFusion/model/psi/stubs/CfmlComponentElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/coldFusion/model/psi/stubs/CfmlComponentElementType", "serialize"));
        }
        dataStream.writeName(stub.getName());
        dataStream.writeBoolean(stub.isInterface());
        dataStream.writeName(stub.getSuperclass());
        dataStream.writeByte(stub.getInterfaces().length);
        for (String name : stub.getInterfaces()) {
            dataStream.writeName(name);
        }
    }

    @NotNull
    public CfmlComponentStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/coldFusion/model/psi/stubs/CfmlComponentElementType", "deserialize"));
        }
        String name = StringRef.toString((StringRef)dataStream.readName());
        boolean isInterface = dataStream.readBoolean();
        String superclass = StringRef.toString((StringRef)dataStream.readName());
        int supersNumber = dataStream.readByte();
        String[] interfaces = new String[supersNumber];
        for (int i = 0; i < supersNumber; ++i) {
            interfaces[i] = StringRef.toString((StringRef)dataStream.readName());
        }
        CfmlComponentStubImpl cfmlComponentStubImpl = new CfmlComponentStubImpl(parentStub, this, name, isInterface, superclass, interfaces);
        if (cfmlComponentStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/stubs/CfmlComponentElementType", "deserialize"));
        }
        return cfmlComponentStubImpl;
    }

    @Override
    public void indexStub(@NotNull CfmlComponentStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/coldFusion/model/psi/stubs/CfmlComponentElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/coldFusion/model/psi/stubs/CfmlComponentElementType", "indexStub"));
        }
        super.indexStub(stub, sink);
        String shortName = stub.getName();
        if (shortName != null) {
            if (stub.isInterface()) {
                sink.occurrence(CfmlInterfaceIndex.KEY, (Object)shortName.toLowerCase());
            } else {
                sink.occurrence(CfmlComponentIndex.KEY, (Object)shortName.toLowerCase());
            }
        }
        if (stub.getSuperclass() != null) {
            sink.occurrence(CfmlInheritanceIndex.KEY, (Object)stub.getSuperclass().toLowerCase());
        }
        for (String superName : stub.getInterfaces()) {
            sink.occurrence(CfmlInheritanceIndex.KEY, (Object)superName.toLowerCase());
        }
    }
}

