/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.aliasFor;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.model.aliasFor.SpringAliasFor;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringAliasForUtils {
    @Nullable
    public static SpringAliasFor findAliasFor(@NotNull PsiElement context, @Nullable String toSearchInAnnotation, @NotNull String aliasedClassName, @NotNull String attrName) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "findAliasFor"));
        }
        if (aliasedClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliasedClassName", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "findAliasFor"));
        }
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "findAliasFor"));
        }
        if (toSearchInAnnotation == null) {
            return null;
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)context.getProject());
        PsiClass toSearchInClass = javaPsiFacade.findClass(toSearchInAnnotation, context.getResolveScope());
        if (toSearchInClass == null || !toSearchInClass.isAnnotationType()) {
            return null;
        }
        PsiClass annotationClass = javaPsiFacade.findClass(aliasedClassName, context.getResolveScope());
        if (annotationClass == null || !annotationClass.isAnnotationType()) {
            return null;
        }
        for (SpringAliasFor aliasFor : SpringAliasForUtils.getAliasForAttributes(toSearchInClass)) {
            if (!attrName.equals(aliasFor.getAttributeName()) || !annotationClass.equals(aliasFor.getAnnotationClass())) continue;
            return aliasFor;
        }
        return null;
    }

    @NotNull
    private static List<SpringAliasFor> getAliasForAttributes(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "getAliasForAttributes"));
        }
        List list = JamService.getJamService((Project)psiClass.getProject()).getAnnotatedMembersList(psiClass, SpringAliasFor.SEM_KEY, false, true, false, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "getAliasForAttributes"));
        }
        return list;
    }

    @Nullable
    public static PsiAnnotation findDefiningMetaAnnotation(@NotNull PsiElement context, @NotNull String customAnnotationFqn, @NotNull String baseMetaAnnotationFqn) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "findDefiningMetaAnnotation"));
        }
        if (customAnnotationFqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customAnnotationFqn", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "findDefiningMetaAnnotation"));
        }
        if (baseMetaAnnotationFqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseMetaAnnotationFqn", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "findDefiningMetaAnnotation"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        if (module == null) {
            return null;
        }
        PsiClass customAnnoClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(customAnnotationFqn, context.getResolveScope());
        return SpringAliasForUtils.findDefiningMetaAnnotation(customAnnoClass, baseMetaAnnotationFqn, JamAnnotationTypeUtil.getInstance(module).getAnnotationTypesWithChildren(baseMetaAnnotationFqn));
    }

    @Nullable
    public static PsiAnnotation findDefiningMetaAnnotation(@Nullable PsiClass customAnnoClass, @NotNull String baseMetaAnnotationFqn, @NotNull Collection<PsiClass> allMetaAnnotations) {
        if (baseMetaAnnotationFqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseMetaAnnotationFqn", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "findDefiningMetaAnnotation"));
        }
        if (allMetaAnnotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allMetaAnnotations", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "findDefiningMetaAnnotation"));
        }
        if (customAnnoClass == null || !customAnnoClass.isAnnotationType()) {
            return null;
        }
        PsiAnnotation psiAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)customAnnoClass, (boolean)true, (String[])new String[]{baseMetaAnnotationFqn});
        if (psiAnnotation != null) {
            return psiAnnotation;
        }
        for (PsiClass customMetaAnnoClass : allMetaAnnotations) {
            String qualifiedName = customMetaAnnoClass.getQualifiedName();
            if (qualifiedName == null || !AnnotationUtil.isAnnotated((PsiModifierListOwner)customAnnoClass, (String)qualifiedName, (boolean)true)) continue;
            return SpringAliasForUtils.findDefiningMetaAnnotation(customMetaAnnoClass, baseMetaAnnotationFqn, allMetaAnnotations);
        }
        return null;
    }
}

