/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.stereotype;

import com.intellij.jam.JamClassAttributeElement;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassAttributeMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.semantic.SemKey;
import com.intellij.spring.contexts.model.ComponentScanPackagesModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringCacheUtils;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringComponentScan
extends CommonModelElement.PsiBase
implements JamElement,
SpringBeansPackagesScan {
    protected static final String VALUE_ATTR_NAME = "value";
    protected static final String BASE_PACKAGES_ATTR_NAME = "basePackages";
    protected static final String BASE_PACKAGE_CLASSES_ATTR_NAME = "basePackageClasses";
    public static final SemKey<JamAnnotationMeta> COMPONENT_SCAN_META_KEY = SemKey.createKey((String)"SpringComponentScan", (SemKey[])new SemKey[0]);
    public static final SemKey<SpringComponentScan> COMPONENT_SCAN_JAM_KEY = JamService.JAM_ELEMENT_KEY.subKey("SpringComponentScan", new SemKey[0]);
    private final PsiClass myPsiElement;

    public SpringComponentScan(@NotNull PsiClass psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/model/jam/stereotype/SpringComponentScan", "<init>"));
        }
        this.myPsiElement = psiElement;
    }

    @Override
    @NotNull
    public final Set<CommonSpringBean> getScannedElements(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/jam/stereotype/SpringComponentScan", "getScannedElements"));
        }
        Set<CommonSpringBean> set = SpringCacheUtils.getCreatedCachedBeans(module, this, (Function<Module, Set<CommonSpringBean>>)((Function)this::getScannedBeans));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/stereotype/SpringComponentScan", "getScannedElements"));
        }
        return set;
    }

    @NotNull
    protected Set<CommonSpringBean> getScannedBeans(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/jam/stereotype/SpringComponentScan", "getScannedBeans"));
        }
        Collection<SpringBeanPointer> scannedComponents = ComponentScanPackagesModel.getScannedComponents(this.getPsiPackages(), module, null, this.useDefaultFilters(), this.getExcludeContextFilters(), this.getIncludeContextFilters());
        Set set = ContainerUtil.map2LinkedSet(scannedComponents, SpringBeanPointer.TO_BEAN);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/stereotype/SpringComponentScan", "getScannedBeans"));
        }
        return set;
    }

    @Nullable
    public abstract PsiAnnotation getAnnotation();

    @NotNull
    public PsiClass getPsiElement() {
        PsiClass psiClass = this.myPsiElement;
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/stereotype/SpringComponentScan", "getPsiElement"));
        }
        return psiClass;
    }

    @Override
    @NotNull
    public Set<PsiPackage> getPsiPackages() {
        PsiFile file;
        LinkedHashSet allPackages = ContainerUtil.newLinkedHashSet();
        for (JamStringAttributeMeta.Collection<Collection<PsiPackage>> packageMeta : this.getPackageJamAttributes()) {
            this.addPackages(allPackages, packageMeta);
        }
        this.addBasePackageClasses(allPackages);
        if (allPackages.isEmpty() && (file = this.getPsiElement().getContainingFile()) instanceof PsiClassOwner) {
            String packageName = ((PsiClassOwner)file).getPackageName();
            PsiManager manager = this.getPsiElement().getManager();
            PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)manager.getProject()).findPackage(packageName);
            if (psiPackage != null) {
                Set<PsiPackage> set = Collections.singleton(psiPackage);
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/stereotype/SpringComponentScan", "getPsiPackages"));
                }
                return set;
            }
        }
        LinkedHashSet linkedHashSet = allPackages;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/stereotype/SpringComponentScan", "getPsiPackages"));
        }
        return linkedHashSet;
    }

    private void addBasePackageClasses(Set<PsiPackage> importedResources) {
        List<JamClassAttributeElement> basePackageClasses = this.getBasePackageClassAttribute();
        for (JamClassAttributeElement bpc : basePackageClasses) {
            PsiPackage psiPackage;
            PsiDirectory containingDirectory;
            PsiClass psiClass = bpc.getValue();
            if (psiClass == null || (containingDirectory = psiClass.getContainingFile().getContainingDirectory()) == null || (psiPackage = JavaDirectoryService.getInstance().getPackage(containingDirectory)) == null) continue;
            importedResources.add(psiPackage);
        }
    }

    @NotNull
    protected List<JamClassAttributeElement> getBasePackageClassAttribute() {
        JamClassAttributeMeta.Collection meta = this.getBasePackageClassMeta();
        List list = meta != null ? (List)this.getAnnotationMeta().getAttribute((PsiModifierListOwner)this.getPsiElement(), (JamAttributeMeta)meta) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/stereotype/SpringComponentScan", "getBasePackageClassAttribute"));
        }
        return list;
    }

    @Nullable
    protected abstract JamClassAttributeMeta.Collection getBasePackageClassMeta();

    private void addPackages(@NotNull Set<PsiPackage> importedResources, @NotNull JamStringAttributeMeta.Collection<Collection<PsiPackage>> attrMeta) {
        if (importedResources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importedResources", "com/intellij/spring/model/jam/stereotype/SpringComponentScan", "addPackages"));
        }
        if (attrMeta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrMeta", "com/intellij/spring/model/jam/stereotype/SpringComponentScan", "addPackages"));
        }
        for (JamStringAttributeElement element : (List)this.getAnnotationMeta().getAttribute((PsiModifierListOwner)this.getPsiElement(), attrMeta)) {
            if (element == null) continue;
            importedResources.addAll((Collection)element.getValue());
        }
    }

    @NotNull
    protected abstract JamAnnotationMeta getAnnotationMeta();

    @NotNull
    public abstract List<JamStringAttributeMeta.Collection<Collection<PsiPackage>>> getPackageJamAttributes();

    public boolean processPsiPackages(@NotNull Processor<Pair<PsiPackage, ? extends PsiElement>> processor) {
        PsiFile file;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/model/jam/stereotype/SpringComponentScan", "processPsiPackages"));
        }
        List<JamStringAttributeMeta.Collection<Collection<PsiPackage>>> packageJamAttributes = this.getPackageJamAttributes();
        List<JamClassAttributeElement> basePackageClasses = this.getBasePackageClassAttribute();
        int packageDefiningElementsCount = basePackageClasses.size();
        for (JamStringAttributeMeta.Collection<Collection<PsiPackage>> packageMeta : packageJamAttributes) {
            packageDefiningElementsCount += ((List)this.getAnnotationMeta().getAttribute((PsiModifierListOwner)this.getPsiElement(), packageMeta)).size();
        }
        boolean useCurrentPackageForScan = packageDefiningElementsCount == 0;
        boolean useAnnotationAsElement = packageDefiningElementsCount == 1;
        PsiAnnotation annotationElement = this.getAnnotationMeta().getAnnotation((PsiModifierListOwner)this.getPsiElement());
        for (JamStringAttributeMeta.Collection<Collection<PsiPackage>> packageMeta : packageJamAttributes) {
            for (JamStringAttributeElement element : (List)this.getAnnotationMeta().getAttribute((PsiModifierListOwner)this.getPsiElement(), packageMeta)) {
                Collection value;
                if (element == null || (value = (Collection)element.getValue()) == null) continue;
                for (PsiPackage psiPackage : value) {
                    PsiAnnotationMemberValue identifyingElement;
                    if (processor.process((Object)Pair.create((Object)psiPackage, (Object)((identifyingElement = useAnnotationAsElement && annotationElement != null ? annotationElement : element.getPsiElement()) == null ? psiPackage : identifyingElement)))) continue;
                    return false;
                }
            }
        }
        for (JamClassAttributeElement bpc : basePackageClasses) {
            PsiPackage psiPackage;
            PsiDirectory containingDirectory;
            PsiClass psiClass = bpc.getValue();
            if (psiClass == null || (containingDirectory = psiClass.getContainingFile().getContainingDirectory()) == null || (psiPackage = JavaDirectoryService.getInstance().getPackage(containingDirectory)) == null || processor.process((Object)Pair.create((Object)psiPackage, (Object)(useAnnotationAsElement ? annotationElement : bpc.getPsiElement())))) continue;
            return false;
        }
        if (useCurrentPackageForScan && (file = this.getPsiElement().getContainingFile()) instanceof PsiClassOwner) {
            String packageName = ((PsiClassOwner)file).getPackageName();
            PsiManager manager = this.getPsiElement().getManager();
            PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)manager.getProject()).findPackage(packageName);
            if (psiPackage != null && !processor.process((Object)Pair.create((Object)psiPackage, (Object)annotationElement))) {
                return false;
            }
        }
        return true;
    }
}

