/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.references;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.play.utils.PlayPathUtils;
import com.intellij.play.utils.PlayUtils;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayControllerActionPsiReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/play/references/PlayControllerActionPsiReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/play/references/PlayControllerActionPsiReferenceProvider", "getReferencesByElement"));
        }
        PsiElement originalElement = element.getOriginalElement();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)originalElement);
        if (module == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/references/PlayControllerActionPsiReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String text = ElementManipulators.getValueText((PsiElement)originalElement);
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/references/PlayControllerActionPsiReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String actionName = text.startsWith("@") ? text.substring(1) : text;
        Set<PsiReference> references = PlayControllerActionPsiReferenceProvider.getActionNameReferences(originalElement, module, actionName, originalElement.getText().indexOf(actionName));
        PsiReference[] psiReferenceArray = references.toArray(new PsiReference[references.size()]);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/references/PlayControllerActionPsiReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    public static Set<PsiReference> getActionNameReferences(PsiElement psiElement, Module module, String actionName, Integer startOffset) {
        HashSet references = new HashSet();
        if (actionName.contains(".")) {
            String controller = actionName.substring(0, actionName.lastIndexOf("."));
            String action = actionName.substring(actionName.lastIndexOf(".") + 1);
            PsiClass controllerByName = PlayPathUtils.findControllerByName(controller, module);
            references.add(new ControllerPsiReference(psiElement, PlayControllerActionPsiReferenceProvider.createTextRange(startOffset, controller), controllerByName, module));
            if (controllerByName != null) {
                references.add(new ActionReference(psiElement, PlayControllerActionPsiReferenceProvider.createTextRange(startOffset + controller.length() + 1, action), controllerByName, action));
            }
        } else {
            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class);
            if (psiClass != null && PlayUtils.isController(psiClass)) {
                references.add(new LocalActionReference(psiElement, startOffset, actionName, psiClass, module));
            }
        }
        return references;
    }

    private static TextRange createTextRange(Integer startOffset, String name) {
        return new TextRange(startOffset.intValue(), startOffset + name.length());
    }

    private static List<PsiClass> getTopLevelControllers(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/play/references/PlayControllerActionPsiReferenceProvider", "getTopLevelControllers"));
        }
        PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)module.getProject()).findPackage("controllers");
        if (psiPackage != null) {
            return Arrays.asList(psiPackage.getClasses(GlobalSearchScope.moduleWithDependenciesScope((Module)module)));
        }
        return new ArrayList<PsiClass>();
    }

    private static Set<PsiMethod> getActionMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/play/references/PlayControllerActionPsiReferenceProvider", "getActionMethods"));
        }
        HashSet names = new HashSet();
        for (PsiMethod psiMethod : psiClass.getAllMethods()) {
            if (!psiMethod.hasModifierProperty("static") || !psiMethod.hasModifierProperty("public")) continue;
            names.add(psiMethod);
        }
        return names;
    }

    private static class LocalActionReference
    extends ActionReference {
        private final PsiClass myPsiClass;
        private final Module myModule;

        public LocalActionReference(@NotNull PsiElement psiElement, int startOffset, @NotNull String actionName, @NotNull PsiClass psiClass, @NotNull Module module) {
            if (psiElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/play/references/PlayControllerActionPsiReferenceProvider$LocalActionReference", "<init>"));
            }
            if (actionName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionName", "com/intellij/play/references/PlayControllerActionPsiReferenceProvider$LocalActionReference", "<init>"));
            }
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/play/references/PlayControllerActionPsiReferenceProvider$LocalActionReference", "<init>"));
            }
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/play/references/PlayControllerActionPsiReferenceProvider$LocalActionReference", "<init>"));
            }
            super(psiElement, PlayControllerActionPsiReferenceProvider.createTextRange(startOffset, actionName), psiClass, actionName);
            this.myPsiClass = psiClass;
            this.myModule = module;
        }

        @Override
        @NotNull
        public Object[] getVariants() {
            ArrayList variants = new ArrayList();
            variants.addAll(ContainerUtil.map((Collection)PlayControllerActionPsiReferenceProvider.getActionMethods(this.myPsiClass), psiMethod -> LookupElementBuilder.create((PsiNamedElement)psiMethod).withIcon(PlatformIcons.METHOD_ICON)));
            variants.addAll(PlayControllerActionPsiReferenceProvider.getTopLevelControllers(this.myModule));
            Object[] objectArray = variants.toArray(new Object[variants.size()]);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/references/PlayControllerActionPsiReferenceProvider$LocalActionReference", "getVariants"));
            }
            return objectArray;
        }
    }

    private static class ActionReference
    extends PsiReferenceBase<PsiElement> {
        private final PsiClass myController;
        private final String myAction;

        public ActionReference(@NotNull PsiElement psiElement, @NotNull TextRange textRange, @NotNull PsiClass controller, @NotNull String action) {
            if (psiElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/play/references/PlayControllerActionPsiReferenceProvider$ActionReference", "<init>"));
            }
            if (textRange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/play/references/PlayControllerActionPsiReferenceProvider$ActionReference", "<init>"));
            }
            if (controller == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controller", "com/intellij/play/references/PlayControllerActionPsiReferenceProvider$ActionReference", "<init>"));
            }
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/play/references/PlayControllerActionPsiReferenceProvider$ActionReference", "<init>"));
            }
            super(psiElement, textRange);
            this.myController = controller;
            this.myAction = action;
        }

        public PsiElement resolve() {
            for (PsiMethod psiMethod : this.myController.getAllMethods()) {
                if (!psiMethod.getName().equals(this.myAction)) continue;
                return psiMethod;
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            Object[] objectArray = ContainerUtil.map2Array((Collection)PlayControllerActionPsiReferenceProvider.getActionMethods(this.myController), LookupElementBuilder.class, s -> LookupElementBuilder.create((PsiNamedElement)s).withIcon(PlatformIcons.METHOD_ICON));
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/references/PlayControllerActionPsiReferenceProvider$ActionReference", "getVariants"));
            }
            return objectArray;
        }
    }

    private static class ControllerPsiReference
    extends PsiReferenceBase<PsiElement> {
        private PsiClass myControllerByName;
        private Module myModule;

        public ControllerPsiReference(@NotNull PsiElement psiElement, @NotNull TextRange textRange, @Nullable PsiClass controller, @NotNull Module module) {
            if (psiElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/play/references/PlayControllerActionPsiReferenceProvider$ControllerPsiReference", "<init>"));
            }
            if (textRange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/play/references/PlayControllerActionPsiReferenceProvider$ControllerPsiReference", "<init>"));
            }
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/play/references/PlayControllerActionPsiReferenceProvider$ControllerPsiReference", "<init>"));
            }
            super(psiElement, textRange);
            this.myControllerByName = controller;
            this.myModule = module;
        }

        public PsiElement resolve() {
            return this.myControllerByName;
        }

        public boolean isReferenceTo(PsiElement element) {
            return super.isReferenceTo(element);
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/play/references/PlayControllerActionPsiReferenceProvider$ControllerPsiReference", "bindToElement"));
            }
            if (element instanceof PsiClass) {
                this.myControllerByName = (PsiClass)element;
                return this.myControllerByName;
            }
            return super.bindToElement(element);
        }

        @NotNull
        public Object[] getVariants() {
            List controllers = PlayControllerActionPsiReferenceProvider.getTopLevelControllers(this.myModule);
            Object[] objectArray = controllers.toArray(new Object[controllers.size()]);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/references/PlayControllerActionPsiReferenceProvider$ControllerPsiReference", "getVariants"));
            }
            return objectArray;
        }
    }
}

