/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.references;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.play.utils.PlayUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PlayControllerMethodsReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/play/references/PlayControllerMethodsReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/play/references/PlayControllerMethodsReferenceProvider", "getReferencesByElement"));
        }
        final PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (psiClass != null && PlayUtils.isController(psiClass)) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new PsiReferenceBase<PsiElement>(element){

                public PsiElement resolve() {
                    String value = this.getValue();
                    if (!StringUtil.isEmptyOrSpaces((String)value)) {
                        for (PsiMethod method : this.getControllerMethods()) {
                            if (!value.equals(method.getName())) continue;
                            return method;
                        }
                    }
                    return null;
                }

                @NotNull
                public Object[] getVariants() {
                    Object[] objectArray = ContainerUtil.map2Array(this.getControllerMethods(), method -> LookupElementBuilder.create((PsiNamedElement)method).withIcon(method.getIcon(0)));
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/references/PlayControllerMethodsReferenceProvider$1", "getVariants"));
                    }
                    return objectArray;
                }

                private Set<PsiMethod> getControllerMethods() {
                    HashSet methods = new HashSet();
                    for (PsiMethod psiMethod : psiClass.getAllMethods()) {
                        if (!psiMethod.hasModifierProperty("static") || !psiMethod.hasModifierProperty("public")) continue;
                        methods.add(psiMethod);
                    }
                    return methods;
                }
            }};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/references/PlayControllerMethodsReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/references/PlayControllerMethodsReferenceProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }
}

