/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.utils.processors;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.play.utils.PlayUtils;
import com.intellij.play.utils.beans.PlayImplicitVariable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.light.LightClass;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.impl.light.LightVariableBuilder;
import com.intellij.psi.scope.DelegatingScopeProcessor;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrImplicitVariableImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightVariable;

public class PlayImplicitVariablesFactory {
    public static PlayImplicitVariable createLightClassImplicitVariable(final @NotNull PsiClass psiClass, @NotNull String name, boolean processStaticMembers) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/play/utils/processors/PlayImplicitVariablesFactory", "createLightClassImplicitVariable"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/play/utils/processors/PlayImplicitVariablesFactory", "createLightClassImplicitVariable"));
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)psiClass.getProject());
        return new PlayImplicitVariable(name, (PsiType)psiFacade.getElementFactory().createType((PsiClass)PlayImplicitVariablesFactory.createLightClassController(psiClass, processStaticMembers)), (PsiElement)psiClass){

            public Icon getElementIcon(int flags) {
                return psiClass.getIcon(0);
            }
        };
    }

    public static LightClass createLightClassController(final PsiClass psiClass, final boolean processStaticMembers) {
        return new LightClass(psiClass){

            public boolean processDeclarations(final @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
                if (processor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/play/utils/processors/PlayImplicitVariablesFactory$2", "processDeclarations"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/play/utils/processors/PlayImplicitVariablesFactory$2", "processDeclarations"));
                }
                if (place == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/play/utils/processors/PlayImplicitVariablesFactory$2", "processDeclarations"));
                }
                return super.processDeclarations((PsiScopeProcessor)new DelegatingScopeProcessor(processor){

                    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                        if (element == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/play/utils/processors/PlayImplicitVariablesFactory$2$1", "execute"));
                        }
                        if (state == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/play/utils/processors/PlayImplicitVariablesFactory$2$1", "execute"));
                        }
                        if (element instanceof PsiMethod) {
                            PsiMethod psiMethod = (PsiMethod)element;
                            if (processStaticMembers && !psiMethod.getModifierList().hasModifierProperty("static")) {
                                return false;
                            }
                            if (!super.execute((PsiElement)PlayImplicitVariablesFactory.getPsiMethodDelegate(psiMethod, true), state)) {
                                return false;
                            }
                            if (!super.execute((PsiElement)PlayImplicitVariablesFactory.getPsiMethodDelegate(psiMethod, false), state)) {
                                return false;
                            }
                            PsiType returnType = psiMethod.getReturnType();
                            if (returnType != null) {
                                return super.execute((PsiElement)new GrLightVariable(psiClass.getManager(), psiMethod.getName(), returnType, psiMethod.getNavigationElement()){

                                    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
                                        if (name == null) {
                                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/play/utils/processors/PlayImplicitVariablesFactory$2$1$1", "setName"));
                                        }
                                        for (PsiElement declaration : this.getDeclarations()) {
                                            if (!(declaration instanceof PsiMethod)) continue;
                                            ((PsiMethod)declaration).setName(name);
                                        }
                                        return this.getNameIdentifier().replace((PsiElement)new GrImplicitVariableImpl.GrLightIdentifier(this.myManager, name));
                                    }
                                }, state);
                            }
                        } else if (element instanceof PsiField) {
                            if (processStaticMembers && !((PsiField)element).hasModifierProperty("static")) {
                                return false;
                            }
                            if (!PlayUtils.isController(((PsiField)element).getContainingClass())) {
                                return super.execute((PsiElement)PlayImplicitVariablesFactory.getPsiFieldDelegate((PsiField)element), state);
                            }
                        }
                        return super.execute(element, state);
                    }

                    public <T> T getHint(@NotNull Key<T> hintKey) {
                        if (hintKey == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "com/intellij/play/utils/processors/PlayImplicitVariablesFactory$2$1", "getHint"));
                        }
                        if (hintKey == ElementClassHint.KEY) {
                            return (T)new ElementClassHint(){

                                public boolean shouldProcess(ElementClassHint.DeclarationKind kind) {
                                    if (kind == ElementClassHint.DeclarationKind.METHOD) {
                                        return true;
                                    }
                                    ElementClassHint hint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
                                    return hint == null || hint.shouldProcess(kind);
                                }
                            };
                        }
                        return (T)super.getHint(hintKey);
                    }
                }, state, lastParent, place);
            }
        };
    }

    private static LightVariableBuilder getPsiFieldDelegate(PsiField original) {
        return new LightVariableBuilder(original.getName(), original.getType(), (PsiElement)original).setBaseIcon(PlatformIcons.FIELD_ICON);
    }

    private static LightMethodBuilder getPsiMethodDelegate(PsiMethod original, boolean withParameters) {
        LightMethodBuilder delegate = new LightMethodBuilder(original.getManager(), original.getName());
        delegate.setNavigationElement((PsiElement)original);
        delegate.setMethodReturnType(original.getReturnType());
        if (withParameters) {
            for (PsiParameter parameter : original.getParameterList().getParameters()) {
                delegate.addParameter(parameter);
            }
        }
        if (original.hasModifierProperty("public")) {
            delegate.addModifier("public");
        }
        return delegate;
    }
}

