/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.settings;

import com.intellij.conversion.ConversionContext;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ConverterProvider;
import com.intellij.conversion.ProjectConverter;
import com.intellij.conversion.RunManagerSettings;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.javascript.debugger.execution.JavascriptDebugConfigurationType;
import com.intellij.openapi.util.text.StringUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class JavaScriptDebugConfigurationConverterProvider
extends ConverterProvider {
    protected JavaScriptDebugConfigurationConverterProvider() {
        super("js-debug-configuration-converter");
    }

    @NotNull
    public String getConversionDescription() {
        if ("JavaScript Remote and Local run configuration will be converted into unified JavaScript run configuration" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/settings/JavaScriptDebugConfigurationConverterProvider", "getConversionDescription"));
        }
        return "JavaScript Remote and Local run configuration will be converted into unified JavaScript run configuration";
    }

    @NotNull
    public ProjectConverter createConverter(@NotNull ConversionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/debugger/settings/JavaScriptDebugConfigurationConverterProvider", "createConverter"));
        }
        ProjectConverter projectConverter = new ProjectConverter(){

            public ConversionProcessor<RunManagerSettings> createRunConfigurationsConverter() {
                return new ConversionProcessor<RunManagerSettings>(){

                    public boolean isConversionNeeded(RunManagerSettings settings) {
                        for (Element element : settings.getRunConfigurations()) {
                            if (!JavaScriptDebugConfigurationConverterProvider.isJsRemoteRunConfiguration(element)) continue;
                            return true;
                        }
                        return false;
                    }

                    public void process(RunManagerSettings settings) {
                        for (Element element : settings.getRunConfigurations()) {
                            if (!JavaScriptDebugConfigurationConverterProvider.isJsRemoteRunConfiguration(element)) continue;
                            JavaScriptDebugConfigurationConverterProvider.convert(element);
                        }
                    }
                };
            }
        };
        if (projectConverter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/settings/JavaScriptDebugConfigurationConverterProvider", "createConverter"));
        }
        return projectConverter;
    }

    public static boolean isJsRemoteRunConfiguration(Element element) {
        return "JavascriptDebugSession".equalsIgnoreCase(element.getAttributeValue("type")) && !"true".equals(element.getAttributeValue("default"));
    }

    public static void convert(Element element) {
        Element settings;
        element.setAttribute("type", JavascriptDebugConfigurationType.getTypeInstance().getId());
        element.removeAttribute("factoryName");
        Element localSettings = element.getChild("JSDebuggerConfigurationSettings");
        Element remoteSettings = localSettings == null ? element.getChild("JSRemoteDebuggerConfigurationSettings") : null;
        Element element2 = settings = localSettings == null ? remoteSettings : localSettings;
        if (settings != null) {
            String engineId = null;
            String uri = null;
            Object[] objects = settings.getChildren().toArray();
            settings.removeContent();
            for (Object o : objects) {
                Element tag = (Element)o;
                if ("option".equals(tag.getName())) {
                    String optionName = tag.getAttributeValue("name");
                    String optionValue = StringUtil.nullize((String)tag.getAttributeValue("value"));
                    if ("fileUrl".equals(optionName)) {
                        uri = optionValue;
                        continue;
                    }
                    if (!"engineId".equals(optionName) || "embedded".equals(optionValue) || "chrome".equals(optionValue)) continue;
                    engineId = "firefox".equals(optionValue) ? WebBrowserManager.PREDEFINED_FIREFOX_ID.toString() : optionValue;
                    continue;
                }
                if (remoteSettings == null || !"mapping".equals(tag.getName())) continue;
                element.addContent(tag);
            }
            element.removeChild("JSDebuggerConfigurationSettings");
            element.removeChild("JSRemoteDebuggerConfigurationSettings");
            if (!StringUtil.isEmpty(engineId)) {
                element.setAttribute("engineId", engineId);
            }
            if (!StringUtil.isEmptyOrSpaces(uri)) {
                element.setAttribute("uri", uri.trim());
            }
        }
    }
}

