/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.scripts;

import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.debugger.execution.RemoteDebuggingFileFinder;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeBuilder;
import com.intellij.ui.treeStructure.WeightBasedComparator;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import com.jetbrains.javascript.debugger.scripts.FileNode;
import com.jetbrains.javascript.debugger.scripts.OpenActualScriptSourceAction;
import com.jetbrains.javascript.debugger.scripts.OpenScriptSourceAction;
import com.jetbrains.javascript.debugger.scripts.SourceTabManager;
import com.jetbrains.javascript.debugger.scripts.SourcesTreeStructure;
import com.jetbrains.javascript.debugger.scripts.actions.SetLocalPathForScriptAction;
import com.jetbrains.javascript.debugger.scripts.actions.VisualizeScriptSourcemap;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.Comparator;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0018\u001a\u00020\u0019H\u0002R\u0015\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/javascript/debugger/scripts/SourcesTreeComponent;", "", "sourceTabManager", "Lcom/jetbrains/javascript/debugger/scripts/SourceTabManager;", "(Lcom/jetbrains/javascript/debugger/scripts/SourceTabManager;)V", "debugProcess", "Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;", "getDebugProcess", "()Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;", "mainComponent", "Ljavax/swing/JScrollPane;", "kotlin.jvm.PlatformType", "getMainComponent", "()Ljavax/swing/JScrollPane;", "selectedNode", "Lcom/jetbrains/javascript/debugger/scripts/FileNode;", "getSelectedNode", "()Lcom/jetbrains/javascript/debugger/scripts/FileNode;", "tree", "Lcom/intellij/ui/treeStructure/SimpleTree;", "treeBuilder", "Lcom/intellij/ui/treeStructure/SimpleTreeBuilder;", "getTreeBuilder$JavaScriptDebugger", "()Lcom/intellij/ui/treeStructure/SimpleTreeBuilder;", "createPopupGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "JavaScriptDebugger"})
public final class SourcesTreeComponent {
    private final SimpleTree tree;
    @NotNull
    private final SimpleTreeBuilder treeBuilder;
    private final JScrollPane mainComponent;
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;

    @NotNull
    public final SimpleTreeBuilder getTreeBuilder$JavaScriptDebugger() {
        return this.treeBuilder;
    }

    public final JScrollPane getMainComponent() {
        return this.mainComponent;
    }

    @NotNull
    public final JavaScriptDebugProcess<?> getDebugProcess() {
        return this.debugProcess;
    }

    @Nullable
    public final FileNode getSelectedNode() {
        SimpleNode simpleNode = this.tree.getSelectedNode();
        if (!(simpleNode instanceof FileNode)) {
            simpleNode = null;
        }
        return (FileNode)simpleNode;
    }

    private final DefaultActionGroup createPopupGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new OpenScriptSourceAction(this));
        WebBrowser browser = this.debugProcess.getConnection().getBrowser();
        if (browser == null || browser.getFamily() == BrowserFamily.CHROME) {
            group.add((AnAction)new OpenActualScriptSourceAction(this));
            group.add((AnAction)new VisualizeScriptSourcemap(this));
        }
        return group;
    }

    public SourcesTreeComponent(@NotNull SourceTabManager sourceTabManager) {
        DefaultActionGroup dirGroup;
        Intrinsics.checkParameterIsNotNull((Object)sourceTabManager, (String)"sourceTabManager");
        this.tree = new SimpleTree();
        this.treeBuilder = new SimpleTreeBuilder((JTree)this.tree, this.tree.getBuilderModel(), (AbstractTreeStructure)new SourcesTreeStructure(sourceTabManager), (Comparator)new WeightBasedComparator(true));
        this.mainComponent = ScrollPaneFactory.createScrollPane((Component)((Component)this.tree));
        this.debugProcess = sourceTabManager.getDebugProcess();
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.treeBuilder.initRootNode();
        sourceTabManager.addListener(new Runnable(){

            @Override
            public final void run() {
                this.getTreeBuilder$JavaScriptDebugger().updateFromRoot(true);
            }
        });
        SetLocalPathForScriptAction setLocalPathForScriptAction = this.debugProcess.getSession().getRunProfile() instanceof JavaScriptDebugConfiguration && this.debugProcess.getFinder() instanceof RemoteDebuggingFileFinder ? new SetLocalPathForScriptAction(this) : (SetLocalPathForScriptAction)null;
        final DefaultActionGroup fileGroup = this.createPopupGroup();
        if (setLocalPathForScriptAction != null) {
            dirGroup = new DefaultActionGroup();
            dirGroup.add((AnAction)setLocalPathForScriptAction);
            fileGroup.add((AnAction)setLocalPathForScriptAction);
        } else {
            dirGroup = null;
        }
        this.tree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(@NotNull Component comp, int x, int y) {
                block1: {
                    DefaultActionGroup group;
                    Intrinsics.checkParameterIsNotNull((Object)comp, (String)"comp");
                    FileNode fileNode = this.getSelectedNode();
                    if (fileNode == null) break block1;
                    FileNode fileNode2 = fileNode;
                    FileNode it = fileNode2;
                    DefaultActionGroup defaultActionGroup = group = it.getFileInfo().isFile() ? fileGroup : dirGroup;
                    if (group != null) {
                        ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)group).getComponent().show(comp, x, y);
                    }
                }
            }
        });
    }
}

