/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.quirksmode;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.jetbrains.quirksmode.Browser;
import com.jetbrains.quirksmode.BrowserFamily;
import com.jetbrains.quirksmode.BrowserSet;
import com.jetbrains.quirksmode.ProblemDetector;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ProblemDetectorImpl
implements ProblemDetector {
    private String myId;
    private String myUrl;
    private ElementPattern myPattern;
    private BrowserSet myBrowserSet;
    private Pair<BrowserSet, String>[] myMessages;

    public ProblemDetectorImpl(@NotNull @NonNls String id, @NotNull ElementPattern pattern, @NotNull @NonNls String url, Pair<BrowserSet, String> ... messages) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/jetbrains/quirksmode/ProblemDetectorImpl", "<init>"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/jetbrains/quirksmode/ProblemDetectorImpl", "<init>"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/quirksmode/ProblemDetectorImpl", "<init>"));
        }
        if (messages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messages", "com/jetbrains/quirksmode/ProblemDetectorImpl", "<init>"));
        }
        this.myId = id;
        this.myUrl = url;
        this.myPattern = pattern;
        BrowserSet browserSet = new BrowserSet(new Browser[0]);
        for (Pair<BrowserSet, String> each : messages) {
            browserSet = browserSet.and((BrowserSet)each.first);
        }
        this.myBrowserSet = browserSet;
        this.myMessages = messages;
    }

    public ProblemDetectorImpl(@NotNull @NonNls String id, @NotNull ElementPattern pattern, @NotNull String message, @NotNull String url, @NotNull BrowserFamily family) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/jetbrains/quirksmode/ProblemDetectorImpl", "<init>"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/jetbrains/quirksmode/ProblemDetectorImpl", "<init>"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/quirksmode/ProblemDetectorImpl", "<init>"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/quirksmode/ProblemDetectorImpl", "<init>"));
        }
        if (family == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "family", "com/jetbrains/quirksmode/ProblemDetectorImpl", "<init>"));
        }
        this(id, pattern, url, Pair.create((Object)new BrowserSet(family), (Object)message));
    }

    public ProblemDetectorImpl(@NotNull @NonNls String id, @NotNull ElementPattern pattern, @NotNull String message, @NotNull String url, @NotNull Browser browser) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/jetbrains/quirksmode/ProblemDetectorImpl", "<init>"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/jetbrains/quirksmode/ProblemDetectorImpl", "<init>"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/quirksmode/ProblemDetectorImpl", "<init>"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/quirksmode/ProblemDetectorImpl", "<init>"));
        }
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/jetbrains/quirksmode/ProblemDetectorImpl", "<init>"));
        }
        this(id, pattern, url, Pair.create((Object)new BrowserSet(browser), (Object)message));
    }

    public ProblemDetectorImpl(@NotNull @NonNls String id, @NotNull ElementPattern pattern, @NotNull String message, @NotNull String url, @NotNull BrowserSet browserSet) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/jetbrains/quirksmode/ProblemDetectorImpl", "<init>"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/jetbrains/quirksmode/ProblemDetectorImpl", "<init>"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/quirksmode/ProblemDetectorImpl", "<init>"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/quirksmode/ProblemDetectorImpl", "<init>"));
        }
        if (browserSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browserSet", "com/jetbrains/quirksmode/ProblemDetectorImpl", "<init>"));
        }
        this(id, pattern, url, Pair.create((Object)browserSet, (Object)message));
    }

    public String getId() {
        return this.myId;
    }

    @Override
    public ElementPattern getPattern() {
        return this.myPattern;
    }

    @Override
    public void createDescriptors(@NotNull PsiElement element, @NotNull ProblemsHolder holder, @NotNull BrowserSet browserSet, boolean isOnTheFly) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/quirksmode/ProblemDetectorImpl", "createDescriptors"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/quirksmode/ProblemDetectorImpl", "createDescriptors"));
        }
        if (browserSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browserSet", "com/jetbrains/quirksmode/ProblemDetectorImpl", "createDescriptors"));
        }
        StringBuilder text = new StringBuilder("<html><body>");
        for (Pair<BrowserSet, String> pair : this.myMessages) {
            BrowserSet set = (BrowserSet)pair.first;
            if (!set.intersects(browserSet)) continue;
            String message = (String)pair.second;
            text.append(set).append(" compatibility problem#treeend #loc<blockquote>").append(message).append("</blockquote>\n");
        }
        text.append("<blockquote>Report: <a href=\"").append(this.myUrl).append("\">").append("[").append(this.getId()).append("]</a></blockquote></body></html>");
        if (element instanceof XmlTag) {
            ASTNode node = element.getNode();
            if (node != null) {
                TextRange highlightRange;
                ASTNode startTagName = XmlChildRole.START_TAG_NAME_FINDER.findChild(node);
                ASTNode endTagName = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(node);
                if (startTagName != null) {
                    int offsetInParent = startTagName.getPsi().getStartOffsetInParent();
                    highlightRange = new TextRange(offsetInParent, offsetInParent + startTagName.getTextLength());
                    holder.registerProblem(element, highlightRange, text.toString(), new LocalQuickFix[0]);
                }
                if (endTagName != null) {
                    int offsetInParent = endTagName.getPsi().getStartOffsetInParent();
                    highlightRange = new TextRange(offsetInParent, offsetInParent + endTagName.getTextLength());
                    holder.registerProblem(element, highlightRange, text.toString(), new LocalQuickFix[0]);
                }
            }
        } else {
            holder.registerProblem(element, text.toString(), new LocalQuickFix[0]);
        }
    }

    @Override
    public boolean isActive(@NotNull BrowserSet browserSet) {
        if (browserSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browserSet", "com/jetbrains/quirksmode/ProblemDetectorImpl", "isActive"));
        }
        return this.myBrowserSet.intersects(browserSet);
    }
}

