/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFunction;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;

public class SQLiteDetector
extends Detector
implements UastScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(SQLiteDetector.class, Scope.SOURCE_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("SQLiteString", "Using STRING instead of TEXT", "In SQLite, any column can store any data type; the declared type for a column is more of a hint as to what the data should be cast to when stored.\n\nThere are many ways to store a string. `TEXT`, `VARCHAR`, `CHARACTER` and `CLOB` are string types, *but `STRING` is not*. Columns defined as STRING are actually numeric.\n\nIf you try to store a value in a numeric column, SQLite will try to cast it to a float or an integer before storing. If it can't, it will just store it as a string.\n\nThis can lead to some subtle bugs. For example, when SQLite encounters a string like `1234567e1234`, it will parse it as a float, but the result will be out of range for floating point numbers, so `Inf` will be stored! Similarly, strings that look like integers will lose leading zeroes.\n\nTo fix this, you can change your schema to use a `TEXT` type instead.", Category.CORRECTNESS, 5, Severity.WARNING, IMPLEMENTATION).addMoreInfo("https://www.sqlite.org/datatype3.html");

    @Override
    public List<String> getApplicableFunctionNames() {
        return Collections.singletonList("execSQL");
    }

    @Override
    public void visitCall(UastAndroidContext context, UCallExpression node) {
        UExpression argument;
        String sql;
        UFunction resolvedFunction = node.resolve(context);
        UClass containingClass = UastUtils.getContainingClass(resolvedFunction);
        if (resolvedFunction == null || containingClass == null) {
            return;
        }
        if (!containingClass.matchesFqName("android.database.sqlite.SQLiteDatabase")) {
            return;
        }
        if (resolvedFunction.getValueParameterCount() > 0 && resolvedFunction.getValueParameters().get(0).getType().matchesFqName("java.lang.String") && node.getValueArgumentCount() == resolvedFunction.getValueParameterCount() && (sql = (argument = node.getValueArguments().get(0)).evaluateString()) != null && (sql.startsWith("CREATE TABLE") || sql.startsWith("ALTER TABLE")) && sql.matches(".*\\bSTRING\\b.*")) {
            String message2 = "Using column type STRING; did you mean to use TEXT? (STRING is a numeric type and its value can be adjusted; for example,strings that look like integers can drop leading zeroes. See issue explanation for details.)";
            context.report(ISSUE, node, context.getLocation(node), message2);
        }
    }
}

