/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.jam;

import com.intellij.aop.AopBundle;
import com.intellij.aop.AopIntroduction;
import com.intellij.aop.IntroductionManipulator;
import com.intellij.aop.psi.AopPointcutExpressionFile;
import com.intellij.aop.psi.AopPointcutExpressionHolder;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DeclareParentsInspection
extends XmlSuppressableInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.aop.jam.DeclareParentsInspection");

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/jam/DeclareParentsInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = AopBundle.message("inspection.display.name.declareParents", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/jam/DeclareParentsInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("DeclareParentsInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/jam/DeclareParentsInspection", "getShortName"));
        }
        return "DeclareParentsInspection";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/aop/jam/DeclareParentsInspection", "buildVisitor"));
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof PsiLiteralExpression || element instanceof XmlAttributeValue) {
                    PsiFile file = InjectedLanguageUtil.findInjectedPsiNoCommit((PsiFile)element.getContainingFile(), (int)(element.getTextRange().getStartOffset() + 1));
                    if (file instanceof AopPointcutExpressionFile) {
                        this.process((AopPointcutExpressionHolder)file, element instanceof XmlElement);
                    }
                } else if (element instanceof AopPointcutExpressionHolder && !(element instanceof AopPointcutExpressionFile)) {
                    this.process((AopPointcutExpressionHolder)element, false);
                }
            }

            private void process(AopPointcutExpressionHolder file, boolean isXml) {
                final IntroductionManipulator manipulator = file.getAopModel().getIntroductionManipulator();
                if (manipulator == null) {
                    return;
                }
                AopIntroduction introduction = manipulator.getIntroduction();
                if (introduction == null) {
                    return;
                }
                PsiClass intf = (PsiClass)introduction.getImplementInterface().getValue();
                if (intf == null && introduction.getImplementInterface().getStringValue() != null || intf != null && !intf.isInterface()) {
                    DeclareParentsInspection.registerProblem(manipulator.getInterfaceElement(), AopBundle.message("error.interface.expected", new Object[0]), holder);
                    return;
                }
                if (intf == null) {
                    return;
                }
                PsiClass defaultImpl = (PsiClass)introduction.getDefaultImpl().getValue();
                if (defaultImpl == null) {
                    if (!isXml && !ContainerUtil.findAll((Object[])intf.getAllMethods(), method -> method.hasModifierProperty("abstract")).isEmpty()) {
                        holder.registerProblem(manipulator.getCommonProblemElement(), AopBundle.message("error.default.implementation.class.should.be.specified", new Object[0]), new LocalQuickFix[]{new LocalQuickFix(){

                            @NotNull
                            public String getName() {
                                String string = AopBundle.message("quickfix.name.define.attribute", manipulator.getDefaultImplAttributeName());
                                if (string == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/jam/DeclareParentsInspection$1$1", "getName"));
                                }
                                return string;
                            }

                            @NotNull
                            public String getFamilyName() {
                                String string = this.getName();
                                if (string == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/jam/DeclareParentsInspection$1$1", "getFamilyName"));
                                }
                                return string;
                            }

                            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                                if (project == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/aop/jam/DeclareParentsInspection$1$1", "applyFix"));
                                }
                                if (descriptor == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/aop/jam/DeclareParentsInspection$1$1", "applyFix"));
                                }
                                try {
                                    if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)descriptor.getPsiElement().getContainingFile())) {
                                        return;
                                    }
                                    manipulator.defineDefaultImpl(project, descriptor);
                                }
                                catch (IncorrectOperationException e) {
                                    LOG.error((Throwable)e);
                                }
                            }
                        }});
                    }
                    return;
                }
                if (defaultImpl.hasModifierProperty("abstract") || !defaultImpl.isInheritor(intf, true)) {
                    PsiElement defaultImplElement = manipulator.getDefaultImplElement();
                    assert (defaultImplElement != null);
                    DeclareParentsInspection.registerProblem(defaultImplElement, AopBundle.message("error.non.abstract.class.implemention.0.expected", intf.getQualifiedName()), holder);
                }
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/jam/DeclareParentsInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    private static void registerProblem(PsiElement element, String descriptionTemplate, ProblemsHolder holder) {
        int quotes = element.getText().startsWith("\"") ? 1 : 0;
        TextRange range = TextRange.from((int)quotes, (int)Math.max(element.getTextLength() - 2 * quotes, 1));
        holder.registerProblem(holder.getManager().createProblemDescriptor(element, range, descriptionTemplate, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, holder.isOnTheFly(), new LocalQuickFix[0]));
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = AopBundle.message("inspection.group.display.name.aop", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/jam/DeclareParentsInspection", "getGroupDisplayName"));
        }
        return string;
    }
}

